/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Collection;
import java.util.Properties;
import kafka.log.CleanerConfig;
import kafka.log.CleanerConfig$;
import kafka.log.Log;
import kafka.log.LogCleaner;
import kafka.log.LogCleanerLagIntegrationTest$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@RunWith(value=Parameterized.class)
@ScalaSignature(bytes="\u0006\u0001\t}b\u0001B\u0001\u0003\u0001\u001d\u0011A\u0004T8h\u00072,\u0017M\\3s\u0019\u0006<\u0017J\u001c;fOJ\fG/[8o)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u00119\u0001\"!\u0003\u0007\u000e\u0003)Q\u0011aC\u0001\u0006g\u000e\fG.Y\u0005\u0003\u001b)\u0011a!\u00118z%\u00164\u0007CA\b\u0013\u001b\u0005\u0001\"BA\t\u0005\u0003\u0015)H/\u001b7t\u0013\t\u0019\u0002CA\u0004M_\u001e<\u0017N\\4\t\u0011U\u0001!\u0011!Q\u0001\nY\tAcY8naJ,7o]5p]\u000e{G-Z2OC6,\u0007CA\f\u001b\u001d\tI\u0001$\u0003\u0002\u001a\u0015\u00051\u0001K]3eK\u001aL!a\u0007\u000f\u0003\rM#(/\u001b8h\u0015\tI\"\u0002C\u0003\u001f\u0001\u0011\u0005q$\u0001\u0004=S:LGO\u0010\u000b\u0003A\t\u0002\"!\t\u0001\u000e\u0003\tAQ!F\u000fA\u0002YAq\u0001\n\u0001C\u0002\u0013\u0005Q%A\u0005ngB+'\u000fS8veV\ta\u0005\u0005\u0002\nO%\u0011\u0001F\u0003\u0002\u0004\u0013:$\bB\u0002\u0016\u0001A\u0003%a%\u0001\u0006ngB+'\u000fS8ve\u0002Bq\u0001\f\u0001C\u0002\u0013\u0005Q%A\u0007d_6\u0004\u0018m\u0019;j_:d\u0015m\u001a\u0005\u0007]\u0001\u0001\u000b\u0011\u0002\u0014\u0002\u001d\r|W\u000e]1di&|g\u000eT1hA!9\u0001\u0007\u0001b\u0001\n\u0003\t\u0014\u0001\u0002;j[\u0016,\u0012A\r\t\u0003\u001fMJ!\u0001\u000e\t\u0003\u00115{7m\u001b+j[\u0016DaA\u000e\u0001!\u0002\u0013\u0011\u0014!\u0002;j[\u0016\u0004\u0003b\u0002\u001d\u0001\u0005\u0004%\t!O\u0001\u0011G2,\u0017M\\3s\u0005\u0006\u001c7n\u00144g\u001bN,\u0012A\u000f\t\u0003\u0013mJ!\u0001\u0010\u0006\u0003\t1{gn\u001a\u0005\u0007}\u0001\u0001\u000b\u0011\u0002\u001e\u0002#\rdW-\u00198fe\n\u000b7m[(gM6\u001b\b\u0005C\u0004A\u0001\t\u0007I\u0011A\u0013\u0002\u0017M,w-\\3oiNK'0\u001a\u0005\u0007\u0005\u0002\u0001\u000b\u0011\u0002\u0014\u0002\u0019M,w-\\3oiNK'0\u001a\u0011\t\u000f\u0011\u0003!\u0019!C\u0001K\u0005YA-\u001a7fi\u0016$U\r\\1z\u0011\u00191\u0005\u0001)A\u0005M\u0005aA-\u001a7fi\u0016$U\r\\1zA!9\u0001\n\u0001b\u0001\n\u0003I\u0015a\u00027pO:\u000bW.Z\u000b\u0002\u0015B\u00111\nU\u0007\u0002\u0019*\u0011QJT\u0001\u0005Y\u0006twMC\u0001P\u0003\u0011Q\u0017M^1\n\u0005ma\u0005B\u0002*\u0001A\u0003%!*\u0001\u0005m_\u001et\u0015-\\3!\u0011\u001d!\u0006A1A\u0005\u0002U\u000ba\u0001\\8h\t&\u0014X#\u0001,\u0011\u0005]SV\"\u0001-\u000b\u0005es\u0015AA5p\u0013\tY\u0006L\u0001\u0003GS2,\u0007BB/\u0001A\u0003%a+A\u0004m_\u001e$\u0015N\u001d\u0011\t\u000f}\u0003\u0001\u0019!C\u0001K\u000591m\\;oi\u0016\u0014\bbB1\u0001\u0001\u0004%\tAY\u0001\fG>,h\u000e^3s?\u0012*\u0017\u000f\u0006\u0002dMB\u0011\u0011\u0002Z\u0005\u0003K*\u0011A!\u00168ji\"9q\rYA\u0001\u0002\u00041\u0013a\u0001=%c!1\u0011\u000e\u0001Q!\n\u0019\n\u0001bY8v]R,'\u000f\t\u0005\bW\u0002\u0011\r\u0011\"\u0001m\u0003\u0019!x\u000e]5dgV\tQ\u000eE\u0002\n]BL!a\u001c\u0006\u0003\u000b\u0005\u0013(/Y=\u0011\u0005ELX\"\u0001:\u000b\u0005M$\u0018AB2p[6|gN\u0003\u0002\u0006k*\u0011ao^\u0001\u0007CB\f7\r[3\u000b\u0003a\f1a\u001c:h\u0013\tQ(O\u0001\bU_BL7\rU1si&$\u0018n\u001c8\t\rq\u0004\u0001\u0015!\u0003n\u0003\u001d!x\u000e]5dg\u0002BqA \u0001C\u0002\u0013\u0005q0\u0001\td_6\u0004(/Z:tS>t7i\u001c3fGV\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001:\u0002\rI,7m\u001c:e\u0013\u0011\tY!!\u0002\u0003\u001f\r{W\u000e\u001d:fgNLwN\u001c+za\u0016D\u0001\"a\u0004\u0001A\u0003%\u0011\u0011A\u0001\u0012G>l\u0007O]3tg&|gnQ8eK\u000e\u0004\u0003bBA\n\u0001\u0011\u0005\u0011QC\u0001\fG2,\u0017M\\3s)\u0016\u001cH\u000fF\u0001dQ\u0011\t\t\"!\u0007\u0011\t\u0005m\u0011\u0011E\u0007\u0003\u0003;Q1!a\bx\u0003\u0015QWO\\5u\u0013\u0011\t\u0019#!\b\u0003\tQ+7\u000f\u001e\u0005\b\u0003O\u0001A\u0011BA\u0015\u0003-\u0011X-\u00193Ge>lGj\\4\u0015\t\u0005-\u0012Q\b\t\u0007\u0003[\t\u0019$a\u000e\u000e\u0005\u0005=\"bAA\u0019\u0015\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005U\u0012q\u0006\u0002\t\u0013R,'/\u00192mKB)\u0011\"!\u000f'M%\u0019\u00111\b\u0006\u0003\rQ+\b\u000f\\33\u0011\u001d\u0019\u0011Q\u0005a\u0001\u0003\u007f\u00012!IA!\u0013\r\t\u0019E\u0001\u0002\u0004\u0019><\u0007bBA$\u0001\u0011%\u0011\u0011J\u0001\noJLG/\u001a#vaN$B\"a\u0013\u0002R\u0005U\u0013\u0011LA.\u0003?\u0002b!!\f\u0002N\u0005]\u0012\u0002BA(\u0003_\u00111aU3r\u0011\u001d\t\u0019&!\u0012A\u0002\u0019\nqA\\;n\u0017\u0016L8\u000fC\u0004\u0002X\u0005\u0015\u0003\u0019\u0001\u0014\u0002\u000f9,X\u000eR;qg\"91!!\u0012A\u0002\u0005}\u0002\u0002CA/\u0003\u000b\u0002\r!!\u0001\u0002\u000b\r|G-Z2\t\u000f\u0005\u0005\u0014Q\ta\u0001u\u0005IA/[7fgR\fW\u000e\u001d\u0005\b\u0003K\u0002A\u0011AA\u000b\u0003!!X-\u0019:e_^t\u0007\u0006BA2\u0003S\u0002B!a\u0007\u0002l%!\u0011QNA\u000f\u0005\u0015\te\r^3s\u0011\u001d\t\t\b\u0001C\u0005\u0003g\n1\"\\1lK\u000ecW-\u00198feRq\u0011QOA>\u0003\u007f\nI)!$\u0002\u0012\u0006U\u0005cA\u0011\u0002x%\u0019\u0011\u0011\u0010\u0002\u0003\u00151{wm\u00117fC:,'\u000fC\u0004\u0002~\u0005=\u0004\u0019\u0001\u0014\u0002\u000bA\f'\u000f^:\t\u0015\u0005\u0005\u0015q\u000eI\u0001\u0002\u0004\t\u0019)\u0001\fnS:\u001cE.Z1oC\ndW\rR5sif\u0014\u0016\r^5p!\rI\u0011QQ\u0005\u0004\u0003\u000fS!!\u0002$m_\u0006$\b\"CAF\u0003_\u0002\n\u00111\u0001'\u0003)qW/\u001c+ie\u0016\fGm\u001d\u0005\n\u0003\u001f\u000by\u0007%AA\u0002i\n\u0011BY1dW>3g-T:\t\u0013\u0005M\u0015q\u000eI\u0001\u0002\u00041\u0012!\u00043fM\u0006,H\u000e\u001e)pY&\u001c\u0017\u0010\u0003\u0006\u0002\u0018\u0006=\u0004\u0013!a\u0001\u00033\u000bq\u0002]8mS\u000eLxJ^3se&$Wm\u001d\t\u0007\u0003[\tYJ\u0006\f\n\t\u0005u\u0015q\u0006\u0002\u0004\u001b\u0006\u0004\b\"CAQ\u0001E\u0005I\u0011BAR\u0003Ui\u0017m[3DY\u0016\fg.\u001a:%I\u00164\u0017-\u001e7uII*\"!!*+\t\u0005\r\u0015qU\u0016\u0003\u0003S\u0003B!a+\u000266\u0011\u0011Q\u0016\u0006\u0005\u0003_\u000b\t,A\u0005v]\u000eDWmY6fI*\u0019\u00111\u0017\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u00028\u00065&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u00111\u0018\u0001\u0012\u0002\u0013%\u0011QX\u0001\u0016[\u0006\\Wm\u00117fC:,'\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tyLK\u0002'\u0003OC\u0011\"a1\u0001#\u0003%I!!2\u0002+5\f7.Z\"mK\u0006tWM\u001d\u0013eK\u001a\fW\u000f\u001c;%iU\u0011\u0011q\u0019\u0016\u0004u\u0005\u001d\u0006\"CAf\u0001E\u0005I\u0011BAg\u0003Ui\u0017m[3DY\u0016\fg.\u001a:%I\u00164\u0017-\u001e7uIU*\"!a4+\u0007Y\t9\u000bC\u0005\u0002T\u0002\t\n\u0011\"\u0003\u0002V\u0006)R.Y6f\u00072,\u0017M\\3sI\u0011,g-Y;mi\u00122TCAAlU\u0011\tI*a*)\u000f\u0001\tY.a:\u0002jB!\u0011Q\\Ar\u001b\t\tyN\u0003\u0003\u0002b\u0006u\u0011A\u0002:v]:,'/\u0003\u0003\u0002f\u0006}'a\u0002*v]^KG\u000f[\u0001\u0006m\u0006dW/Z\u0012\u0003\u0003W\u0004B!!<\u0002t6\u0011\u0011q\u001e\u0006\u0005\u0003c\fi\"A\u0004sk:tWM]:\n\t\u0005U\u0018q\u001e\u0002\u000e!\u0006\u0014\u0018-\\3uKJL'0\u001a3\b\u000f\u0005e(\u0001#\u0001\u0002|\u0006aBj\\4DY\u0016\fg.\u001a:MC\u001eLe\u000e^3he\u0006$\u0018n\u001c8UKN$\bcA\u0011\u0002~\u001a1\u0011A\u0001E\u0001\u0003\u007f\u001c2!!@\t\u0011\u001dq\u0012Q C\u0001\u0005\u0007!\"!a?\t\u0011\t\u001d\u0011Q C\u0001\u0005\u0013\tAb\u001c8f!\u0006\u0014\u0018-\\3uKJ,\"Aa\u0003\u0011\r\t5!1\u0003B\f\u001b\t\u0011yAC\u0002\u0003\u00129\u000bA!\u001e;jY&!!Q\u0003B\b\u0005)\u0019u\u000e\u001c7fGRLwN\u001c\t\u0004\u001394\u0002\u0002\u0003B\u000e\u0003{$\tA!\u0003\u0002\u0015A\f'/Y7fi\u0016\u00148\u000f\u000b\u0003\u0003\u001a\t}\u0001\u0003\u0002B\u0011\u0005sqAAa\t\u000369!!Q\u0005B\u001a\u001d\u0011\u00119C!\r\u000f\t\t%\"qF\u0007\u0003\u0005WQ1A!\f\u0007\u0003\u0019a$o\\8u}%\t\u00010C\u0002\u0002 ]LA!!=\u0002\u001e%!!qGAx\u00035\u0001\u0016M]1nKR,'/\u001b>fI&!!1\bB\u001f\u0005)\u0001\u0016M]1nKR,'o\u001d\u0006\u0005\u0005o\ty\u000f")
public class LogCleanerLagIntegrationTest
implements Logging {
    private final int msPerHour;
    private final int compactionLag;
    private final MockTime time;
    private final long cleanerBackOffMs;
    private final int segmentSize;
    private final int deleteDelay;
    private final String logName;
    private final File logDir;
    private int counter;
    private final TopicPartition[] topics;
    private final CompressionType compressionCodec;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    @Parameterized.Parameters
    public static Collection<String[]> parameters() {
        return LogCleanerLagIntegrationTest$.MODULE$.parameters();
    }

    public static Collection<String[]> oneParameter() {
        return LogCleanerLagIntegrationTest$.MODULE$.oneParameter();
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogCleanerLagIntegrationTest logCleanerLagIntegrationTest = this;
        synchronized (logCleanerLagIntegrationTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public int msPerHour() {
        return this.msPerHour;
    }

    public int compactionLag() {
        return this.compactionLag;
    }

    public MockTime time() {
        return this.time;
    }

    public long cleanerBackOffMs() {
        return this.cleanerBackOffMs;
    }

    public int segmentSize() {
        return this.segmentSize;
    }

    public int deleteDelay() {
        return this.deleteDelay;
    }

    public String logName() {
        return this.logName;
    }

    public File logDir() {
        return this.logDir;
    }

    public int counter() {
        return this.counter;
    }

    public void counter_$eq(int x$1) {
        this.counter = x$1;
    }

    public TopicPartition[] topics() {
        return this.topics;
    }

    public CompressionType compressionCodec() {
        return this.compressionCodec;
    }

    @Test
    public void cleanerTest() {
        int x$3 = 3;
        long x$4 = this.cleanerBackOffMs();
        float x$5 = this.makeCleaner$default$2();
        int x$6 = this.makeCleaner$default$3();
        String x$7 = this.makeCleaner$default$5();
        Map<String, String> x$8 = this.makeCleaner$default$6();
        LogCleaner cleaner = this.makeCleaner(x$3, x$5, x$6, x$4, x$7, x$8);
        Log log = (Log)cleaner.logs().get((Object)this.topics()[0]);
        long T0 = this.time().milliseconds();
        Seq<Tuple2<Object, Object>> appends0 = this.writeDups(100, 3, log, this.compressionCodec(), T0);
        long startSizeBlock0 = log.size();
        this.debug((Function0<String>)new Serializable(this, startSizeBlock0){
            public static final long serialVersionUID = 0L;
            private final long startSizeBlock0$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"total log size at T0: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.startSizeBlock0$1)}));
            }
            {
                this.startSizeBlock0$1 = startSizeBlock0$1;
            }
        });
        LogSegment activeSegAtT0 = log.activeSegment();
        this.debug((Function0<String>)new Serializable(this, activeSegAtT0){
            public static final long serialVersionUID = 0L;
            private final LogSegment activeSegAtT0$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"active segment at T0 has base offset: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.activeSegAtT0$1.baseOffset())}));
            }
            {
                this.activeSegAtT0$1 = activeSegAtT0$1;
            }
        });
        long sizeUpToActiveSegmentAtT0 = BoxesRunTime.unboxToLong((Object)((TraversableOnce)log.logSegments(0L, activeSegAtT0.baseOffset()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$1) {
                return x$1.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        this.debug((Function0<String>)new Serializable(this, sizeUpToActiveSegmentAtT0){
            public static final long serialVersionUID = 0L;
            private final long sizeUpToActiveSegmentAtT0$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log size up to base offset of active segment at T0: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.sizeUpToActiveSegmentAtT0$1)}));
            }
            {
                this.sizeUpToActiveSegmentAtT0$1 = sizeUpToActiveSegmentAtT0$1;
            }
        });
        cleaner.startup();
        this.time().sleep(this.compactionLag() / 2);
        Thread.sleep(5L * this.cleanerBackOffMs());
        Assert.assertEquals((String)"There should be no cleaning until the compaction lag has passed", (long)startSizeBlock0, (long)log.size());
        this.time().sleep(this.compactionLag() / 2 + 1);
        long T1 = this.time().milliseconds();
        Seq appends1 = (Seq)appends0.$plus$plus(this.writeDups(100, 3, log, this.compressionCodec(), T1), Seq$.MODULE$.canBuildFrom());
        long firstBlock1SegmentBaseOffset = activeSegAtT0.baseOffset();
        cleaner.awaitCleaned(new TopicPartition("log", 0), activeSegAtT0.baseOffset(), cleaner.awaitCleaned$default$3());
        Iterable<Tuple2<Object, Object>> read1 = this.readFromLog(log);
        Assert.assertEquals((String)"Contents of the map shouldn't change.", (Object)appends1.toMap(Predef$.MODULE$.conforms()), (Object)read1.toMap(Predef$.MODULE$.conforms()));
        long compactedSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)log.logSegments(0L, activeSegAtT0.baseOffset()).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$2) {
                return x$2.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        this.debug((Function0<String>)new Serializable(this, compactedSize){
            public static final long serialVersionUID = 0L;
            private final long compactedSize$1;

            public final String apply() {
                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"after cleaning the compacted size up to active segment at T0: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.compactedSize$1)}));
            }
            {
                this.compactedSize$1 = compactedSize$1;
            }
        });
        long lastCleaned = BoxesRunTime.unboxToLong((Object)cleaner.cleanerManager().allCleanerCheckpoints().apply((Object)new TopicPartition("log", 0)));
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log cleaner should have processed up to offset ", ", but lastCleaned=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)firstBlock1SegmentBaseOffset), BoxesRunTime.boxToLong((long)lastCleaned)})), (lastCleaned >= firstBlock1SegmentBaseOffset ? 1 : 0) != 0);
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"log should have been compacted: size up to offset of active segment at T0=", " compacted size=", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)sizeUpToActiveSegmentAtT0), BoxesRunTime.boxToLong((long)compactedSize)})), (sizeUpToActiveSegmentAtT0 > compactedSize ? 1 : 0) != 0);
        cleaner.logs().remove((Object)this.topics()[0]);
        cleaner.shutdown();
    }

    private Iterable<Tuple2<Object, Object>> readFromLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Tuple2<Object, Object>> apply(LogSegment segment) {
                return (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().deepEntries()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<Object, Object> apply(LogEntry logEntry) {
                        int key = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(logEntry.record().key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                        int value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(logEntry.record().value(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)key)), (Object)BoxesRunTime.boxToInteger((int)value));
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private Seq<Tuple2<Object, Object>> writeDups(int numKeys, int numDups, Log log, CompressionType codec, long timestamp) {
        return (Seq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numDups).flatMap((Function1)new Serializable(this, numKeys, log, codec, timestamp){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerLagIntegrationTest $outer;
            private final int numKeys$1;
            public final Log log$1;
            public final CompressionType codec$1;
            public final long timestamp$1;

            public final IndexedSeq<Tuple2<Object, Object>> apply(int _) {
                return (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numKeys$1).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$writeDups$1 $outer;

                    public final Tuple2<Object, Object> apply(int key) {
                        int count = this.$outer.kafka$log$LogCleanerLagIntegrationTest$$anonfun$$$outer().counter();
                        byte[] x$9 = ((Object)BoxesRunTime.boxToInteger((int)this.$outer.kafka$log$LogCleanerLagIntegrationTest$$anonfun$$$outer().counter())).toString().getBytes();
                        CompressionType x$10 = this.$outer.codec$1;
                        byte[] x$11 = ((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes();
                        long x$12 = this.$outer.timestamp$1;
                        byte x$13 = TestUtils$.MODULE$.singletonRecords$default$5();
                        this.$outer.log$1.append(TestUtils$.MODULE$.singletonRecords(x$9, x$11, x$10, x$12, x$13), true);
                        this.$outer.kafka$log$LogCleanerLagIntegrationTest$$anonfun$$$outer().counter_$eq(this.$outer.kafka$log$LogCleanerLagIntegrationTest$$anonfun$$$outer().counter() + 1);
                        return new Tuple2.mcII.sp(key, count);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }, IndexedSeq$.MODULE$.canBuildFrom());
            }

            public /* synthetic */ LogCleanerLagIntegrationTest kafka$log$LogCleanerLagIntegrationTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.numKeys$1 = numKeys$1;
                this.log$1 = log$1;
                this.codec$1 = codec$1;
                this.timestamp$1 = timestamp$1;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
    }

    @After
    public void teardown() {
        this.time().scheduler().shutdown();
        Utils.delete((File)this.logDir());
    }

    private LogCleaner makeCleaner(int parts, float minCleanableDirtyRatio, int numThreads, long backOffMs, String defaultPolicy, Map<String, String> policyOverrides) {
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), parts).foreach((Function1)new Serializable(this, minCleanableDirtyRatio, logs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerLagIntegrationTest $outer;
            private final float minCleanableDirtyRatio$1;
            private final Pool logs$1;

            public final Log apply(int i) {
                File dir = new File(this.$outer.logDir(), new StringBuilder().append((Object)"log-").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                dir.mkdirs();
                Properties logProps = new Properties();
                logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(this.$outer.segmentSize()));
                logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(102400));
                logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(this.$outer.deleteDelay()));
                logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(this.$outer.compactionLag()));
                logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
                logProps.put(LogConfig$.MODULE$.MinCleanableDirtyRatioProp(), Predef$.MODULE$.float2Float(this.minCleanableDirtyRatio$1));
                Log log = new Log(dir, new LogConfig((java.util.Map)logProps), 0L, (Scheduler)this.$outer.time().scheduler(), (Time)this.$outer.time());
                return (Log)this.logs$1.put((Object)new TopicPartition("log", i), (Object)log);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.minCleanableDirtyRatio$1 = minCleanableDirtyRatio$1;
                this.logs$1 = logs$1;
            }
        });
        int x$14 = numThreads;
        long x$15 = backOffMs;
        long x$16 = CleanerConfig$.MODULE$.apply$default$2();
        double x$17 = CleanerConfig$.MODULE$.apply$default$3();
        int x$18 = CleanerConfig$.MODULE$.apply$default$4();
        int x$19 = CleanerConfig$.MODULE$.apply$default$5();
        double x$20 = CleanerConfig$.MODULE$.apply$default$6();
        boolean x$21 = CleanerConfig$.MODULE$.apply$default$8();
        String x$22 = CleanerConfig$.MODULE$.apply$default$9();
        return new LogCleaner(new CleanerConfig(x$14, x$16, x$17, x$18, x$19, x$20, x$15, x$21, x$22), (File[])((Object[])new File[]{this.logDir()}), logs, (Time)this.time());
    }

    private float makeCleaner$default$2() {
        return 0.0f;
    }

    private int makeCleaner$default$3() {
        return 1;
    }

    private long makeCleaner$default$4() {
        return 200L;
    }

    private String makeCleaner$default$5() {
        return "compact";
    }

    private Map<String, String> makeCleaner$default$6() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public LogCleanerLagIntegrationTest(String compressionCodecName) {
        Logging.class.$init$((Logging)this);
        this.msPerHour = 3600000;
        this.compactionLag = 1 * this.msPerHour();
        Assert.assertTrue((String)"compactionLag must be divisible by 2 for this test", (this.compactionLag() % 2 == 0 ? 1 : 0) != 0);
        this.time = new MockTime(1400000000000L, 1000L);
        this.cleanerBackOffMs = 200L;
        this.segmentSize = 100;
        this.deleteDelay = 1000;
        this.logName = "log";
        this.logDir = TestUtils$.MODULE$.tempDir();
        this.counter = 0;
        this.topics = (TopicPartition[])((Object[])new TopicPartition[]{new TopicPartition("log", 0), new TopicPartition("log", 1), new TopicPartition("log", 2)});
        this.compressionCodec = CompressionType.forName((String)compressionCodecName);
    }
}

