/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.util.Properties;
import kafka.log.Log;
import kafka.log.LogCleanerManager;
import kafka.log.LogCleanerManager$;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.MockTime;
import kafka.utils.Pool;
import kafka.utils.Pool$;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001B\u0001\u0003\u0001\u001d\u0011Q\u0003T8h\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011I\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\u000b\u0015Vs\u0017\u000e^*vSR,\u0007CA\n\u0017\u001b\u0005!\"BA\u000b\u0005\u0003\u0015)H/\u001b7t\u0013\t9BCA\u0004M_\u001e<\u0017N\\4\t\u000be\u0001A\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005Y\u0002C\u0001\u000f\u0001\u001b\u0005\u0011\u0001b\u0002\u0010\u0001\u0005\u0004%\taH\u0001\u0007i6\u0004H)\u001b:\u0016\u0003\u0001\u0002\"!\t\u0014\u000e\u0003\tR!a\t\u0013\u0002\u0005%|'\"A\u0013\u0002\t)\fg/Y\u0005\u0003O\t\u0012AAR5mK\"1\u0011\u0006\u0001Q\u0001\n\u0001\nq\u0001^7q\t&\u0014\b\u0005C\u0004,\u0001\t\u0007I\u0011A\u0010\u0002\r1|w\rR5s\u0011\u0019i\u0003\u0001)A\u0005A\u00059An\\4ESJ\u0004\u0003bB\u0018\u0001\u0005\u0004%\t\u0001M\u0001\tY><\u0007K]8qgV\t\u0011\u0007\u0005\u00023k5\t1G\u0003\u00025I\u0005!Q\u000f^5m\u0013\t14G\u0001\u0006Qe>\u0004XM\u001d;jKNDa\u0001\u000f\u0001!\u0002\u0013\t\u0014!\u00037pOB\u0013x\u000e]:!\u0011\u001dQ\u0004A1A\u0005\u0002m\n\u0011\u0002\\8h\u0007>tg-[4\u0016\u0003q\u0002\"\u0001H\u001f\n\u0005y\u0012!!\u0003'pO\u000e{gNZ5h\u0011\u0019\u0001\u0005\u0001)A\u0005y\u0005QAn\\4D_:4\u0017n\u001a\u0011\t\u000f\t\u0003!\u0019!C\u0001\u0007\u0006!A/[7f+\u0005!\u0005CA\nF\u0013\t1EC\u0001\u0005N_\u000e\\G+[7f\u0011\u0019A\u0005\u0001)A\u0005\t\u0006)A/[7fA!)!\n\u0001C\u0001\u0017\u0006AA/Z1s\t><h\u000eF\u0001M!\ti\u0005+D\u0001O\u0015\u0005y\u0015!B:dC2\f\u0017BA)O\u0005\u0011)f.\u001b;)\u0005%\u001b\u0006C\u0001+W\u001b\u0005)&BA\u0006\u000f\u0013\t9VKA\u0003BMR,'\u000fC\u0003Z\u0001\u0011\u00051*\u0001#uKN$Hj\\4t/&$\bnU3h[\u0016tGo\u001d+p\t\u0016dW\r^3TQ>,H\u000e\u001a(pi\u000e{gn]5eKJ\u001cE.Z1okB\u0004v\u000e\\5ds\u0012+G.\u001a;f\u0019><7\u000f\u000b\u0002Y7B\u0011A\u000bX\u0005\u0003;V\u0013A\u0001V3ti\")q\f\u0001C\u0001\u0017\u0006AE/Z:u\u0019><7oV5uQN+w-\\3oiN$v\u000eR3mKR,7\u000b[8vY\u0012\u001cuN\\:jI\u0016\u00148\t\\3b]V\u0004\bk\u001c7jGf\u001cu.\u001c9bGR$U\r\\3uK2{wm\u001d\u0015\u0003=nCQA\u0019\u0001\u0005\u0002-\u000bQ\t^3ti2{wm],ji\"\u001cVmZ7f]R\u001cHk\u001c#fY\u0016$Xm\u00155pk2$gj\u001c;D_:\u001c\u0018\u000eZ3s\u00072,\u0017M\\;q!>d\u0017nY=D_6\u0004\u0018m\u0019;M_\u001e\u001c\bFA1\\\u0011\u0015)\u0007\u0001\"\u0001L\u0003m!Xm\u001d;DY\u0016\fg.\u00192mK>3gm]3ug\u001a{'OT8oK\"\u0012Am\u0017\u0005\u0006Q\u0002!\taS\u0001\u001ci\u0016\u001cHo\u00117fC:\f'\r\\3PM\u001a\u001cX\r^:G_J$\u0016.\\3)\u0005\u001d\\\u0006\"B6\u0001\t\u0003Y\u0015\u0001\t;fgR\u001cE.Z1oC\ndWm\u00144gg\u0016$8OR8s'\"|'\u000f\u001e+j[\u0016D#A[.\t\u000b9\u0004A\u0011B8\u0002)\r\u0014X-\u0019;f\u00072,\u0017M\\3s\u001b\u0006t\u0017mZ3s)\t\u00018\u000f\u0005\u0002\u001dc&\u0011!O\u0001\u0002\u0012\u0019><7\t\\3b]\u0016\u0014X*\u00198bO\u0016\u0014\b\"B\u0002n\u0001\u0004!\bC\u0001\u000fv\u0013\t1(AA\u0002M_\u001eDQ\u0001\u001f\u0001\u0005\ne\f\u0011b\u0019:fCR,Gj\\4\u0015\u0007QTx\u0010C\u0003|o\u0002\u0007A0A\u0006tK\u001elWM\u001c;TSj,\u0007CA'~\u0013\tqhJA\u0002J]RD\u0011\"!\u0001x!\u0003\u0005\r!a\u0001\u0002\u001b\rdW-\u00198vaB{G.[2z!\u0011\t)!a\u0003\u000f\u00075\u000b9!C\u0002\u0002\n9\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0007\u0003\u001f\u0011aa\u0015;sS:<'bAA\u0005\u001d\"9\u00111\u0003\u0001\u0005\n\u0005U\u0011aB7bW\u0016dun\u001a\u000b\u0006i\u0006]\u00111\u0004\u0005\n\u00033\t\t\u0002%AA\u0002\u0001\n1\u0001Z5s\u0011%\ti\"!\u0005\u0011\u0002\u0003\u0007A(\u0001\u0004d_:4\u0017n\u001a\u0005\b\u0003C\u0001A\u0011BA\u0012\u0003)awnZ#oiJLWm\u001d\u000b\t\u0003K\tY$a\u0010\u0002DA!\u0011qEA\u001c\u001b\t\tIC\u0003\u0003\u0002,\u00055\u0012A\u0002:fG>\u0014HM\u0003\u0003\u00020\u0005E\u0012AB2p[6|gNC\u0002\u0006\u0003gQ1!!\u000e\u000f\u0003\u0019\t\u0007/Y2iK&!\u0011\u0011HA\u0015\u00055iU-\\8ssJ+7m\u001c:eg\"9\u0011QHA\u0010\u0001\u0004a\u0018aA6fs\"9\u0011\u0011IA\u0010\u0001\u0004a\u0018!\u0002<bYV,\u0007\u0002CA#\u0003?\u0001\r!a\u0012\u0002\u0013QLW.Z:uC6\u0004\bcA'\u0002J%\u0019\u00111\n(\u0003\t1{gn\u001a\u0005\n\u0003\u001f\u0002\u0011\u0013!C\u0005\u0003#\n1c\u0019:fCR,Gj\\4%I\u00164\u0017-\u001e7uII*\"!a\u0015+\t\u0005\r\u0011QK\u0016\u0003\u0003/\u0002B!!\u0017\u0002d5\u0011\u00111\f\u0006\u0005\u0003;\ny&A\u0005v]\u000eDWmY6fI*\u0019\u0011\u0011\r(\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002f\u0005m#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011\u0011\u000e\u0001\u0012\u0002\u0013%\u00111N\u0001\u0012[\u0006\\W\rT8hI\u0011,g-Y;mi\u0012\nTCAA7U\r\u0001\u0013Q\u000b\u0005\n\u0003c\u0002\u0011\u0013!C\u0005\u0003g\n\u0011#\\1lK2{w\r\n3fM\u0006,H\u000e\u001e\u00133+\t\t)HK\u0002=\u0003+\u0002")
public class LogCleanerManagerTest
extends JUnitSuite
implements Logging {
    private final File tmpDir;
    private final File logDir;
    private final Properties logProps;
    private final LogConfig logConfig;
    private final MockTime time;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        LogCleanerManagerTest logCleanerManagerTest = this;
        synchronized (logCleanerManagerTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public boolean isDebugEnabled() {
        return Logging.class.isDebugEnabled((Logging)this);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public File tmpDir() {
        return this.tmpDir;
    }

    public File logDir() {
        return this.logDir;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    @After
    public void tearDown() {
        Utils.delete((File)this.tmpDir());
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyDeleteLogs() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$2(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Delete());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 0 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldConsiderCleanupPolicyCompactDeleteLogs() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records2.sizeInBytes() * 5, new StringBuilder().append((Object)LogConfig$.MODULE$.Compact()).append((Object)",").append((Object)LogConfig$.MODULE$.Delete()).toString());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)1L, (long)readyToDelete);
    }

    @Test
    public void testLogsWithSegmentsToDeleteShouldNotConsiderCleanupPolicyCompactLogs() {
        MemoryRecords records2 = TestUtils$.MODULE$.singletonRecords("test".getBytes(), "test".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        Log log = this.createLog(records2.sizeInBytes() * 5, LogConfig$.MODULE$.Compact());
        LogCleanerManager cleanerManager = this.createCleanerManager(log);
        int readyToDelete = cleanerManager.deletableLogs().size();
        Assert.assertEquals((String)"should have 1 logs ready to be deleted", (long)0L, (long)readyToDelete);
    }

    @Test
    public void testCleanableOffsetsForNone() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$1 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$2 = this.makeLog$default$1();
        Log log = this.makeLog(x$2, x$1);
        while (log.numberOfSegments() < 8) {
            log.append(this.logEntries((int)log.logEndOffset(), (int)log.logEndOffset(), this.time().milliseconds()), log.append$default$2());
        }
        TopicPartition topicPartition = new TopicPartition("log", 0);
        Map lastClean = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with the active segment.", (long)log.activeSegment().baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testCleanableOffsetsForTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$3 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$4 = this.makeLog$default$1();
        Log log = this.makeLog(x$4, x$3);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 4) {
            log.append(this.logEntries((int)log.logEndOffset(), (int)log.logEndOffset(), t0), log.append$default$2());
        }
        LogSegment activeSegAtT0 = log.activeSegment();
        this.time().sleep(compactionLag + 1);
        long t1 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.append(this.logEntries((int)log.logEndOffset(), (int)log.logEndOffset(), t1), log.append$default$2());
        }
        TopicPartition topicPartition = new TopicPartition("log", 0);
        Map lastClean = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with the second block of log entries.", (long)activeSegAtT0.baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    @Test
    public void testCleanableOffsetsForShortTime() {
        int compactionLag = 3600000;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.MinCompactionLagMsProp(), Predef$.MODULE$.int2Integer(compactionLag));
        LogConfig x$5 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$6 = this.makeLog$default$1();
        Log log = this.makeLog(x$6, x$5);
        long t0 = this.time().milliseconds();
        while (log.numberOfSegments() < 8) {
            log.append(this.logEntries((int)log.logEndOffset(), (int)log.logEndOffset(), t0), log.append$default$2());
        }
        this.time().sleep(compactionLag + 1);
        TopicPartition topicPartition = new TopicPartition("log", 0);
        Map lastClean = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)topicPartition), (Object)BoxesRunTime.boxToLong((long)0L))}));
        Tuple2 cleanableOffsets = LogCleanerManager$.MODULE$.cleanableOffsets(log, topicPartition, lastClean, this.time().milliseconds());
        Assert.assertEquals((String)"The first cleanable offset starts at the beginning of the log.", (long)0L, (long)cleanableOffsets._1$mcJ$sp());
        Assert.assertEquals((String)"The first uncleanable offset begins with active segment.", (long)log.activeSegment().baseOffset(), (long)cleanableOffsets._2$mcJ$sp());
    }

    /*
     * WARNING - void declaration
     */
    private LogCleanerManager createCleanerManager(Log log) {
        void var3_3;
        Pool logs = new Pool((Option)Pool$.MODULE$.$lessinit$greater$default$1());
        logs.put((Object)new TopicPartition("log", 0), (Object)log);
        LogCleanerManager cleanerManager = new LogCleanerManager((File[])((Object[])new File[]{this.logDir()}), logs);
        return var3_3;
    }

    private Log createLog(int segmentSize, String cleanupPolicy) {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(segmentSize));
        logProps.put(LogConfig$.MODULE$.RetentionMsProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), cleanupPolicy);
        LogConfig config = new LogConfig((java.util.Map)logProps);
        File partitionDir = new File(this.logDir(), "log-0");
        Log log = new Log(partitionDir, config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
        return log;
    }

    private String createLog$default$2() {
        return "delete";
    }

    private Log makeLog(File dir, LogConfig config) {
        return new Log(dir, config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
    }

    private File makeLog$default$1() {
        return this.logDir();
    }

    private LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    private MemoryRecords logEntries(int key, int value, long timestamp) {
        return MemoryRecords.withRecords((Record[])new Record[]{Record.create((long)timestamp, (byte[])((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), (byte[])((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())});
    }

    public LogCleanerManagerTest() {
        Logging.class.$init$((Logging)this);
        this.tmpDir = TestUtils$.MODULE$.tempDir();
        this.logDir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpDir());
        this.logProps = new Properties();
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((java.util.Map)this.logProps());
        this.time = new MockTime(1400000000000L, 1000L);
    }
}

