/*
 * Decompiled with CFR 0.152.
 */
package kafka.log;

import java.io.File;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import kafka.common.LogCleaningAbortedException;
import kafka.log.Cleaner;
import kafka.log.CleanerStats;
import kafka.log.CleanerStats$;
import kafka.log.FakeOffsetMap;
import kafka.log.Log;
import kafka.log.Log$;
import kafka.log.LogAppendInfo;
import kafka.log.LogConfig;
import kafka.log.LogConfig$;
import kafka.log.LogSegment;
import kafka.log.LogToClean;
import kafka.log.OffsetMap;
import kafka.utils.CoreUtils$;
import kafka.utils.MockTime;
import kafka.utils.Scheduler;
import kafka.utils.TestUtils$;
import kafka.utils.Throttler;
import kafka.utils.Throttler$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.record.FileLogInputStream;
import org.apache.kafka.common.record.LogEntry;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.MemoryRecordsBuilder;
import org.apache.kafka.common.record.Record;
import org.apache.kafka.common.record.TimestampType;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.ListSet;
import scala.collection.immutable.ListSet$;
import scala.collection.immutable.Range;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

@ScalaSignature(bytes="\u0006\u0001\t}e\u0001B\u0001\u0003\u0001\u001d\u0011a\u0002T8h\u00072,\u0017M\\3s)\u0016\u001cHO\u0003\u0002\u0004\t\u0005\u0019An\\4\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011\u0002E\u0007\u0002\u0015)\u00111\u0002D\u0001\u0006UVt\u0017\u000e\u001e\u0006\u0003\u001b9\t\u0011b]2bY\u0006$Xm\u001d;\u000b\u0003=\t1a\u001c:h\u0013\t\t\"B\u0001\u0006K+:LGoU;ji\u0016DQa\u0005\u0001\u0005\u0002Q\ta\u0001P5oSRtD#A\u000b\u0011\u0005Y\u0001Q\"\u0001\u0002\t\u000fa\u0001!\u0019!C\u00013\u00051A/\u001c9eSJ,\u0012A\u0007\t\u00037\u0001j\u0011\u0001\b\u0006\u0003;y\t!![8\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u0005\r&dW\r\u0003\u0004$\u0001\u0001\u0006IAG\u0001\bi6\u0004H-\u001b:!\u0011\u001d)\u0003A1A\u0005\u0002e\t1\u0001Z5s\u0011\u00199\u0003\u0001)A\u00055\u0005!A-\u001b:!\u0011\u001dI\u0003A1A\u0005\u0002)\n\u0001\u0002\\8h!J|\u0007o]\u000b\u0002WA\u0011AfL\u0007\u0002[)\u0011aFH\u0001\u0005kRLG.\u0003\u00021[\tQ\u0001K]8qKJ$\u0018.Z:\t\rI\u0002\u0001\u0015!\u0003,\u0003%awn\u001a)s_B\u001c\b\u0005C\u00045\u0001\t\u0007I\u0011A\u001b\u0002\u00131|wmQ8oM&<W#\u0001\u001c\u0011\u0005Y9\u0014B\u0001\u001d\u0003\u0005%aunZ\"p]\u001aLw\r\u0003\u0004;\u0001\u0001\u0006IAN\u0001\u000bY><7i\u001c8gS\u001e\u0004\u0003b\u0002\u001f\u0001\u0005\u0004%\t!P\u0001\u0005i&lW-F\u0001?!\ty$)D\u0001A\u0015\t\tE!A\u0003vi&d7/\u0003\u0002D\u0001\nAQj\\2l)&lW\r\u0003\u0004F\u0001\u0001\u0006IAP\u0001\u0006i&lW\r\t\u0005\b\u000f\u0002\u0011\r\u0011\"\u0001I\u0003%!\bN]8ui2,'/F\u0001J!\ty$*\u0003\u0002L\u0001\nIA\u000b\u001b:piRdWM\u001d\u0005\u0007\u001b\u0002\u0001\u000b\u0011B%\u0002\u0015QD'o\u001c;uY\u0016\u0014\b\u0005C\u0003P\u0001\u0011\u0005\u0001+\u0001\u0005uK\u0006\u0014Hm\\<o)\u0005\t\u0006C\u0001*V\u001b\u0005\u0019&\"\u0001+\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001b&\u0001B+oSRD#A\u0014-\u0011\u0005e[V\"\u0001.\u000b\u0005-q\u0011B\u0001/[\u0005\u0015\te\r^3s\u0011\u0015q\u0006\u0001\"\u0001Q\u0003E!Xm\u001d;DY\u0016\fgnU3h[\u0016tGo\u001d\u0015\u0003;\u0002\u0004\"!W1\n\u0005\tT&\u0001\u0002+fgRDQ\u0001\u001a\u0001\u0005\u0002A\u000b\u0001\u0003^3ti2\u000b'oZ3NKN\u001c\u0018mZ3)\u0005\r\u0004\u0007\"B4\u0001\t\u0003\u0001\u0016a\u0006;fgR\u001cE.Z1oS:<w+\u001b;i\t\u0016dW\r^3tQ\t1\u0007\rC\u0003k\u0001\u0011\u0005\u0001+A\nuKN$Hj\\4DY\u0016\fg.\u001a:Ti\u0006$8\u000fC\u0003m\u0001\u0011\u0005\u0001+A\fuKN$\b+\u0019:uS\u0006d7+Z4nK:$8\t\\3b]\"\u00121\u000e\u0019\u0005\u0006_\u0002!\t\u0001U\u0001#i\u0016\u001cHo\u00117fC:LgnZ,ji\",fn\u00197fC:\f'\r\\3TK\u000e$\u0018n\u001c8)\u00059\u0004\u0007\"\u0002:\u0001\t\u0003\u0001\u0016A\u0004;fgRdun\u001a+p\u00072,\u0017M\u001c\u0015\u0003c\u0002DQ!\u001e\u0001\u0005\u0002A\u000bA\u0005^3ti2{w\rV8DY\u0016\fgnV5uQVs7\r\\3b]\u0006\u0014G.Z*fGRLwN\u001c\u0015\u0003i\u0002DQ\u0001\u001f\u0001\u0005\u0002A\u000bq\u0004^3ti\u000ecW-\u00198j]\u001e<\u0016\u000e\u001e5V].,\u00170\u001a3NKN\u001c\u0018mZ3tQ\t9\b\rC\u0003|\u0001\u0011\u0005A0A\u0005lKf\u001c\u0018J\u001c'pOR\u0019Q0!\u0004\u0011\u000by\f\u0019!a\u0002\u000e\u0003}T1!!\u0001T\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0004\u0003\u000by(\u0001C%uKJ\f'\r\\3\u0011\u0007I\u000bI!C\u0002\u0002\fM\u00131!\u00138u\u0011\u0019\u0019!\u00101\u0001\u0002\u0010A\u0019a#!\u0005\n\u0007\u0005M!AA\u0002M_\u001eDq!a\u0006\u0001\t\u0003\tI\"\u0001\u0007pM\u001a\u001cX\r^:J]2{w\r\u0006\u0003\u0002\u001c\u0005\r\u0002#\u0002@\u0002\u0004\u0005u\u0001c\u0001*\u0002 %\u0019\u0011\u0011E*\u0003\t1{gn\u001a\u0005\b\u0007\u0005U\u0001\u0019AA\b\u0011\u001d\t9\u0003\u0001C\u0001\u0003S\t\u0001$\u001e8lKf,G-T3tg\u0006<WmQ8v]RLe\u000eT8h)\u0011\t9!a\u000b\t\u000f\r\t)\u00031\u0001\u0002\u0010!9\u0011q\u0006\u0001\u0005\u0002\u0005E\u0012AD1c_J$8\t[3dW\u0012{g.\u001a\u000b\u0004#\u0006M\u0002\u0002CA\u001b\u0003[\u0001\r!a\u000e\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!\u0011\u0011HA#\u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0012AB2p[6|gNC\u0002\u0006\u0003\u0003R1!a\u0011\u000f\u0003\u0019\t\u0007/Y2iK&!\u0011qIA\u001e\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:Da!a\u0013\u0001\t\u0003\u0001\u0016A\u0007;fgR\u001cE.Z1o'\u0016<W.\u001a8ug^KG\u000f[!c_J$\bfAA%A\"1\u0011\u0011\u000b\u0001\u0005\u0002A\u000b1\u0003^3tiN+w-\\3oi\u001e\u0013x.\u001e9j]\u001eD3!a\u0014a\u0011\u0019\t9\u0006\u0001C\u0001!\u0006!C/Z:u'\u0016<W.\u001a8u\u000fJ|W\u000f]5oO^KG\u000f[*qCJ\u001cXm\u00144gg\u0016$8\u000fK\u0002\u0002V\u0001Dq!!\u0018\u0001\t\u0013\ty&A\tdQ\u0016\u001c7nU3h[\u0016tGo\u0014:eKJ$2!UA1\u0011!\t\u0019'a\u0017A\u0002\u0005\u0015\u0014AB4s_V\u00048\u000fE\u0003\u007f\u0003O\nY'C\u0002\u0002j}\u00141aU3r!\u0015q\u0018qMA7!\r1\u0012qN\u0005\u0004\u0003c\u0012!A\u0003'pON+w-\\3oi\"1\u0011Q\u000f\u0001\u0005\u0002A\u000b!\u0003^3ti\n+\u0018\u000e\u001c3PM\u001a\u001cX\r^'ba\"\u001a\u00111\u000f1\t\r\u0005m\u0004\u0001\"\u0001Q\u0003Y!Xm\u001d;SK\u000e|g/\u001a:z\u0003\u001a$XM]\"sCND\u0007fAA=A\"1\u0011\u0011\u0011\u0001\u0005\u0002A\u000b1\u0004^3ti\n+\u0018\u000e\u001c3PM\u001a\u001cX\r^'ba\u001a\u000b7.\u001a'be\u001e,\u0007fAA@A\"1\u0011q\u0011\u0001\u0005\u0002A\u000b\u0011\u0004^3ti\n+\u0018\u000e\u001c3QCJ$\u0018.\u00197PM\u001a\u001cX\r^'ba\"\u001a\u0011Q\u00111\t\r\u00055\u0005\u0001\"\u0001Q\u0003i!Xm\u001d;DY\u0016\fgnQ8seV\u0004H/T3tg\u0006<WmU3uQ\r\tY\t\u0019\u0005\u0007\u0003'\u0003A\u0011\u0001)\u0002KQ,7\u000f^\"mS\u0016tG\u000fS1oI2LgnZ(g\u0007>\u0014(/\u001e9u\u001b\u0016\u001c8/Y4f'\u0016$\bfAAIA\"1\u0011\u0011\u0014\u0001\u0005\u0002A\u000b!\u0003^3ti\u000ecW-\u00198U_6\u00147\u000f^8oK\"\u001a\u0011q\u00131\t\u000f\u0005}\u0005\u0001\"\u0003\u0002\"\u0006QqO]5uKR{Gj\\4\u0015\u0011\u0005m\u00111UAS\u0003cCqaAAO\u0001\u0004\ty\u0001\u0003\u0005\u0002(\u0006u\u0005\u0019AAU\u00035YW-_:B]\u00124\u0016\r\\;fgB)a0a\u0001\u0002,B9!+!,\u0002\b\u0005\u001d\u0011bAAX'\n1A+\u001e9mKJB\u0001\"a-\u0002\u001e\u0002\u0007\u00111D\u0001\n_\u001a47/\u001a;TKFDq!a.\u0001\t\u0013\tI,A\u000bj]Z\fG.\u001b3DY\u0016\fg.\u001a3NKN\u001c\u0018mZ3\u0015\u0011\u0005m\u0016qYAf\u0003\u001b\u0004B!!0\u0002D6\u0011\u0011q\u0018\u0006\u0005\u0003\u0003\fY$\u0001\u0004sK\u000e|'\u000fZ\u0005\u0005\u0003\u000b\fyLA\u0007NK6|'/\u001f*fG>\u0014Hm\u001d\u0005\t\u0003\u0013\f)\f1\u0001\u0002\u001e\u0005i\u0011N\\5uS\u0006dwJ\u001a4tKRD\u0001\"a*\u00026\u0002\u0007\u0011\u0011\u0016\u0005\u000b\u0003\u001f\f)\f%AA\u0002\u0005E\u0017!B2pI\u0016\u001c\u0007\u0003BA_\u0003'LA!!6\u0002@\ny1i\\7qe\u0016\u001c8/[8o)f\u0004X\rC\u0004\u0002Z\u0002!I!a7\u0002#5,7o]1hK^KG\u000f[(gMN,G\u000f\u0006\u0005\u0002<\u0006u\u0017\u0011]As\u0011!\ty.a6A\u0002\u0005\u001d\u0011aA6fs\"A\u00111]Al\u0001\u0004\t9!A\u0003wC2,X\r\u0003\u0005\u0002h\u0006]\u0007\u0019AA\u000f\u0003\u0019ygMZ:fi\"9\u00111\u001e\u0001\u0005\u0002\u00055\u0018aB7bW\u0016dun\u001a\u000b\u0007\u0003\u001f\ty/!=\t\u0011\u0015\nI\u000f%AA\u0002iA\u0011\"a=\u0002jB\u0005\t\u0019\u0001\u001c\u0002\r\r|gNZ5h\u0011\u001d\t9\u0010\u0001C\u0001\u0003s\fQB\\8Pa\u000eCWmY6E_:,GcA)\u0002|\"A\u0011QGA{\u0001\u0004\t9\u0004C\u0004\u0002\u0000\u0002!\tA!\u0001\u0002\u00175\f7.Z\"mK\u0006tWM\u001d\u000b\t\u0005\u0007\u0011IA!\u0004\u0003\u0018A\u0019aC!\u0002\n\u0007\t\u001d!AA\u0004DY\u0016\fg.\u001a:\t\u0011\t-\u0011Q a\u0001\u0003\u000f\t\u0001bY1qC\u000eLG/\u001f\u0005\u000b\u0005\u001f\ti\u0010%AA\u0002\tE\u0011!C2iK\u000e\\Gi\u001c8f!\u0019\u0011&1CA\u001c#&\u0019!QC*\u0003\u0013\u0019+hn\u0019;j_:\f\u0004B\u0003B\r\u0003{\u0004\n\u00111\u0001\u0002\b\u0005qQ.\u0019=NKN\u001c\u0018mZ3TSj,\u0007bBAP\u0001\u0011\u0005!Q\u0004\u000b\u0007\u00037\u0011yB!\t\t\u000f\r\u0011Y\u00021\u0001\u0002\u0010!A!1\u0005B\u000e\u0001\u0004\tI+A\u0002tKFDq!a8\u0001\t\u0003\u00119\u0003\u0006\u0003\u0003*\tU\u0002\u0003\u0002B\u0016\u0005ci!A!\f\u000b\u0007\t=b$A\u0002oS>LAAa\r\u0003.\tQ!)\u001f;f\u0005V4g-\u001a:\t\u0011\t]\"Q\u0005a\u0001\u0003\u000f\t!!\u001b3\t\u000f\u0005\u0005\u0007\u0001\"\u0001\u0003<Q1\u00111\u0018B\u001f\u0005\u007fA\u0001\"a8\u0003:\u0001\u0007\u0011q\u0001\u0005\t\u0003G\u0014I\u00041\u0001\u0002\b!9\u0011\u0011\u0019\u0001\u0005\u0002\t\rCCBA^\u0005\u000b\u00129\u0005\u0003\u0005\u0002`\n\u0005\u0003\u0019AA\u0004\u0011!\t\u0019O!\u0011A\u0002\t%\u0003#\u0002*\u0003L\t=\u0013b\u0001B''\n)\u0011I\u001d:bsB\u0019!K!\u0015\n\u0007\tM3K\u0001\u0003CsR,\u0007b\u0002B,\u0001\u0011\u0005!\u0011L\u0001\u000ek:\\W-_3e%\u0016\u001cwN\u001d3\u0015\t\u0005m&1\f\u0005\t\u0003G\u0014)\u00061\u0001\u0002\b!9!q\f\u0001\u0005\u0002\t\u0005\u0014a\u0004;p[\n\u001cHo\u001c8f%\u0016\u001cwN\u001d3\u0015\t\u0005m&1\r\u0005\t\u0003?\u0014i\u00061\u0001\u0002\b!I!q\r\u0001\u0012\u0002\u0013\u0005!\u0011N\u0001\u0016[\u0006\\Wm\u00117fC:,'\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011YG\u000b\u0003\u0003\u0012\t54F\u0001B8!\u0011\u0011\tHa\u001f\u000e\u0005\tM$\u0002\u0002B;\u0005o\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\te4+\u0001\u0006b]:|G/\u0019;j_:LAA! \u0003t\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t\u0005\u0005!%A\u0005\u0002\t\r\u0015!F7bW\u0016\u001cE.Z1oKJ$C-\u001a4bk2$HeM\u000b\u0003\u0005\u000bSC!a\u0002\u0003n!I!\u0011\u0012\u0001\u0012\u0002\u0013\u0005!1R\u0001\u0012[\u0006\\W\rT8hI\u0011,g-Y;mi\u0012\nTC\u0001BGU\rQ\"Q\u000e\u0005\n\u0005#\u0003\u0011\u0013!C\u0001\u0005'\u000b\u0011#\\1lK2{w\r\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011)JK\u00027\u0005[B\u0011B!'\u0001#\u0003%IAa'\u0002?%tg/\u00197jI\u000ecW-\u00198fI6+7o]1hK\u0012\"WMZ1vYR$3'\u0006\u0002\u0003\u001e*\"\u0011\u0011\u001bB7\u0001")
public class LogCleanerTest
extends JUnitSuite {
    private final File tmpdir = TestUtils$.MODULE$.tempDir();
    private final File dir = TestUtils$.MODULE$.randomPartitionLogDir(this.tmpdir());
    private final Properties logProps = new Properties();
    private final LogConfig logConfig;
    private final MockTime time;
    private final Throttler throttler;

    public File tmpdir() {
        return this.tmpdir;
    }

    public File dir() {
        return this.dir;
    }

    public Properties logProps() {
        return this.logProps;
    }

    public LogConfig logConfig() {
        return this.logConfig;
    }

    public MockTime time() {
        return this.time;
    }

    public Throttler throttler() {
        return this.throttler;
    }

    @After
    public void teardown() {
        Utils.delete((File)this.tmpdir());
    }

    @Test
    public void testCleanSegments() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$31 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$32 = this.makeLog$default$1();
        Log log = this.makeLog(x$32, x$31);
        while (log.numberOfSegments() < 4) {
            log.append(this.record((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        Iterable<Object> keysFound = this.keysInLog(log);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$1.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.map$1 = map$1;
            }
        });
        Seq segments = ((TraversableOnce)log.logSegments().take(3)).toSeq();
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        long expectedBytesRead = BoxesRunTime.unboxToLong((Object)((TraversableOnce)segments.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$1) {
                return x$1.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        cleaner.cleanSegments(log, segments, (OffsetMap)map, 0L, stats);
        Iterable shouldRemain = (Iterable)this.keysInLog(log).filter((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final ListSet keys$1;

            public final boolean apply(int x$2) {
                return this.apply$mcZI$sp(x$2);
            }

            public boolean apply$mcZI$sp(int x$2) {
                return !this.keys$1.contains((Object)BoxesRunTime.boxToInteger((int)x$2));
            }
            {
                this.keys$1 = keys$1;
            }
        });
        Assert.assertEquals((Object)shouldRemain, this.keysInLog(log));
        Assert.assertEquals((long)expectedBytesRead, (long)stats.bytesRead());
    }

    @Test
    public void testLargeMessage() {
        int largeMessageSize = 0x100000;
        int x$33 = Integer.MAX_VALUE;
        int x$34 = 1024;
        Function1<TopicPartition, BoxedUnit> x$35 = this.makeCleaner$default$2();
        Cleaner cleaner = this.makeCleaner(x$33, x$35, x$34);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 16));
        logProps.put(LogConfig$.MODULE$.MaxMessageBytesProp(), Predef$.MODULE$.int2Integer(largeMessageSize * 2));
        LogConfig x$36 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$37 = this.makeLog$default$1();
        Log log = this.makeLog(x$37, x$36);
        while (log.numberOfSegments() < 2) {
            log.append(this.record((int)log.logEndOffset(), (byte[])Array$.MODULE$.fill(largeMessageSize, (Function0)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final byte apply() {
                    return this.apply$mcB$sp();
                }

                public byte apply$mcB$sp() {
                    return 0;
                }
            }, ClassTag$.MODULE$.Byte())), log.append$default$2());
        }
        Iterable<Object> keysFound = this.keysInLog(log);
        Assert.assertEquals((Object)new RichLong(Predef$.MODULE$.longWrapper(0L)).until((Object)BoxesRunTime.boxToLong((long)log.logEndOffset())), keysFound);
        ListSet keys = (ListSet)ListSet$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 3, 5, 7, 9}));
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$2;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$2.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.map$2 = map$2;
            }
        });
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.cleanSegments(log, (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new LogSegment[]{(LogSegment)log.logSegments().head()})), (OffsetMap)map, 0L, stats);
        Iterable shouldRemain = (Iterable)this.keysInLog(log).filter((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final ListSet keys$2;

            public final boolean apply(int x$3) {
                return this.apply$mcZI$sp(x$3);
            }

            public boolean apply$mcZI$sp(int x$3) {
                return !this.keys$2.contains((Object)BoxesRunTime.boxToInteger((int)x$3));
            }
            {
                this.keys$2 = keys$2;
            }
        });
        Assert.assertEquals((Object)shouldRemain, this.keysInLog(log));
    }

    @Test
    public void testCleaningWithDeletes() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$38 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$39 = this.makeLog$default$1();
        Log log = this.makeLog(x$39, x$38);
        while (log.numberOfSegments() < 2) {
            log.append(this.record((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        long leo = log.logEndOffset();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).foreach((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$1;

            public final LogAppendInfo apply(int key) {
                return this.log$1.append(this.$outer.tombstoneRecord(key), this.log$1.append$default$2());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.log$1 = log$1;
            }
        });
        while (log.numberOfSegments() < 4) {
            log.append(this.record((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        Set keys = this.keysInLog(log).toSet();
        Assert.assertTrue((String)"None of the keys we deleted should still exist.", (boolean)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), (int)leo).by(2).forall((Function1)new Serializable(this, keys){
            public static final long serialVersionUID = 0L;
            private final Set keys$3;

            public final boolean apply(int x$4) {
                return this.apply$mcZI$sp(x$4);
            }

            public boolean apply$mcZI$sp(int x$4) {
                return !this.keys$3.contains((Object)BoxesRunTime.boxToInteger((int)x$4));
            }
            {
                this.keys$3 = keys$3;
            }
        }));
    }

    public void testLogCleanerStats() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$40 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$41 = this.makeLog$default$1();
        Log log = this.makeLog(x$41, x$40);
        log.append(this.record(0, 0), log.append$default$2());
        log.append(this.record(1, 1), log.append$default$2());
        log.append(this.record(0, 0), log.append$default$2());
        log.append(this.record(1, 1), log.append$default$2());
        log.append(this.record(0, 0), log.append$default$2());
        log.roll(log.roll$default$1());
        long initialLogSize = log.size();
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset()));
        if (tuple2 != null) {
            Tuple2 tuple22;
            long endOffset = tuple2._1$mcJ$sp();
            CleanerStats stats = (CleanerStats)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)endOffset), (Object)stats);
            long endOffset2 = tuple23._1$mcJ$sp();
            CleanerStats stats2 = (CleanerStats)tuple23._2();
            Assert.assertEquals((long)5L, (long)endOffset2);
            Assert.assertEquals((long)5L, (long)stats2.messagesRead());
            Assert.assertEquals((long)initialLogSize, (long)stats2.bytesRead());
            Assert.assertEquals((long)2L, (long)stats2.messagesWritten());
            Assert.assertEquals((long)log.size(), (long)stats2.bytesWritten());
            Assert.assertEquals((long)0L, (long)stats2.invalidMessagesRead());
            Assert.assertTrue((stats2.endTime() >= stats2.startTime() ? 1 : 0) != 0);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    @Test
    public void testPartialSegmentClean() {
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$42 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$43 = this.makeLog$default$1();
        Log log = this.makeLog(x$43, x$42);
        log.append(this.record(0, 0), log.append$default$2());
        log.append(this.record(1, 1), log.append$default$2());
        log.append(this.record(0, 0), log.append$default$2());
        log.append(this.record(1, 1), log.append$default$2());
        log.append(this.record(0, 0), log.append$default$2());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0, 1, 0})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3, 4})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 3L, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1, 0})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{2, 3, 4})), this.offsetsInLog(log));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 4L, log.activeSegment().baseOffset()));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 0})), this.keysInLog(log));
        Assert.assertEquals((Object)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{3, 4})), this.offsetsInLog(log));
    }

    @Test
    public void testCleaningWithUncleanableSection() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$44 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$45 = this.makeLog$default$1();
        Log log = this.makeLog(x$45, x$44);
        int N = 10;
        int numCleanableSegments = 2;
        int numTotalSegments = 7;
        while (log.numberOfSegments() <= numCleanableSegments) {
            log.append(this.record((int)log.logEndOffset() % N, (int)log.logEndOffset()), log.append$default$2());
        }
        long firstUncleanableOffset = log.logEndOffset() + 1L;
        while (log.numberOfSegments() < numTotalSegments - 1) {
            log.append(this.record((int)log.logEndOffset() % N, (int)log.logEndOffset()), log.append$default$2());
        }
        Seq disctinctValuesBySegmentBeforeClean = this.distinctValuesBySegment$1(log);
        Assert.assertTrue((String)"Test is not effective unless each segment contains duplicates. Increase segment size or decrease number of keys.", (boolean)((IterableLike)((TraversableLike)this.distinctValuesBySegment$1(log).reverse()).tail()).forall((Function1)new Serializable(this, N){
            public static final long serialVersionUID = 0L;
            private final int N$1;

            public final boolean apply(int x$6) {
                return this.apply$mcZI$sp(x$6);
            }

            public boolean apply$mcZI$sp(int x$6) {
                return x$6 > this.N$1;
            }
            {
                this.N$1 = N$1;
            }
        }));
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, firstUncleanableOffset));
        Seq distinctValuesBySegmentAfterClean = this.distinctValuesBySegment$1(log);
        Assert.assertTrue((String)"The cleanable segments should have fewer number of values after cleaning", (boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).take(numCleanableSegments)).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> x0$1) {
                Tuple2<Object, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    int before = tuple2._1$mcI$sp();
                    int after = tuple2._2$mcI$sp();
                    boolean bl = after < before;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }));
        Assert.assertTrue((String)"The uncleanable segments should have the same number of values after cleaning", (boolean)((IterableLike)((IterableLike)disctinctValuesBySegmentBeforeClean.zip((GenIterable)distinctValuesBySegmentAfterClean, Seq$.MODULE$.canBuildFrom())).slice(numCleanableSegments, numTotalSegments)).forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> x) {
                return x._1$mcI$sp() == x._2$mcI$sp();
            }
        }));
    }

    @Test
    public void testLogToClean() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$46 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$47 = this.makeLog$default$1();
        Log log = this.makeLog(x$47, x$46);
        MemoryRecords messageSet = TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(50, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply() {
                return this.apply$mcB$sp();
            }

            public byte apply$mcB$sp() {
                return 0;
            }
        }, ClassTag$.MODULE$.Byte()), ((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1)new Serializable(this, log, messageSet){
            public static final long serialVersionUID = 0L;
            private final Log log$3;
            private final MemoryRecords messageSet$1;

            public final LogAppendInfo apply(int _) {
                return this.log$3.append(this.messageSet$1, true);
            }
            {
                this.log$3 = log$3;
                this.messageSet$1 = messageSet$1;
            }
        });
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log, log.activeSegment().baseOffset(), log.activeSegment().baseOffset());
        Assert.assertEquals((String)"Total bytes of LogToClean should equal size of all segments excluding the active segment", (long)logToClean.totalBytes(), (long)(log.size() - log.activeSegment().size()));
    }

    @Test
    public void testLogToCleanWithUncleanableSection() {
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(100));
        LogConfig x$48 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$49 = this.makeLog$default$1();
        Log log = this.makeLog(x$49, x$48);
        MemoryRecords messageSet = TestUtils$.MODULE$.singletonRecords((byte[])Array$.MODULE$.fill(50, (Function0)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final byte apply() {
                return this.apply$mcB$sp();
            }

            public byte apply$mcB$sp() {
                return 0;
            }
        }, ClassTag$.MODULE$.Byte()), ((Object)BoxesRunTime.boxToInteger((int)1)).toString().getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 6).foreach((Function1)new Serializable(this, log, messageSet){
            public static final long serialVersionUID = 0L;
            private final Log log$4;
            private final MemoryRecords messageSet$2;

            public final LogAppendInfo apply(int _) {
                return this.log$4.append(this.messageSet$2, true);
            }
            {
                this.log$4 = log$4;
                this.messageSet$2 = messageSet$2;
            }
        });
        Seq segs = log.logSegments().toSeq();
        LogToClean logToClean = new LogToClean(new TopicPartition("test", 0), log, ((LogSegment)segs.apply(2)).baseOffset(), ((LogSegment)segs.apply(4)).baseOffset());
        long expectedCleanSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)segs.take(2)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$7) {
                return x$7.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        long expectedCleanableSize = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)segs.slice(2, 4)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$8) {
                return x$8.size();
            }
        }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        Assert.assertEquals((String)"Uncleanable bytes of LogToClean should equal size of all segments prior the one containing first dirty", (long)logToClean.cleanBytes(), (long)expectedCleanSize);
        Assert.assertEquals((String)"Cleanable bytes of LogToClean should equal size of all segments from the one containing first dirty offset to the segment prior to the one with the first uncleanable offset", (long)logToClean.cleanableBytes(), (long)expectedCleanableSize);
        Assert.assertEquals((String)"Total bytes should be the sum of the clean and cleanable segments", (long)logToClean.totalBytes(), (long)(expectedCleanSize + expectedCleanableSize));
        Assert.assertEquals((String)"Total cleanable ratio should be the ratio of cleanable size to clean plus cleanable", (double)logToClean.cleanableRatio(), (double)((double)expectedCleanableSize / (double)(expectedCleanSize + expectedCleanableSize)), (double)1.0E-6);
    }

    @Test
    public void testCleaningWithUnkeyedMessages() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Delete());
        LogConfig x$50 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$51 = this.makeLog$default$1();
        Log log = this.makeLog(x$51, x$50);
        while (log.numberOfSegments() < 2) {
            log.append(this.unkeyedRecord((int)log.logEndOffset()), log.append$default$2());
        }
        int numInvalidMessages = this.unkeyedMessageCountInLog(log);
        long sizeWithUnkeyedMessages = log.size();
        while (log.numberOfSegments() < 3) {
            log.append(this.record((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        long expectedSizeAfterCleaning = log.size() - sizeWithUnkeyedMessages;
        Tuple2 tuple2 = cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        if (tuple2 != null) {
            CleanerStats stats;
            CleanerStats cleanerStats;
            CleanerStats stats2 = cleanerStats = (stats = (CleanerStats)tuple2._2());
            Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)0L, (long)this.unkeyedMessageCountInLog(log));
            Assert.assertEquals((String)"Log should only contain keyed messages after cleaning.", (long)expectedSizeAfterCleaning, (long)log.size());
            Assert.assertEquals((String)"Cleaner should have seen %d invalid messages.", (long)numInvalidMessages, (long)stats2.invalidMessagesRead());
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public Iterable<Object> keysInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment s) {
                return (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().shallowEntries()).asScala()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileLogInputStream.FileChannelLogEntry x$9) {
                        return !x$9.record().hasNullValue();
                    }
                })).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileLogInputStream.FileChannelLogEntry x$10) {
                        return x$10.record().hasKey();
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final int apply(FileLogInputStream.FileChannelLogEntry m) {
                        return new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(m.record().key(), TestUtils$.MODULE$.readString$default$2()))).toInt();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public Iterable<Object> offsetsInLog(Log log) {
        return (Iterable)log.logSegments().flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<Object> apply(LogSegment s) {
                return (Iterable)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().shallowEntries()).asScala()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileLogInputStream.FileChannelLogEntry x$11) {
                        return !x$11.record().hasNullValue();
                    }
                })).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileLogInputStream.FileChannelLogEntry x$12) {
                        return x$12.record().hasKey();
                    }
                })).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(FileLogInputStream.FileChannelLogEntry m) {
                        return m.offset();
                    }
                }, Iterable$.MODULE$.canBuildFrom());
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public int unkeyedMessageCountInLog(Log log) {
        return BoxesRunTime.unboxToInt((Object)((TraversableOnce)log.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment s) {
                return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().shallowEntries()).asScala()).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileLogInputStream.FileChannelLogEntry x$13) {
                        return !x$13.record().hasNullValue();
                    }
                })).count((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(FileLogInputStream.FileChannelLogEntry m) {
                        return !m.record().hasKey();
                    }
                });
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$));
    }

    public void abortCheckDone(TopicPartition topicPartition) {
        throw new LogCleaningAbortedException();
    }

    @Test
    public void testCleanSegmentsWithAbort() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, (Function1<TopicPartition, BoxedUnit>)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;

            public final void apply(TopicPartition topicPartition) {
                this.$outer.abortCheckDone(topicPartition);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        LogConfig x$52 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$53 = this.makeLog$default$1();
        Log log = this.makeLog(x$53, x$52);
        while (log.numberOfSegments() < 4) {
            log.append(this.record((int)log.logEndOffset(), (int)log.logEndOffset()), log.append$default$2());
        }
        Iterable<Object> keys = this.keysInLog(log);
        FakeOffsetMap map = new FakeOffsetMap(Integer.MAX_VALUE);
        keys.foreach((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$3;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.map$3.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.map$3 = map$3;
            }
        });
        this.intercept((Function0)new Serializable(this, cleaner, log, map){
            public static final long serialVersionUID = 0L;
            private final Cleaner cleaner$1;
            private final Log log$5;
            private final FakeOffsetMap map$3;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.cleaner$1.cleanSegments(this.log$5, ((TraversableOnce)this.log$5.logSegments().take(3)).toSeq(), (OffsetMap)this.map$3, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
            }
            {
                this.cleaner$1 = cleaner$1;
                this.log$5 = log$5;
                this.map$3 = map$3;
            }
        }, ClassTag$.MODULE$.apply(LogCleaningAbortedException.class), new Position("LogCleanerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 359));
    }

    @Test
    public void testSegmentGrouping() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$54 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$55 = this.makeLog$default$1();
        Log log = this.makeLog(x$55, x$54);
        int i = 0;
        while (log.numberOfSegments() < 10) {
            log.append(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), log.append$default$2());
            ++i;
        }
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)groups.size());
        Assert.assertEquals((long)log.numberOfSegments(), (long)((SeqLike)groups.head()).size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), 1, Integer.MAX_VALUE);
        Assert.assertEquals((long)log.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$14) {
                return x$14.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, 1);
        Assert.assertEquals((long)log.numberOfSegments(), (long)groups.size());
        Assert.assertTrue((String)"All groups should be singletons.", (boolean)groups.forall((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Seq<LogSegment> x$15) {
                return x$15.size() == 1;
            }
        }));
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        int groupSize = 3;
        int logSize = (int)BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final long apply(LogSegment x$16) {
                return x$16.size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), logSize, Integer.MAX_VALUE);
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$17) {
                return x$17.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
        int indexSize = BoxesRunTime.unboxToInt((Object)((TraversableOnce)((TraversableLike)log.logSegments().take(groupSize)).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment x$18) {
                return x$18.index().sizeInBytes();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) + 1;
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, indexSize);
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        Assert.assertTrue((String)"All but the last group should be the target size.", (boolean)groups.dropRight(1).forall((Function1)new Serializable(this, groupSize){
            public static final long serialVersionUID = 0L;
            private final int groupSize$1;

            public final boolean apply(Seq<LogSegment> x$19) {
                return x$19.size() == this.groupSize$1;
            }
            {
                this.groupSize$1 = groupSize$1;
            }
        }));
    }

    @Test
    public void testSegmentGroupingWithSparseOffsets() {
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        LogConfig x$56 = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$57 = this.makeLog$default$1();
        Log log = this.makeLog(x$57, x$56);
        while (log.numberOfSegments() == 1) {
            log.append(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), log.append$default$2());
        }
        MemoryRecords records2 = MemoryRecords.withLogEntries((LogEntry[])new LogEntry[]{LogEntry.create((long)0x7FFFFFFEL, (Record)Record.create((byte[])"hello".getBytes(), (byte[])"hello".getBytes()))});
        log.append(records2, false);
        log.append(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), log.append$default$2());
        Assert.assertEquals((long)Integer.MAX_VALUE, (long)log.activeSegment().index().lastOffset());
        List groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertEquals((long)1L, (long)groups.size());
        log.append(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), log.append$default$2());
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertEquals((long)2L, (long)groups.size());
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
        while (log.numberOfSegments() < 4) {
            log.append(TestUtils$.MODULE$.singletonRecords("hello".getBytes(), "hello".getBytes(), TestUtils$.MODULE$.singletonRecords$default$3(), TestUtils$.MODULE$.singletonRecords$default$4(), TestUtils$.MODULE$.singletonRecords$default$5()), log.append$default$2());
        }
        groups = cleaner.groupSegmentsBySize(log.logSegments(), Integer.MAX_VALUE, Integer.MAX_VALUE);
        Assert.assertEquals((long)(log.numberOfSegments() - 1), (long)groups.size());
        groups.foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Seq<LogSegment> group) {
                Assert.assertTrue((String)"Relative offset greater than Int.MaxValue", (((LogSegment)group.last()).index().lastOffset() - ((LogSegment)group.head()).index().baseOffset() <= Integer.MAX_VALUE ? 1 : 0) != 0);
            }
        });
        this.checkSegmentOrder((Seq<Seq<LogSegment>>)groups);
    }

    private void checkSegmentOrder(Seq<Seq<LogSegment>> groups) {
        Seq offsets = (Seq)groups.flatMap((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(Seq<LogSegment> x$20) {
                return (Seq)x$20.map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final long apply(LogSegment x$21) {
                        return x$21.baseOffset();
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
        }, Seq$.MODULE$.canBuildFrom());
        Assert.assertEquals((String)"Offsets should be in increasing order.", (Object)offsets.sorted((Ordering)Ordering.Long$.MODULE$), (Object)offsets);
    }

    @Test
    public void testBuildOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Log log = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2());
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int start2 = 0;
        int end = 500;
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end), IndexedSeq$.MODULE$.canBuildFrom())));
        Seq segments = log.logSegments().toSeq();
        this.checkRange$1(map, 0, (int)((LogSegment)segments.apply(1)).baseOffset(), log, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(1)).baseOffset(), (int)((LogSegment)segments.apply(3)).baseOffset(), log, cleaner);
        this.checkRange$1(map, (int)((LogSegment)segments.apply(3)).baseOffset(), (int)log.logEndOffset(), log, cleaner);
    }

    @Test
    public void testRecoveryAfterCrash() {
        LogConfig config;
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(300));
        logProps.put(LogConfig$.MODULE$.IndexIntervalBytesProp(), Predef$.MODULE$.int2Integer(1));
        logProps.put(LogConfig$.MODULE$.FileDeleteDelayMsProp(), Predef$.MODULE$.int2Integer(10));
        LogConfig x$60 = config = LogConfig$.MODULE$.fromProps(this.logConfig().originals(), logProps);
        File x$61 = this.makeLog$default$1();
        Log log = this.makeLog(x$61, x$60);
        int messageCount = 0;
        while (log.numberOfSegments() < 10) {
            Log qual$1 = log;
            MemoryRecords x$62 = this.record((int)log.logEndOffset(), (int)log.logEndOffset());
            boolean x$63 = qual$1.append$default$2();
            qual$1.append(x$62, x$63);
            ++messageCount;
        }
        Iterable<Object> allKeys = this.keysInLog(log);
        FakeOffsetMap offsetMap = new FakeOffsetMap(Integer.MAX_VALUE);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap offsetMap$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$1.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.offsetMap$1 = offsetMap$1;
            }
        });
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        Iterable<Object> cleanedKeys = this.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.CleanedFileSuffix());
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
            }
        });
        log = this.recoverAndCheck$1(config, allKeys);
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        cleanedKeys = this.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(File file) {
                return file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix());
            }
        }).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                Utils.atomicMoveWithFallback((Path)file.toPath(), (Path)Paths.get(CoreUtils$.MODULE$.replaceSuffix(file.getPath(), Log$.MODULE$.DeletedFileSuffix(), ""), new String[0]));
            }
        });
        log = this.recoverAndCheck$1(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            Log qual$2 = log;
            MemoryRecords x$64 = this.record((int)log.logEndOffset(), (int)log.logEndOffset());
            boolean x$65 = qual$2.append$default$2();
            qual$2.append(x$64, x$65);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap offsetMap$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$1.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.offsetMap$1 = offsetMap$1;
            }
        });
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        cleanedKeys = this.keysInLog(log);
        ((LogSegment)log.logSegments().head()).changeFileSuffixes("", Log$.MODULE$.SwapFileSuffix());
        log = this.recoverAndCheck$1(config, cleanedKeys);
        while (log.numberOfSegments() < 10) {
            Log qual$3 = log;
            MemoryRecords x$66 = this.record((int)log.logEndOffset(), (int)log.logEndOffset());
            boolean x$67 = qual$3.append$default$2();
            qual$3.append(x$66, x$67);
            ++messageCount;
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), messageCount).by(2).foreach$mVc$sp((Function1)new Serializable(this, offsetMap){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap offsetMap$1;

            public final void apply(int k) {
                this.apply$mcVI$sp(k);
            }

            public void apply$mcVI$sp(int k) {
                this.offsetMap$1.put(this.$outer.key(k), Long.MAX_VALUE);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.offsetMap$1 = offsetMap$1;
            }
        });
        cleaner.cleanSegments(log, ((TraversableOnce)log.logSegments().take(9)).toSeq(), (OffsetMap)offsetMap, 0L, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        cleanedKeys = this.keysInLog(log);
        this.recoverAndCheck$1(config, cleanedKeys);
    }

    @Test
    public void testBuildOffsetMapFakeLarge() {
        LogConfig logConfig;
        FakeOffsetMap map = new FakeOffsetMap(1000);
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(72));
        logProps.put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(72));
        logProps.put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        LogConfig x$68 = logConfig = new LogConfig((Map)logProps);
        File x$69 = this.makeLog$default$1();
        Log log = this.makeLog(x$69, x$68);
        Cleaner cleaner = this.makeCleaner(Integer.MAX_VALUE, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        int start2 = 0;
        int end = 2;
        Seq offsetSeq = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapLongArray(new long[]{0L, 7206178L}));
        this.writeToLog(log, (Iterable<Tuple2<Object, Object>>)((Iterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end).zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end), IndexedSeq$.MODULE$.canBuildFrom())), (Iterable<Object>)offsetSeq);
        cleaner.buildOffsetMap(log, (long)start2, (long)end, (OffsetMap)map, new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1()));
        long endOffset = map.latestOffset();
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)7206178L, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(end - start2), (long)map.size());
        Assert.assertEquals((String)"Map should contain first value", (long)0L, (long)map.get(this.key(0)));
        Assert.assertEquals((String)"Map should contain second value", (long)7206178L, (long)map.get(this.key(1)));
    }

    @Test
    public void testBuildPartialOffsetMap() {
        FakeOffsetMap map = new FakeOffsetMap(3);
        Log log = this.makeLog(this.makeLog$default$1(), this.makeLog$default$2());
        Cleaner cleaner = this.makeCleaner(2, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        log.append(this.record(0, 0), log.append$default$2());
        log.append(this.record(1, 1), log.append$default$2());
        log.append(this.record(2, 2), log.append$default$2());
        log.append(this.record(3, 3), log.append$default$2());
        log.append(this.record(4, 4), log.append$default$2());
        log.roll(log.roll$default$1());
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner.buildOffsetMap(log, 2L, Integer.MAX_VALUE, (OffsetMap)map, stats);
        Assert.assertEquals((long)2L, (long)map.size());
        Assert.assertEquals((long)-1L, (long)map.get(this.key(0)));
        Assert.assertEquals((long)2L, (long)map.get(this.key(2)));
        Assert.assertEquals((long)3L, (long)map.get(this.key(3)));
        Assert.assertEquals((long)-1L, (long)map.get(this.key(4)));
        Assert.assertEquals((long)4L, (long)stats.mapMessagesRead());
    }

    @Test
    public void testCleanCorruptMessageSet() {
        LogConfig logConfig;
        CompressionType codec = CompressionType.GZIP;
        Properties logProps = new Properties();
        logProps.put(LogConfig$.MODULE$.CompressionTypeProp(), codec.name);
        LogConfig x$70 = logConfig = new LogConfig((Map)logProps);
        File x$71 = this.makeLog$default$1();
        Log log = this.makeLog(x$71, x$70);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        IndexedSeq dupSetKeys = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2).$plus$plus((GenTraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 2), IndexedSeq$.MODULE$.canBuildFrom());
        int dupSetOffset = 25;
        IndexedSeq dupSet = (IndexedSeq)dupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(dupSetOffset), dupSetOffset + dupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        Range noDupSetKeys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(3), 5);
        int noDupSetOffset = 50;
        IndexedSeq noDupSet = (IndexedSeq)noDupSetKeys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(noDupSetOffset), noDupSetOffset + noDupSetKeys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        log.append(this.invalidCleanedMessage(dupSetOffset, (Iterable<Tuple2<Object, Object>>)dupSet, codec), false);
        log.append(this.invalidCleanedMessage(noDupSetOffset, (Iterable<Tuple2<Object, Object>>)noDupSet, codec), false);
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        log.logSegments().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LogSegment segment) {
                ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(segment.log().shallowEntries()).asScala()).foreach((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(FileLogInputStream.FileChannelLogEntry shallowLogEntry) {
                        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter((java.lang.Iterable)shallowLogEntry).asScala()).foreach((Function1)new Serializable(this, shallowLogEntry){
                            public static final long serialVersionUID = 0L;
                            private final FileLogInputStream.FileChannelLogEntry shallowLogEntry$1;

                            public final void apply(LogEntry deepLogEntry) {
                                Assert.assertEquals((long)this.shallowLogEntry$1.record().magic(), (long)deepLogEntry.record().magic());
                                long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(deepLogEntry.record().value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
                                Assert.assertEquals((long)deepLogEntry.offset(), (long)value);
                            }
                            {
                                this.shallowLogEntry$1 = shallowLogEntry$1;
                            }
                        });
                    }
                });
            }
        });
    }

    @Test
    public void testClientHandlingOfCorruptMessageSet() {
        Range keys = RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(1), 10);
        int offset = 50;
        IndexedSeq set = (IndexedSeq)keys.zip((GenIterable)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(offset), offset + keys.size()), IndexedSeq$.MODULE$.canBuildFrom());
        MemoryRecords corruptedMessage = this.invalidCleanedMessage(offset, (Iterable<Tuple2<Object, Object>>)set, this.invalidCleanedMessage$default$3());
        MemoryRecords records2 = MemoryRecords.readableRecords((ByteBuffer)corruptedMessage.buffer());
        ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(records2.deepEntries()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(LogEntry logEntry) {
                long offset = logEntry.offset();
                long value = new StringOps(Predef$.MODULE$.augmentString(TestUtils$.MODULE$.readString(logEntry.record().value(), TestUtils$.MODULE$.readString$default$2()))).toLong();
                Assert.assertEquals((long)offset, (long)value);
            }
        });
    }

    @Test
    public void testCleanTombstone() {
        LogConfig logConfig;
        LogConfig x$72 = logConfig = new LogConfig((Map)new Properties());
        File x$73 = this.makeLog$default$1();
        Log log = this.makeLog(x$73, x$72);
        Cleaner cleaner = this.makeCleaner(10, this.makeCleaner$default$2(), this.makeCleaner$default$3());
        byte[] x$74 = "0".getBytes();
        byte[] x$75 = "0".getBytes();
        long x$76 = this.time().milliseconds() + Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) + 10000L;
        CompressionType x$77 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$78 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.append(TestUtils$.MODULE$.singletonRecords(x$74, x$75, x$77, x$76, x$78), log.append$default$2());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 0L, log.activeSegment().baseOffset()));
        Object x$79 = null;
        byte[] x$80 = "0".getBytes();
        long x$81 = this.time().milliseconds() - Predef$.MODULE$.Long2long(logConfig.deleteRetentionMs()) - 10000L;
        CompressionType x$82 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$83 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.append(TestUtils$.MODULE$.singletonRecords(null, x$80, x$82, x$81, x$83), log.append$default$2());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 1L, log.activeSegment().baseOffset()));
        Assert.assertEquals((String)"The tombstone should be retained.", (long)1L, (long)((FileLogInputStream.FileChannelLogEntry)((LogSegment)log.logSegments().head()).log().shallowEntries().iterator().next()).offset());
        byte[] x$84 = "1".getBytes();
        byte[] x$85 = "1".getBytes();
        long x$86 = this.time().milliseconds();
        CompressionType x$87 = TestUtils$.MODULE$.singletonRecords$default$3();
        byte x$88 = TestUtils$.MODULE$.singletonRecords$default$5();
        log.append(TestUtils$.MODULE$.singletonRecords(x$84, x$85, x$87, x$86, x$88), log.append$default$2());
        log.roll(log.roll$default$1());
        cleaner.clean(new LogToClean(new TopicPartition("test", 0), log, 2L, log.activeSegment().baseOffset()));
        Assert.assertEquals((String)"The tombstone should be retained.", (long)1L, (long)((FileLogInputStream.FileChannelLogEntry)((LogSegment)log.logSegments().head()).log().shallowEntries().iterator().next()).offset());
    }

    private Iterable<Object> writeToLog(Log log, Iterable<Tuple2<Object, Object>> keysAndValues, Iterable<Object> offsetSeq) {
        return (Iterable)((TraversableLike)keysAndValues.zip(offsetSeq, Iterable$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Tuple2<Object, Object>, Object> check$ifrefutable$1) {
                Tuple2 tuple2;
                Tuple2<Tuple2<Object, Object>, Object> tuple22 = check$ifrefutable$1;
                boolean bl = tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null;
                return bl;
            }
        }).map((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$8;

            public final long apply(Tuple2<Tuple2<Object, Object>, Object> x$22) {
                Tuple2<Tuple2<Object, Object>, Object> tuple2 = x$22;
                if (tuple2 != null) {
                    Tuple2 tuple22 = (Tuple2)tuple2._1();
                    long offset = tuple2._2$mcJ$sp();
                    if (tuple22 != null) {
                        int key = tuple22._1$mcI$sp();
                        int value = tuple22._2$mcI$sp();
                        long l = this.log$8.append(this.$outer.kafka$log$LogCleanerTest$$messageWithOffset(key, value, offset), false).firstOffset();
                        return l;
                    }
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.log$8 = log$8;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    private MemoryRecords invalidCleanedMessage(long initialOffset, Iterable<Tuple2<Object, Object>> keysAndValues, CompressionType codec) {
        Iterable records2 = (Iterable)keysAndValues.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Record apply(Tuple2<Object, Object> kv) {
                return Record.create((byte)0, (long)-1L, (byte[])((Object)BoxesRunTime.boxToInteger((int)kv._1$mcI$sp())).toString().getBytes(), (byte[])((Object)BoxesRunTime.boxToInteger((int)kv._2$mcI$sp())).toString().getBytes());
            }
        }, Iterable$.MODULE$.canBuildFrom());
        ByteBuffer buffer = ByteBuffer.allocate(package$.MODULE$.min(package$.MODULE$.max(BoxesRunTime.unboxToInt((Object)((TraversableOnce)records2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(Record x$23) {
                return x$23.sizeInBytes();
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / 2, 1024), 65536));
        MemoryRecordsBuilder builder = MemoryRecords.builder((ByteBuffer)buffer, (byte)1, (CompressionType)codec, (TimestampType)TimestampType.CREATE_TIME);
        LongRef offset = new LongRef(initialOffset);
        records2.foreach((Function1)new Serializable(this, builder, offset){
            public static final long serialVersionUID = 0L;
            private final MemoryRecordsBuilder builder$1;
            private final LongRef offset$1;

            public final void apply(Record record) {
                this.builder$1.appendUnchecked(this.offset$1.elem, record);
                ++this.offset$1.elem;
            }
            {
                this.builder$1 = builder$1;
                this.offset$1 = offset$1;
            }
        });
        return builder.build();
    }

    private CompressionType invalidCleanedMessage$default$3() {
        return CompressionType.GZIP;
    }

    public MemoryRecords kafka$log$LogCleanerTest$$messageWithOffset(int key, int value, long offset) {
        return MemoryRecords.withLogEntries((LogEntry[])new LogEntry[]{LogEntry.create((long)offset, (Record)Record.create((byte[])((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), (byte[])((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes()))});
    }

    public Log makeLog(File dir, LogConfig config) {
        return new Log(dir, config, 0L, (Scheduler)this.time().scheduler(), (Time)this.time());
    }

    public File makeLog$default$1() {
        return this.dir();
    }

    public LogConfig makeLog$default$2() {
        return this.logConfig();
    }

    public void noOpCheckDone(TopicPartition topicPartition) {
    }

    public Cleaner makeCleaner(int capacity, Function1<TopicPartition, BoxedUnit> checkDone, int maxMessageSize) {
        return new Cleaner(0, (OffsetMap)new FakeOffsetMap(capacity), maxMessageSize, maxMessageSize, 0.75, this.throttler(), (Time)this.time(), checkDone);
    }

    public Function1<TopicPartition, BoxedUnit> makeCleaner$default$2() {
        return new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;

            public final void apply(TopicPartition topicPartition) {
                this.$outer.noOpCheckDone(topicPartition);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        };
    }

    public int makeCleaner$default$3() {
        return 65536;
    }

    public Iterable<Object> writeToLog(Log log, Iterable<Tuple2<Object, Object>> seq) {
        return (Iterable)seq.withFilter((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$2) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$2;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(this, log){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final Log log$7;

            public final long apply(Tuple2<Object, Object> x$24) {
                Tuple2<Object, Object> tuple2 = x$24;
                if (tuple2 != null) {
                    int key = tuple2._1$mcI$sp();
                    int value = tuple2._2$mcI$sp();
                    long l = this.log$7.append(this.$outer.record(key, value), this.log$7.append$default$2()).firstOffset();
                    return l;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.log$7 = log$7;
            }
        }, Iterable$.MODULE$.canBuildFrom());
    }

    public ByteBuffer key(int id) {
        return ByteBuffer.wrap(((Object)BoxesRunTime.boxToInteger((int)id)).toString().getBytes());
    }

    public MemoryRecords record(int key, int value) {
        return this.record(key, ((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes());
    }

    public MemoryRecords record(int key, byte[] value) {
        return MemoryRecords.withRecords((Record[])new Record[]{Record.create((byte[])((Object)BoxesRunTime.boxToInteger((int)key)).toString().getBytes(), (byte[])value)});
    }

    public MemoryRecords unkeyedRecord(int value) {
        return MemoryRecords.withRecords((Record[])new Record[]{Record.create((byte[])((Object)BoxesRunTime.boxToInteger((int)value)).toString().getBytes())});
    }

    public MemoryRecords tombstoneRecord(int key) {
        return this.record(key, null);
    }

    private final Seq distinctValuesBySegment$1(Log log$2) {
        return ((TraversableOnce)log$2.logSegments().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final int apply(LogSegment s) {
                return ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(s.log().shallowEntries()).asScala()).map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply(FileLogInputStream.FileChannelLogEntry m) {
                        return TestUtils$.MODULE$.readString(m.record().value(), TestUtils$.MODULE$.readString$default$2());
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSet().size();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSeq();
    }

    private final void checkRange$1(FakeOffsetMap map, int start2, int end, Log log$6, Cleaner cleaner$2) {
        CleanerStats stats = new CleanerStats(CleanerStats$.MODULE$.$lessinit$greater$default$1());
        cleaner$2.buildOffsetMap(log$6, (long)start2, (long)end, (OffsetMap)map, stats);
        long endOffset = map.latestOffset() + 1L;
        Assert.assertEquals((String)"Last offset should be the end offset.", (long)end, (long)endOffset);
        Assert.assertEquals((String)"Should have the expected number of messages in the map.", (long)(end - start2), (long)map.size());
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(start2), end).foreach$mVc$sp((Function1)new Serializable(this, map){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ LogCleanerTest $outer;
            private final FakeOffsetMap map$4;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((String)"Should find all the keys", (long)i, (long)this.map$4.get(this.$outer.key(i)));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.map$4 = map$4;
            }
        });
        Assert.assertEquals((String)"Should not find a value too small", (long)-1L, (long)map.get(this.key(start2 - 1)));
        Assert.assertEquals((String)"Should not find a value too large", (long)-1L, (long)map.get(this.key(end)));
        Assert.assertEquals((long)(end - start2), (long)stats.mapMessagesRead());
    }

    /*
     * WARNING - void declaration
     */
    private final Log recoverAndCheck$1(LogConfig config, Iterable expectedKeys) {
        void var3_5;
        LogConfig x$58 = config;
        File x$59 = this.makeLog$default$1();
        Log recoveredLog = this.makeLog(x$59, x$58);
        this.time().sleep(Predef$.MODULE$.Long2long(config.fileDeleteDelayMs()) + 1L);
        Predef$.MODULE$.refArrayOps((Object[])this.dir().listFiles()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(File file) {
                Assert.assertFalse((String)"Unexpected .deleted file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.DeletedFileSuffix()));
                Assert.assertFalse((String)"Unexpected .cleaned file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.CleanedFileSuffix()));
                Assert.assertFalse((String)"Unexpected .swap file after recovery", (boolean)file.getName().endsWith(Log$.MODULE$.SwapFileSuffix()));
            }
        });
        Assert.assertEquals((Object)expectedKeys, this.keysInLog(recoveredLog));
        return var3_5;
    }

    public LogCleanerTest() {
        this.logProps().put(LogConfig$.MODULE$.SegmentBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.SegmentIndexBytesProp(), Predef$.MODULE$.int2Integer(1024));
        this.logProps().put(LogConfig$.MODULE$.CleanupPolicyProp(), LogConfig$.MODULE$.Compact());
        this.logConfig = new LogConfig((Map)this.logProps());
        this.time = new MockTime();
        double x$25 = Double.MAX_VALUE;
        long x$26 = Long.MAX_VALUE;
        MockTime x$27 = this.time();
        boolean x$28 = Throttler$.MODULE$.$lessinit$greater$default$3();
        String x$29 = Throttler$.MODULE$.$lessinit$greater$default$4();
        String x$30 = Throttler$.MODULE$.$lessinit$greater$default$5();
        this.throttler = new Throttler(x$25, x$26, x$28, x$29, x$30, (Time)x$27);
    }
}

