/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Metric;
import com.yammer.metrics.core.MetricName;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Properties;
import java.util.Random;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import kafka.network.Acceptor;
import kafka.network.ConnectionQuotas;
import kafka.network.Processor;
import kafka.network.RequestChannel;
import kafka.network.RequestMetrics;
import kafka.network.RequestMetrics$;
import kafka.network.SocketServer;
import kafka.network.SocketServerTest$;
import kafka.security.CredentialProvider;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.network.NetworkSend;
import org.apache.kafka.common.network.Send;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.requests.ProduceRequest;
import org.apache.kafka.common.requests.RequestHeader;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalactic.source.Position;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.mutable.ArrayBuffer;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u00055g\u0001B\u0001\u0003\u0001\u001d\u0011\u0001cU8dW\u0016$8+\u001a:wKJ$Vm\u001d;\u000b\u0005\r!\u0011a\u00028fi^|'o\u001b\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011C\u0001\u0001\t!\tI\u0001#D\u0001\u000b\u0015\tYA\"A\u0003kk:LGO\u0003\u0002\u000e\u001d\u0005I1oY1mCR,7\u000f\u001e\u0006\u0002\u001f\u0005\u0019qN]4\n\u0005EQ!A\u0003&V]&$8+^5uK\")1\u0003\u0001C\u0001)\u00051A(\u001b8jiz\"\u0012!\u0006\t\u0003-\u0001i\u0011A\u0001\u0005\b1\u0001\u0011\r\u0011\"\u0001\u001a\u0003\u0015\u0001(o\u001c9t+\u0005Q\u0002CA\u000e!\u001b\u0005a\"BA\u000f\u001f\u0003\u0011)H/\u001b7\u000b\u0003}\tAA[1wC&\u0011\u0011\u0005\b\u0002\u000b!J|\u0007/\u001a:uS\u0016\u001c\bBB\u0012\u0001A\u0003%!$\u0001\u0004qe>\u00048\u000f\t\u0005\bK\u0001\u0011\r\u0011\"\u0001'\u0003\u0019\u0019wN\u001c4jOV\tq\u0005\u0005\u0002)W5\t\u0011F\u0003\u0002+\t\u000511/\u001a:wKJL!\u0001L\u0015\u0003\u0017-\u000bgm[1D_:4\u0017n\u001a\u0005\u0007]\u0001\u0001\u000b\u0011B\u0014\u0002\u000f\r|gNZ5hA!9\u0001\u0007\u0001b\u0001\n\u0003\t\u0014aB7fiJL7m]\u000b\u0002eA\u00111GO\u0007\u0002i)\u0011\u0001'\u000e\u0006\u0003m]\naaY8n[>t'BA\u00039\u0015\tId\"\u0001\u0004ba\u0006\u001c\u0007.Z\u0005\u0003wQ\u0012q!T3ue&\u001c7\u000f\u0003\u0004>\u0001\u0001\u0006IAM\u0001\t[\u0016$(/[2tA!9q\b\u0001b\u0001\n\u0003\u0001\u0015AE2sK\u0012,g\u000e^5bYB\u0013xN^5eKJ,\u0012!\u0011\t\u0003\u0005\u0016k\u0011a\u0011\u0006\u0003\t\u0012\t\u0001b]3dkJLG/_\u0005\u0003\r\u000e\u0013!c\u0011:fI\u0016tG/[1m!J|g/\u001b3fe\"1\u0001\n\u0001Q\u0001\n\u0005\u000b1c\u0019:fI\u0016tG/[1m!J|g/\u001b3fe\u0002BqA\u000b\u0001C\u0002\u0013\u0005!*F\u0001L!\t1B*\u0003\u0002N\u0005\ta1k\\2lKR\u001cVM\u001d<fe\"1q\n\u0001Q\u0001\n-\u000bqa]3sm\u0016\u0014\b\u0005C\u0004R\u0001\t\u0007I\u0011\u0001*\u0002\u000fM|7m[3ugV\t1\u000bE\u0002U7vk\u0011!\u0016\u0006\u0003-^\u000bq!\\;uC\ndWM\u0003\u0002Y3\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003i\u000bQa]2bY\u0006L!\u0001X+\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003=\u0006l\u0011a\u0018\u0006\u0003Az\t1A\\3u\u0013\t\u0011wL\u0001\u0004T_\u000e\\W\r\u001e\u0005\u0007I\u0002\u0001\u000b\u0011B*\u0002\u0011M|7m[3ug\u0002BQA\u001a\u0001\u0005\u0002\u001d\f1b]3oIJ+\u0017/^3tiR!\u0001\u000e\u001c8w!\tI'.D\u0001Z\u0013\tY\u0017L\u0001\u0003V]&$\b\"B7f\u0001\u0004i\u0016AB:pG.,G\u000fC\u0003pK\u0002\u0007\u0001/A\u0004sKF,Xm\u001d;\u0011\u0007%\f8/\u0003\u0002s3\n)\u0011I\u001d:bsB\u0011\u0011\u000e^\u0005\u0003kf\u0013AAQ=uK\"9q/\u001aI\u0001\u0002\u0004A\u0018AA5e!\rI\u0017p_\u0005\u0003uf\u0013aa\u00149uS>t\u0007CA5}\u0013\ti\u0018LA\u0003TQ>\u0014H\u000f\u0003\u0004\u0000\u0001\u0011\u0005\u0011\u0011A\u0001\u0010e\u0016\u001cW-\u001b<f%\u0016\u001c\bo\u001c8tKR\u0019\u0001/a\u0001\t\u000b5t\b\u0019A/\t\u000f\u0005\u001d\u0001\u0001\"\u0001\u0002\n\u0005q\u0001O]8dKN\u001c(+Z9vKN$Hc\u00015\u0002\f!A\u0011QBA\u0003\u0001\u0004\ty!A\u0004dQ\u0006tg.\u001a7\u0011\u0007Y\t\t\"C\u0002\u0002\u0014\t\u0011aBU3rk\u0016\u001cHo\u00115b]:,G\u000eC\u0004\u0002\b\u0001!\t!a\u0006\u0015\u000b!\fI\"a\u0007\t\u0011\u00055\u0011Q\u0003a\u0001\u0003\u001fAqa\\A\u000b\u0001\u0004\ti\u0002\u0005\u0003\u0002 \u0005\u0015bb\u0001\f\u0002\"%\u0019\u00111\u0005\u0002\u0002\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY&!\u0011qEA\u0015\u0005\u001d\u0011V-];fgRT1!a\t\u0003\u0011\u001d\ti\u0003\u0001C\u0001\u0003_\tqaY8o]\u0016\u001cG\u000fF\u0003^\u0003c\t)\u0004C\u0005\u00024\u0005-\u0002\u0013!a\u0001\u0017\u0006\t1\u000f\u0003\u0006\u00028\u0005-\u0002\u0013!a\u0001\u0003s\t\u0001\u0002\u001d:pi>\u001cw\u000e\u001c\t\u0005\u0003w\ty$\u0004\u0002\u0002>)\u0019\u0011qG\u001b\n\t\u0005\u0005\u0013Q\b\u0002\u0011'\u0016\u001cWO]5usB\u0013x\u000e^8d_2Dq!!\u0012\u0001\t\u0003\t9%\u0001\u0005uK\u0006\u0014Hi\\<o)\u0005A\u0007\u0006BA\"\u0003\u0017\u0002B!!\u0014\u0002R5\u0011\u0011q\n\u0006\u0003\u00179IA!a\u0015\u0002P\t)\u0011I\u001a;fe\"9\u0011q\u000b\u0001\u0005\n\u0005e\u0013\u0001\u00069s_\u0012,8-\u001a:SKF,Xm\u001d;CsR,7/F\u0001q\u0011\u001d\ti\u0006\u0001C\u0001\u0003\u000f\nQb]5na2,'+Z9vKN$\b\u0006BA.\u0003C\u0002B!!\u0014\u0002d%!\u0011QMA(\u0005\u0011!Vm\u001d;\t\u000f\u0005%\u0004\u0001\"\u0001\u0002H\u00059Bo\\8CS\u001e\u0014V-];fgRL5OU3kK\u000e$X\r\u001a\u0015\u0005\u0003O\n\t\u0007C\u0004\u0002p\u0001!\t!a\u0012\u0002#Q,7\u000f^$sC\u000e,g-\u001e7DY>\u001cX\r\u000b\u0003\u0002n\u0005\u0005\u0004bBA;\u0001\u0011\u0005\u0011qI\u0001\u001bi\u0016\u001cHoU8dW\u0016$8o\u00117pg\u0016|en\u00155vi\u0012|wO\u001c\u0015\u0005\u0003g\n\t\u0007C\u0004\u0002|\u0001!\t!a\u0012\u0002/Q,7\u000f^'bq\u000e{gN\\3di&|gn\u001d)fe&\u0003\b\u0006BA=\u0003CBq!!!\u0001\t\u0003\t9%\u0001\u0011uKN$X*\u0019=D_:tWm\u0019;j_:\u001c\b+\u001a:Ja>3XM\u001d:jI\u0016\u001c\b\u0006BA@\u0003CBq!a\"\u0001\t\u0003\t9%A\nuKN$8k\u001d7T_\u000e\\W\r^*feZ,'\u000f\u000b\u0003\u0002\u0006\u0006\u0005\u0004bBAG\u0001\u0011\u0005\u0011qI\u0001\u0015i\u0016\u001cHoU3tg&|g\u000e\u0015:j]\u000eL\u0007/\u00197)\t\u0005-\u0015\u0011\r\u0005\b\u0003'\u0003A\u0011AA$\u00031\"Xm\u001d;DY&,g\u000e\u001e#jg\u000e|gN\\3di&|g.\u00169eCR,7OU3rk\u0016\u001cH/T3ue&\u001c7\u000f\u000b\u0003\u0002\u0012\u0006\u0005\u0004bBAM\u0001\u0011\u0005\u0011qI\u00016i\u0016\u001cHO\u0011:pW\u0016\u00148+\u001a8e\u0003\u001a$XM]\"iC:tW\r\\\"m_N,G-\u00169eCR,7OU3rk\u0016\u001cH/T3ue&\u001c7\u000f\u000b\u0003\u0002\u0018\u0006\u0005\u0004bBAP\u0001\u0011\u0005\u0011qI\u0001\"i\u0016\u001cH/T3ue&\u001c7i\u001c7mK\u000e$\u0018n\u001c8BMR,'o\u00155vi\u0012|wO\u001c\u0015\u0005\u0003;\u000b\t\u0007C\u0005\u0002&\u0002\t\n\u0011\"\u0001\u0002(\u0006)2/\u001a8e%\u0016\fX/Z:uI\u0011,g-Y;mi\u0012\u001aTCAAUU\rA\u00181V\u0016\u0003\u0003[\u0003B!a,\u0002:6\u0011\u0011\u0011\u0017\u0006\u0005\u0003g\u000b),A\u0005v]\u000eDWmY6fI*\u0019\u0011qW-\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002<\u0006E&!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\"I\u0011q\u0018\u0001\u0012\u0002\u0013\u0005\u0011\u0011Y\u0001\u0012G>tg.Z2uI\u0011,g-Y;mi\u0012\nTCAAbU\rY\u00151\u0016\u0005\n\u0003\u000f\u0004\u0011\u0013!C\u0001\u0003\u0013\f\u0011cY8o]\u0016\u001cG\u000f\n3fM\u0006,H\u000e\u001e\u00133+\t\tYM\u000b\u0003\u0002:\u0005-\u0006")
public class SocketServerTest
extends JUnitSuite {
    private final Properties props;
    private final KafkaConfig config;
    private final Metrics metrics;
    private final CredentialProvider credentialProvider;
    private final SocketServer server;
    private final ArrayBuffer<Socket> sockets;

    public Properties props() {
        return this.props;
    }

    public KafkaConfig config() {
        return this.config;
    }

    public Metrics metrics() {
        return this.metrics;
    }

    public CredentialProvider credentialProvider() {
        return this.credentialProvider;
    }

    public SocketServer server() {
        return this.server;
    }

    public ArrayBuffer<Socket> sockets() {
        return this.sockets;
    }

    public void sendRequest(Socket socket, byte[] request, Option<Object> id) {
        Option<Object> option;
        block4: {
            DataOutputStream outgoing;
            block3: {
                block2: {
                    outgoing = new DataOutputStream(socket.getOutputStream());
                    option = id;
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    short id2 = BoxesRunTime.unboxToShort((Object)some.x());
                    outgoing.writeInt(request.length + 2);
                    outgoing.writeShort(id2);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                None$ none$ = None$.MODULE$;
                Option<Object> option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block4;
                outgoing.writeInt(request.length);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            outgoing.write(request);
            outgoing.flush();
            return;
        }
        throw new MatchError(option);
    }

    public Option<Object> sendRequest$default$3() {
        return None$.MODULE$;
    }

    public byte[] receiveResponse(Socket socket) {
        DataInputStream incoming = new DataInputStream(socket.getInputStream());
        int len = incoming.readInt();
        byte[] response = new byte[len];
        incoming.readFully(response);
        return response;
    }

    public void processRequest(RequestChannel channel) {
        RequestChannel.Request request = channel.receiveRequest(2000L);
        Assert.assertNotNull((String)"receiveRequest timed out", (Object)request);
        this.processRequest(channel, request);
    }

    public void processRequest(RequestChannel channel, RequestChannel.Request request) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(request.header().sizeOf() + request.body().sizeOf());
        request.header().writeTo(byteBuffer);
        request.body().writeTo(byteBuffer);
        byteBuffer.rewind();
        NetworkSend send = new NetworkSend(request.connectionId(), byteBuffer);
        channel.sendResponse(new RequestChannel.Response(request.processor(), request, (Send)send));
    }

    /*
     * WARNING - void declaration
     */
    public Socket connect(SocketServer s, SecurityProtocol protocol) {
        void var3_3;
        Socket socket = new Socket("localhost", s.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)protocol)));
        this.sockets().$plus$eq((Object)socket);
        return var3_3;
    }

    public SocketServer connect$default$1() {
        return this.server();
    }

    public SecurityProtocol connect$default$2() {
        return SecurityProtocol.PLAINTEXT;
    }

    @After
    public void tearDown() {
        this.metrics().close();
        this.server().shutdown();
        this.sockets().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Socket x$1) {
                x$1.close();
            }
        });
        this.sockets().clear();
    }

    private byte[] producerRequestBytes() {
        short apiKey = 0;
        int correlationId = -1;
        String clientId = "";
        int ackTimeoutMs = 10000;
        short ack = 0;
        ProduceRequest emptyRequest = new ProduceRequest.Builder(ack, ackTimeoutMs, new HashMap()).build();
        RequestHeader emptyHeader = new RequestHeader(apiKey, emptyRequest.version(), clientId, correlationId);
        ByteBuffer byteBuffer = ByteBuffer.allocate(emptyHeader.sizeOf() + emptyRequest.sizeOf());
        emptyHeader.writeTo(byteBuffer);
        emptyRequest.writeTo(byteBuffer);
        byteBuffer.rewind();
        byte[] serializedBytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(serializedBytes);
        return serializedBytes;
    }

    @Test
    public void simpleRequest() {
        SecurityProtocol x$20 = SecurityProtocol.PLAINTEXT;
        SocketServer x$21 = this.connect$default$1();
        Socket plainSocket = this.connect(x$21, x$20);
        SecurityProtocol x$22 = SecurityProtocol.TRACE;
        SocketServer x$23 = this.connect$default$1();
        Socket traceSocket = this.connect(x$23, x$22);
        byte[] serializedBytes = this.producerRequestBytes();
        this.sendRequest(plainSocket, serializedBytes, this.sendRequest$default$3());
        this.processRequest(this.server().requestChannel());
        Assert.assertEquals((Object)Predef$.MODULE$.byteArrayOps(serializedBytes).toSeq(), (Object)Predef$.MODULE$.byteArrayOps(this.receiveResponse(plainSocket)).toSeq());
        this.sendRequest(traceSocket, serializedBytes, this.sendRequest$default$3());
        this.processRequest(this.server().requestChannel());
        Assert.assertEquals((Object)Predef$.MODULE$.byteArrayOps(serializedBytes).toSeq(), (Object)Predef$.MODULE$.byteArrayOps(this.receiveResponse(traceSocket)).toSeq());
    }

    @Test
    public void tooBigRequestIsRejected() {
        byte[] tooManyBytes = new byte[Predef$.MODULE$.Integer2int(this.server().config().socketRequestMaxBytes()) + 1];
        new Random().nextBytes(tooManyBytes);
        Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());
        DataOutputStream outgoing = new DataOutputStream(socket.getOutputStream());
        outgoing.writeInt(tooManyBytes.length);
        try {
            outgoing.write(tooManyBytes);
            outgoing.flush();
            this.receiveResponse(socket);
        }
        catch (IOException iOException) {}
    }

    @Test
    public void testGracefulClose() {
        SecurityProtocol x$24 = SecurityProtocol.PLAINTEXT;
        SocketServer x$25 = this.connect$default$1();
        Socket plainSocket = this.connect(x$25, x$24);
        byte[] serializedBytes = this.producerRequestBytes();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this, plainSocket, serializedBytes){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServerTest $outer;
            private final Socket plainSocket$1;
            private final byte[] serializedBytes$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.$outer.sendRequest(this.plainSocket$1, this.serializedBytes$1, this.$outer.sendRequest$default$3());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.plainSocket$1 = plainSocket$1;
                this.serializedBytes$1 = serializedBytes$1;
            }
        });
        plainSocket.close();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 10).foreach$mVc$sp((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServerTest $outer;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                RequestChannel.Request request = this.$outer.server().requestChannel().receiveRequest(2000L);
                Assert.assertNotNull((String)"receiveRequest timed out", (Object)request);
                this.$outer.server().requestChannel().noOperation(request.processor(), request);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testSocketsCloseOnShutdown() {
        SecurityProtocol x$26 = SecurityProtocol.PLAINTEXT;
        SocketServer x$27 = this.connect$default$1();
        Socket plainSocket = this.connect(x$27, x$26);
        SecurityProtocol x$28 = SecurityProtocol.TRACE;
        SocketServer x$29 = this.connect$default$1();
        Socket traceSocket = this.connect(x$29, x$28);
        byte[] bytes = new byte[40];
        this.sendRequest(plainSocket, bytes, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)0)));
        this.sendRequest(traceSocket, bytes, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)0)));
        this.processRequest(this.server().requestChannel());
        this.server().acceptors().values().map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(Acceptor acceptor) {
                Assert.assertFalse((boolean)acceptor.serverChannel().socket().isClosed());
            }
        }, Iterable$.MODULE$.canBuildFrom());
        this.server().shutdown();
        byte[] largeChunkOfBytes = new byte[1000000];
        try {
            this.sendRequest(plainSocket, largeChunkOfBytes, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)0)));
            throw this.fail("expected exception when writing to closed plain socket", new Position("SocketServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 206));
        }
        catch (IOException iOException) {
            try {
                this.sendRequest(traceSocket, largeChunkOfBytes, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)0)));
                throw this.fail("expected exception when writing to closed trace socket", new Position("SocketServerTest.scala", "Please set the environment variable SCALACTIC_FILL_FILE_PATHNAMES to yes at compile time to enable this feature.", 213));
            }
            catch (IOException iOException2) {
                return;
            }
        }
    }

    @Test
    public void testMaxConnectionsPerIp() {
        IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), Predef$.MODULE$.Integer2int(this.server().config().maxConnectionsPerIp())).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServerTest $outer;

            public final Socket apply(int x$2) {
                return this.$outer.connect(this.$outer.connect$default$1(), this.$outer.connect$default$2());
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        Socket conn = this.connect(this.connect$default$1(), this.connect$default$2());
        conn.setSoTimeout(3000);
        Assert.assertEquals((long)-1L, (long)conn.getInputStream().read());
        conn.close();
        InetAddress address = ((Socket)conns.head()).getInetAddress();
        ((Socket)conns.head()).close();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, conns, address){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SocketServerTest $outer;
            private final IndexedSeq conns$1;
            private final InetAddress address$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return this.$outer.server().connectionCount(this.address$1) < this.conns$1.length();
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.conns$1 = conns$1;
                this.address$1 = address$1;
            }
        }, "Failed to decrement connection count after close", TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        Socket conn2 = this.connect(this.connect$default$1(), this.connect$default$2());
        byte[] serializedBytes = this.producerRequestBytes();
        this.sendRequest(conn2, serializedBytes, this.sendRequest$default$3());
        RequestChannel.Request request = this.server().requestChannel().receiveRequest(2000L);
        Assert.assertNotNull((Object)request);
    }

    @Test
    public void testMaxConnectionsPerIpOverrides() {
        int overrideNum = Predef$.MODULE$.Integer2int(this.server().config().maxConnectionsPerIp()) + 1;
        int x$30 = 0;
        String x$31 = TestUtils$.MODULE$.MockZkConnect();
        int x$32 = 0;
        boolean x$33 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$34 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$35 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$36 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$37 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$38 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$39 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$40 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$41 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$42 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$43 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$44 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$45 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties overrideProps = TestUtils$.MODULE$.createBrokerConfig(x$30, x$31, x$33, x$34, x$32, x$35, x$36, x$37, x$38, x$39, x$40, x$41, x$42, x$43, x$44, x$45);
        overrideProps.put(KafkaConfig$.MODULE$.MaxConnectionsPerIpOverridesProp(), new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"localhost:", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)overrideNum)})));
        Metrics serverMetrics = new Metrics();
        SocketServer overrideServer = new SocketServer(KafkaConfig$.MODULE$.fromProps(overrideProps), serverMetrics, Time.SYSTEM, this.credentialProvider());
        try {
            overrideServer.startup();
            IndexedSeq conns = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), overrideNum).map((Function1)new Serializable(this, overrideServer){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SocketServerTest $outer;
                private final SocketServer overrideServer$1;

                public final Socket apply(int x$3) {
                    return this.$outer.connect(this.overrideServer$1, this.$outer.connect$default$2());
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.overrideServer$1 = overrideServer$1;
                }
            }, IndexedSeq$.MODULE$.canBuildFrom());
            byte[] serializedBytes = this.producerRequestBytes();
            this.sendRequest((Socket)conns.last(), serializedBytes, this.sendRequest$default$3());
            RequestChannel.Request request = overrideServer.requestChannel().receiveRequest(2000L);
            Assert.assertNotNull((Object)request);
            Socket conn = this.connect(overrideServer, this.connect$default$2());
            conn.setSoTimeout(3000);
            Assert.assertEquals((long)-1L, (long)conn.getInputStream().read());
            return;
        }
        finally {
            overrideServer.shutdown();
            serverMetrics.close();
        }
    }

    @Test
    public void testSslSocketServer() {
        File trustStoreFile = File.createTempFile("truststore", ".jks");
        int x$46 = 0;
        String x$47 = TestUtils$.MODULE$.MockZkConnect();
        Some x$48 = new Some((Object)SecurityProtocol.SSL);
        Some x$49 = new Some((Object)trustStoreFile);
        boolean x$50 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$51 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        int x$52 = TestUtils$.MODULE$.createBrokerConfig$default$5();
        Option<Properties> x$53 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$54 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$55 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$56 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$57 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$58 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$59 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$60 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$61 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties overrideProps = TestUtils$.MODULE$.createBrokerConfig(x$46, x$47, x$50, x$51, x$52, (Option<SecurityProtocol>)x$48, (Option<File>)x$49, x$53, x$54, x$55, x$56, x$57, x$58, x$59, x$60, x$61);
        overrideProps.put(KafkaConfig$.MODULE$.ListenersProp(), "SSL://localhost:0");
        Metrics serverMetrics = new Metrics();
        SocketServer overrideServer = new SocketServer(KafkaConfig$.MODULE$.fromProps(overrideProps), serverMetrics, Time.SYSTEM, this.credentialProvider());
        try {
            overrideServer.startup();
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, (TrustManager[])((Object[])new TrustManager[]{TestUtils$.MODULE$.trustAllCerts()}), new SecureRandom());
            SSLSocketFactory socketFactory = sslContext.getSocketFactory();
            SSLSocket sslSocket = (SSLSocket)socketFactory.createSocket("localhost", overrideServer.boundPort(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.SSL)));
            sslSocket.setNeedClientAuth(false);
            short apiKey = ApiKeys.PRODUCE.id;
            int correlationId = -1;
            String clientId = "";
            int ackTimeoutMs = 10000;
            short ack = 0;
            ProduceRequest emptyRequest = new ProduceRequest.Builder(ack, ackTimeoutMs, new HashMap()).build();
            RequestHeader emptyHeader = new RequestHeader(apiKey, emptyRequest.version(), clientId, correlationId);
            ByteBuffer byteBuffer = ByteBuffer.allocate(emptyHeader.sizeOf() + emptyRequest.sizeOf());
            emptyHeader.writeTo(byteBuffer);
            emptyRequest.writeTo(byteBuffer);
            byteBuffer.rewind();
            byte[] serializedBytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(serializedBytes);
            this.sendRequest(sslSocket, serializedBytes, this.sendRequest$default$3());
            this.processRequest(overrideServer.requestChannel());
            Assert.assertEquals((Object)Predef$.MODULE$.byteArrayOps(serializedBytes).toSeq(), (Object)Predef$.MODULE$.byteArrayOps(this.receiveResponse(sslSocket)).toSeq());
            sslSocket.close();
            return;
        }
        finally {
            overrideServer.shutdown();
            serverMetrics.close();
        }
    }

    @Test
    public void testSessionPrincipal() {
        Socket socket = this.connect(this.connect$default$1(), this.connect$default$2());
        byte[] bytes = new byte[40];
        this.sendRequest(socket, bytes, (Option<Object>)new Some((Object)BoxesRunTime.boxToShort((short)0)));
        Assert.assertEquals((Object)KafkaPrincipal.ANONYMOUS, (Object)this.server().requestChannel().receiveRequest(2000L).session().principal());
    }

    @Test
    public void testClientDisconnectionUpdatesRequestMetrics() {
        int x$62 = 0;
        String x$63 = TestUtils$.MODULE$.MockZkConnect();
        int x$64 = 0;
        boolean x$65 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$66 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$67 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$68 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$69 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$70 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$71 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$72 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$73 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$74 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$75 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$76 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$77 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$62, x$63, x$65, x$66, x$64, x$67, x$68, x$69, x$70, x$71, x$72, x$73, x$74, x$75, x$76, x$77);
        Metrics serverMetrics = new Metrics();
        ObjectRef conn = new ObjectRef(null);
        SocketServer overrideServer = new SocketServer(this, props, serverMetrics, conn){
            public final ObjectRef conn$1;

            public Processor newProcessor(int id, ConnectionQuotas connectionQuotas, ListenerName listenerName, SecurityProtocol protocol) {
                return new Processor(this, id, connectionQuotas, listenerName, protocol){
                    private final /* synthetic */ $anon$2 $outer;

                    public void sendResponse(RequestChannel.Response response) {
                        ((Socket)this.$outer.conn$1.elem).close();
                        super.sendResponse(response);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        super(id$1, $outer.time(), Predef$.MODULE$.Integer2int($outer.config().socketRequestMaxBytes()), $outer.requestChannel(), connectionQuotas$1, Predef$.MODULE$.Long2long($outer.config().connectionsMaxIdleMs()), listenerName$1, protocol$1, $outer.config().values(), $outer.metrics(), $outer.credentialProvider());
                    }
                };
            }
            {
                this.conn$1 = conn$1;
                super(KafkaConfig$.MODULE$.fromProps(props$1), serverMetrics$1, Time.SYSTEM, $outer.credentialProvider());
            }
        };
        try {
            overrideServer.startup();
            conn.elem = this.connect(overrideServer, this.connect$default$2());
            byte[] serializedBytes = this.producerRequestBytes();
            this.sendRequest((Socket)conn.elem, serializedBytes, this.sendRequest$default$3());
            RequestChannel channel = overrideServer.requestChannel();
            RequestChannel.Request request = channel.receiveRequest(2000L);
            RequestMetrics requestMetrics = (RequestMetrics)RequestMetrics$.MODULE$.metricsMap().apply((Object)ApiKeys.forId((int)request.requestId()).name);
            long expectedTotalTimeCount = this.kafka$network$SocketServerTest$$totalTimeHistCount$1(requestMetrics) + 1L;
            NetworkSend send = new NetworkSend(request.connectionId(), ByteBuffer.allocate(550000));
            channel.sendResponse(new RequestChannel.Response(request.processor(), request, (Send)send));
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, requestMetrics, expectedTotalTimeCount){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SocketServerTest $outer;
                private final RequestMetrics requestMetrics$1;
                private final long expectedTotalTimeCount$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.$outer.kafka$network$SocketServerTest$$totalTimeHistCount$1(this.requestMetrics$1) == this.expectedTotalTimeCount$1;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.requestMetrics$1 = requestMetrics$1;
                    this.expectedTotalTimeCount$1 = expectedTotalTimeCount$1;
                }
            }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request metrics not updated, expected: ", ", actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)expectedTotalTimeCount), BoxesRunTime.boxToLong((long)this.kafka$network$SocketServerTest$$totalTimeHistCount$1(requestMetrics))})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            return;
        }
        finally {
            overrideServer.shutdown();
            serverMetrics.close();
        }
    }

    @Test
    public void testBrokerSendAfterChannelClosedUpdatesRequestMetrics() {
        int x$78 = 0;
        String x$79 = TestUtils$.MODULE$.MockZkConnect();
        int x$80 = 0;
        boolean x$81 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$82 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$83 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$84 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$85 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$86 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$87 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$88 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$89 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$90 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$91 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$92 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$93 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        Properties props = TestUtils$.MODULE$.createBrokerConfig(x$78, x$79, x$81, x$82, x$80, x$83, x$84, x$85, x$86, x$87, x$88, x$89, x$90, x$91, x$92, x$93);
        props.setProperty(KafkaConfig$.MODULE$.ConnectionsMaxIdleMsProp(), "100");
        Metrics serverMetrics = new Metrics();
        Socket conn = null;
        SocketServer overrideServer = new SocketServer(KafkaConfig$.MODULE$.fromProps(props), serverMetrics, Time.SYSTEM, this.credentialProvider());
        try {
            overrideServer.startup();
            conn = this.connect(overrideServer, this.connect$default$2());
            byte[] serializedBytes = this.producerRequestBytes();
            this.sendRequest(conn, serializedBytes, this.sendRequest$default$3());
            RequestChannel channel = overrideServer.requestChannel();
            RequestChannel.Request request = channel.receiveRequest(2000L);
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, overrideServer, request){
                public static final long serialVersionUID = 0L;
                private final SocketServer overrideServer$2;
                private final RequestChannel.Request request$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.overrideServer$2.processor(this.request$1.processor()).channel(this.request$1.connectionId()).isEmpty();
                }
                {
                    this.overrideServer$2 = overrideServer$2;
                    this.request$1 = request$1;
                }
            }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Idle connection `", "` was not closed by selector"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{request.connectionId()})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            RequestMetrics requestMetrics = (RequestMetrics)RequestMetrics$.MODULE$.metricsMap().apply((Object)ApiKeys.forId((int)request.requestId()).name);
            long expectedTotalTimeCount = this.kafka$network$SocketServerTest$$totalTimeHistCount$2(requestMetrics) + 1L;
            this.processRequest(channel, request);
            TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, requestMetrics, expectedTotalTimeCount){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SocketServerTest $outer;
                private final RequestMetrics requestMetrics$2;
                private final long expectedTotalTimeCount$2;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return this.$outer.kafka$network$SocketServerTest$$totalTimeHistCount$2(this.requestMetrics$2) == this.expectedTotalTimeCount$2;
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                    this.requestMetrics$2 = requestMetrics$2;
                    this.expectedTotalTimeCount$2 = expectedTotalTimeCount$2;
                }
            }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"request metrics not updated, expected: ", ", actual: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)expectedTotalTimeCount), BoxesRunTime.boxToLong((long)this.kafka$network$SocketServerTest$$totalTimeHistCount$2(requestMetrics))})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
            return;
        }
        finally {
            overrideServer.shutdown();
            serverMetrics.close();
        }
    }

    @Test
    public void testMetricCollectionAfterShutdown() {
        this.server().shutdown();
        double sum = BoxesRunTime.unboxToDouble((Object)((TraversableOnce)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(com.yammer.metrics.Metrics.defaultRegistry().allMetrics()).asScala()).filterKeys((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(MetricName k) {
                return k.getName().endsWith("IdlePercent") || k.getName().endsWith("NetworkProcessorAvgIdlePercent");
            }
        }).collect((PartialFunction)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final <A1 extends Tuple2<MetricName, Metric>, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                Metric metric;
                A1 A1 = x1;
                if (A1 != null && (metric = (Metric)A1._2()) instanceof Gauge) {
                    Gauge gauge = (Gauge)metric;
                    object = BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble((Object)gauge.value()));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Tuple2<MetricName, Metric> x1) {
                Metric metric;
                Tuple2<MetricName, Metric> tuple2 = x1;
                boolean bl = tuple2 != null && (metric = (Metric)tuple2._2()) instanceof Gauge;
                return bl;
            }
        }, Iterable$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
        Assert.assertEquals((double)0.0, (double)sum, (double)0.0);
    }

    public final long kafka$network$SocketServerTest$$totalTimeHistCount$1(RequestMetrics requestMetrics$1) {
        return requestMetrics$1.totalTimeHist().count();
    }

    public final long kafka$network$SocketServerTest$$totalTimeHistCount$2(RequestMetrics requestMetrics$2) {
        return requestMetrics$2.totalTimeHist().count();
    }

    public SocketServerTest() {
        int x$4 = 0;
        String x$5 = TestUtils$.MODULE$.MockZkConnect();
        int x$6 = 0;
        boolean x$7 = TestUtils$.MODULE$.createBrokerConfig$default$3();
        boolean x$8 = TestUtils$.MODULE$.createBrokerConfig$default$4();
        Option<SecurityProtocol> x$9 = TestUtils$.MODULE$.createBrokerConfig$default$6();
        Option<File> x$10 = TestUtils$.MODULE$.createBrokerConfig$default$7();
        Option<Properties> x$11 = TestUtils$.MODULE$.createBrokerConfig$default$8();
        boolean x$12 = TestUtils$.MODULE$.createBrokerConfig$default$9();
        boolean x$13 = TestUtils$.MODULE$.createBrokerConfig$default$10();
        int x$14 = TestUtils$.MODULE$.createBrokerConfig$default$11();
        boolean x$15 = TestUtils$.MODULE$.createBrokerConfig$default$12();
        int x$16 = TestUtils$.MODULE$.createBrokerConfig$default$13();
        boolean x$17 = TestUtils$.MODULE$.createBrokerConfig$default$14();
        int x$18 = TestUtils$.MODULE$.createBrokerConfig$default$15();
        Option<String> x$19 = TestUtils$.MODULE$.createBrokerConfig$default$16();
        this.props = TestUtils$.MODULE$.createBrokerConfig(x$4, x$5, x$7, x$8, x$6, x$9, x$10, x$11, x$12, x$13, x$14, x$15, x$16, x$17, x$18, x$19);
        this.props().put("listeners", "PLAINTEXT://localhost:0,TRACE://localhost:0");
        this.props().put("num.network.threads", "1");
        this.props().put("socket.send.buffer.bytes", "300000");
        this.props().put("socket.receive.buffer.bytes", "300000");
        this.props().put("queued.max.requests", "50");
        this.props().put("socket.request.max.bytes", "50");
        this.props().put("max.connections.per.ip", "5");
        this.props().put("connections.max.idle.ms", "60000");
        this.config = KafkaConfig$.MODULE$.fromProps(this.props());
        this.metrics = new Metrics();
        this.credentialProvider = new CredentialProvider(this.config().saslEnabledMechanisms());
        this.server = new SocketServer(this.config(), this.metrics(), Time.SYSTEM, this.credentialProvider());
        this.server().startup();
        this.sockets = new ArrayBuffer();
    }
}

