/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.nio.ByteBuffer;
import java.util.List;
import kafka.network.SocketServer;
import kafka.server.BaseRequestTest;
import kafka.server.DeleteTopicsRequestTest$$anonfun$kafka$server$DeleteTopicsRequestTest$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DeleteTopicsRequest;
import org.apache.kafka.common.requests.DeleteTopicsResponse;
import org.apache.kafka.common.requests.MetadataRequest;
import org.apache.kafka.common.requests.MetadataResponse;
import org.junit.Assert;
import org.junit.Test;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001e4A!\u0001\u0002\u0001\u000f\t9B)\u001a7fi\u0016$v\u000e]5dgJ+\u0017/^3tiR+7\u000f\u001e\u0006\u0003\u0007\u0011\taa]3sm\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001\u0001\u0003\t\u0003\u0013)i\u0011AA\u0005\u0003\u0017\t\u0011qBQ1tKJ+\u0017/^3tiR+7\u000f\u001e\u0005\u0006\u001b\u0001!\tAD\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003=\u0001\"!\u0003\u0001\t\u000bE\u0001A\u0011\u0001\n\u00029Q,7\u000f\u001e,bY&$G)\u001a7fi\u0016$v\u000e]5d%\u0016\fX/Z:ugR\t1\u0003\u0005\u0002\u0015/5\tQCC\u0001\u0017\u0003\u0015\u00198-\u00197b\u0013\tARC\u0001\u0003V]&$\bF\u0001\t\u001b!\tY\u0002%D\u0001\u001d\u0015\tib$A\u0003kk:LGOC\u0001 \u0003\ry'oZ\u0005\u0003Cq\u0011A\u0001V3ti\")1\u0005\u0001C\u0005I\u0005\u0001c/\u00197jI\u0006$XMV1mS\u0012$U\r\\3uKR{\u0007/[2SKF,Xm\u001d;t)\t\u0019R\u0005C\u0003'E\u0001\u0007q%A\u0004sKF,Xm\u001d;\u0011\u0005!\u0002T\"A\u0015\u000b\u0005)Z\u0013\u0001\u0003:fcV,7\u000f^:\u000b\u00051j\u0013AB2p[6|gN\u0003\u0002\u0006])\u0011qFH\u0001\u0007CB\f7\r[3\n\u0005EJ#a\u0005#fY\u0016$X\rV8qS\u000e\u001c(+Z9vKN$\b\"B\u001a\u0001\t\u0003\u0011\u0012\u0001\b;fgR,%O]8s\t\u0016dW\r^3U_BL7MU3rk\u0016\u001cHo\u001d\u0015\u0003eiAQA\u000e\u0001\u0005\n]\n\u0001E^1mS\u0012\fG/Z#se>\u0014H)\u001a7fi\u0016$v\u000e]5d%\u0016\fX/Z:ugR\u00191\u0003O\u001d\t\u000b\u0019*\u0004\u0019A\u0014\t\u000bi*\u0004\u0019A\u001e\u0002!\u0015D\b/Z2uK\u0012\u0014Vm\u001d9p]N,\u0007\u0003\u0002\u001f@\u0005\u0016s!\u0001F\u001f\n\u0005y*\u0012A\u0002)sK\u0012,g-\u0003\u0002A\u0003\n\u0019Q*\u00199\u000b\u0005y*\u0002C\u0001\u001fD\u0013\t!\u0015I\u0001\u0004TiJLgn\u001a\t\u0003\r&k\u0011a\u0012\u0006\u0003\u0011.\n\u0001\u0002\u001d:pi>\u001cw\u000e\\\u0005\u0003\u0015\u001e\u0013a!\u0012:s_J\u001c\b\"\u0002'\u0001\t\u0003\u0011\u0012!\u0005;fgRtu\u000e^\"p]R\u0014x\u000e\u001c7fe\"\u00121J\u0007\u0005\u0006\u001f\u0002!I\u0001U\u0001\u0017m\u0006d\u0017\u000eZ1uKR{\u0007/[2Jg\u0012+G.\u001a;fIR\u00111#\u0015\u0005\u0006%:\u0003\rAQ\u0001\u0006i>\u0004\u0018n\u0019\u0005\u0006)\u0002!I!V\u0001\u0018g\u0016tG\rR3mKR,Gk\u001c9jGN\u0014V-];fgR$2AV-[!\tAs+\u0003\u0002YS\t!B)\u001a7fi\u0016$v\u000e]5dgJ+7\u000f]8og\u0016DQAJ*A\u0002\u001dBqaW*\u0011\u0002\u0003\u0007A,\u0001\u0007t_\u000e\\W\r^*feZ,'\u000f\u0005\u0002^A6\taL\u0003\u0002`\t\u00059a.\u001a;x_J\\\u0017BA1_\u00051\u0019vnY6fiN+'O^3s\u0011\u0015\u0019\u0007\u0001\"\u0003e\u0003M\u0019XM\u001c3NKR\fG-\u0019;b%\u0016\fX/Z:u)\t)\u0007\u000e\u0005\u0002)M&\u0011q-\u000b\u0002\u0011\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016DQA\n2A\u0002%\u0004\"\u0001\u000b6\n\u0005-L#aD'fi\u0006$\u0017\r^1SKF,Xm\u001d;\t\u000f5\u0004\u0011\u0013!C\u0005]\u0006\t3/\u001a8e\t\u0016dW\r^3U_BL7m\u001d*fcV,7\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\tqN\u000b\u0002]a.\n\u0011\u000f\u0005\u0002so6\t1O\u0003\u0002uk\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003mV\t!\"\u00198o_R\fG/[8o\u0013\tA8OA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class DeleteTopicsRequestTest
extends BaseRequestTest {
    @Test
    public void testValidDeleteTopicRequests() {
        int timeout = 10000;
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "topic-1", 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.validateValidDeleteTopicRequests(new DeleteTopicsRequest.Builder((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic-1"}))).asJava(), Predef$.MODULE$.int2Integer(timeout)).build());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "topic-3", 5, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "topic-4", 1, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.validateValidDeleteTopicRequests(new DeleteTopicsRequest.Builder((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"topic-3", "topic-4"}))).asJava(), Predef$.MODULE$.int2Integer(timeout)).build());
    }

    private void validateValidDeleteTopicRequests(DeleteTopicsRequest request) {
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.sendDeleteTopicsRequest$default$2());
        Option error = ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(response.errors().values()).asScala()).find((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Errors x$1) {
                Errors errors = x$1;
                Errors errors2 = Errors.NONE;
                return errors != null ? !errors.equals(errors2) : errors2 != null;
            }
        });
        Assert.assertTrue((String)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"There should be no errors, found ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{JavaConverters$.MODULE$.mapAsScalaMapConverter(response.errors()).asScala()})), (boolean)error.isEmpty());
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(request.topics()).asScala()).foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicsRequestTest $outer;

            public final void apply(String topic) {
                this.$outer.kafka$server$DeleteTopicsRequestTest$$validateTopicIsDeleted(topic);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        });
    }

    @Test
    public void testErrorDeleteTopicRequests() {
        int timeout = 30000;
        String timeoutTopic = "invalid-timeout";
        this.validateErrorDeleteTopicRequests(new DeleteTopicsRequest.Builder((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"invalid-topic"}))).asJava(), Predef$.MODULE$.int2Integer(timeout)).build(), (Map<String, Errors>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"invalid-topic"), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION)}))));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), "partial-topic-1", 1, 1, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.validateErrorDeleteTopicRequests(new DeleteTopicsRequest.Builder((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"partial-topic-1", "partial-invalid-topic"}))).asJava(), Predef$.MODULE$.int2Integer(timeout)).build(), (Map<String, Errors>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partial-topic-1"), (Object)Errors.NONE), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)"partial-invalid-topic"), (Object)Errors.UNKNOWN_TOPIC_OR_PARTITION)}))));
        TestUtils$.MODULE$.createTopic(this.zkUtils(), timeoutTopic, 5, 2, (Seq<KafkaServer>)this.servers(), TestUtils$.MODULE$.createTopic$default$6());
        this.validateErrorDeleteTopicRequests(new DeleteTopicsRequest.Builder((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{timeoutTopic}))).asJava(), Predef$.MODULE$.int2Integer(0)).build(), (Map<String, Errors>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)timeoutTopic), (Object)Errors.REQUEST_TIMED_OUT)}))));
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, timeoutTopic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicsRequestTest $outer;
            private final String timeoutTopic$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !((KafkaServer)this.$outer.servers().head()).metadataCache().contains(this.timeoutTopic$1);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.timeoutTopic$1 = timeoutTopic$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Topic ", " is never deleted"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{timeoutTopic})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
        this.kafka$server$DeleteTopicsRequestTest$$validateTopicIsDeleted(timeoutTopic);
    }

    private void validateErrorDeleteTopicRequests(DeleteTopicsRequest request, Map<String, Errors> expectedResponse) {
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.sendDeleteTopicsRequest$default$2());
        scala.collection.mutable.Map errors = (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(response.errors()).asScala();
        Assert.assertEquals((String)"The response size should match", (long)expectedResponse.size(), (long)response.errors().size());
        expectedResponse.foreach((Function1)new Serializable(this, expectedResponse, errors){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeleteTopicsRequestTest $outer;
            private final Map expectedResponse$1;
            private final scala.collection.mutable.Map errors$1;

            public final void apply(Tuple2<String, Errors> x0$1) {
                Tuple2<String, Errors> tuple2 = x0$1;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    String topic = (String)tuple2._1();
                    Errors expectedError = (Errors)tuple2._2();
                    Assert.assertEquals((String)"The response error should match", (Object)this.expectedResponse$1.apply((Object)topic), (Object)this.errors$1.apply((Object)topic));
                    Errors errors = expectedError;
                    Errors errors2 = Errors.NONE;
                    if (!(errors != null ? !errors.equals(errors2) : errors2 != null)) {
                        this.$outer.kafka$server$DeleteTopicsRequestTest$$validateTopicIsDeleted(topic);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.expectedResponse$1 = expectedResponse$1;
                this.errors$1 = errors$1;
            }
        });
    }

    @Test
    public void testNotController() {
        DeleteTopicsRequest request = new DeleteTopicsRequest.Builder((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"not-controller"}))).asJava(), Predef$.MODULE$.int2Integer(1000)).build();
        DeleteTopicsResponse response = this.sendDeleteTopicsRequest(request, this.notControllerSocketServer());
        Errors error = (Errors)((Tuple2)((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(response.errors()).asScala()).head())._2();
        Assert.assertEquals((String)"Expected controller error when routed incorrectly", (Object)Errors.NOT_CONTROLLER, (Object)error);
    }

    public void kafka$server$DeleteTopicsRequestTest$$validateTopicIsDeleted(String topic) {
        Iterable metadata = (Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.sendMetadataRequest(new MetadataRequest.Builder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))).asJava()).build()).topicMetadata()).asScala();
        TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, topic, metadata){
            public static final long serialVersionUID = 0L;
            public final String topic$1;
            private final Iterable metadata$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return !this.metadata$1.exists((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$kafka$server$DeleteTopicsRequestTest$$validateTopicIsDeleted$1 $outer;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final boolean apply(MetadataResponse.TopicMetadata p) {
                        if (!p.topic().equals(this.$outer.topic$1)) return false;
                        Errors errors = p.error();
                        Errors errors2 = Errors.NONE;
                        if (errors != null) {
                            if (!errors.equals(errors2)) return false;
                            return true;
                        }
                        if (errors2 == null) return true;
                        return false;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.topic$1 = topic$1;
                this.metadata$1 = metadata$1;
            }
        }, new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The topic ", " should not exist"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic})), TestUtils$.MODULE$.waitUntilTrue$default$3(), TestUtils$.MODULE$.waitUntilTrue$default$4());
    }

    private DeleteTopicsResponse sendDeleteTopicsRequest(DeleteTopicsRequest request, SocketServer socketServer) {
        ByteBuffer response = this.send((AbstractRequest)request, ApiKeys.DELETE_TOPICS, socketServer, this.send$default$4());
        return DeleteTopicsResponse.parse((ByteBuffer)response, (int)request.version());
    }

    private SocketServer sendDeleteTopicsRequest$default$2() {
        return this.controllerSocketServer();
    }

    private MetadataResponse sendMetadataRequest(MetadataRequest request) {
        ByteBuffer response = this.send((AbstractRequest)request, ApiKeys.METADATA, this.send$default$3(), this.send$default$4());
        return MetadataResponse.parse((ByteBuffer)response);
    }
}

