/*
 * Decompiled with CFR 0.152.
 */
package kafka.integration;

import java.util.Hashtable;
import java.util.Properties;
import junit.framework.Assert;
import kafka.consumer.Consumer$;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.ConsumerConnector;
import kafka.consumer.ConsumerIterator;
import kafka.consumer.ConsumerTimeoutException;
import kafka.consumer.KafkaStream;
import kafka.integration.KafkaServerTestHarness;
import kafka.integration.KafkaServerTestHarness$class;
import kafka.producer.KeyedMessage;
import kafka.producer.Producer;
import kafka.serializer.DefaultEncoder;
import kafka.serializer.DefaultEncoder$;
import kafka.serializer.StringEncoder;
import kafka.serializer.StringEncoder$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandler;
import kafka.server.KafkaServer;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.TestUtils$;
import kafka.utils.ZKGroupTopicDirs;
import kafka.zk.EmbeddedZookeeper;
import kafka.zk.ZooKeeperTestHarness$class;
import org.I0Itec.zkclient.ZkClient;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.scalatest.junit.JUnit3Suite;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\u0001\u0003\u0001\u001d\u00111#Q;u_>3gm]3u%\u0016\u001cX\r\u001e+fgRT!a\u0001\u0003\u0002\u0017%tG/Z4sCRLwN\u001c\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011\u0003\u0002\u0001\t%Y\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\f\u0015Vs\u0017\u000e^\u001aTk&$X\r\u0005\u0002\u0014)5\t!!\u0003\u0002\u0016\u0005\t12*\u00194lCN+'O^3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002\u001855\t\u0001D\u0003\u0002\u001a\t\u0005)Q\u000f^5mg&\u00111\u0004\u0007\u0002\b\u0019><w-\u001b8h\u0011\u0015i\u0002\u0001\"\u0001\u001f\u0003\u0019a\u0014N\\5u}Q\tq\u0004\u0005\u0002\u0014\u0001!9\u0011\u0005\u0001b\u0001\n\u0003\u0011\u0013!\u0002;pa&\u001cW#A\u0012\u0011\u0005\u0011JS\"A\u0013\u000b\u0005\u0019:\u0013\u0001\u00027b]\u001eT\u0011\u0001K\u0001\u0005U\u00064\u0018-\u0003\u0002+K\t11\u000b\u001e:j]\u001eDa\u0001\f\u0001!\u0002\u0013\u0019\u0013A\u0002;pa&\u001c\u0007\u0005C\u0004/\u0001\t\u0007I\u0011\u0001\u0012\u0002\u000b\u001d\u0014x.\u001e9\t\rA\u0002\u0001\u0015!\u0003$\u0003\u00199'o\\;qA!9!\u0007\u0001b\u0001\n\u0003\u0011\u0013\u0001\u0004;fgR\u001cuN\\:v[\u0016\u0014\bB\u0002\u001b\u0001A\u0003%1%A\u0007uKN$8i\u001c8tk6,'\u000f\t\u0005\bm\u0001\u0011\r\u0011\"\u00018\u0003\u001d\u0019wN\u001c4jON,\u0012\u0001\u000f\t\u0004s\u0001\u0013U\"\u0001\u001e\u000b\u0005mb\u0014!C5n[V$\u0018M\u00197f\u0015\tid(\u0001\u0006d_2dWm\u0019;j_:T\u0011aP\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0003j\u0012A\u0001T5tiB\u00111IR\u0007\u0002\t*\u0011Q\tB\u0001\u0007g\u0016\u0014h/\u001a:\n\u0005\u001d#%aC&bM.\f7i\u001c8gS\u001eDa!\u0013\u0001!\u0002\u0013A\u0014\u0001C2p]\u001aLwm\u001d\u0011\t\u000f-\u0003!\u0019!C\u0001\u0019\u0006Ya*^7NKN\u001c\u0018mZ3t+\u0005i\u0005C\u0001(P\u001b\u0005q\u0014B\u0001)?\u0005\rIe\u000e\u001e\u0005\u0007%\u0002\u0001\u000b\u0011B'\u0002\u00199+X.T3tg\u0006<Wm\u001d\u0011\t\u000fQ\u0003!\u0019!C\u0001\u0019\u0006YA*\u0019:hK>3gm]3u\u0011\u00191\u0006\u0001)A\u0005\u001b\u0006aA*\u0019:hK>3gm]3uA!9\u0001\f\u0001b\u0001\n\u0003a\u0015aC*nC2dwJ\u001a4tKRDaA\u0017\u0001!\u0002\u0013i\u0015\u0001D*nC2dwJ\u001a4tKR\u0004\u0003b\u0002/\u0001\u0005\u0004%\t!X\u0001\u0015e\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0019><w-\u001a:\u0016\u0003y\u0003\"a\u00183\u000e\u0003\u0001T!!\u00192\u0002\u000b1|w\r\u000e6\u000b\u0005\rt\u0011AB1qC\u000eDW-\u0003\u0002fA\n1Aj\\4hKJDaa\u001a\u0001!\u0002\u0013q\u0016!\u0006:fcV,7\u000f\u001e%b]\u0012dWM\u001d'pO\u001e,'\u000f\t\u0005\u0006S\u0002!\tE[\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002WB\u0011a\n\\\u0005\u0003[z\u0012A!\u00168ji\")q\u000e\u0001C!U\u0006AA/Z1s\t><h\u000eC\u0003r\u0001\u0011\u0005!.\u0001\u0013uKN$(+Z:fiR{W)\u0019:mS\u0016\u001cHo\u00165f]>3gm]3u)>|\u0007*[4i\u0011\u0015\u0019\b\u0001\"\u0001k\u0003\r\"Xm\u001d;SKN,G\u000fV8FCJd\u0017.Z:u/\",gn\u00144gg\u0016$Hk\\8M_^DQ!\u001e\u0001\u0005\u0002)\f!\u0005^3tiJ+7/\u001a;U_2\u000bG/Z:u/\",gn\u00144gg\u0016$Hk\\8IS\u001eD\u0007\"B<\u0001\t\u0003Q\u0017!\t;fgR\u0014Vm]3u)>d\u0015\r^3ti^CWM\\(gMN,G\u000fV8p\u0019><\b\"B=\u0001\t\u0003Q\u0018a\u0004:fg\u0016$\u0018I\u001c3D_:\u001cX/\\3\u0015\u000b5[X0a\u0003\t\u000bqD\b\u0019A'\u0002\u00179,X.T3tg\u0006<Wm\u001d\u0005\u0006}b\u0004\ra`\u0001\be\u0016\u001cX\r\u001e+p!\u0011\t\t!a\u0002\u000f\u00079\u000b\u0019!C\u0002\u0002\u0006y\na\u0001\u0015:fI\u00164\u0017b\u0001\u0016\u0002\n)\u0019\u0011Q\u0001 \t\u000f\u00055\u0001\u00101\u0001\u0002\u0010\u00051qN\u001a4tKR\u00042ATA\t\u0013\r\t\u0019B\u0010\u0002\u0005\u0019>tw\r")
public class AutoOffsetResetTest
extends JUnit3Suite
implements KafkaServerTestHarness,
Logging {
    private final String topic;
    private final String group;
    private final String testConsumer;
    private final List<KafkaConfig> configs;
    private final int NumMessages;
    private final int LargeOffset;
    private final int SmallOffset;
    private final Logger requestHandlerLogger;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private List<KafkaServer> servers;
    private final String zkConnect;
    private EmbeddedZookeeper zookeeper;
    private ZkClient zkClient;
    private final int zkConnectionTimeout;
    private final int zkSessionTimeout;
    private volatile boolean bitmap$0;

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        AutoOffsetResetTest autoOffsetResetTest = this;
        synchronized (autoOffsetResetTest) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    @Override
    public List<KafkaServer> servers() {
        return this.servers;
    }

    @Override
    public void servers_$eq(List<KafkaServer> x$1) {
        this.servers = x$1;
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$setUp() {
        ZooKeeperTestHarness$class.setUp(this);
    }

    @Override
    public void kafka$integration$KafkaServerTestHarness$$super$tearDown() {
        ZooKeeperTestHarness$class.tearDown(this);
    }

    @Override
    public String zkConnect() {
        return this.zkConnect;
    }

    @Override
    public EmbeddedZookeeper zookeeper() {
        return this.zookeeper;
    }

    @Override
    public void zookeeper_$eq(EmbeddedZookeeper x$1) {
        this.zookeeper = x$1;
    }

    @Override
    public ZkClient zkClient() {
        return this.zkClient;
    }

    @Override
    public void zkClient_$eq(ZkClient x$1) {
        this.zkClient = x$1;
    }

    @Override
    public int zkConnectionTimeout() {
        return this.zkConnectionTimeout;
    }

    @Override
    public int zkSessionTimeout() {
        return this.zkSessionTimeout;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$setUp() {
        super.setUp();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$$super$tearDown() {
        super.tearDown();
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnect_$eq(String x$1) {
        this.zkConnect = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkConnectionTimeout_$eq(int x$1) {
        this.zkConnectionTimeout = x$1;
    }

    @Override
    public void kafka$zk$ZooKeeperTestHarness$_setter_$zkSessionTimeout_$eq(int x$1) {
        this.zkSessionTimeout = x$1;
    }

    public String topic() {
        return this.topic;
    }

    public String group() {
        return this.group;
    }

    public String testConsumer() {
        return this.testConsumer;
    }

    @Override
    public List<KafkaConfig> configs() {
        return this.configs;
    }

    public int NumMessages() {
        return this.NumMessages;
    }

    public int LargeOffset() {
        return this.LargeOffset;
    }

    public int SmallOffset() {
        return this.SmallOffset;
    }

    public Logger requestHandlerLogger() {
        return this.requestHandlerLogger;
    }

    @Override
    public void setUp() {
        KafkaServerTestHarness$class.setUp(this);
        this.requestHandlerLogger().setLevel(Level.FATAL);
    }

    @Override
    public void tearDown() {
        this.requestHandlerLogger().setLevel(Level.ERROR);
        KafkaServerTestHarness$class.tearDown(this);
    }

    public void testResetToEarliestWhenOffsetTooHigh() {
        Assert.assertEquals((int)this.NumMessages(), (int)this.resetAndConsume(this.NumMessages(), "smallest", this.LargeOffset()));
    }

    public void testResetToEarliestWhenOffsetTooLow() {
        Assert.assertEquals((int)this.NumMessages(), (int)this.resetAndConsume(this.NumMessages(), "smallest", this.SmallOffset()));
    }

    public void testResetToLatestWhenOffsetTooHigh() {
        Assert.assertEquals((int)0, (int)this.resetAndConsume(this.NumMessages(), "largest", this.LargeOffset()));
    }

    public void testResetToLatestWhenOffsetTooLow() {
        Assert.assertEquals((int)0, (int)this.resetAndConsume(this.NumMessages(), "largest", this.SmallOffset()));
    }

    public int resetAndConsume(int numMessages, String resetTo, long offset) {
        TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged(this.zkClient(), this.topic(), 0, 1000L, TestUtils$.MODULE$.waitUntilLeaderIsElectedOrChanged$default$5());
        Producer producer = TestUtils$.MODULE$.createProducer(TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)this.configs()), new DefaultEncoder(DefaultEncoder$.MODULE$.$lessinit$greater$default$1()), new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, producer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ AutoOffsetResetTest $outer;
            private final Producer producer$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.producer$1.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage(this.$outer.topic(), (Object)this.$outer.topic(), (Object)"test".getBytes())}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.producer$1 = producer$1;
            }
        });
        TestUtils$.MODULE$.waitUntilMetadataIsPropagated((Seq<KafkaServer>)this.servers(), this.topic(), 0, 1000L);
        ZKGroupTopicDirs dirs = new ZKGroupTopicDirs(this.group(), this.topic());
        Properties consumerProps = TestUtils$.MODULE$.createConsumerProperties(this.zkConnect(), this.group(), this.testConsumer(), TestUtils$.MODULE$.createConsumerProperties$default$4());
        ((Hashtable)consumerProps).put("auto.offset.reset", resetTo);
        ((Hashtable)consumerProps).put("consumer.timeout.ms", "2000");
        ((Hashtable)consumerProps).put("fetch.wait.max.ms", "0");
        ConsumerConfig consumerConfig = new ConsumerConfig(consumerProps);
        TestUtils$.MODULE$.updateConsumerOffset(consumerConfig, new StringBuilder().append((Object)dirs.consumerOffsetDir()).append((Object)"/").append((Object)"0").toString(), offset);
        this.info((Function0)new Serializable(this, offset){
            public static final long serialVersionUID = 0L;
            private final long offset$1;

            public final String apply() {
                return new StringBuilder().append((Object)"Updated consumer offset to ").append((Object)BoxesRunTime.boxToLong((long)this.offset$1)).toString();
            }
            {
                this.offset$1 = offset$1;
            }
        });
        ConsumerConnector consumerConnector = Consumer$.MODULE$.create(consumerConfig);
        KafkaStream messageStream = (KafkaStream)((IterableLike)consumerConnector.createMessageStreams((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)this.topic()), (Object)BoxesRunTime.boxToInteger((int)1))}))).apply((Object)this.topic())).head();
        IntRef received = new IntRef(0);
        ConsumerIterator iter = messageStream.iterator();
        try {
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), numMessages).foreach$mVc$sp((Function1)new Serializable(this, received, iter){
                public static final long serialVersionUID = 0L;
                private final IntRef received$1;
                private final ConsumerIterator iter$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    this.iter$1.next();
                    ++this.received$1.elem;
                }
                {
                    this.received$1 = received$1;
                    this.iter$1 = iter$1;
                }
            });
        }
        catch (ConsumerTimeoutException consumerTimeoutException) {
            this.info((Function0)new Serializable(this, received){
                public static final long serialVersionUID = 0L;
                private final IntRef received$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"consumer timed out after receiving ").append((Object)BoxesRunTime.boxToInteger((int)this.received$1.elem)).append((Object)" messages.").toString();
                }
                {
                    this.received$1 = received$1;
                }
            });
        }
        finally {
            producer.close();
            consumerConnector.shutdown();
        }
        return received.elem;
    }

    public AutoOffsetResetTest() {
        ZooKeeperTestHarness$class.$init$(this);
        KafkaServerTestHarness$class.$init$(this);
        Logging.class.$init$((Logging)this);
        this.topic = "test_topic";
        this.group = "default_group";
        this.testConsumer = "consumer";
        this.configs = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KafkaConfig[]{new KafkaConfig(TestUtils$.MODULE$.createBrokerConfig(0, TestUtils$.MODULE$.createBrokerConfig$default$2()))}));
        this.NumMessages = 10;
        this.LargeOffset = 10000;
        this.SmallOffset = -1;
        this.requestHandlerLogger = Logger.getLogger(KafkaRequestHandler.class);
    }
}

