/*
 * Decompiled with CFR 0.152.
 */
package kafka.message;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.HashMap;
import junit.framework.Assert;
import kafka.message.CompressionCodec;
import kafka.message.GZIPCompressionCodec$;
import kafka.message.Message;
import kafka.message.Message$;
import kafka.message.MessageTest$;
import kafka.message.MessageTest$$anonfun$setUp$1$;
import kafka.message.MessageTestVal;
import kafka.message.NoCompressionCodec$;
import kafka.utils.TestUtils$;
import kafka.utils.Utils$;
import org.junit.Before;
import org.junit.Test;
import org.scalatest.Assertions;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.PendingNothing;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.TestRerunner;
import org.scalatest.Tracker;
import org.scalatest.junit.AssertionsForJUnit;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.collection.mutable.ArrayBuffer;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001M3A!\u0001\u0002\u0001\u000f\tYQ*Z:tC\u001e,G+Z:u\u0015\t\u0019A!A\u0004nKN\u001c\u0018mZ3\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001aE\u0002\u0001\u0011A\u0001\"!\u0003\b\u000e\u0003)Q!a\u0003\u0007\u0002\t1\fgn\u001a\u0006\u0002\u001b\u0005!!.\u0019<b\u0013\ty!B\u0001\u0004PE*,7\r\u001e\t\u0003#ai\u0011A\u0005\u0006\u0003'Q\tQA[;oSRT!!\u0006\f\u0002\u0013M\u001c\u0017\r\\1uKN$(\"A\f\u0002\u0007=\u0014x-\u0003\u0002\u001a%\tQ!*\u00168jiN+\u0018\u000e^3\t\u000bm\u0001A\u0011\u0001\u000f\u0002\rqJg.\u001b;?)\u0005i\u0002C\u0001\u0010\u0001\u001b\u0005\u0011\u0001b\u0002\u0011\u0001\u0001\u0004%\t!I\u0001\t[\u0016\u001c8/Y4fgV\t!\u0005E\u0002$U1j\u0011\u0001\n\u0006\u0003K\u0019\nq!\\;uC\ndWM\u0003\u0002(Q\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0013\u0003\u0017\u0005\u0013(/Y=Ck\u001a4WM\u001d\t\u0003=5J!A\f\u0002\u0003\u001d5+7o]1hKR+7\u000f\u001e,bY\"9\u0001\u0007\u0001a\u0001\n\u0003\t\u0014\u0001D7fgN\fw-Z:`I\u0015\fHC\u0001\u001a7!\t\u0019D'D\u0001)\u0013\t)\u0004F\u0001\u0003V]&$\bbB\u001c0\u0003\u0003\u0005\rAI\u0001\u0004q\u0012\n\u0004BB\u001d\u0001A\u0003&!%A\u0005nKN\u001c\u0018mZ3tA!)1\b\u0001C\u0001y\u0005)1/\u001a;VaR\t!\u0007\u000b\u0002;}A\u0011q(Q\u0007\u0002\u0001*\u00111CF\u0005\u0003\u0005\u0002\u0013aAQ3g_J,\u0007\"\u0002#\u0001\t\u0003)\u0015a\u0004;fgR4\u0015.\u001a7e-\u0006dW/Z:\u0016\u0003IB#aQ$\u0011\u0005}B\u0015BA%A\u0005\u0011!Vm\u001d;\t\u000b-\u0003A\u0011\u0001\u001f\u0002\u0019Q,7\u000f^\"iK\u000e\\7/^7)\u0005);\u0005\"\u0002(\u0001\t\u0003a\u0014\u0001\u0004;fgR,\u0015/^1mSRL\bFA'H\u0011\u0015\t\u0006\u0001\"\u0001=\u00039!Xm\u001d;Jg\"\u000b7\u000f[1cY\u0016D#\u0001U$")
public class MessageTest
implements JUnitSuite {
    private ArrayBuffer<MessageTestVal> messages;
    private volatile Tracker org$scalatest$junit$JUnitSuite$$theTracker;
    private final String styleName;

    public Tracker org$scalatest$junit$JUnitSuite$$theTracker() {
        return this.org$scalatest$junit$JUnitSuite$$theTracker;
    }

    public void org$scalatest$junit$JUnitSuite$$theTracker_$eq(Tracker x$1) {
        this.org$scalatest$junit$JUnitSuite$$theTracker = x$1;
    }

    public final String styleName() {
        return this.styleName;
    }

    public final void org$scalatest$junit$JUnitSuite$_setter_$styleName_$eq(String x$1) {
        this.styleName = x$1;
    }

    public final void withFixture(Suite.NoArgTest test) {
        JUnitSuite.class.withFixture((JUnitSuite)this, (Suite.NoArgTest)test);
    }

    public final void runNestedSuites(Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runNestedSuites((JUnitSuite)this, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTests(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runTests((JUnitSuite)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        JUnitSuite.class.runTest((JUnitSuite)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    public Set<String> testNames() {
        return JUnitSuite.class.testNames((JUnitSuite)this);
    }

    public int expectedTestCount(Filter filter) {
        return JUnitSuite.class.expectedTestCount((JUnitSuite)this, (Filter)filter);
    }

    public Map<String, Set<String>> tags() {
        return JUnitSuite.class.tags((JUnitSuite)this);
    }

    public void run(Option<String> testName, Reporter report, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.run((JUnitSuite)this, testName, (Reporter)report, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public Throwable newAssertionFailedException(Option<Object> optionalMessage, Option<Throwable> optionalCause, int stackDepth) {
        return AssertionsForJUnit.class.newAssertionFailedException((AssertionsForJUnit)this, optionalMessage, optionalCause, (int)stackDepth);
    }

    public void org$scalatest$Suite$_setter_$styleName_$eq(String x$1) {
    }

    public List<Suite> nestedSuites() {
        return Suite.class.nestedSuites((Suite)this);
    }

    public final void execute(String testName, Map<String, Object> configMap, boolean color, boolean durations, boolean shortstacks, boolean fullstacks, boolean stats) {
        Suite.class.execute((Suite)this, (String)testName, configMap, (boolean)color, (boolean)durations, (boolean)shortstacks, (boolean)fullstacks, (boolean)stats);
    }

    public Method getMethodForTestName(String testName) {
        return Suite.class.getMethodForTestName((Suite)this, (String)testName);
    }

    public Tuple6<Stopper, Reporter, Method, Object, Option<TestRerunner>, Object> getSuiteRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getSuiteRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public Tuple5<Stopper, Reporter, Object, Option<TestRerunner>, Object> getRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public void handleFailedTest(Throwable throwable, boolean hasPublicNoArgConstructor, String testName, Option<Rerunner> rerunnable, Reporter report, Tracker tracker, long duration) {
        Suite.class.handleFailedTest((Suite)this, (Throwable)throwable, (boolean)hasPublicNoArgConstructor, (String)testName, rerunnable, (Reporter)report, (Tracker)tracker, (long)duration);
    }

    public String suiteName() {
        return Suite.class.suiteName((Suite)this);
    }

    public PendingNothing pending() {
        return Suite.class.pending((Suite)this);
    }

    public void pendingUntilFixed(Function0<BoxedUnit> f) {
        Suite.class.pendingUntilFixed((Suite)this, f);
    }

    public Reporter wrapReporterIfNecessary(Reporter reporter) {
        return Suite.class.wrapReporterIfNecessary((Suite)this, (Reporter)reporter);
    }

    public final String execute$default$1() {
        return Suite.class.execute$default$1((Suite)this);
    }

    public final Map<String, Object> execute$default$2() {
        return Suite.class.execute$default$2((Suite)this);
    }

    public final boolean execute$default$3() {
        return Suite.class.execute$default$3((Suite)this);
    }

    public final boolean execute$default$4() {
        return Suite.class.execute$default$4((Suite)this);
    }

    public final boolean execute$default$5() {
        return Suite.class.execute$default$5((Suite)this);
    }

    public final boolean execute$default$6() {
        return Suite.class.execute$default$6((Suite)this);
    }

    public final boolean execute$default$7() {
        return Suite.class.execute$default$7((Suite)this);
    }

    public void assert(boolean condition) {
        Assertions.class.assert((Assertions)this, (boolean)condition);
    }

    public void assert(boolean condition, Object clue) {
        Assertions.class.assert((Assertions)this, (boolean)condition, (Object)clue);
    }

    public void assert(Option<String> o, Object clue) {
        Assertions.class.assert((Assertions)this, o, (Object)clue);
    }

    public void assert(Option<String> o) {
        Assertions.class.assert((Assertions)this, o);
    }

    public Assertions.Equalizer convertToEqualizer(Object left) {
        return Assertions.class.convertToEqualizer((Assertions)this, (Object)left);
    }

    public <T> T intercept(Function0<Object> f, Manifest<T> manifest) {
        return (T)Assertions.class.intercept((Assertions)this, f, manifest);
    }

    public void expectResult(Object expected, Object clue, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expect(Object expected, Object clue, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expectResult(Object expected, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)actual);
    }

    public void expect(Object expected, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)actual);
    }

    public Nothing$ fail() {
        return Assertions.class.fail((Assertions)this);
    }

    public Nothing$ fail(String message) {
        return Assertions.class.fail((Assertions)this, (String)message);
    }

    public Nothing$ fail(String message, Throwable cause) {
        return Assertions.class.fail((Assertions)this, (String)message, (Throwable)cause);
    }

    public Nothing$ fail(Throwable cause) {
        return Assertions.class.fail((Assertions)this, (Throwable)cause);
    }

    public <T> T withClue(Object clue, Function0<T> fun) {
        return (T)Assertions.class.withClue((Assertions)this, (Object)clue, fun);
    }

    public ArrayBuffer<MessageTestVal> messages() {
        return this.messages;
    }

    public void messages_$eq(ArrayBuffer<MessageTestVal> x$1) {
        this.messages = x$1;
    }

    @Before
    public void setUp() {
        byte[][] byArrayArray = new byte[3][];
        byArrayArray[0] = null;
        byArrayArray[1] = "key".getBytes();
        byArrayArray[2] = "".getBytes();
        byte[][] keys = (byte[][])((Object[])byArrayArray);
        byte[][] byArrayArray2 = new byte[3][];
        byArrayArray2[0] = "value".getBytes();
        byArrayArray2[1] = "".getBytes();
        byArrayArray2[2] = null;
        byte[][] vals = (byte[][])((Object[])byArrayArray2);
        Product[] codecs = (Product[])((Object[])new Product[]{NoCompressionCodec$.MODULE$, GZIPCompressionCodec$.MODULE$});
        Predef$.MODULE$.refArrayOps((Object[])keys).foreach((Function1)new Serializable(this, vals, codecs){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ MessageTest $outer;
            private final byte[][] vals$1;
            public final Product[] codecs$1;

            public final void apply(byte[] k) {
                Predef$.MODULE$.refArrayOps((Object[])this.vals$1).foreach((Function1)new Serializable(this, k){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$setUp$1 $outer;
                    public final byte[] k$1;

                    public final void apply(byte[] v) {
                        Predef$.MODULE$.refArrayOps((Object[])this.$outer.codecs$1).foreach((Function1)new Serializable(this, v){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anonfun$setUp$1$$anonfun$apply$1 $outer;
                            private final byte[] v$1;

                            public final ArrayBuffer<MessageTestVal> apply(Product codec) {
                                return this.$outer.kafka$message$MessageTest$$anonfun$$anonfun$$$outer().kafka$message$MessageTest$$anonfun$$$outer().messages().$plus$eq((Object)new MessageTestVal(this.$outer.k$1, this.v$1, (CompressionCodec)codec, new Message(this.v$1, this.$outer.k$1, (CompressionCodec)codec)));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.v$1 = v$1;
                            }
                        });
                    }

                    public /* synthetic */ $anonfun$setUp$1 kafka$message$MessageTest$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.k$1 = k$1;
                    }
                });
            }

            public /* synthetic */ MessageTest kafka$message$MessageTest$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.vals$1 = vals$1;
                this.codecs$1 = codecs$1;
            }
        });
    }

    @Test
    public void testFieldValues() {
        this.messages().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MessageTestVal v) {
                if (v.payload() == null) {
                    Assert.assertTrue((boolean)v.message().isNull());
                    Assert.assertEquals((String)"Payload should be null", null, (Object)v.message().payload());
                } else {
                    TestUtils$.MODULE$.checkEquals(ByteBuffer.wrap(v.payload()), v.message().payload());
                }
                Assert.assertEquals((byte)Message$.MODULE$.CurrentMagicValue(), (byte)v.message().magic());
                if (v.message().hasKey()) {
                    TestUtils$.MODULE$.checkEquals(ByteBuffer.wrap(v.key()), v.message().key());
                } else {
                    Assert.assertEquals(null, (Object)v.message().key());
                }
                Assert.assertEquals((Object)v.codec(), (Object)v.message().compressionCodec());
            }
        });
    }

    @Test
    public void testChecksum() {
        this.messages().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MessageTestVal v) {
                Assert.assertTrue((String)"Auto-computed checksum should be valid", (boolean)v.message().isValid());
                int badChecksum = (int)(v.message().checksum() + 1L);
                Utils$.MODULE$.writeUnsignedInt(v.message().buffer(), Message$.MODULE$.CrcOffset(), (long)badChecksum);
                Assert.assertFalse((String)"Message with invalid checksum should be invalid", (boolean)v.message().isValid());
            }
        });
    }

    @Test
    public void testEquality() {
        this.messages().foreach((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final void apply(MessageTestVal v) {
                Assert.assertFalse((String)"Should not equal null", (boolean)v.message().equals(null));
                Assert.assertFalse((String)"Should not equal a random string", (boolean)v.message().equals((Object)"asdf"));
                Assert.assertTrue((String)"Should equal itself", (boolean)v.message().equals((Object)v.message()));
                Message copy = new Message(v.payload(), v.key(), v.codec());
                Assert.assertTrue((String)"Should equal another message with the same content.", (boolean)v.message().equals((Object)copy));
            }
        });
    }

    @Test
    public void testIsHashable() {
        HashMap m = new HashMap();
        this.messages().foreach((Function1)new Serializable(this, m){
            public static final long serialVersionUID = 0L;
            private final HashMap m$1;

            public final Message apply(MessageTestVal v) {
                return this.m$1.put(v.message(), v.message());
            }
            {
                this.m$1 = m$1;
            }
        });
        this.messages().foreach((Function1)new Serializable(this, m){
            public static final long serialVersionUID = 0L;
            private final HashMap m$1;

            public final void apply(MessageTestVal v) {
                Assert.assertEquals((Object)v.message(), this.m$1.get(v.message()));
            }
            {
                this.m$1 = m$1;
            }
        });
    }

    public MessageTest() {
        Assertions.class.$init$((Assertions)this);
        Suite.class.$init$((Suite)this);
        AssertionsForJUnit.class.$init$((AssertionsForJUnit)this);
        JUnitSuite.class.$init$((JUnitSuite)this);
        this.messages = new ArrayBuffer();
    }
}

