/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.Socket;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.util.Random;
import kafka.api.ProducerRequest;
import kafka.network.BoundedByteBufferSend;
import kafka.network.RequestChannel;
import kafka.network.Send;
import kafka.network.SocketServer;
import kafka.producer.SyncProducerConfig$;
import kafka.utils.TestUtils$;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.scalatest.Assertions;
import org.scalatest.Distributor;
import org.scalatest.Filter;
import org.scalatest.PendingNothing;
import org.scalatest.Reporter;
import org.scalatest.Rerunner;
import org.scalatest.Stopper;
import org.scalatest.Suite;
import org.scalatest.TestRerunner;
import org.scalatest.Tracker;
import org.scalatest.junit.AssertionsForJUnit;
import org.scalatest.junit.JUnitSuite;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple5;
import scala.Tuple6;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.mutable.Map$;
import scala.reflect.Manifest;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.Nothing$;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ScalaSignature(bytes="\u0006\u0001E4A!\u0001\u0002\u0001\u000f\t\u00012k\\2lKR\u001cVM\u001d<feR+7\u000f\u001e\u0006\u0003\u0007\u0011\tqA\\3uo>\u00148NC\u0001\u0006\u0003\u0015Y\u0017MZ6b\u0007\u0001\u00192\u0001\u0001\u0005\u0011!\tIa\"D\u0001\u000b\u0015\tYA\"\u0001\u0003mC:<'\"A\u0007\u0002\t)\fg/Y\u0005\u0003\u001f)\u0011aa\u00142kK\u000e$\bCA\t\u0019\u001b\u0005\u0011\"BA\n\u0015\u0003\u0015QWO\\5u\u0015\t)b#A\u0005tG\u0006d\u0017\r^3ti*\tq#A\u0002pe\u001eL!!\u0007\n\u0003\u0015)+f.\u001b;Tk&$X\rC\u0003\u001c\u0001\u0011\u0005A$\u0001\u0004=S:LGO\u0010\u000b\u0002;A\u0011a\u0004A\u0007\u0002\u0005!9\u0001\u0005\u0001b\u0001\n\u0003\t\u0013AB:feZ,'/F\u0001#!\tq2%\u0003\u0002%\u0005\ta1k\\2lKR\u001cVM\u001d<fe\"1a\u0005\u0001Q\u0001\n\t\nqa]3sm\u0016\u0014\b\u0005C\u0003)\u0001\u0011\u0005\u0011&A\u0006tK:$'+Z9vKN$H\u0003\u0002\u00161qu\u0002\"a\u000b\u0018\u000e\u00031R\u0011!L\u0001\u0006g\u000e\fG.Y\u0005\u0003_1\u0012A!\u00168ji\")\u0011g\na\u0001e\u000511o\\2lKR\u0004\"a\r\u001c\u000e\u0003QR!!\u000e\u0007\u0002\u00079,G/\u0003\u00028i\t11k\\2lKRDQ!O\u0014A\u0002i\n!!\u001b3\u0011\u0005-Z\u0014B\u0001\u001f-\u0005\u0015\u0019\u0006n\u001c:u\u0011\u0015qt\u00051\u0001@\u0003\u001d\u0011X-];fgR\u00042a\u000b!C\u0013\t\tEFA\u0003BeJ\f\u0017\u0010\u0005\u0002,\u0007&\u0011A\t\f\u0002\u0005\u0005f$X\rC\u0003G\u0001\u0011\u0005q)A\bsK\u000e,\u0017N^3SKN\u0004xN\\:f)\ty\u0004\nC\u00032\u000b\u0002\u0007!\u0007C\u0003K\u0001\u0011\u00051*\u0001\bqe>\u001cWm]:SKF,Xm\u001d;\u0015\u0005)b\u0005\"B'J\u0001\u0004q\u0015aB2iC:tW\r\u001c\t\u0003==K!\u0001\u0015\u0002\u0003\u001dI+\u0017/^3ti\u000eC\u0017M\u001c8fY\")!\u000b\u0001C\u0001'\u000691m\u001c8oK\u000e$H#\u0001\u001a\t\u000bU\u0003A\u0011\u0001,\u0002\u000f\rdW-\u00198vaR\t!\u0006\u000b\u0002U1B\u0011\u0011lW\u0007\u00025*\u00111CF\u0005\u00039j\u0013Q!\u00114uKJDQA\u0018\u0001\u0005\u0002Y\u000bQb]5na2,'+Z9vKN$\bFA/a!\tI\u0016-\u0003\u0002c5\n!A+Z:u\u0011\u0015!\u0007\u0001\"\u0001W\u0003]!xn\u001c\"jOJ+\u0017/^3ti&\u001b(+\u001a6fGR,G\r\u000b\u0003dA\u001a<\u0017\u0001C3ya\u0016\u001cG/\u001a3$\u0003!\u0004\"!\u001b7\u000e\u0003)T!a\u001b\u0007\u0002\u0005%|\u0017BA7k\u0005-Iu*\u0012=dKB$\u0018n\u001c8\t\u000b=\u0004A\u0011\u0001,\u00027Q,7\u000f^*pG.,GoU3mK\u000e$\u0018n\u001c8LKf\u001cF/\u0019;fQ\tq\u0007\r")
public class SocketServerTest
implements JUnitSuite {
    private final SocketServer server;
    private volatile Tracker org$scalatest$junit$JUnitSuite$$theTracker;
    private final String styleName;

    public Tracker org$scalatest$junit$JUnitSuite$$theTracker() {
        return this.org$scalatest$junit$JUnitSuite$$theTracker;
    }

    public void org$scalatest$junit$JUnitSuite$$theTracker_$eq(Tracker x$1) {
        this.org$scalatest$junit$JUnitSuite$$theTracker = x$1;
    }

    public final String styleName() {
        return this.styleName;
    }

    public final void org$scalatest$junit$JUnitSuite$_setter_$styleName_$eq(String x$1) {
        this.styleName = x$1;
    }

    public final void withFixture(Suite.NoArgTest test) {
        JUnitSuite.class.withFixture((JUnitSuite)this, (Suite.NoArgTest)test);
    }

    public final void runNestedSuites(Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runNestedSuites((JUnitSuite)this, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTests(Option<String> testName, Reporter reporter, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.runTests((JUnitSuite)this, testName, (Reporter)reporter, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public final void runTest(String testName, Reporter reporter, Stopper stopper, Map<String, Object> configMap, Tracker tracker) {
        JUnitSuite.class.runTest((JUnitSuite)this, (String)testName, (Reporter)reporter, (Stopper)stopper, configMap, (Tracker)tracker);
    }

    public Set<String> testNames() {
        return JUnitSuite.class.testNames((JUnitSuite)this);
    }

    public int expectedTestCount(Filter filter) {
        return JUnitSuite.class.expectedTestCount((JUnitSuite)this, (Filter)filter);
    }

    public Map<String, Set<String>> tags() {
        return JUnitSuite.class.tags((JUnitSuite)this);
    }

    public void run(Option<String> testName, Reporter report, Stopper stopper, Filter filter, Map<String, Object> configMap, Option<Distributor> distributor, Tracker tracker) {
        JUnitSuite.class.run((JUnitSuite)this, testName, (Reporter)report, (Stopper)stopper, (Filter)filter, configMap, distributor, (Tracker)tracker);
    }

    public Throwable newAssertionFailedException(Option<Object> optionalMessage, Option<Throwable> optionalCause, int stackDepth) {
        return AssertionsForJUnit.class.newAssertionFailedException((AssertionsForJUnit)this, optionalMessage, optionalCause, (int)stackDepth);
    }

    public void org$scalatest$Suite$_setter_$styleName_$eq(String x$1) {
    }

    public List<Suite> nestedSuites() {
        return Suite.class.nestedSuites((Suite)this);
    }

    public final void execute(String testName, Map<String, Object> configMap, boolean color, boolean durations, boolean shortstacks, boolean fullstacks, boolean stats) {
        Suite.class.execute((Suite)this, (String)testName, configMap, (boolean)color, (boolean)durations, (boolean)shortstacks, (boolean)fullstacks, (boolean)stats);
    }

    public Method getMethodForTestName(String testName) {
        return Suite.class.getMethodForTestName((Suite)this, (String)testName);
    }

    public Tuple6<Stopper, Reporter, Method, Object, Option<TestRerunner>, Object> getSuiteRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getSuiteRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public Tuple5<Stopper, Reporter, Object, Option<TestRerunner>, Object> getRunTestGoodies(Stopper stopper, Reporter reporter, String testName) {
        return Suite.class.getRunTestGoodies((Suite)this, (Stopper)stopper, (Reporter)reporter, (String)testName);
    }

    public void handleFailedTest(Throwable throwable, boolean hasPublicNoArgConstructor, String testName, Option<Rerunner> rerunnable, Reporter report, Tracker tracker, long duration) {
        Suite.class.handleFailedTest((Suite)this, (Throwable)throwable, (boolean)hasPublicNoArgConstructor, (String)testName, rerunnable, (Reporter)report, (Tracker)tracker, (long)duration);
    }

    public String suiteName() {
        return Suite.class.suiteName((Suite)this);
    }

    public PendingNothing pending() {
        return Suite.class.pending((Suite)this);
    }

    public void pendingUntilFixed(Function0<BoxedUnit> f) {
        Suite.class.pendingUntilFixed((Suite)this, f);
    }

    public Reporter wrapReporterIfNecessary(Reporter reporter) {
        return Suite.class.wrapReporterIfNecessary((Suite)this, (Reporter)reporter);
    }

    public final String execute$default$1() {
        return Suite.class.execute$default$1((Suite)this);
    }

    public final Map<String, Object> execute$default$2() {
        return Suite.class.execute$default$2((Suite)this);
    }

    public final boolean execute$default$3() {
        return Suite.class.execute$default$3((Suite)this);
    }

    public final boolean execute$default$4() {
        return Suite.class.execute$default$4((Suite)this);
    }

    public final boolean execute$default$5() {
        return Suite.class.execute$default$5((Suite)this);
    }

    public final boolean execute$default$6() {
        return Suite.class.execute$default$6((Suite)this);
    }

    public final boolean execute$default$7() {
        return Suite.class.execute$default$7((Suite)this);
    }

    public void assert(boolean condition) {
        Assertions.class.assert((Assertions)this, (boolean)condition);
    }

    public void assert(boolean condition, Object clue) {
        Assertions.class.assert((Assertions)this, (boolean)condition, (Object)clue);
    }

    public void assert(Option<String> o, Object clue) {
        Assertions.class.assert((Assertions)this, o, (Object)clue);
    }

    public void assert(Option<String> o) {
        Assertions.class.assert((Assertions)this, o);
    }

    public Assertions.Equalizer convertToEqualizer(Object left) {
        return Assertions.class.convertToEqualizer((Assertions)this, (Object)left);
    }

    public <T> T intercept(Function0<Object> f, Manifest<T> manifest) {
        return (T)Assertions.class.intercept((Assertions)this, f, manifest);
    }

    public void expectResult(Object expected, Object clue, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expect(Object expected, Object clue, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)clue, (Object)actual);
    }

    public void expectResult(Object expected, Object actual) {
        Assertions.class.expectResult((Assertions)this, (Object)expected, (Object)actual);
    }

    public void expect(Object expected, Object actual) {
        Assertions.class.expect((Assertions)this, (Object)expected, (Object)actual);
    }

    public Nothing$ fail() {
        return Assertions.class.fail((Assertions)this);
    }

    public Nothing$ fail(String message) {
        return Assertions.class.fail((Assertions)this, (String)message);
    }

    public Nothing$ fail(String message, Throwable cause) {
        return Assertions.class.fail((Assertions)this, (String)message, (Throwable)cause);
    }

    public Nothing$ fail(Throwable cause) {
        return Assertions.class.fail((Assertions)this, (Throwable)cause);
    }

    public <T> T withClue(Object clue, Function0<T> fun) {
        return (T)Assertions.class.withClue((Assertions)this, (Object)clue, fun);
    }

    public SocketServer server() {
        return this.server;
    }

    public void sendRequest(Socket socket, short id, byte[] request) {
        DataOutputStream outgoing = new DataOutputStream(socket.getOutputStream());
        outgoing.writeInt(request.length + 2);
        outgoing.writeShort(id);
        outgoing.write(request);
        outgoing.flush();
    }

    public byte[] receiveResponse(Socket socket) {
        DataInputStream incoming = new DataInputStream(socket.getInputStream());
        int len = incoming.readInt();
        byte[] response = new byte[len];
        incoming.readFully(response);
        return response;
    }

    public void processRequest(RequestChannel channel) {
        RequestChannel.Request request = channel.receiveRequest();
        ByteBuffer byteBuffer = ByteBuffer.allocate(request.requestObj().sizeInBytes());
        request.requestObj().writeTo(byteBuffer);
        ((Buffer)byteBuffer).rewind();
        BoundedByteBufferSend send = new BoundedByteBufferSend(byteBuffer);
        channel.sendResponse(new RequestChannel.Response(request.processor(), request, (Send)send));
    }

    public Socket connect() {
        return new Socket("localhost", this.server().port());
    }

    @After
    public void cleanup() {
        this.server().shutdown();
    }

    @Test
    public void simpleRequest() {
        Socket socket = this.connect();
        int correlationId = -1;
        String clientId = SyncProducerConfig$.MODULE$.DefaultClientId();
        int ackTimeoutMs = SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs();
        short ack = SyncProducerConfig$.MODULE$.DefaultRequiredAcks();
        ProducerRequest emptyRequest = new ProducerRequest(correlationId, clientId, ack, ackTimeoutMs, (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
        ByteBuffer byteBuffer = ByteBuffer.allocate(emptyRequest.sizeInBytes());
        emptyRequest.writeTo(byteBuffer);
        ((Buffer)byteBuffer).rewind();
        byte[] serializedBytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(serializedBytes);
        this.sendRequest(socket, (short)0, serializedBytes);
        this.processRequest(this.server().requestChannel());
        junit.framework.Assert.assertEquals((Object)Predef$.MODULE$.byteArrayOps(serializedBytes).toSeq(), (Object)Predef$.MODULE$.byteArrayOps(this.receiveResponse(socket)).toSeq());
    }

    @Test(expected=IOException.class)
    public void tooBigRequestIsRejected() {
        byte[] tooManyBytes = new byte[this.server().maxRequestSize() + 1];
        new Random().nextBytes(tooManyBytes);
        Socket socket = this.connect();
        this.sendRequest(socket, (short)0, tooManyBytes);
        this.receiveResponse(socket);
    }

    @Test
    public void testSocketSelectionKeyState() {
        Socket socket = this.connect();
        int correlationId = -1;
        String clientId = SyncProducerConfig$.MODULE$.DefaultClientId();
        int ackTimeoutMs = SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs();
        short ack = 0;
        ProducerRequest emptyRequest = new ProducerRequest(correlationId, clientId, ack, ackTimeoutMs, (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$));
        ByteBuffer byteBuffer = ByteBuffer.allocate(emptyRequest.sizeInBytes());
        emptyRequest.writeTo(byteBuffer);
        ((Buffer)byteBuffer).rewind();
        byte[] serializedBytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(serializedBytes);
        this.sendRequest(socket, (short)0, serializedBytes);
        RequestChannel.Request request = this.server().requestChannel().receiveRequest();
        Assert.assertFalse(((((SelectionKey)request.requestKey()).interestOps() & 1) == 1 ? 1 : 0) != 0);
        this.server().requestChannel().sendResponse(new RequestChannel.Response(0, request, null));
        Assert.assertTrue((boolean)TestUtils$.MODULE$.waitUntilTrue((Function0<Object>)new Serializable(this, request){
            public static final long serialVersionUID = 0L;
            private final RequestChannel.Request request$1;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return (((SelectionKey)this.request$1.requestKey()).interestOps() & 1) == 1;
            }
            {
                this.request$1 = request$1;
            }
        }, 5000L));
    }

    public SocketServerTest() {
        Assertions.class.$init$((Assertions)this);
        Suite.class.$init$((Suite)this);
        AssertionsForJUnit.class.$init$((AssertionsForJUnit)this);
        JUnitSuite.class.$init$((JUnitSuite)this);
        this.server = new SocketServer(0, null, TestUtils$.MODULE$.choosePort(), 1, 50, 300000, 300000, 50);
        this.server().startup();
    }
}

