/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.util.Hashtable;
import java.util.Properties;
import java.util.concurrent.LinkedBlockingQueue;
import junit.framework.Assert;
import kafka.api.PartitionMetadata;
import kafka.api.PartitionMetadata$;
import kafka.api.ProducerRequest;
import kafka.api.ProducerResponse;
import kafka.api.ProducerResponseStatus;
import kafka.api.TopicMetadata;
import kafka.api.TopicMetadata$;
import kafka.cluster.Broker;
import kafka.common.ErrorMapping$;
import kafka.common.FailedToSendMessageException;
import kafka.common.QueueFullException;
import kafka.common.TopicAndPartition;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.NoCompressionCodec$;
import kafka.producer.AsyncProducerTest$;
import kafka.producer.KeyedMessage;
import kafka.producer.NegativePartitioner;
import kafka.producer.NegativePartitioner$;
import kafka.producer.Partitioner;
import kafka.producer.Producer;
import kafka.producer.ProducerClosedException;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerPool;
import kafka.producer.SyncProducer;
import kafka.producer.async.DefaultEventHandler;
import kafka.producer.async.EventHandler;
import kafka.producer.async.ProducerSendThread;
import kafka.serializer.Encoder;
import kafka.serializer.NullEncoder;
import kafka.serializer.NullEncoder$;
import kafka.serializer.StringEncoder;
import kafka.serializer.StringEncoder$;
import kafka.server.KafkaConfig;
import kafka.utils.FixedValuePartitioner;
import kafka.utils.FixedValuePartitioner$;
import kafka.utils.IntEncoder;
import kafka.utils.IntEncoder$;
import kafka.utils.TestUtils$;
import kafka.utils.Utils$;
import org.easymock.EasyMock;
import org.junit.Test;
import org.scalatest.junit.JUnit3Suite;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConversions$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005%e\u0001B\u0001\u0003\u0001\u001d\u0011\u0011#Q:z]\u000e\u0004&o\u001c3vG\u0016\u0014H+Z:u\u0015\t\u0019A!\u0001\u0005qe>$WoY3s\u0015\u0005)\u0011!B6bM.\f7\u0001A\n\u0003\u0001!\u0001\"!\u0003\t\u000e\u0003)Q!a\u0003\u0007\u0002\u000b),h.\u001b;\u000b\u00055q\u0011!C:dC2\fG/Z:u\u0015\u0005y\u0011aA8sO&\u0011\u0011C\u0003\u0002\f\u0015Vs\u0017\u000e^\u001aTk&$X\rC\u0003\u0014\u0001\u0011\u0005A#\u0001\u0004=S:LGO\u0010\u000b\u0002+A\u0011a\u0003A\u0007\u0002\u0005!9\u0001\u0004\u0001b\u0001\n\u0003I\u0012!\u00029s_B\u001cX#\u0001\u000e\u0011\u0007m)\u0003F\u0004\u0002\u001dE9\u0011Q\u0004I\u0007\u0002=)\u0011qDB\u0001\u0007yI|w\u000e\u001e \n\u0003\u0005\nQa]2bY\u0006L!a\t\u0013\u0002\u000fA\f7m[1hK*\t\u0011%\u0003\u0002'O\t!A*[:u\u0015\t\u0019C\u0005\u0005\u0002*]5\t!F\u0003\u0002,Y\u0005!Q\u000f^5m\u0015\u0005i\u0013\u0001\u00026bm\u0006L!a\f\u0016\u0003\u0015A\u0013x\u000e]3si&,7\u000f\u0003\u00042\u0001\u0001\u0006IAG\u0001\u0007aJ|\u0007o\u001d\u0011\t\u000fM\u0002!\u0019!C\u0001i\u000591m\u001c8gS\u001e\u001cX#A\u001b\u0011\u0007YZD(D\u00018\u0015\tA\u0014(A\u0005j[6,H/\u00192mK*\u0011!\bJ\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u00148!\ti\u0004)D\u0001?\u0015\tyD!\u0001\u0004tKJ4XM]\u0005\u0003\u0003z\u00121bS1gW\u0006\u001cuN\u001c4jO\"11\t\u0001Q\u0001\nU\n\u0001bY8oM&<7\u000f\t\u0005\u0006\u000b\u0002!\tER\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002\u000fB\u0011\u0001*S\u0007\u0002I%\u0011!\n\n\u0002\u0005+:LG\u000fC\u0003M\u0001\u0011\u0005c)\u0001\u0005uK\u0006\u0014Hi\\<o\u0011\u0015q\u0005\u0001\"\u0001G\u0003U!Xm\u001d;Qe>$WoY3s#V,W/Z*ju\u0016D#!\u0014)\u0011\u0005E\u001bV\"\u0001*\u000b\u0005-q\u0011B\u0001+S\u0005\u0011!Vm\u001d;\t\u000bY\u0003A\u0011\u0001$\u0002-Q,7\u000f\u001e)s_\u0012,8-Z!gi\u0016\u00148\t\\8tK\u0012D#!\u0016)\t\u000be\u0003A\u0011\u0001$\u0002\u001bQ,7\u000f\u001e\"bi\u000eD7+\u001b>fQ\tA\u0006\u000bC\u0003]\u0001\u0011\u0005a)\u0001\u000buKN$\u0018+^3vKRKW.Z#ya&\u0014X\r\u001a\u0015\u00037BCQa\u0018\u0001\u0005\u0002\u0019\u000bQ\u0004^3tiB\u000b'\u000f^5uS>t\u0017I\u001c3D_2d\u0017\r^3Fm\u0016tGo\u001d\u0015\u0003=BCQA\u0019\u0001\u0005\u0002\u0019\u000b1\u0003^3tiN+'/[1mSj,WI^3oiND#!\u0019)\t\u000b\u0015\u0004A\u0011\u0001$\u0002)Q,7\u000f^%om\u0006d\u0017\u000e\u001a)beRLG/[8oQ\t!\u0007\u000bC\u0003i\u0001\u0011\u0005a)\u0001\u0007uKN$hj\u001c\"s_.,'\u000f\u000b\u0002h!\")1\u000e\u0001C\u0001\r\u00069B/Z:u\u0013:\u001cw.\u001c9bi&\u0014G.Z#oG>$WM\u001d\u0015\u0003UBCQA\u001c\u0001\u0005\u0002\u0019\u000bQ\u0003^3tiJ\u000bg\u000eZ8n!\u0006\u0014H/\u001b;j_:,'\u000f\u000b\u0002n!\")\u0011\u000f\u0001C\u0001\r\u00061B/Z:u\u0005J|7.\u001a:MSN$\u0018I\u001c3Bgft7\r\u000b\u0002q!\")A\u000f\u0001C\u0001\r\u0006AB/Z:u\r\u0006LG.\u001a3TK:$'+\u001a;ss2{w-[2)\u0005M\u0004\u0006\"B<\u0001\t\u00031\u0015\u0001\u0005;fgRT\u0015M^1Qe>$WoY3sQ\t1\b\u000bC\u0003{\u0001\u0011\u0005a)\u0001\ruKN$\u0018J\u001c<bY&$7i\u001c8gS\u001e,(/\u0019;j_:D#!\u001f)\t\u000bu\u0004A\u0011\u0001@\u0002\u001d\u001d,G\u000f\u0015:pIV\u001cW\rR1uCR\u0019q0!\u0007\u0011\u000bm\t\t!!\u0002\n\u0007\u0005\rqEA\u0002TKF\u0004rAFA\u0004\u0003\u0017\tY!C\u0002\u0002\n\t\u0011AbS3zK\u0012lUm]:bO\u0016\u0004B!!\u0004\u0002\u00149\u0019\u0001*a\u0004\n\u0007\u0005EA%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003+\t9B\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003#!\u0003bBA\u000ey\u0002\u0007\u0011QD\u0001\b]\u00163XM\u001c;t!\rA\u0015qD\u0005\u0004\u0003C!#aA%oi\"9\u0011Q\u0005\u0001\u0005\n\u0005\u001d\u0012\u0001E4fiR{\u0007/[2NKR\fG-\u0019;b)1\tI#!\u000e\u0002:\u0005u\u0012\u0011IA#!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018\t\u0005\u0019\u0011\r]5\n\t\u0005M\u0012Q\u0006\u0002\u000e)>\u0004\u0018nY'fi\u0006$\u0017\r^1\t\u0011\u0005]\u00121\u0005a\u0001\u0003\u0017\tQ\u0001^8qS\u000eD\u0001\"a\u000f\u0002$\u0001\u0007\u0011QD\u0001\na\u0006\u0014H/\u001b;j_:D\u0001\"a\u0010\u0002$\u0001\u0007\u0011QD\u0001\tEJ|7.\u001a:JI\"A\u00111IA\u0012\u0001\u0004\tY!\u0001\u0006ce>\\WM\u001d%pgRD\u0001\"a\u0012\u0002$\u0001\u0007\u0011QD\u0001\u000bEJ|7.\u001a:Q_J$\bbBA\u0013\u0001\u0011%\u00111\n\u000b\r\u0003S\ti%a\u0014\u0002T\u0005U\u0013q\u000b\u0005\t\u0003o\tI\u00051\u0001\u0002\f!A\u00111HA%\u0001\u0004\t\t\u0006E\u0003\u001c\u0003\u0003\ti\u0002\u0003\u0005\u0002@\u0005%\u0003\u0019AA\u000f\u0011!\t\u0019%!\u0013A\u0002\u0005-\u0001\u0002CA$\u0003\u0013\u0002\r!!\b\t\u000f\u0005m\u0003\u0001\"\u0001\u0002^\u0005iQ.Z:tC\u001e,7\u000fV8TKR$B!a\u0018\u0002lA!\u0011\u0011MA4\u001b\t\t\u0019GC\u0002\u0002f\u0011\tq!\\3tg\u0006<W-\u0003\u0003\u0002j\u0005\r$\u0001\u0006\"zi\u0016\u0014UO\u001a4fe6+7o]1hKN+G\u000f\u0003\u0005\u0002n\u0005e\u0003\u0019AA8\u0003!iWm]:bO\u0016\u001c\b#B\u000e\u0002\u0002\u0005-\u0001bBA.\u0001\u0011\u0005\u00111\u000f\u000b\u0007\u0003?\n)(!\"\t\u0011\u0005]\u0014\u0011\u000fa\u0001\u0003s\n1a[3z!\u0015A\u00151PA@\u0013\r\ti\b\n\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004\u0011\u0006\u0005\u0015bAABI\t!!)\u001f;f\u0011!\ti'!\u001dA\u0002\u0005\u001d\u0005#B\u000e\u0002\u0002\u0005e\u0004")
public class AsyncProducerTest
extends JUnit3Suite {
    private final List<Properties> props = TestUtils$.MODULE$.createBrokerConfigs(1);
    private final List<KafkaConfig> configs = (List)this.props().map((Function1)new $anonfun$1(this), List$.MODULE$.canBuildFrom());

    public List<Properties> props() {
        return this.props;
    }

    public List<KafkaConfig> configs() {
        return this.configs;
    }

    public void setUp() {
        super.setUp();
    }

    public void tearDown() {
        super.tearDown();
    }

    @Test
    public void testProducerQueueSize() {
        EventHandler<String, String> mockEventHandler = new EventHandler<String, String>(this){

            public void handle(Seq<KeyedMessage<String, String>> events) {
                Thread.sleep(500L);
            }

            public void close() {
            }
        };
        Properties props = new Properties();
        ((Hashtable)props).put("serializer.class", "kafka.serializer.StringEncoder");
        ((Hashtable)props).put("metadata.broker.list", TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)this.configs()));
        ((Hashtable)props).put("producer.type", "async");
        ((Hashtable)props).put("queue.buffering.max.messages", "10");
        ((Hashtable)props).put("batch.num.messages", "1");
        ((Hashtable)props).put("queue.enqueue.timeout.ms", "0");
        ProducerConfig config = new ProducerConfig(props);
        Seq<KeyedMessage<String, String>> produceData = this.getProduceData(12);
        Producer producer = new Producer(config, (EventHandler)mockEventHandler);
        try {
            try {
                producer.send(produceData);
                throw this.fail("Queue should be full");
            }
            catch (QueueFullException queueFullException) {
            }
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testProduceAfterClosed() {
        Properties props = new Properties();
        ((Hashtable)props).put("serializer.class", "kafka.serializer.StringEncoder");
        ((Hashtable)props).put("metadata.broker.list", TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)this.configs()));
        ((Hashtable)props).put("producer.type", "async");
        ((Hashtable)props).put("batch.num.messages", "1");
        ProducerConfig config = new ProducerConfig(props);
        Seq<KeyedMessage<String, String>> produceData = this.getProduceData(10);
        Producer producer = new Producer(config);
        producer.close();
        try {
            producer.send(produceData);
            throw this.fail("should complain that producer is already closed");
        }
        catch (ProducerClosedException producerClosedException) {
            return;
        }
    }

    @Test
    public void testBatchSize() {
        Seq<KeyedMessage<String, String>> producerDataList = this.getProduceData(10);
        DefaultEventHandler mockHandler = (DefaultEventHandler)EasyMock.createStrictMock(DefaultEventHandler.class);
        mockHandler.handle((Seq)producerDataList.take(5));
        EasyMock.expectLastCall();
        mockHandler.handle((Seq)producerDataList.takeRight(5));
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{mockHandler});
        LinkedBlockingQueue queue = new LinkedBlockingQueue(10);
        ProducerSendThread producerSendThread = new ProducerSendThread("thread1", queue, (EventHandler)mockHandler, Integer.MAX_VALUE, 5, "");
        producerSendThread.start();
        producerDataList.foreach((Function1)new Serializable(this, queue){
            public static final long serialVersionUID = 0L;
            private final LinkedBlockingQueue queue$1;

            public final void apply(KeyedMessage<String, String> producerData) {
                this.queue$1.put(producerData);
            }
            {
                this.queue$1 = queue$1;
            }
        });
        producerSendThread.shutdown();
        EasyMock.verify((Object[])new Object[]{mockHandler});
    }

    @Test
    public void testQueueTimeExpired() {
        Seq<KeyedMessage<String, String>> producerDataList = this.getProduceData(2);
        DefaultEventHandler mockHandler = (DefaultEventHandler)EasyMock.createStrictMock(DefaultEventHandler.class);
        mockHandler.handle(producerDataList);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{mockHandler});
        int queueExpirationTime = 200;
        LinkedBlockingQueue queue = new LinkedBlockingQueue(10);
        ProducerSendThread producerSendThread = new ProducerSendThread("thread1", queue, (EventHandler)mockHandler, (long)queueExpirationTime, 5, "");
        producerSendThread.start();
        producerDataList.foreach((Function1)new Serializable(this, queue){
            public static final long serialVersionUID = 0L;
            private final LinkedBlockingQueue queue$2;

            public final void apply(KeyedMessage<String, String> producerData) {
                this.queue$2.put(producerData);
            }
            {
                this.queue$2 = queue$2;
            }
        });
        Thread.sleep(queueExpirationTime + 100);
        EasyMock.verify((Object[])new Object[]{mockHandler});
        producerSendThread.shutdown();
    }

    @Test
    public void testPartitionAndCollateEvents() {
        ArrayBuffer producerDataList = new ArrayBuffer();
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Message("msg1".getBytes()))}));
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic2", (Object)BoxesRunTime.boxToInteger((int)-99), (Object)BoxesRunTime.boxToInteger((int)1), (Object)new Message("msg2".getBytes()))}));
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new Message("msg3".getBytes()))}));
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)-101), (Object)BoxesRunTime.boxToInteger((int)3), (Object)new Message("msg4".getBytes()))}));
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic2", (Object)BoxesRunTime.boxToInteger((int)4), (Object)new Message("msg5".getBytes()))}));
        Properties props = new Properties();
        ((Hashtable)props).put("metadata.broker.list", TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)this.configs()));
        Broker broker1 = new Broker(0, "localhost", 9092);
        Broker broker2 = new Broker(1, "localhost", 9093);
        PartitionMetadata partition1Metadata = new PartitionMetadata(0, (Option)new Some((Object)broker1), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{broker1, broker2})), PartitionMetadata$.MODULE$.$lessinit$greater$default$4(), PartitionMetadata$.MODULE$.$lessinit$greater$default$5());
        PartitionMetadata partition2Metadata = new PartitionMetadata(1, (Option)new Some((Object)broker2), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{broker1, broker2})), PartitionMetadata$.MODULE$.$lessinit$greater$default$4(), PartitionMetadata$.MODULE$.$lessinit$greater$default$5());
        TopicMetadata topic1Metadata = new TopicMetadata("topic1", (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionMetadata[]{partition1Metadata, partition2Metadata})), TopicMetadata$.MODULE$.$lessinit$greater$default$3());
        TopicMetadata topic2Metadata = new TopicMetadata("topic2", (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new PartitionMetadata[]{partition1Metadata, partition2Metadata})), TopicMetadata$.MODULE$.$lessinit$greater$default$3());
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        topicPartitionInfos.put((Object)"topic2", (Object)topic2Metadata);
        Partitioner intPartitioner = new Partitioner(this){

            public int partition(Object key, int numPartitions) {
                return BoxesRunTime.unboxToInt((Object)key) % numPartitions;
            }
        };
        ProducerConfig config = new ProducerConfig(props);
        ProducerPool producerPool = new ProducerPool(config);
        DefaultEventHandler handler = new DefaultEventHandler(config, intPartitioner, null, (Encoder)new IntEncoder(IntEncoder$.MODULE$.$lessinit$greater$default$1()), producerPool, topicPartitionInfos);
        ArrayBuffer topic1Broker1Data = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)0), (Object)new Message("msg1".getBytes())), new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)2), (Object)new Message("msg3".getBytes()))}));
        ArrayBuffer topic1Broker2Data = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)BoxesRunTime.boxToInteger((int)-101), (Object)BoxesRunTime.boxToInteger((int)3), (Object)new Message("msg4".getBytes()))}));
        ArrayBuffer topic2Broker1Data = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic2", (Object)BoxesRunTime.boxToInteger((int)4), (Object)new Message("msg5".getBytes()))}));
        ArrayBuffer topic2Broker2Data = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic2", (Object)BoxesRunTime.boxToInteger((int)-99), (Object)BoxesRunTime.boxToInteger((int)1), (Object)new Message("msg2".getBytes()))}));
        Some expectedResult = new Some((Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)0)), (Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 0)), (Object)topic1Broker1Data), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic2", 0)), (Object)topic2Broker1Data)}))), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)1)), (Object)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic1", 1)), (Object)topic1Broker2Data), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc((Object)new TopicAndPartition("topic2", 1)), (Object)topic2Broker2Data)})))})));
        Option actualResult = handler.partitionAndCollate((Seq)producerDataList);
        Assert.assertEquals((Object)expectedResult, (Object)actualResult);
    }

    @Test
    public void testSerializeEvents() {
        Seq produceData = (Seq)TestUtils$.MODULE$.getMsgStrings(5).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KeyedMessage<String, String> apply(String m) {
                return new KeyedMessage("topic1", (Object)m);
            }
        }, Seq$.MODULE$.canBuildFrom());
        Properties props = new Properties();
        ((Hashtable)props).put("metadata.broker.list", TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)this.configs()));
        ProducerConfig config = new ProducerConfig(props);
        TopicMetadata topic1Metadata = this.getTopicMetadata("topic1", 0, 0, "localhost", 9092);
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        ProducerPool producerPool = new ProducerPool(config);
        DefaultEventHandler handler = new DefaultEventHandler(config, null, (Encoder)new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), (Encoder)new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), producerPool, topicPartitionInfos);
        Seq serializedData = handler.serialize(produceData);
        Seq deserializedData = (Seq)serializedData.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final KeyedMessage<String, String> apply(KeyedMessage<String, Message> d) {
                return new KeyedMessage(d.topic(), (Object)Utils$.MODULE$.readString(((Message)d.message()).payload(), Utils$.MODULE$.readString$default$2()));
            }
        }, Seq$.MODULE$.canBuildFrom());
        TestUtils$.MODULE$.checkEquals(produceData.iterator(), deserializedData.iterator());
    }

    @Test
    public void testInvalidPartition() {
        ArrayBuffer producerDataList = new ArrayBuffer();
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)"key1", (Object)new Message("msg1".getBytes()))}));
        Properties props = new Properties();
        ((Hashtable)props).put("metadata.broker.list", TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)this.configs()));
        ProducerConfig config = new ProducerConfig(props);
        TopicMetadata topic1Metadata = this.getTopicMetadata("topic1", 0, 0, "localhost", 9092);
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        ProducerPool producerPool = new ProducerPool(config);
        DefaultEventHandler handler = new DefaultEventHandler(config, (Partitioner)new NegativePartitioner(NegativePartitioner$.MODULE$.$lessinit$greater$default$1()), null, null, producerPool, topicPartitionInfos);
        try {
            handler.partitionAndCollate((Seq)producerDataList);
            return;
        }
        catch (Throwable throwable) {
            throw this.fail("Should not throw any exception");
        }
    }

    @Test
    public void testNoBroker() {
        Properties props = new Properties();
        ((Hashtable)props).put("metadata.broker.list", TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)this.configs()));
        ProducerConfig config = new ProducerConfig(props);
        TopicMetadata topic1Metadata = new TopicMetadata("topic1", (Seq)Seq$.MODULE$.empty(), TopicMetadata$.MODULE$.$lessinit$greater$default$3());
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        ProducerPool producerPool = new ProducerPool(config);
        ArrayBuffer producerDataList = new ArrayBuffer();
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)"msg1")}));
        DefaultEventHandler handler = new DefaultEventHandler(config, null, (Encoder)new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), (Encoder)new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), producerPool, topicPartitionInfos);
        try {
            handler.handle((Seq)producerDataList);
            throw this.fail("Should fail with FailedToSendMessageException");
        }
        catch (FailedToSendMessageException failedToSendMessageException) {
            return;
        }
    }

    @Test
    public void testIncompatibleEncoder() {
        Properties props = new Properties();
        ((Hashtable)props).put("metadata.broker.list", TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)this.configs()));
        ProducerConfig config = new ProducerConfig(props);
        Producer producer = new Producer(config);
        try {
            try {
                producer.send(this.getProduceData(1));
                throw this.fail("Should fail with ClassCastException due to incompatible Encoder");
            }
            catch (ClassCastException classCastException) {
            }
        }
        finally {
            producer.close();
        }
    }

    @Test
    public void testRandomPartitioner() {
        Option partitionedDataOpt;
        Properties props = new Properties();
        ((Hashtable)props).put("metadata.broker.list", TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)this.configs()));
        ProducerConfig config = new ProducerConfig(props);
        TopicMetadata topic1Metadata = this.getTopicMetadata("topic1", 0, 0, "localhost", 9092);
        TopicMetadata topic2Metadata = this.getTopicMetadata("topic2", 0, 0, "localhost", 9092);
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        topicPartitionInfos.put((Object)"topic2", (Object)topic2Metadata);
        ProducerPool producerPool = new ProducerPool(config);
        DefaultEventHandler handler = new DefaultEventHandler(config, null, null, null, producerPool, topicPartitionInfos);
        ArrayBuffer producerDataList = new ArrayBuffer();
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)new Message("msg1".getBytes()))}));
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic2", (Object)new Message("msg2".getBytes()))}));
        producerDataList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{new KeyedMessage("topic1", (Object)new Message("msg3".getBytes()))}));
        Option option = partitionedDataOpt = handler.partitionAndCollate((Seq)producerDataList);
        if (option instanceof Some) {
            Some some = (Some)option;
            Map partitionedData = (Map)some.x();
            partitionedData.withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<String, Message>>>> check$ifrefutable$1) {
                    Tuple2<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<String, Message>>>> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<String, Message>>>> x$2) {
                    Tuple2<Object, scala.collection.mutable.Map<TopicAndPartition, Seq<KeyedMessage<String, Message>>>> tuple2 = x$2;
                    if (tuple2 != null) {
                        scala.collection.mutable.Map dataPerBroker = (scala.collection.mutable.Map)tuple2._2();
                        dataPerBroker.withFilter((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final boolean apply(Tuple2<TopicAndPartition, Seq<KeyedMessage<String, Message>>> check$ifrefutable$2) {
                                TopicAndPartition topicAndPartition;
                                Tuple2<TopicAndPartition, Seq<KeyedMessage<String, Message>>> tuple2 = check$ifrefutable$2;
                                boolean bl = tuple2 != null && (topicAndPartition = (TopicAndPartition)tuple2._1()) != null;
                                return bl;
                            }
                        }).foreach((Function1)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final void apply(Tuple2<TopicAndPartition, Seq<KeyedMessage<String, Message>>> x$1) {
                                TopicAndPartition topicAndPartition;
                                Tuple2<TopicAndPartition, Seq<KeyedMessage<String, Message>>> tuple2 = x$1;
                                if (tuple2 != null && (topicAndPartition = (TopicAndPartition)tuple2._1()) != null) {
                                    int partitionId = topicAndPartition.partition();
                                    Assert.assertTrue((partitionId == 0 ? 1 : 0) != 0);
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    return;
                                }
                                throw new MatchError(tuple2);
                            }
                        });
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        return;
                    }
                    throw new MatchError(tuple2);
                }
            });
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        None$ none$ = None$.MODULE$;
        Option option2 = option;
        if (!(none$ != null ? !none$.equals(option2) : option2 != null)) {
            throw this.fail("Failed to collate requests by topic, partition");
        }
        throw new MatchError((Object)option);
    }

    @Test
    public void testBrokerListAndAsync() {
    }

    @Test
    public void testFailedSendRetryLogic() {
        Properties props = new Properties();
        ((Hashtable)props).put("metadata.broker.list", TestUtils$.MODULE$.getBrokerListStrFromConfigs((Seq<KafkaConfig>)this.configs()));
        ((Hashtable)props).put("request.required.acks", "1");
        ((Hashtable)props).put("serializer.class", StringEncoder.class.getName().toString());
        ((Hashtable)props).put("key.serializer.class", NullEncoder.class.getName().toString());
        ((Hashtable)props).put("producer.num.retries", ((Object)BoxesRunTime.boxToInteger((int)3)).toString());
        ProducerConfig config = new ProducerConfig(props);
        String topic1 = "topic1";
        TopicMetadata topic1Metadata = this.getTopicMetadata(topic1, (Seq<Object>)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}), 0, "localhost", 9092);
        HashMap topicPartitionInfos = new HashMap();
        topicPartitionInfos.put((Object)"topic1", (Object)topic1Metadata);
        Seq<String> msgs = TestUtils$.MODULE$.getMsgStrings(2);
        List x$4 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1}));
        List x$5 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        ByteBufferMessageSet x$6 = this.messagesToSet(msgs);
        int x$7 = 1;
        int x$8 = 11;
        int x$9 = TestUtils$.MODULE$.produceRequestWithAcks$default$5();
        String x$10 = TestUtils$.MODULE$.produceRequestWithAcks$default$7();
        ProducerRequest request1 = TestUtils$.MODULE$.produceRequestWithAcks((Seq<String>)x$4, (Seq<Object>)x$5, x$6, x$7, x$9, x$8, x$10);
        List x$11 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic1}));
        List x$12 = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{0, 1}));
        ByteBufferMessageSet x$13 = this.messagesToSet(msgs);
        int x$14 = 1;
        int x$15 = 17;
        int x$16 = TestUtils$.MODULE$.produceRequestWithAcks$default$5();
        String x$17 = TestUtils$.MODULE$.produceRequestWithAcks$default$7();
        ProducerRequest request2 = TestUtils$.MODULE$.produceRequestWithAcks((Seq<String>)x$11, (Seq<Object>)x$12, x$13, x$14, x$16, x$15, x$17);
        ProducerResponse response1 = new ProducerResponse(0, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new TopicAndPartition("topic1", 0), (Object)new ProducerResponseStatus(ErrorMapping$.MODULE$.NotLeaderForPartitionCode(), 0L)), new Tuple2((Object)new TopicAndPartition("topic1", 1), (Object)new ProducerResponseStatus(ErrorMapping$.MODULE$.NoError(), 0L))})));
        String x$18 = topic1;
        int x$19 = 0;
        ByteBufferMessageSet x$20 = this.messagesToSet(msgs);
        int x$21 = 1;
        int x$22 = 21;
        int x$23 = TestUtils$.MODULE$.produceRequest$default$5();
        String x$24 = TestUtils$.MODULE$.produceRequest$default$7();
        ProducerRequest request3 = TestUtils$.MODULE$.produceRequest(x$18, x$19, x$20, x$21, x$23, x$22, x$24);
        ProducerResponse response2 = new ProducerResponse(0, (Map)Map$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{new Tuple2((Object)new TopicAndPartition("topic1", 0), (Object)new ProducerResponseStatus(ErrorMapping$.MODULE$.NoError(), 0L))})));
        SyncProducer mockSyncProducer = (SyncProducer)EasyMock.createMock(SyncProducer.class);
        EasyMock.expect((Object)mockSyncProducer.config()).andReturn(EasyMock.anyObject()).anyTimes();
        EasyMock.expect((Object)mockSyncProducer.send(request1)).andThrow((Throwable)new RuntimeException());
        EasyMock.expect((Object)mockSyncProducer.send(request2)).andReturn((Object)response1);
        EasyMock.expect((Object)mockSyncProducer.send(request3)).andReturn((Object)response2);
        EasyMock.replay((Object[])new Object[]{mockSyncProducer});
        ProducerPool producerPool = (ProducerPool)EasyMock.createMock(ProducerPool.class);
        EasyMock.expect((Object)producerPool.getProducer(0)).andReturn((Object)mockSyncProducer).times(4);
        producerPool.close();
        EasyMock.expect((Object)BoxedUnit.UNIT);
        EasyMock.replay((Object[])new Object[]{producerPool});
        DefaultEventHandler handler = new DefaultEventHandler(config, (Partitioner)new FixedValuePartitioner(FixedValuePartitioner$.MODULE$.$lessinit$greater$default$1()), (Encoder)new StringEncoder(StringEncoder$.MODULE$.$lessinit$greater$default$1()), (Encoder)new NullEncoder(NullEncoder$.MODULE$.$lessinit$greater$default$1()), producerPool, topicPartitionInfos);
        Seq data = (Seq)((TraversableLike)msgs.map((Function1)new Serializable(this, topic1){
            public static final long serialVersionUID = 0L;
            private final String topic1$1;

            public final KeyedMessage<Object, String> apply(String m) {
                return new KeyedMessage(this.topic1$1, (Object)BoxesRunTime.boxToInteger((int)0), (Object)m);
            }
            {
                this.topic1$1 = topic1$1;
            }
        }, Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)msgs.map((Function1)new Serializable(this, topic1){
            public static final long serialVersionUID = 0L;
            private final String topic1$1;

            public final KeyedMessage<Object, String> apply(String m) {
                return new KeyedMessage(this.topic1$1, (Object)BoxesRunTime.boxToInteger((int)1), (Object)m);
            }
            {
                this.topic1$1 = topic1$1;
            }
        }, Seq$.MODULE$.canBuildFrom()), Seq$.MODULE$.canBuildFrom());
        handler.handle(data);
        handler.close();
        EasyMock.verify((Object[])new Object[]{mockSyncProducer});
        EasyMock.verify((Object[])new Object[]{producerPool});
    }

    @Test
    public void testJavaProducer() {
        String topic = "topic1";
        Seq<String> msgs = TestUtils$.MODULE$.getMsgStrings(5);
        Seq scalaProducerData = (Seq)msgs.map((Function1)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$2;

            public final KeyedMessage<String, String> apply(String m) {
                return new KeyedMessage(this.topic$2, (Object)m);
            }
            {
                this.topic$2 = topic$2;
            }
        }, Seq$.MODULE$.canBuildFrom());
        java.util.List javaProducerData = JavaConversions$.MODULE$.seqAsJavaList(scalaProducerData);
        Producer mockScalaProducer = (Producer)EasyMock.createMock(Producer.class);
        mockScalaProducer.send((Seq)Predef$.MODULE$.wrapRefArray((Object[])new KeyedMessage[]{(KeyedMessage)scalaProducerData.head()}));
        EasyMock.expectLastCall();
        mockScalaProducer.send(scalaProducerData);
        EasyMock.expectLastCall();
        EasyMock.replay((Object[])new Object[]{mockScalaProducer});
        kafka.javaapi.producer.Producer javaProducer = new kafka.javaapi.producer.Producer(mockScalaProducer);
        javaProducer.send((KeyedMessage)javaProducerData.get(0));
        javaProducer.send(javaProducerData);
        EasyMock.verify((Object[])new Object[]{mockScalaProducer});
    }

    @Test
    public void testInvalidConfiguration() {
        Properties props = new Properties();
        ((Hashtable)props).put("serializer.class", "kafka.serializer.StringEncoder");
        ((Hashtable)props).put("producer.type", "async");
        try {
            new ProducerConfig(props);
            throw this.fail("should complain about wrong config");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public Seq<KeyedMessage<String, String>> getProduceData(int nEvents) {
        void var2_2;
        ArrayBuffer producerDataList = new ArrayBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), nEvents).foreach$mVc$sp((Function1)new Serializable(this, producerDataList){
            public static final long serialVersionUID = 0L;
            private final ArrayBuffer producerDataList$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                KeyedMessage[] keyedMessageArray = new KeyedMessage[1];
                keyedMessageArray[0] = new KeyedMessage("topic1", null, (Object)new StringBuilder().append((Object)"msg").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
                this.producerDataList$1.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])keyedMessageArray));
            }
            {
                this.producerDataList$1 = producerDataList$1;
            }
        });
        return var2_2;
    }

    private TopicMetadata getTopicMetadata(String topic, int partition, int brokerId, String brokerHost, int brokerPort) {
        return this.getTopicMetadata(topic, (Seq<Object>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{partition})), brokerId, brokerHost, brokerPort);
    }

    private TopicMetadata getTopicMetadata(String topic, Seq<Object> partition, int brokerId, String brokerHost, int brokerPort) {
        Broker broker1 = new Broker(brokerId, brokerHost, brokerPort);
        return new TopicMetadata(topic, (Seq)partition.map((Function1)new Serializable(this, broker1){
            public static final long serialVersionUID = 0L;
            private final Broker broker1$1;

            public final PartitionMetadata apply(int x$3) {
                return new PartitionMetadata(x$3, (Option)new Some((Object)this.broker1$1), (Seq)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Broker[]{this.broker1$1})), PartitionMetadata$.MODULE$.$lessinit$greater$default$4(), PartitionMetadata$.MODULE$.$lessinit$greater$default$5());
            }
            {
                this.broker1$1 = broker1$1;
            }
        }, Seq$.MODULE$.canBuildFrom()), TopicMetadata$.MODULE$.$lessinit$greater$default$3());
    }

    public ByteBufferMessageSet messagesToSet(Seq<String> messages2) {
        return new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)messages2.map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Message apply(String m) {
                return new Message(m.getBytes());
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }

    public ByteBufferMessageSet messagesToSet(byte[] key, Seq<byte[]> messages2) {
        return new ByteBufferMessageSet((CompressionCodec)NoCompressionCodec$.MODULE$, (Seq)messages2.map((Function1)new Serializable(this, key){
            public static final long serialVersionUID = 0L;
            private final byte[] key$1;

            public final Message apply(byte[] m) {
                byte[] x$25 = this.key$1;
                byte[] x$26 = m;
                return new Message(x$26, x$25);
            }
            {
                this.key$1 = key$1;
            }
        }, Seq$.MODULE$.canBuildFrom()));
    }
}

