/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils;

import java.io.File;
import java.io.FileOutputStream;
import java.io.RandomAccessFile;
import java.net.ServerSocket;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import junit.framework.Assert;
import kafka.api.LeaderAndIsr;
import kafka.api.ProducerRequest;
import kafka.api.RequestOrResponse;
import kafka.cluster.Broker;
import kafka.cluster.Partition;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig;
import kafka.message.ByteBufferMessageSet;
import kafka.message.CompressionCodec;
import kafka.message.Message;
import kafka.message.MessageAndOffset;
import kafka.message.NoCompressionCodec$;
import kafka.producer.Producer;
import kafka.producer.ProducerConfig;
import kafka.producer.SyncProducerConfig$;
import kafka.serializer.DefaultEncoder;
import kafka.serializer.DefaultEncoder$;
import kafka.serializer.Encoder;
import kafka.serializer.StringEncoder;
import kafka.server.KafkaConfig;
import kafka.server.KafkaServer;
import kafka.utils.IteratorTemplate;
import kafka.utils.LeaderExistsOrChangedListener;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.SystemTime$;
import kafka.utils.TestUtils$;
import kafka.utils.TestZKUtils$;
import kafka.utils.Time;
import kafka.utils.ZKStringSerializer$;
import kafka.utils.ZkUtils$;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.serialize.ZkSerializer;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.BufferedIterator;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Traversable;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.CanBuildFrom;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Stream;
import scala.collection.immutable.StringOps;
import scala.collection.immutable.Vector;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.math.Numeric;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;
import scala.runtime.Nothing$;
import scala.runtime.RichInt$;
import scala.runtime.RichLong;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class TestUtils$
implements Logging {
    public static final TestUtils$ MODULE$;
    private final String IoTmpDir;
    private final String Letters;
    private final String Digits;
    private final String LettersAndDigits;
    private final Random seededRandom;
    private final Random random;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new TestUtils$();
    }

    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TestUtils$ testUtils$ = this;
        synchronized (testUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public String logIdent() {
        return this.logIdent;
    }

    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    public void trace(Function0<String> msg) {
        Logging.class.trace((Logging)this, msg);
    }

    public Object trace(Function0<Throwable> e) {
        return Logging.class.trace((Logging)this, e);
    }

    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.trace((Logging)this, msg, e);
    }

    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging.class.swallowTrace((Logging)this, action);
    }

    public void debug(Function0<String> msg) {
        Logging.class.debug((Logging)this, msg);
    }

    public Object debug(Function0<Throwable> e) {
        return Logging.class.debug((Logging)this, e);
    }

    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.debug((Logging)this, msg, e);
    }

    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging.class.swallowDebug((Logging)this, action);
    }

    public void info(Function0<String> msg) {
        Logging.class.info((Logging)this, msg);
    }

    public Object info(Function0<Throwable> e) {
        return Logging.class.info((Logging)this, e);
    }

    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.info((Logging)this, msg, e);
    }

    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging.class.swallowInfo((Logging)this, action);
    }

    public void warn(Function0<String> msg) {
        Logging.class.warn((Logging)this, msg);
    }

    public Object warn(Function0<Throwable> e) {
        return Logging.class.warn((Logging)this, e);
    }

    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.warn((Logging)this, msg, e);
    }

    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging.class.swallowWarn((Logging)this, action);
    }

    public void swallow(Function0<BoxedUnit> action) {
        Logging.class.swallow((Logging)this, action);
    }

    public void error(Function0<String> msg) {
        Logging.class.error((Logging)this, msg);
    }

    public Object error(Function0<Throwable> e) {
        return Logging.class.error((Logging)this, e);
    }

    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.error((Logging)this, msg, e);
    }

    public void swallowError(Function0<BoxedUnit> action) {
        Logging.class.swallowError((Logging)this, action);
    }

    public void fatal(Function0<String> msg) {
        Logging.class.fatal((Logging)this, msg);
    }

    public Object fatal(Function0<Throwable> e) {
        return Logging.class.fatal((Logging)this, e);
    }

    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.class.fatal((Logging)this, msg, e);
    }

    public String IoTmpDir() {
        return this.IoTmpDir;
    }

    public String Letters() {
        return this.Letters;
    }

    public String Digits() {
        return this.Digits;
    }

    public String LettersAndDigits() {
        return this.LettersAndDigits;
    }

    public Random seededRandom() {
        return this.seededRandom;
    }

    public Random random() {
        return this.random;
    }

    public List<Object> choosePorts(int count) {
        IndexedSeq sockets = (IndexedSeq)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), count).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final ServerSocket apply(int i) {
                return new ServerSocket(0);
            }
        }, IndexedSeq$.MODULE$.canBuildFrom());
        List socketList = sockets.toList();
        List ports = (List)socketList.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(ServerSocket x$1) {
                return x$1.getLocalPort();
            }
        }, List$.MODULE$.canBuildFrom());
        socketList.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final void apply(ServerSocket x$2) {
                x$2.close();
            }
        }, List$.MODULE$.canBuildFrom());
        return ports;
    }

    public int choosePort() {
        return BoxesRunTime.unboxToInt((Object)this.choosePorts(1).head());
    }

    /*
     * WARNING - void declaration
     */
    public File tempDir() {
        void var1_1;
        File f = new File(this.IoTmpDir(), new StringBuilder().append((Object)"kafka-").append((Object)BoxesRunTime.boxToInteger((int)this.random().nextInt(1000000))).toString());
        f.mkdirs();
        f.deleteOnExit();
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public File tempRelativeDir(String parent) {
        void var2_2;
        File f = new File(parent, new StringBuilder().append((Object)"kafka-").append((Object)BoxesRunTime.boxToInteger((int)this.random().nextInt(1000000))).toString());
        f.mkdirs();
        f.deleteOnExit();
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public File tempFile() {
        void var1_1;
        File f = File.createTempFile("kafka", ".tmp");
        f.deleteOnExit();
        return var1_1;
    }

    public FileChannel tempChannel() {
        return new RandomAccessFile(this.tempFile(), "rw").getChannel();
    }

    /*
     * WARNING - void declaration
     */
    public KafkaServer createServer(KafkaConfig config, Time time) {
        void var3_3;
        KafkaServer server = new KafkaServer(config, time);
        server.startup();
        return var3_3;
    }

    public Time createServer$default$2() {
        return SystemTime$.MODULE$;
    }

    public List<Properties> createBrokerConfigs(int numConfigs) {
        return (List)((TraversableLike)this.choosePorts(numConfigs).zipWithIndex(List$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Object, Object> check$ifrefutable$1) {
                Tuple2<Object, Object> tuple2 = check$ifrefutable$1;
                boolean bl = tuple2 != null;
                return bl;
            }
        }).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Properties apply(Tuple2<Object, Object> x$3) {
                Tuple2<Object, Object> tuple2 = x$3;
                if (tuple2 != null) {
                    int port = tuple2._1$mcI$sp();
                    int node = tuple2._2$mcI$sp();
                    Properties properties = TestUtils$.MODULE$.createBrokerConfig(node, port);
                    return properties;
                }
                throw new MatchError(tuple2);
            }
        }, List$.MODULE$.canBuildFrom());
    }

    public String getBrokerListStrFromConfigs(Seq<KafkaConfig> configs) {
        return ((TraversableOnce)configs.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(KafkaConfig c) {
                return new StringBuilder().append((Object)c.hostName()).append((Object)":").append((Object)BoxesRunTime.boxToInteger((int)c.port())).toString();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(",");
    }

    /*
     * WARNING - void declaration
     */
    public Properties createBrokerConfig(int nodeId, int port) {
        void var3_3;
        Properties props = new Properties();
        ((Hashtable)props).put("broker.id", ((Object)BoxesRunTime.boxToInteger((int)nodeId)).toString());
        ((Hashtable)props).put("host.name", "localhost");
        ((Hashtable)props).put("port", ((Object)BoxesRunTime.boxToInteger((int)port)).toString());
        ((Hashtable)props).put("log.dir", this.tempDir().getAbsolutePath());
        ((Hashtable)props).put("zookeeper.connect", TestZKUtils$.MODULE$.zookeeperConnect());
        ((Hashtable)props).put("replica.socket.timeout.ms", "1500");
        return var3_3;
    }

    public int createBrokerConfig$default$2() {
        return this.choosePort();
    }

    public Properties createConsumerProperties(String zkConnect, String groupId, String consumerId, long consumerTimeout) {
        Properties props = new Properties();
        ((Hashtable)props).put("zookeeper.connect", zkConnect);
        ((Hashtable)props).put("group.id", groupId);
        ((Hashtable)props).put("consumer.id", consumerId);
        ((Hashtable)props).put("consumer.timeout.ms", ((Object)BoxesRunTime.boxToLong((long)consumerTimeout)).toString());
        ((Hashtable)props).put("zookeeper.session.timeout.ms", "400");
        ((Hashtable)props).put("zookeeper.sync.time.ms", "200");
        ((Hashtable)props).put("auto.commit.interval.ms", "1000");
        ((Hashtable)props).put("rebalance.max.retries", "4");
        ((Hashtable)props).put("auto.offset.reset", "smallest");
        ((Hashtable)props).put("num.consumer.fetchers", "2");
        return props;
    }

    public long createConsumerProperties$default$4() {
        return -1L;
    }

    public ByteBufferMessageSet singleMessageSet(byte[] payload, CompressionCodec codec, byte[] key) {
        return new ByteBufferMessageSet(codec, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Message[]{new Message(payload, key)}));
    }

    public CompressionCodec singleMessageSet$default$2() {
        return NoCompressionCodec$.MODULE$;
    }

    public byte[] singleMessageSet$default$3() {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public byte[] randomBytes(int numBytes) {
        void var2_2;
        byte[] bytes = new byte[numBytes];
        this.seededRandom().nextBytes(bytes);
        return var2_2;
    }

    public String randomString(int len) {
        StringBuilder b = new StringBuilder();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), len).foreach((Function1)new Serializable(b){
            public static final long serialVersionUID = 0L;
            private final StringBuilder b$1;

            public final StringBuilder apply(int i) {
                return this.b$1.append(TestUtils$.MODULE$.LettersAndDigits().charAt(TestUtils$.MODULE$.seededRandom().nextInt(TestUtils$.MODULE$.LettersAndDigits().length())));
            }
            {
                this.b$1 = b$1;
            }
        });
        return b.toString();
    }

    public void checkEquals(ByteBuffer b1, ByteBuffer b2) {
        Assert.assertEquals((String)"Buffers should have equal length", (int)(b1.limit() - b1.position()), (int)(b2.limit() - b2.position()));
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), b1.limit() - b1.position()).foreach$mVc$sp((Function1)new Serializable(b1, b2){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer b1$1;
            private final ByteBuffer b2$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                Assert.assertEquals((String)new StringBuilder().append((Object)"byte ").append((Object)BoxesRunTime.boxToInteger((int)i)).append((Object)" byte not equal.").toString(), (byte)this.b1$1.get(this.b1$1.position() + i), (byte)this.b2$1.get(this.b1$1.position() + i));
            }
            {
                this.b1$1 = b1$1;
                this.b2$1 = b2$1;
            }
        });
    }

    public <T> void checkEquals(Iterator<T> expected, Iterator<T> actual) {
        int length = 0;
        while (expected.hasNext() && actual.hasNext()) {
            ++length;
            Assert.assertEquals((Object)expected.next(), (Object)actual.next());
        }
        if (expected.hasNext()) {
            int length1 = length;
            while (expected.hasNext()) {
                expected.next();
                ++length1;
            }
            Assert.assertFalse((String)new StringBuilder().append((Object)"Iterators have uneven length-- first has more: ").append((Object)BoxesRunTime.boxToInteger((int)length1)).append((Object)" > ").append((Object)BoxesRunTime.boxToInteger((int)length)).toString(), (boolean)true);
        }
        if (actual.hasNext()) {
            int length2 = length;
            while (actual.hasNext()) {
                actual.next();
                ++length2;
            }
            Assert.assertFalse((String)new StringBuilder().append((Object)"Iterators have uneven length-- second has more: ").append((Object)BoxesRunTime.boxToInteger((int)length2)).append((Object)" > ").append((Object)BoxesRunTime.boxToInteger((int)length)).toString(), (boolean)true);
        }
    }

    public <T> void checkLength(Iterator<T> s1, int expectedLength) {
        int n = 0;
        while (s1.hasNext()) {
            ++n;
            s1.next();
        }
        Assert.assertEquals((int)expectedLength, (int)n);
    }

    public <T> void checkEquals(java.util.Iterator<T> s1, java.util.Iterator<T> s2) {
        while (s1.hasNext() && s2.hasNext()) {
            Assert.assertEquals(s1.next(), s2.next());
        }
        Assert.assertFalse((String)"Iterators have uneven length--first has more", (boolean)s1.hasNext());
        Assert.assertFalse((String)"Iterators have uneven length--second has more", (boolean)s2.hasNext());
    }

    public <T> Iterator<T> stackedIterator(Seq<Iterator<T>> s) {
        return new Iterator<T>(s){
            private Iterator<T> cur;
            private final Iterator<Iterator<T>> topIterator;

            public Iterator<T> seq() {
                return Iterator.class.seq((Iterator)this);
            }

            public boolean isEmpty() {
                return Iterator.class.isEmpty((Iterator)this);
            }

            public boolean isTraversableAgain() {
                return Iterator.class.isTraversableAgain((Iterator)this);
            }

            public boolean hasDefiniteSize() {
                return Iterator.class.hasDefiniteSize((Iterator)this);
            }

            public Iterator<T> take(int n) {
                return Iterator.class.take((Iterator)this, (int)n);
            }

            public Iterator<T> drop(int n) {
                return Iterator.class.drop((Iterator)this, (int)n);
            }

            public Iterator<T> slice(int from, int until) {
                return Iterator.class.slice((Iterator)this, (int)from, (int)until);
            }

            public <B> Iterator<B> map(Function1<T, B> f) {
                return Iterator.class.map((Iterator)this, f);
            }

            public <B> Iterator<B> $plus$plus(Function0<GenTraversableOnce<B>> that) {
                return Iterator.class.$plus$plus((Iterator)this, that);
            }

            public <B> Iterator<B> flatMap(Function1<T, GenTraversableOnce<B>> f) {
                return Iterator.class.flatMap((Iterator)this, f);
            }

            public Iterator<T> filter(Function1<T, Object> p) {
                return Iterator.class.filter((Iterator)this, p);
            }

            public <B> boolean corresponds(GenTraversableOnce<B> that, Function2<T, B, Object> p) {
                return Iterator.class.corresponds((Iterator)this, that, p);
            }

            public Iterator<T> withFilter(Function1<T, Object> p) {
                return Iterator.class.withFilter((Iterator)this, p);
            }

            public Iterator<T> filterNot(Function1<T, Object> p) {
                return Iterator.class.filterNot((Iterator)this, p);
            }

            public <B> Iterator<B> collect(PartialFunction<T, B> pf) {
                return Iterator.class.collect((Iterator)this, pf);
            }

            public <B> Iterator<B> scanLeft(B z, Function2<B, T, B> op) {
                return Iterator.class.scanLeft((Iterator)this, z, op);
            }

            public <B> Iterator<B> scanRight(B z, Function2<T, B, B> op) {
                return Iterator.class.scanRight((Iterator)this, z, op);
            }

            public Iterator<T> takeWhile(Function1<T, Object> p) {
                return Iterator.class.takeWhile((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> partition(Function1<T, Object> p) {
                return Iterator.class.partition((Iterator)this, p);
            }

            public Tuple2<Iterator<T>, Iterator<T>> span(Function1<T, Object> p) {
                return Iterator.class.span((Iterator)this, p);
            }

            public Iterator<T> dropWhile(Function1<T, Object> p) {
                return Iterator.class.dropWhile((Iterator)this, p);
            }

            public <B> Iterator<Tuple2<T, B>> zip(Iterator<B> that) {
                return Iterator.class.zip((Iterator)this, that);
            }

            public <A1> Iterator<A1> padTo(int len, A1 elem) {
                return Iterator.class.padTo((Iterator)this, (int)len, elem);
            }

            public Iterator<Tuple2<T, Object>> zipWithIndex() {
                return Iterator.class.zipWithIndex((Iterator)this);
            }

            public <B, A1, B1> Iterator<Tuple2<A1, B1>> zipAll(Iterator<B> that, A1 thisElem, B1 thatElem) {
                return Iterator.class.zipAll((Iterator)this, that, thisElem, thatElem);
            }

            public <U> void foreach(Function1<T, U> f) {
                Iterator.class.foreach((Iterator)this, f);
            }

            public boolean forall(Function1<T, Object> p) {
                return Iterator.class.forall((Iterator)this, p);
            }

            public boolean exists(Function1<T, Object> p) {
                return Iterator.class.exists((Iterator)this, p);
            }

            public boolean contains(Object elem) {
                return Iterator.class.contains((Iterator)this, (Object)elem);
            }

            public Option<T> find(Function1<T, Object> p) {
                return Iterator.class.find((Iterator)this, p);
            }

            public int indexWhere(Function1<T, Object> p) {
                return Iterator.class.indexWhere((Iterator)this, p);
            }

            public <B> int indexOf(B elem) {
                return Iterator.class.indexOf((Iterator)this, elem);
            }

            public BufferedIterator<T> buffered() {
                return Iterator.class.buffered((Iterator)this);
            }

            public <B> Iterator.GroupedIterator<B> grouped(int size) {
                return Iterator.class.grouped((Iterator)this, (int)size);
            }

            public <B> Iterator.GroupedIterator<B> sliding(int size, int step) {
                return Iterator.class.sliding((Iterator)this, (int)size, (int)step);
            }

            public int length() {
                return Iterator.class.length((Iterator)this);
            }

            public Tuple2<Iterator<T>, Iterator<T>> duplicate() {
                return Iterator.class.duplicate((Iterator)this);
            }

            public <B> Iterator<B> patch(int from, Iterator<B> patchElems, int replaced) {
                return Iterator.class.patch((Iterator)this, (int)from, patchElems, (int)replaced);
            }

            public <B> void copyToArray(Object xs, int start, int len) {
                Iterator.class.copyToArray((Iterator)this, (Object)xs, (int)start, (int)len);
            }

            public boolean sameElements(Iterator<?> that) {
                return Iterator.class.sameElements((Iterator)this, that);
            }

            public Traversable<T> toTraversable() {
                return Iterator.class.toTraversable((Iterator)this);
            }

            public Iterator<T> toIterator() {
                return Iterator.class.toIterator((Iterator)this);
            }

            public Stream<T> toStream() {
                return Iterator.class.toStream((Iterator)this);
            }

            public String toString() {
                return Iterator.class.toString((Iterator)this);
            }

            public <B> int sliding$default$2() {
                return Iterator.class.sliding$default$2((Iterator)this);
            }

            public List<T> reversed() {
                return TraversableOnce.class.reversed((TraversableOnce)this);
            }

            public int size() {
                return TraversableOnce.class.size((TraversableOnce)this);
            }

            public boolean nonEmpty() {
                return TraversableOnce.class.nonEmpty((TraversableOnce)this);
            }

            public int count(Function1<T, Object> p) {
                return TraversableOnce.class.count((TraversableOnce)this, p);
            }

            public <B> Option<B> collectFirst(PartialFunction<T, B> pf) {
                return TraversableOnce.class.collectFirst((TraversableOnce)this, pf);
            }

            public <B> B $div$colon(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.class.$div$colon((TraversableOnce)this, z, op);
            }

            public <B> B $colon$bslash(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.class.$colon$bslash((TraversableOnce)this, z, op);
            }

            public <B> B foldLeft(B z, Function2<B, T, B> op) {
                return (B)TraversableOnce.class.foldLeft((TraversableOnce)this, z, op);
            }

            public <B> B foldRight(B z, Function2<T, B, B> op) {
                return (B)TraversableOnce.class.foldRight((TraversableOnce)this, z, op);
            }

            public <B> B reduceLeft(Function2<B, T, B> op) {
                return (B)TraversableOnce.class.reduceLeft((TraversableOnce)this, op);
            }

            public <B> B reduceRight(Function2<T, B, B> op) {
                return (B)TraversableOnce.class.reduceRight((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceLeftOption(Function2<B, T, B> op) {
                return TraversableOnce.class.reduceLeftOption((TraversableOnce)this, op);
            }

            public <B> Option<B> reduceRightOption(Function2<T, B, B> op) {
                return TraversableOnce.class.reduceRightOption((TraversableOnce)this, op);
            }

            public <A1> A1 reduce(Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.reduce((TraversableOnce)this, op);
            }

            public <A1> Option<A1> reduceOption(Function2<A1, A1, A1> op) {
                return TraversableOnce.class.reduceOption((TraversableOnce)this, op);
            }

            public <A1> A1 fold(A1 z, Function2<A1, A1, A1> op) {
                return (A1)TraversableOnce.class.fold((TraversableOnce)this, z, op);
            }

            public <B> B aggregate(B z, Function2<B, T, B> seqop, Function2<B, B, B> combop) {
                return (B)TraversableOnce.class.aggregate((TraversableOnce)this, z, seqop, combop);
            }

            public <B> B sum(Numeric<B> num) {
                return (B)TraversableOnce.class.sum((TraversableOnce)this, num);
            }

            public <B> B product(Numeric<B> num) {
                return (B)TraversableOnce.class.product((TraversableOnce)this, num);
            }

            public <B> T min(Ordering<B> cmp) {
                return (T)TraversableOnce.class.min((TraversableOnce)this, cmp);
            }

            public <B> T max(Ordering<B> cmp) {
                return (T)TraversableOnce.class.max((TraversableOnce)this, cmp);
            }

            public <B> T maxBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.class.maxBy((TraversableOnce)this, f, cmp);
            }

            public <B> T minBy(Function1<T, B> f, Ordering<B> cmp) {
                return (T)TraversableOnce.class.minBy((TraversableOnce)this, f, cmp);
            }

            public <B> void copyToBuffer(Buffer<B> dest) {
                TraversableOnce.class.copyToBuffer((TraversableOnce)this, dest);
            }

            public <B> void copyToArray(Object xs, int start) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs, (int)start);
            }

            public <B> void copyToArray(Object xs) {
                TraversableOnce.class.copyToArray((TraversableOnce)this, (Object)xs);
            }

            public <B> Object toArray(ClassTag<B> evidence$1) {
                return TraversableOnce.class.toArray((TraversableOnce)this, evidence$1);
            }

            public List<T> toList() {
                return TraversableOnce.class.toList((TraversableOnce)this);
            }

            public Iterable<T> toIterable() {
                return TraversableOnce.class.toIterable((TraversableOnce)this);
            }

            public Seq<T> toSeq() {
                return TraversableOnce.class.toSeq((TraversableOnce)this);
            }

            public IndexedSeq<T> toIndexedSeq() {
                return TraversableOnce.class.toIndexedSeq((TraversableOnce)this);
            }

            public <B> Buffer<B> toBuffer() {
                return TraversableOnce.class.toBuffer((TraversableOnce)this);
            }

            public <B> Set<B> toSet() {
                return TraversableOnce.class.toSet((TraversableOnce)this);
            }

            public Vector<T> toVector() {
                return TraversableOnce.class.toVector((TraversableOnce)this);
            }

            public <Col> Col to(CanBuildFrom<Nothing$, T, Col> cbf) {
                return (Col)TraversableOnce.class.to((TraversableOnce)this, cbf);
            }

            public <T, U> scala.collection.immutable.Map<T, U> toMap(Predef.$less$colon$less<T, Tuple2<T, U>> ev) {
                return TraversableOnce.class.toMap((TraversableOnce)this, ev);
            }

            public String mkString(String start, String sep, String end) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)start, (String)sep, (String)end);
            }

            public String mkString(String sep) {
                return TraversableOnce.class.mkString((TraversableOnce)this, (String)sep);
            }

            public String mkString() {
                return TraversableOnce.class.mkString((TraversableOnce)this);
            }

            public StringBuilder addString(StringBuilder b, String start, String sep, String end) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)start, (String)sep, (String)end);
            }

            public StringBuilder addString(StringBuilder b, String sep) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b, (String)sep);
            }

            public StringBuilder addString(StringBuilder b) {
                return TraversableOnce.class.addString((TraversableOnce)this, (StringBuilder)b);
            }

            public <A1> A1 $div$colon$bslash(A1 z, Function2<A1, A1, A1> op) {
                return (A1)GenTraversableOnce.class.$div$colon$bslash((GenTraversableOnce)this, z, op);
            }

            private Iterator<T> cur() {
                return this.cur;
            }

            private void cur_$eq(Iterator<T> x$1) {
                this.cur = x$1;
            }

            private Iterator<Iterator<T>> topIterator() {
                return this.topIterator;
            }

            public boolean hasNext() {
                while (true) {
                    if (this.cur() == null) {
                        if (this.topIterator().hasNext()) {
                            this.cur_$eq((Iterator)this.topIterator().next());
                        } else {
                            return false;
                        }
                    }
                    if (this.cur().hasNext()) {
                        return true;
                    }
                    this.cur_$eq(null);
                }
            }

            public T next() {
                return (T)this.cur().next();
            }
            {
                GenTraversableOnce.class.$init$((GenTraversableOnce)this);
                TraversableOnce.class.$init$((TraversableOnce)this);
                Iterator.class.$init$((Iterator)this);
                this.cur = null;
                this.topIterator = s$1.iterator();
            }
        };
    }

    public String hexString(byte[] bytes) {
        return this.hexString(ByteBuffer.wrap(bytes));
    }

    public String hexString(ByteBuffer buffer) {
        StringBuilder builder = new StringBuilder("0x");
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), buffer.limit()).foreach((Function1)new Serializable(buffer, builder){
            public static final long serialVersionUID = 0L;
            private final ByteBuffer buffer$1;
            private final StringBuilder builder$1;

            public final StringBuilder apply(int i) {
                return this.builder$1.append(String.format("%x", this.buffer$1.get(this.buffer$1.position() + i)));
            }
            {
                this.buffer$1 = buffer$1;
                this.builder$1 = builder$1;
            }
        });
        return builder.toString();
    }

    public <K, V> Producer<K, V> createProducer(String brokerList, Encoder<V> encoder, Encoder<K> keyEncoder) {
        Properties props = new Properties();
        ((Hashtable)props).put("metadata.broker.list", brokerList);
        ((Hashtable)props).put("send.buffer.bytes", "65536");
        ((Hashtable)props).put("connect.timeout.ms", "100000");
        ((Hashtable)props).put("reconnect.interval", "10000");
        ((Hashtable)props).put("serializer.class", encoder.getClass().getCanonicalName());
        ((Hashtable)props).put("key.serializer.class", keyEncoder.getClass().getCanonicalName());
        return new Producer(new ProducerConfig(props));
    }

    public <K, V> DefaultEncoder createProducer$default$2() {
        return new DefaultEncoder(DefaultEncoder$.MODULE$.$lessinit$greater$default$1());
    }

    public <K, V> DefaultEncoder createProducer$default$3() {
        return new DefaultEncoder(DefaultEncoder$.MODULE$.$lessinit$greater$default$1());
    }

    /*
     * WARNING - void declaration
     */
    public Properties getProducerConfig(String brokerList, String partitioner) {
        void var3_3;
        Properties props = new Properties();
        ((Hashtable)props).put("metadata.broker.list", brokerList);
        ((Hashtable)props).put("partitioner.class", partitioner);
        ((Hashtable)props).put("message.send.max.retries", "3");
        ((Hashtable)props).put("retry.backoff.ms", "1000");
        ((Hashtable)props).put("request.timeout.ms", "500");
        ((Hashtable)props).put("request.required.acks", "-1");
        ((Hashtable)props).put("serializer.class", StringEncoder.class.getName().toString());
        return var3_3;
    }

    public String getProducerConfig$default$2() {
        return "kafka.producer.DefaultPartitioner";
    }

    /*
     * WARNING - void declaration
     */
    public Properties getSyncProducerConfig(int port) {
        void var2_2;
        Properties props = new Properties();
        ((Hashtable)props).put("host", "localhost");
        ((Hashtable)props).put("port", ((Object)BoxesRunTime.boxToInteger((int)port)).toString());
        ((Hashtable)props).put("request.timeout.ms", "500");
        ((Hashtable)props).put("request.required.acks", "1");
        ((Hashtable)props).put("serializer.class", StringEncoder.class.getName().toString());
        return var2_2;
    }

    public void updateConsumerOffset(ConsumerConfig config, String path, long offset) {
        ZkClient zkClient = new ZkClient(config.zkConnect(), config.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), (ZkSerializer)ZKStringSerializer$.MODULE$);
        ZkUtils$.MODULE$.updatePersistentPath(zkClient, path, ((Object)BoxesRunTime.boxToLong((long)offset)).toString());
    }

    public Iterator<Message> getMessageIterator(Iterator<MessageAndOffset> iter) {
        return new IteratorTemplate<Message>(iter){
            private final Iterator iter$1;

            public Message makeNext() {
                if (this.iter$1.hasNext()) {
                    return ((MessageAndOffset)this.iter$1.next()).message();
                }
                return (Message)this.allDone();
            }
            {
                this.iter$1 = iter$1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Broker> createBrokersInZk(ZkClient zkClient, Seq<Object> ids) {
        void var3_3;
        Seq brokers = (Seq)ids.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Broker apply(int id) {
                return new Broker(id, "localhost", 6667);
            }
        }, Seq$.MODULE$.canBuildFrom());
        brokers.foreach((Function1)new Serializable(zkClient){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$1;

            public final void apply(Broker b) {
                ZkUtils$.MODULE$.registerBrokerInZk(this.zkClient$1, b.id(), b.host(), b.port(), 6000, -1);
            }
            {
                this.zkClient$1 = zkClient$1;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<Broker> deleteBrokersInZk(ZkClient zkClient, Seq<Object> ids) {
        void var3_3;
        Seq brokers = (Seq)ids.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Broker apply(int id) {
                return new Broker(id, "localhost", 6667);
            }
        }, Seq$.MODULE$.canBuildFrom());
        brokers.foreach((Function1)new Serializable(zkClient){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$3;

            public final boolean apply(Broker b) {
                return ZkUtils$.MODULE$.deletePath(this.zkClient$3, new StringBuilder().append((Object)ZkUtils$.MODULE$.BrokerIdsPath()).append((Object)"/").append((Object)b).toString());
            }
            {
                this.zkClient$3 = zkClient$3;
            }
        });
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public Seq<String> getMsgStrings(int n) {
        void var2_2;
        ListBuffer buffer = new ListBuffer();
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).foreach((Function1)new Serializable(buffer){
            public static final long serialVersionUID = 0L;
            private final ListBuffer buffer$2;

            public final ListBuffer<String> apply(int i) {
                return this.buffer$2.$plus$eq((Object)new StringBuilder().append((Object)"msg").append((Object)BoxesRunTime.boxToInteger((int)i)).toString());
            }
            {
                this.buffer$2 = buffer$2;
            }
        });
        return var2_2;
    }

    public ProducerRequest produceRequest(String topic, int partition, ByteBufferMessageSet message, int acks, int timeout, int correlationId, String clientId) {
        return this.produceRequestWithAcks((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic}))), (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{partition}))), message, acks, timeout, correlationId, clientId);
    }

    public int produceRequest$default$4() {
        return SyncProducerConfig$.MODULE$.DefaultRequiredAcks();
    }

    public int produceRequest$default$5() {
        return SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs();
    }

    public int produceRequest$default$6() {
        return 0;
    }

    public String produceRequest$default$7() {
        return SyncProducerConfig$.MODULE$.DefaultClientId();
    }

    public ProducerRequest produceRequestWithAcks(Seq<String> topics, Seq<Object> partitions, ByteBufferMessageSet message, int acks, int timeout, int correlationId, String clientId) {
        Seq data = (Seq)topics.flatMap((Function1)new Serializable(partitions, message){
            public static final long serialVersionUID = 0L;
            private final Seq partitions$1;
            public final ByteBufferMessageSet message$1;

            public final Seq<Tuple2<TopicAndPartition, ByteBufferMessageSet>> apply(String topic) {
                return (Seq)this.partitions$1.map((Function1)new Serializable(this, topic){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.5 $outer;
                    private final String topic$4;

                    public final Tuple2<TopicAndPartition, ByteBufferMessageSet> apply(int partition) {
                        return new Tuple2((Object)new TopicAndPartition(this.topic$4, partition), (Object)this.$outer.message$1);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.topic$4 = topic$4;
                    }
                }, Seq$.MODULE$.canBuildFrom());
            }
            {
                this.partitions$1 = partitions$1;
                this.message$1 = message$1;
            }
        }, Seq$.MODULE$.canBuildFrom());
        return new ProducerRequest(correlationId, clientId, (short)acks, timeout, (Map)Map$.MODULE$.apply(data));
    }

    public int produceRequestWithAcks$default$4() {
        return SyncProducerConfig$.MODULE$.DefaultRequiredAcks();
    }

    public int produceRequestWithAcks$default$5() {
        return SyncProducerConfig$.MODULE$.DefaultAckTimeoutMs();
    }

    public int produceRequestWithAcks$default$6() {
        return 0;
    }

    public String produceRequestWithAcks$default$7() {
        return SyncProducerConfig$.MODULE$.DefaultClientId();
    }

    public void makeLeaderForPartition(ZkClient zkClient, String topic, scala.collection.immutable.Map<Object, Object> leaderPerPartitionMap, int controllerEpoch) {
        leaderPerPartitionMap.foreach((Function1)new Serializable(zkClient, topic, controllerEpoch){
            public static final long serialVersionUID = 0L;
            private final ZkClient zkClient$2;
            public final String topic$3;
            private final int controllerEpoch$1;

            public final void apply(Tuple2<Object, Object> leaderForPartition) {
                int partition = leaderForPartition._1$mcI$sp();
                int leader = leaderForPartition._2$mcI$sp();
                try {
                    Option currentLeaderAndIsrOpt = ZkUtils$.MODULE$.getLeaderAndIsrForPartition(this.zkClient$2, this.topic$3, partition);
                    LeaderAndIsr newLeaderAndIsr = null;
                    Option option = currentLeaderAndIsrOpt;
                    None$ none$ = None$.MODULE$;
                    if (!(option != null ? !option.equals(none$) : none$ != null)) {
                        newLeaderAndIsr = new LeaderAndIsr(leader, List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{leader})));
                    } else {
                        newLeaderAndIsr = (LeaderAndIsr)currentLeaderAndIsrOpt.get();
                        newLeaderAndIsr.leader_$eq(leader);
                        LeaderAndIsr leaderAndIsr = newLeaderAndIsr;
                        leaderAndIsr.leaderEpoch_$eq(leaderAndIsr.leaderEpoch() + 1);
                        LeaderAndIsr leaderAndIsr2 = newLeaderAndIsr;
                        leaderAndIsr2.zkVersion_$eq(leaderAndIsr2.zkVersion() + 1);
                    }
                    ZkUtils$.MODULE$.updatePersistentPath(this.zkClient$2, ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(this.topic$3, partition), ZkUtils$.MODULE$.leaderAndIsrZkData(newLeaderAndIsr, this.controllerEpoch$1));
                }
                catch (Throwable throwable) {
                    TestUtils$.MODULE$.error((Function0)new Serializable(this, partition){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ anonfun.makeLeaderForPartition.1 $outer;
                        private final int partition$3;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Error while electing leader for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.topic$3, BoxesRunTime.boxToInteger((int)this.partition$3)}));
                        }
                        {
                            if ($outer == null) {
                                throw new NullPointerException();
                            }
                            this.$outer = $outer;
                            this.partition$3 = partition$3;
                        }
                    }, (Function0)new Serializable(this, throwable){
                        public static final long serialVersionUID = 0L;
                        private final Throwable oe$1;

                        public final Throwable apply() {
                            return this.oe$1;
                        }
                        {
                            this.oe$1 = oe$1;
                        }
                    });
                }
            }
            {
                this.zkClient$2 = zkClient$2;
                this.topic$3 = topic$3;
                this.controllerEpoch$1 = controllerEpoch$1;
            }
        });
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged(ZkClient zkClient, String topic, int partition, long timeoutMs, Option<Object> oldLeaderOpt) {
        ReentrantLock leaderLock = new ReentrantLock();
        Condition leaderExistsOrChanged = leaderLock.newCondition();
        Option<Object> option = oldLeaderOpt;
        None$ none$ = None$.MODULE$;
        if (!(option != null ? !option.equals((Object)none$) : none$ != null)) {
            this.info((Function0)new Serializable(topic, partition){
                public static final long serialVersionUID = 0L;
                private final String topic$1;
                private final int partition$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Waiting for leader to be elected for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1)}));
                }
                {
                    this.topic$1 = topic$1;
                    this.partition$1 = partition$1;
                }
            });
        } else {
            this.info((Function0)new Serializable(topic, partition, oldLeaderOpt){
                public static final long serialVersionUID = 0L;
                private final String topic$1;
                private final int partition$1;
                private final Option oldLeaderOpt$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Waiting for leader for partition [%s,%d] to be changed from old leader %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1), this.oldLeaderOpt$1.get()}));
                }
                {
                    this.topic$1 = topic$1;
                    this.partition$1 = partition$1;
                    this.oldLeaderOpt$1 = oldLeaderOpt$1;
                }
            });
        }
        leaderLock.lock();
        try {
            Option option2;
            block13: {
                Option leader;
                block12: {
                    block11: {
                        BoxedUnit boxedUnit;
                        zkClient.subscribeDataChanges(ZkUtils$.MODULE$.getTopicPartitionLeaderAndIsrPath(topic, partition), (IZkDataListener)new LeaderExistsOrChangedListener(topic, partition, leaderLock, leaderExistsOrChanged, oldLeaderOpt, zkClient));
                        leaderExistsOrChanged.await(timeoutMs, TimeUnit.MILLISECONDS);
                        option2 = leader = ZkUtils$.MODULE$.getLeaderForPartition(zkClient, topic, partition);
                        if (!(option2 instanceof Some)) break block11;
                        Some some = (Some)option2;
                        int l = BoxesRunTime.unboxToInt((Object)some.x());
                        Option<Object> option3 = oldLeaderOpt;
                        None$ none$2 = None$.MODULE$;
                        if (!(option3 != null ? !option3.equals((Object)none$2) : none$2 != null)) {
                            this.info((Function0)new Serializable(topic, partition, l){
                                public static final long serialVersionUID = 0L;
                                private final String topic$1;
                                private final int partition$1;
                                private final int l$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Leader %d is elected for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.l$1), this.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1)}));
                                }
                                {
                                    this.topic$1 = topic$1;
                                    this.partition$1 = partition$1;
                                    this.l$1 = l$1;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        } else {
                            this.info((Function0)new Serializable(topic, partition, oldLeaderOpt, l){
                                public static final long serialVersionUID = 0L;
                                private final String topic$1;
                                private final int partition$1;
                                private final Option oldLeaderOpt$1;
                                private final int l$1;

                                public final String apply() {
                                    return new StringOps(Predef$.MODULE$.augmentString("Leader for partition [%s,%d] is changed from %d to %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1), this.oldLeaderOpt$1.get(), BoxesRunTime.boxToInteger((int)this.l$1)}));
                                }
                                {
                                    this.topic$1 = topic$1;
                                    this.partition$1 = partition$1;
                                    this.oldLeaderOpt$1 = oldLeaderOpt$1;
                                    this.l$1 = l$1;
                                }
                            });
                            boxedUnit = BoxedUnit.UNIT;
                        }
                        BoxedUnit boxedUnit2 = boxedUnit;
                        break block12;
                    }
                    None$ none$3 = None$.MODULE$;
                    Option option4 = option2;
                    if (none$3 != null ? !none$3.equals(option4) : option4 != null) break block13;
                    this.error((Function0)new Serializable(topic, partition, timeoutMs){
                        public static final long serialVersionUID = 0L;
                        private final String topic$1;
                        private final int partition$1;
                        private final long timeoutMs$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Timing out after %d ms since leader is not elected for partition [%s,%d]")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)this.timeoutMs$1), this.topic$1, BoxesRunTime.boxToInteger((int)this.partition$1)}));
                        }
                        {
                            this.topic$1 = topic$1;
                            this.partition$1 = partition$1;
                            this.timeoutMs$1 = timeoutMs$1;
                        }
                    });
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                return leader;
            }
            throw new MatchError((Object)option2);
        }
        finally {
            leaderLock.unlock();
        }
    }

    public Option<Object> waitUntilLeaderIsElectedOrChanged$default$5() {
        return None$.MODULE$;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void retry(long maxWaitMs, Function0<BoxedUnit> block) {
        LongRef wait = new LongRef(1L);
        long startTime = System.currentTimeMillis();
        {
            block.apply$mcV$sp();
            return;
        }
    }

    public boolean waitUntilTrue(Function0<Object> condition, long waitTime) {
        long startTime = System.currentTimeMillis();
        while (!condition.apply$mcZ$sp()) {
            if (System.currentTimeMillis() > startTime + waitTime) {
                return false;
            }
            Thread.sleep(BoxesRunTime.unboxToLong((Object)new RichLong(Predef$.MODULE$.longWrapper(waitTime)).min((Object)BoxesRunTime.boxToLong((long)100L))));
        }
        return true;
    }

    public boolean isLeaderLocalOnBroker(String topic, int partitionId, KafkaServer server) {
        Option option;
        block4: {
            Option option2;
            block7: {
                boolean bl;
                block3: {
                    boolean bl2;
                    block6: {
                        block5: {
                            Option replicaOpt;
                            block2: {
                                Option partitionOpt;
                                option = partitionOpt = server.replicaManager().getPartition(topic, partitionId);
                                None$ none$ = None$.MODULE$;
                                Option option3 = option;
                                if (none$ != null ? !none$.equals(option3) : option3 != null) break block2;
                                bl = false;
                                break block3;
                            }
                            if (!(option instanceof Some)) break block4;
                            Some some = (Some)option;
                            Partition partition = (Partition)some.x();
                            option2 = replicaOpt = partition.leaderReplicaIfLocal();
                            None$ none$ = None$.MODULE$;
                            Option option4 = option2;
                            if (none$ != null ? !none$.equals(option4) : option4 != null) break block5;
                            bl2 = false;
                            break block6;
                        }
                        if (!(option2 instanceof Some)) break block7;
                        bl2 = true;
                    }
                    bl = bl2;
                }
                return bl;
            }
            throw new MatchError((Object)option2);
        }
        throw new MatchError((Object)option);
    }

    /*
     * WARNING - void declaration
     */
    public ByteBuffer createRequestByteBuffer(RequestOrResponse request) {
        void var2_2;
        ByteBuffer byteBuffer = ByteBuffer.allocate(request.sizeInBytes() + 2);
        byteBuffer.putShort(BoxesRunTime.unboxToShort((Object)request.requestId().get()));
        request.writeTo(byteBuffer);
        ((java.nio.Buffer)byteBuffer).rewind();
        return var2_2;
    }

    public void waitUntilMetadataIsPropagated(Seq<KafkaServer> servers, String topic, int partition, long timeout) {
        Assert.assertTrue((String)new StringOps(Predef$.MODULE$.augmentString("Partition [%s,%d] metadata not propagated after timeout")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partition)})), (boolean)this.waitUntilTrue((Function0<Object>)new Serializable(servers, topic, partition){
            public static final long serialVersionUID = 0L;
            private final Seq servers$1;
            public final String topic$2;
            public final int partition$2;

            public final boolean apply() {
                return this.apply$mcZ$sp();
            }

            public boolean apply$mcZ$sp() {
                return BoxesRunTime.unboxToBoolean((Object)this.servers$1.foldLeft((Object)BoxesRunTime.boxToBoolean((boolean)true), (Function2)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.waitUntilMetadataIsPropagated.1 $outer;

                    public final boolean apply(boolean x$4, KafkaServer x$5) {
                        return x$4 && x$5.apis().metadataCache().containsTopicAndPartition(this.$outer.topic$2, this.$outer.partition$2);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                }));
            }
            {
                this.servers$1 = servers$1;
                this.topic$2 = topic$2;
                this.partition$2 = partition$2;
            }
        }, timeout));
    }

    public void writeNonsenseToFile(File fileName, long position, int size) {
        RandomAccessFile file = new RandomAccessFile(fileName, "rw");
        file.seek(position);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final RandomAccessFile file$1;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.file$1.writeByte(TestUtils$.MODULE$.random().nextInt(255));
            }
            {
                this.file$1 = file$1;
            }
        });
        file.close();
    }

    public void appendNonsenseToFile(File fileName, int size) {
        FileOutputStream file = new FileOutputStream(fileName, true);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), size).foreach$mVc$sp((Function1)new Serializable(file){
            public static final long serialVersionUID = 0L;
            private final FileOutputStream file$2;

            public final void apply(int i) {
                this.apply$mcVI$sp(i);
            }

            public void apply$mcVI$sp(int i) {
                this.file$2.write(TestUtils$.MODULE$.random().nextInt(255));
            }
            {
                this.file$2 = file$2;
            }
        });
        file.close();
    }

    public void checkForPhantomInSyncReplicas(ZkClient zkClient, String topic, int partitionToBeReassigned, Seq<Object> assignedReplicas) {
        Seq inSyncReplicas = ZkUtils$.MODULE$.getInSyncReplicasForPartition(zkClient, topic, partitionToBeReassigned);
        Set phantomInSyncReplicas = (Set)inSyncReplicas.toSet().$minus$minus((GenTraversableOnce)assignedReplicas.toSet());
        Assert.assertTrue((String)new StringOps(Predef$.MODULE$.augmentString("All in sync replicas %s must be in the assigned replica list %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{inSyncReplicas, assignedReplicas})), (phantomInSyncReplicas.size() == 0 ? 1 : 0) != 0);
    }

    public void ensureNoUnderReplicatedPartitions(ZkClient zkClient, String topic, int partitionToBeReassigned, Seq<Object> assignedReplicas, Seq<KafkaServer> servers) {
        Seq inSyncReplicas = ZkUtils$.MODULE$.getInSyncReplicasForPartition(zkClient, topic, partitionToBeReassigned);
        Assert.assertFalse((String)new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is underreplicated")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned)})), (inSyncReplicas.size() < assignedReplicas.size() ? 1 : 0) != 0);
        Option leader = ZkUtils$.MODULE$.getLeaderForPartition(zkClient, topic, partitionToBeReassigned);
        Assert.assertTrue((String)new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is unavailable")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned)})), (boolean)leader.isDefined());
        KafkaServer leaderBroker = (KafkaServer)((IterableLike)servers.filter((Function1)new Serializable(leader){
            public static final long serialVersionUID = 0L;
            private final Option leader$1;

            public final boolean apply(KafkaServer s) {
                return s.config().brokerId() == BoxesRunTime.unboxToInt((Object)this.leader$1.get());
            }
            {
                this.leader$1 = leader$1;
            }
        })).head();
        Assert.assertTrue((String)new StringOps(Predef$.MODULE$.augmentString("Reassigned partition [%s,%d] is underreplicated as reported by the leader %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{topic, BoxesRunTime.boxToInteger((int)partitionToBeReassigned), leader.get()})), (leaderBroker.replicaManager().underReplicatedPartitionCount() == 0 ? 1 : 0) != 0);
    }

    public boolean checkIfReassignPartitionPathExists(ZkClient zkClient) {
        return ZkUtils$.MODULE$.pathExists(zkClient, ZkUtils$.MODULE$.ReassignPartitionsPath());
    }

    private TestUtils$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
        this.IoTmpDir = System.getProperty("java.io.tmpdir");
        this.Letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz";
        this.Digits = "0123456789";
        this.LettersAndDigits = new StringBuilder().append((Object)this.Letters()).append((Object)this.Digits()).toString();
        this.seededRandom = new Random(192348092834L);
        this.random = new Random();
    }
}

