/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junit4;

import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.surefire.junit4.JUnit4StackTraceWriter;
import org.apache.maven.surefire.report.DefaultReportEntry;
import org.apache.maven.surefire.report.ReportEntry;
import org.apache.maven.surefire.report.ReporterManager;
import org.apache.maven.surefire.report.StackTraceWriter;
import org.junit.runner.Description;
import org.junit.runner.Result;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunListener;

public class JUnit4TestSetReporter
extends RunListener {
    private static ResourceBundle bundle = ResourceBundle.getBundle("org.apache.maven.surefire.surefire");
    private Class testSet;
    private ReporterManager reportMgr;
    private boolean failureFlag;

    JUnit4TestSetReporter(Class testClass, ReporterManager reportManager) {
        this.testSet = testClass;
        this.reportMgr = reportManager;
    }

    public void testRunStarted(Description description) throws Exception {
        String rawString = bundle.getString("testSetStarting");
        DefaultReportEntry report = new DefaultReportEntry(this.testSet.getName(), this.testSet.getName(), rawString);
        this.reportMgr.testSetStarting((ReportEntry)report);
    }

    public void testRunFinished(Result result) throws Exception {
        String rawString = bundle.getString("testSetCompletedNormally");
        DefaultReportEntry report = new DefaultReportEntry(this.testSet.getName(), this.testSet.getName(), rawString);
        this.reportMgr.testSetCompleted((ReportEntry)report);
        this.reportMgr.reset();
    }

    public void testIgnored(Description description) throws Exception {
        String rawString = bundle.getString("testSkipped");
        DefaultReportEntry report = new DefaultReportEntry(this.extractClassName(description), description.getDisplayName(), rawString);
        this.reportMgr.testSkipped((ReportEntry)report);
    }

    public void testStarted(Description description) throws Exception {
        String rawString = bundle.getString("testStarting");
        DefaultReportEntry report = new DefaultReportEntry(this.extractClassName(description), description.getDisplayName(), rawString);
        this.reportMgr.testStarting((ReportEntry)report);
        this.failureFlag = false;
    }

    public void testFailure(Failure failure) throws Exception {
        String rawString = bundle.getString("executeException");
        DefaultReportEntry report = new DefaultReportEntry(this.extractClassName(failure.getDescription()), failure.getTestHeader(), rawString, (StackTraceWriter)new JUnit4StackTraceWriter(failure));
        if (failure.getException() instanceof AssertionError) {
            this.reportMgr.testFailed((ReportEntry)report);
        } else {
            this.reportMgr.testError((ReportEntry)report);
        }
        this.failureFlag = true;
    }

    public void testFinished(Description description) throws Exception {
        if (!this.failureFlag) {
            String rawString = bundle.getString("testSuccessful");
            DefaultReportEntry report = new DefaultReportEntry(this.extractClassName(description), description.getDisplayName(), rawString);
            this.reportMgr.testSucceeded((ReportEntry)report);
        }
    }

    private String extractClassName(Description description) {
        String displayName = description.getDisplayName();
        Pattern PARENS = Pattern.compile("^[^\\(\\)]+\\(([^\\\\(\\\\)]+)\\)$");
        Matcher m = PARENS.matcher(displayName);
        if (!m.find()) {
            return displayName;
        }
        return m.group(1);
    }

    public void setTestSet(Class testSet) {
        this.testSet = testSet;
    }

    public void setReportMgr(ReporterManager reportMgr) {
        this.reportMgr = reportMgr;
    }
}

