/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.wagon.providers.webdav;

import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.MkColMethod;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.maven.wagon.PathUtils;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.providers.webdav.AbstractHttpClientWagon;
import org.apache.maven.wagon.providers.webdav.PathNavigator;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDavWagon
extends AbstractHttpClientWagon {
    protected static final String CONTINUE_ON_FAILURE_PROPERTY = "wagon.webdav.continueOnFailure";
    private final boolean continueOnFailure = Boolean.getBoolean("wagon.webdav.continueOnFailure");
    private static final String[][] PROTOCOL_MAP = new String[][]{{"dav:http://", "http://"}, {"dav:https://", "https://"}, {"dav+http://", "http://"}, {"dav+https://", "https://"}, {"dav://", "http://"}, {"davs://", "https://"}};

    public boolean supportsDirectoryCopy() {
        return true;
    }

    @Override
    protected void mkdirs(String dir) throws IOException {
        String url;
        Repository repository = this.getRepository();
        String basedir = repository.getBasedir();
        String baseUrl = repository.getProtocol() + "://" + repository.getHost();
        if (repository.getPort() != -1) {
            baseUrl = baseUrl + ":" + repository.getPort();
        }
        String relpath = FileUtils.normalize((String)(WebDavWagon.getPath((String)basedir, (String)dir) + "/"));
        PathNavigator navigator = new PathNavigator(relpath);
        int status = -1;
        while ((status = this.doMkCol(url = baseUrl + "/" + navigator.getPath())) != 200 && status != 201 && status != 405 && navigator.backward()) {
        }
        while (navigator.forward()) {
            url = baseUrl + "/" + navigator.getPath();
            status = this.doMkCol(url);
            if (status == 200 || status == 201) continue;
            throw new IOException("Unable to create collection: " + url + "; status code = " + status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int doMkCol(String url) throws IOException {
        MkColMethod method = null;
        try {
            method = new MkColMethod(url);
            int n = this.execute((HttpMethod)method);
            return n;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public void putDirectory(File sourceDirectory, String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        for (File file : sourceDirectory.listFiles()) {
            if (file.isDirectory()) {
                this.putDirectory(file, destinationDirectory + "/" + file.getName());
                continue;
            }
            String target = destinationDirectory + "/" + file.getName();
            this.put(file, target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDirectory(String url) throws IOException, DavException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(DavPropertyName.create((String)"resourcetype"));
        PropFindMethod method = null;
        try {
            MultiStatus multiStatus;
            MultiStatusResponse response;
            DavPropertySet propertySet;
            DavProperty property;
            method = new PropFindMethod(url, nameSet, 0);
            this.execute((HttpMethod)method);
            if (method.succeeded() && (property = (propertySet = (response = (multiStatus = method.getResponseBodyAsMultiStatus()).getResponses()[0]).getProperties(200)).get("resourcetype")) != null) {
                Node node = (Node)property.getValue();
                boolean bl = node.getLocalName().equals("collection");
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public List<String> getFileList(String destinationDirectory) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        String repositoryUrl = this.repository.getUrl();
        String url = repositoryUrl + (repositoryUrl.endsWith("/") ? "" : "/") + destinationDirectory;
        PropFindMethod method = null;
        try {
            if (this.isDirectory(url)) {
                DavPropertyNameSet nameSet = new DavPropertyNameSet();
                nameSet.add(DavPropertyName.create((String)"displayname"));
                method = new PropFindMethod(url, nameSet, 1);
                int status = this.execute((HttpMethod)method);
                if (method.succeeded()) {
                    ArrayList<String> dirs = new ArrayList<String>();
                    MultiStatus multiStatus = method.getResponseBodyAsMultiStatus();
                    for (int i = 0; i < multiStatus.getResponses().length; ++i) {
                        MultiStatusResponse response = multiStatus.getResponses()[i];
                        String entryUrl = response.getHref();
                        String fileName = PathUtils.filename((String)URLDecoder.decode(entryUrl));
                        if (entryUrl.endsWith("/")) {
                            if (i == 0) continue;
                            fileName = PathUtils.filename((String)PathUtils.dirname((String)URLDecoder.decode(entryUrl))) + "/";
                        }
                        if (StringUtils.isEmpty((String)fileName)) continue;
                        dirs.add(fileName);
                    }
                    ArrayList<String> arrayList = dirs;
                    return arrayList;
                }
                if (status == 404) {
                    throw new ResourceDoesNotExistException("Destination directory does not exist: " + url);
                }
            }
        }
        catch (DavException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new TransferFailedException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
        throw new ResourceDoesNotExistException("Destination path exists but is not a WebDAV collection (directory): " + url);
    }

    @Override
    public String getURL(Repository repository) {
        String url = repository.getUrl();
        for (String[] entry : PROTOCOL_MAP) {
            String protocol = entry[0];
            if (!url.startsWith(protocol)) continue;
            return entry[1] + url.substring(protocol.length());
        }
        return url;
    }

    @Override
    public void put(File source, String resourceName) throws TransferFailedException, ResourceDoesNotExistException, AuthorizationException {
        try {
            super.put(source, resourceName);
        }
        catch (TransferFailedException e) {
            if (this.continueOnFailure) {
                System.out.println("WARN: Skip unable to transfer '" + resourceName + "' from '" + source.getPath() + "' due to " + e.getMessage());
            }
            throw e;
        }
    }
}

