/*
 * Decompiled with CFR 0.152.
 */
package opennlp.maxent.quasinewton;

import opennlp.maxent.quasinewton.ArrayMath;
import opennlp.maxent.quasinewton.DifferentiableFunction;
import opennlp.maxent.quasinewton.LineSearchResult;

public class LineSearch {
    private static final double INITIAL_STEP_SIZE = 1.0;
    private static final double MIN_STEP_SIZE = 1.0E-10;
    private static final double C1 = 1.0E-4;
    private static final double C2 = 0.9;
    private static final double TT = 16.0;

    public static LineSearchResult doLineSearch(DifferentiableFunction function, double[] direction, LineSearchResult lsr) {
        return LineSearch.doLineSearch(function, direction, lsr, false);
    }

    public static LineSearchResult doLineSearch(DifferentiableFunction function, double[] direction, LineSearchResult lsr, boolean verbose) {
        long startTime;
        double valueAtNextPoint;
        double[] gradAtNextPoint;
        double[] nextPoint;
        double[] gradAtX;
        double valueAtX;
        double[] x;
        double stepSize;
        int currFctEvalCount;
        block5: {
            currFctEvalCount = lsr.getFctEvalCount();
            stepSize = 1.0;
            x = lsr.getNextPoint();
            valueAtX = lsr.getValueAtNext();
            gradAtX = lsr.getGradAtNext();
            nextPoint = null;
            gradAtNextPoint = null;
            valueAtNextPoint = 0.0;
            double mu = 0.0;
            double upsilon = Double.POSITIVE_INFINITY;
            startTime = System.currentTimeMillis();
            do {
                nextPoint = ArrayMath.updatePoint(x, direction, stepSize);
                valueAtNextPoint = function.valueAt(nextPoint);
                ++currFctEvalCount;
                gradAtNextPoint = function.gradientAt(nextPoint);
                if (!LineSearch.checkArmijoCond(valueAtX, valueAtNextPoint, gradAtX, direction, stepSize, true)) {
                    upsilon = stepSize;
                } else {
                    if (LineSearch.checkCurvature(gradAtNextPoint, gradAtX, direction, x.length, true)) break block5;
                    mu = stepSize;
                }
                if (upsilon < Double.POSITIVE_INFINITY) {
                    stepSize = (mu + upsilon) / 16.0;
                    continue;
                }
                stepSize *= 16.0;
            } while (!(stepSize < 1.0E-10 + mu));
            stepSize = 0.0;
        }
        long endTime = System.currentTimeMillis();
        long duration = endTime - startTime;
        if (verbose) {
            System.out.print("\t" + valueAtX);
            System.out.print("\t" + (valueAtNextPoint - valueAtX));
            System.out.print("\t" + (double)duration / 1000.0 + "\n");
        }
        LineSearchResult result = new LineSearchResult(stepSize, valueAtX, valueAtNextPoint, gradAtX, gradAtNextPoint, x, nextPoint, currFctEvalCount);
        return result;
    }

    private static boolean checkArmijoCond(double valueAtX, double valueAtNewPoint, double[] gradAtX, double[] direction, double currStepSize, boolean isMaximizing) {
        double armijo = valueAtX + 1.0E-4 * ArrayMath.innerProduct(direction, gradAtX) * currStepSize;
        return isMaximizing ? valueAtNewPoint > armijo : valueAtNewPoint <= armijo;
    }

    private static boolean checkCurvature(double[] gradAtNewPoint, double[] gradAtX, double[] direction, int domainDimension, boolean isMaximizing) {
        double curvature01 = ArrayMath.innerProduct(direction, gradAtNewPoint);
        double curvature02 = 0.9 * ArrayMath.innerProduct(direction, gradAtX);
        return isMaximizing ? curvature01 < curvature02 : curvature01 >= curvature02;
    }
}

