/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.store;

public class DispatchRequest {
    private final String topic;
    private final int queueId;
    private final long commitLogOffset;
    private final int msgSize;
    private final long tagsCode;
    private final long storeTimestamp;
    private final long consumeQueueOffset;
    private final String keys;
    private final boolean success;
    private final String uniqKey;
    private final int sysFlag;
    private final long preparedTransactionOffset;

    public DispatchRequest(String topic, int queueId, long commitLogOffset, int msgSize, long tagsCode, long storeTimestamp, long consumeQueueOffset, String keys, String uniqKey, int sysFlag, long preparedTransactionOffset) {
        this.topic = topic;
        this.queueId = queueId;
        this.commitLogOffset = commitLogOffset;
        this.msgSize = msgSize;
        this.tagsCode = tagsCode;
        this.storeTimestamp = storeTimestamp;
        this.consumeQueueOffset = consumeQueueOffset;
        this.keys = keys;
        this.uniqKey = uniqKey;
        this.sysFlag = sysFlag;
        this.preparedTransactionOffset = preparedTransactionOffset;
        this.success = true;
    }

    public DispatchRequest(int size) {
        this.topic = "";
        this.queueId = 0;
        this.commitLogOffset = 0L;
        this.msgSize = size;
        this.tagsCode = 0L;
        this.storeTimestamp = 0L;
        this.consumeQueueOffset = 0L;
        this.keys = "";
        this.uniqKey = null;
        this.sysFlag = 0;
        this.preparedTransactionOffset = 0L;
        this.success = false;
    }

    public DispatchRequest(int size, boolean success) {
        this.topic = "";
        this.queueId = 0;
        this.commitLogOffset = 0L;
        this.msgSize = size;
        this.tagsCode = 0L;
        this.storeTimestamp = 0L;
        this.consumeQueueOffset = 0L;
        this.keys = "";
        this.uniqKey = null;
        this.sysFlag = 0;
        this.preparedTransactionOffset = 0L;
        this.success = success;
    }

    public String getTopic() {
        return this.topic;
    }

    public int getQueueId() {
        return this.queueId;
    }

    public long getCommitLogOffset() {
        return this.commitLogOffset;
    }

    public int getMsgSize() {
        return this.msgSize;
    }

    public long getStoreTimestamp() {
        return this.storeTimestamp;
    }

    public long getConsumeQueueOffset() {
        return this.consumeQueueOffset;
    }

    public String getKeys() {
        return this.keys;
    }

    public long getTagsCode() {
        return this.tagsCode;
    }

    public int getSysFlag() {
        return this.sysFlag;
    }

    public long getPreparedTransactionOffset() {
        return this.preparedTransactionOffset;
    }

    public boolean isSuccess() {
        return this.success;
    }

    public String getUniqKey() {
        return this.uniqKey;
    }
}

