/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.tools.command;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.joran.spi.JoranException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;
import org.apache.rocketmq.acl.common.AclUtils;
import org.apache.rocketmq.common.MQVersion;
import org.apache.rocketmq.remoting.RPCHook;
import org.apache.rocketmq.srvutil.ServerUtil;
import org.apache.rocketmq.tools.command.SubCommand;
import org.apache.rocketmq.tools.command.acl.ClusterAclConfigVersionListSubCommand;
import org.apache.rocketmq.tools.command.acl.DeleteAccessConfigSubCommand;
import org.apache.rocketmq.tools.command.acl.GetAccessConfigSubCommand;
import org.apache.rocketmq.tools.command.acl.UpdateAccessConfigSubCommand;
import org.apache.rocketmq.tools.command.acl.UpdateGlobalWhiteAddrSubCommand;
import org.apache.rocketmq.tools.command.broker.BrokerConsumeStatsSubCommad;
import org.apache.rocketmq.tools.command.broker.BrokerStatusSubCommand;
import org.apache.rocketmq.tools.command.broker.CleanExpiredCQSubCommand;
import org.apache.rocketmq.tools.command.broker.CleanUnusedTopicCommand;
import org.apache.rocketmq.tools.command.broker.GetBrokerConfigCommand;
import org.apache.rocketmq.tools.command.broker.SendMsgStatusCommand;
import org.apache.rocketmq.tools.command.broker.UpdateBrokerConfigSubCommand;
import org.apache.rocketmq.tools.command.cluster.CLusterSendMsgRTCommand;
import org.apache.rocketmq.tools.command.cluster.ClusterListSubCommand;
import org.apache.rocketmq.tools.command.connection.ConsumerConnectionSubCommand;
import org.apache.rocketmq.tools.command.connection.ProducerConnectionSubCommand;
import org.apache.rocketmq.tools.command.consumer.ConsumerProgressSubCommand;
import org.apache.rocketmq.tools.command.consumer.ConsumerStatusSubCommand;
import org.apache.rocketmq.tools.command.consumer.DeleteSubscriptionGroupCommand;
import org.apache.rocketmq.tools.command.consumer.GetConsumerConfigSubCommand;
import org.apache.rocketmq.tools.command.consumer.StartMonitoringSubCommand;
import org.apache.rocketmq.tools.command.consumer.UpdateSubGroupSubCommand;
import org.apache.rocketmq.tools.command.export.ExportConfigsCommand;
import org.apache.rocketmq.tools.command.export.ExportMetadataCommand;
import org.apache.rocketmq.tools.command.export.ExportMetricsCommand;
import org.apache.rocketmq.tools.command.message.CheckMsgSendRTCommand;
import org.apache.rocketmq.tools.command.message.ConsumeMessageCommand;
import org.apache.rocketmq.tools.command.message.PrintMessageByQueueCommand;
import org.apache.rocketmq.tools.command.message.PrintMessageSubCommand;
import org.apache.rocketmq.tools.command.message.QueryMsgByIdSubCommand;
import org.apache.rocketmq.tools.command.message.QueryMsgByKeySubCommand;
import org.apache.rocketmq.tools.command.message.QueryMsgByOffsetSubCommand;
import org.apache.rocketmq.tools.command.message.QueryMsgByUniqueKeySubCommand;
import org.apache.rocketmq.tools.command.message.QueryMsgTraceByIdSubCommand;
import org.apache.rocketmq.tools.command.message.SendMessageCommand;
import org.apache.rocketmq.tools.command.namesrv.AddWritePermSubCommand;
import org.apache.rocketmq.tools.command.namesrv.DeleteKvConfigCommand;
import org.apache.rocketmq.tools.command.namesrv.GetNamesrvConfigCommand;
import org.apache.rocketmq.tools.command.namesrv.UpdateKvConfigCommand;
import org.apache.rocketmq.tools.command.namesrv.UpdateNamesrvConfigCommand;
import org.apache.rocketmq.tools.command.namesrv.WipeWritePermSubCommand;
import org.apache.rocketmq.tools.command.offset.CloneGroupOffsetCommand;
import org.apache.rocketmq.tools.command.offset.ResetOffsetByTimeCommand;
import org.apache.rocketmq.tools.command.queue.QueryConsumeQueueCommand;
import org.apache.rocketmq.tools.command.stats.StatsAllSubCommand;
import org.apache.rocketmq.tools.command.topic.AllocateMQSubCommand;
import org.apache.rocketmq.tools.command.topic.DeleteTopicSubCommand;
import org.apache.rocketmq.tools.command.topic.TopicClusterSubCommand;
import org.apache.rocketmq.tools.command.topic.TopicListSubCommand;
import org.apache.rocketmq.tools.command.topic.TopicRouteSubCommand;
import org.apache.rocketmq.tools.command.topic.TopicStatusSubCommand;
import org.apache.rocketmq.tools.command.topic.UpdateOrderConfCommand;
import org.apache.rocketmq.tools.command.topic.UpdateTopicPermSubCommand;
import org.apache.rocketmq.tools.command.topic.UpdateTopicSubCommand;
import org.slf4j.LoggerFactory;

public class MQAdminStartup {
    protected static List<SubCommand> subCommandList = new ArrayList<SubCommand>();
    private static String rocketmqHome = System.getProperty("rocketmq.home.dir", System.getenv("ROCKETMQ_HOME"));

    public static void main(String[] args) {
        MQAdminStartup.main0(args, null);
    }

    public static void main0(String[] args, RPCHook rpcHook) {
        System.setProperty("rocketmq.remoting.version", Integer.toString(MQVersion.CURRENT_VERSION));
        MQAdminStartup.initCommand();
        try {
            MQAdminStartup.initLogback();
            switch (args.length) {
                case 0: {
                    MQAdminStartup.printHelp();
                    break;
                }
                case 2: {
                    if (args[0].equals("help")) {
                        SubCommand cmd = MQAdminStartup.findSubCommand(args[1]);
                        if (cmd != null) {
                            Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
                            if ((options = cmd.buildCommandlineOptions(options)) != null) {
                                ServerUtil.printCommandLineHelp((String)("mqadmin " + cmd.commandName()), (Options)options);
                            }
                            break;
                        }
                        System.out.printf("The sub command %s not exist.%n", args[1]);
                        break;
                    }
                }
                default: {
                    SubCommand cmd = MQAdminStartup.findSubCommand(args[0]);
                    if (cmd != null) {
                        String[] subargs = MQAdminStartup.parseSubArgs(args);
                        Options options = ServerUtil.buildCommandlineOptions((Options)new Options());
                        CommandLine commandLine = ServerUtil.parseCmdLine((String)("mqadmin " + cmd.commandName()), (String[])subargs, (Options)cmd.buildCommandlineOptions(options), (CommandLineParser)new PosixParser());
                        if (null == commandLine) {
                            return;
                        }
                        if (commandLine.hasOption('n')) {
                            String namesrvAddr = commandLine.getOptionValue('n');
                            System.setProperty("rocketmq.namesrv.addr", namesrvAddr);
                        }
                        cmd.execute(commandLine, options, AclUtils.getAclRPCHook((String)(rocketmqHome + "/conf/tools.yml")));
                        break;
                    }
                    System.out.printf("The sub command %s not exist.%n", args[0]);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void initCommand() {
        MQAdminStartup.initCommand(new UpdateTopicSubCommand());
        MQAdminStartup.initCommand(new DeleteTopicSubCommand());
        MQAdminStartup.initCommand(new UpdateSubGroupSubCommand());
        MQAdminStartup.initCommand(new DeleteSubscriptionGroupCommand());
        MQAdminStartup.initCommand(new UpdateBrokerConfigSubCommand());
        MQAdminStartup.initCommand(new UpdateTopicPermSubCommand());
        MQAdminStartup.initCommand(new TopicRouteSubCommand());
        MQAdminStartup.initCommand(new TopicStatusSubCommand());
        MQAdminStartup.initCommand(new TopicClusterSubCommand());
        MQAdminStartup.initCommand(new BrokerStatusSubCommand());
        MQAdminStartup.initCommand(new QueryMsgByIdSubCommand());
        MQAdminStartup.initCommand(new QueryMsgByKeySubCommand());
        MQAdminStartup.initCommand(new QueryMsgByUniqueKeySubCommand());
        MQAdminStartup.initCommand(new QueryMsgByOffsetSubCommand());
        MQAdminStartup.initCommand(new QueryMsgTraceByIdSubCommand());
        MQAdminStartup.initCommand(new PrintMessageSubCommand());
        MQAdminStartup.initCommand(new PrintMessageByQueueCommand());
        MQAdminStartup.initCommand(new SendMsgStatusCommand());
        MQAdminStartup.initCommand(new BrokerConsumeStatsSubCommad());
        MQAdminStartup.initCommand(new ProducerConnectionSubCommand());
        MQAdminStartup.initCommand(new ConsumerConnectionSubCommand());
        MQAdminStartup.initCommand(new ConsumerProgressSubCommand());
        MQAdminStartup.initCommand(new ConsumerStatusSubCommand());
        MQAdminStartup.initCommand(new CloneGroupOffsetCommand());
        MQAdminStartup.initCommand(new ClusterListSubCommand());
        MQAdminStartup.initCommand(new TopicListSubCommand());
        MQAdminStartup.initCommand(new UpdateKvConfigCommand());
        MQAdminStartup.initCommand(new DeleteKvConfigCommand());
        MQAdminStartup.initCommand(new WipeWritePermSubCommand());
        MQAdminStartup.initCommand(new AddWritePermSubCommand());
        MQAdminStartup.initCommand(new ResetOffsetByTimeCommand());
        MQAdminStartup.initCommand(new UpdateOrderConfCommand());
        MQAdminStartup.initCommand(new CleanExpiredCQSubCommand());
        MQAdminStartup.initCommand(new CleanUnusedTopicCommand());
        MQAdminStartup.initCommand(new StartMonitoringSubCommand());
        MQAdminStartup.initCommand(new StatsAllSubCommand());
        MQAdminStartup.initCommand(new AllocateMQSubCommand());
        MQAdminStartup.initCommand(new CheckMsgSendRTCommand());
        MQAdminStartup.initCommand(new CLusterSendMsgRTCommand());
        MQAdminStartup.initCommand(new GetNamesrvConfigCommand());
        MQAdminStartup.initCommand(new UpdateNamesrvConfigCommand());
        MQAdminStartup.initCommand(new GetBrokerConfigCommand());
        MQAdminStartup.initCommand(new GetConsumerConfigSubCommand());
        MQAdminStartup.initCommand(new QueryConsumeQueueCommand());
        MQAdminStartup.initCommand(new SendMessageCommand());
        MQAdminStartup.initCommand(new ConsumeMessageCommand());
        MQAdminStartup.initCommand(new UpdateAccessConfigSubCommand());
        MQAdminStartup.initCommand(new DeleteAccessConfigSubCommand());
        MQAdminStartup.initCommand(new ClusterAclConfigVersionListSubCommand());
        MQAdminStartup.initCommand(new UpdateGlobalWhiteAddrSubCommand());
        MQAdminStartup.initCommand(new GetAccessConfigSubCommand());
        MQAdminStartup.initCommand(new ExportMetadataCommand());
        MQAdminStartup.initCommand(new ExportConfigsCommand());
        MQAdminStartup.initCommand(new ExportMetricsCommand());
    }

    private static void initLogback() throws JoranException {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext((Context)lc);
        lc.reset();
        configurator.doConfigure(rocketmqHome + "/conf/logback_tools.xml");
    }

    private static void printHelp() {
        System.out.printf("The most commonly used mqadmin commands are:%n", new Object[0]);
        for (SubCommand cmd : subCommandList) {
            System.out.printf("   %-20s %s%n", cmd.commandName(), cmd.commandDesc());
        }
        System.out.printf("%nSee 'mqadmin help <command>' for more information on a specific command.%n", new Object[0]);
    }

    private static SubCommand findSubCommand(String name) {
        for (SubCommand cmd : subCommandList) {
            if (!cmd.commandName().toUpperCase().equals(name.toUpperCase())) continue;
            return cmd;
        }
        return null;
    }

    private static String[] parseSubArgs(String[] args) {
        if (args.length > 1) {
            String[] result = new String[args.length - 1];
            for (int i = 0; i < args.length - 1; ++i) {
                result[i] = args[i + 1];
            }
            return result;
        }
        return null;
    }

    public static void initCommand(SubCommand command) {
        subCommandList.add(command);
    }
}

