/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.buffer.Buffer;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;
import org.apache.servicecomb.foundation.vertx.http.BodyBufferSupport;
import org.apache.servicecomb.foundation.vertx.http.BodyBufferSupportImpl;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.stream.BufferInputStream;

public class StandardHttpServletRequestEx
extends HttpServletRequestWrapper
implements HttpServletRequestEx {
    private BodyBufferSupport bodyBuffer = new BodyBufferSupportImpl();
    private boolean cacheRequest;
    private ServletInputStream inputStream;

    public StandardHttpServletRequestEx(HttpServletRequest request) {
        super(request);
    }

    public void setCacheRequest(boolean cacheRequest) {
        this.cacheRequest = cacheRequest;
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.inputStream == null) {
            if (this.cacheRequest) {
                byte[] inputBytes = IOUtils.toByteArray((InputStream)this.getRequest().getInputStream());
                ByteBuf byteBuf = Unpooled.wrappedBuffer((byte[])inputBytes);
                this.inputStream = new BufferInputStream(byteBuf);
                this.setBodyBuffer(Buffer.buffer((ByteBuf)Unpooled.wrappedBuffer((ByteBuf)byteBuf)));
            } else {
                this.inputStream = this.getRequest().getInputStream();
            }
        }
        return this.inputStream;
    }

    @Override
    public void setBodyBuffer(Buffer bodyBuffer) {
        this.bodyBuffer.setBodyBuffer(bodyBuffer);
    }

    @Override
    public Buffer getBodyBuffer() {
        return this.bodyBuffer.getBodyBuffer();
    }

    @Override
    public byte[] getBodyBytes() {
        return this.bodyBuffer.getBodyBytes();
    }

    @Override
    public int getBodyBytesLength() {
        return this.bodyBuffer.getBodyBytesLength();
    }
}

