/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.opentracing;

import com.google.common.base.Preconditions;
import io.opentracing.Tracer;
import io.opentracing.util.GlobalTracer;
import lombok.Generated;
import org.apache.shardingsphere.underlying.common.exception.ShardingSphereException;

public final class ShardingTracer {
    private static final String OPENTRACING_TRACER_CLASS_NAME = "org.apache.shardingsphere.opentracing.tracer.class";

    public static void init() {
        String tracerClassName = System.getProperty(OPENTRACING_TRACER_CLASS_NAME);
        Preconditions.checkNotNull((Object)tracerClassName, (String)"Can not find opentracing tracer implementation class via system property `%s`", (Object[])new Object[]{OPENTRACING_TRACER_CLASS_NAME});
        try {
            ShardingTracer.init((Tracer)Class.forName(tracerClassName).newInstance());
        }
        catch (ReflectiveOperationException ex) {
            throw new ShardingSphereException("Initialize opentracing tracer class failure.", (Exception)ex);
        }
    }

    public static void init(Tracer tracer) {
        if (!GlobalTracer.isRegistered()) {
            GlobalTracer.register((Tracer)tracer);
        }
    }

    public static Tracer get() {
        return GlobalTracer.get();
    }

    @Generated
    private ShardingTracer() {
    }
}

