/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.opentracing.hook;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import org.apache.shardingsphere.opentracing.ShardingTracer;
import org.apache.shardingsphere.opentracing.hook.ShardingErrorSpan;
import org.apache.shardingsphere.sql.parser.hook.ParsingHook;
import org.apache.shardingsphere.sql.parser.sql.statement.SQLStatement;

public final class OpenTracingParsingHook
implements ParsingHook {
    private static final String OPERATION_NAME = "/ShardingSphere/parseSQL/";
    private Span span;

    public void start(String sql) {
        this.span = ShardingTracer.get().buildSpan(OPERATION_NAME).withTag(Tags.COMPONENT.getKey(), "ShardingSphere").withTag(Tags.SPAN_KIND.getKey(), "client").withTag(Tags.DB_STATEMENT.getKey(), sql).startManual();
    }

    public void finishSuccess(SQLStatement sqlStatement) {
        this.span.finish();
    }

    public void finishFailure(Exception cause) {
        ShardingErrorSpan.setError(this.span, cause);
        this.span.finish();
    }
}

