/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.opentracing.hook;

import io.opentracing.ActiveSpan;
import io.opentracing.tag.Tags;
import org.apache.shardingsphere.opentracing.ShardingTracer;
import org.apache.shardingsphere.opentracing.constant.ShardingTags;
import org.apache.shardingsphere.underlying.common.hook.RootInvokeHook;
import org.apache.shardingsphere.underlying.executor.engine.ExecutorDataMap;

public final class OpenTracingRootInvokeHook
implements RootInvokeHook {
    public static final String ACTIVE_SPAN_CONTINUATION = "ACTIVE_SPAN_CONTINUATION";
    private static final String OPERATION_NAME = "/ShardingSphere/rootInvoke/";
    private ActiveSpan activeSpan;

    public void start() {
        this.activeSpan = ShardingTracer.get().buildSpan(OPERATION_NAME).withTag(Tags.COMPONENT.getKey(), "ShardingSphere").startActive();
        ExecutorDataMap.getValue().put(ACTIVE_SPAN_CONTINUATION, this.activeSpan.capture());
    }

    public void finish(int connectionCount) {
        ((ActiveSpan)this.activeSpan.setTag(ShardingTags.CONNECTION_COUNT.getKey(), (Number)connectionCount)).deactivate();
    }
}

