/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.opentracing.hook;

import com.google.common.base.Joiner;
import io.opentracing.ActiveSpan;
import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.opentracing.ShardingTracer;
import org.apache.shardingsphere.opentracing.constant.ShardingTags;
import org.apache.shardingsphere.opentracing.hook.ShardingErrorSpan;
import org.apache.shardingsphere.spi.database.metadata.DataSourceMetaData;
import org.apache.shardingsphere.underlying.executor.hook.SQLExecutionHook;

public final class OpenTracingSQLExecutionHook
implements SQLExecutionHook {
    private static final String OPERATION_NAME = "/ShardingSphere/executeSQL/";
    private ActiveSpan activeSpan;
    private Span span;

    public void start(String dataSourceName, String sql, List<Object> parameters, DataSourceMetaData dataSourceMetaData, boolean isTrunkThread, Map<String, Object> shardingExecuteDataMap) {
        if (!isTrunkThread) {
            this.activeSpan = ((ActiveSpan.Continuation)shardingExecuteDataMap.get("ACTIVE_SPAN_CONTINUATION")).activate();
        }
        this.span = ShardingTracer.get().buildSpan(OPERATION_NAME).withTag(Tags.COMPONENT.getKey(), "ShardingSphere").withTag(Tags.SPAN_KIND.getKey(), "client").withTag(Tags.PEER_HOSTNAME.getKey(), dataSourceMetaData.getHostName()).withTag(Tags.PEER_PORT.getKey(), (Number)dataSourceMetaData.getPort()).withTag(Tags.DB_TYPE.getKey(), "sql").withTag(Tags.DB_INSTANCE.getKey(), dataSourceName).withTag(Tags.DB_STATEMENT.getKey(), sql).withTag(ShardingTags.DB_BIND_VARIABLES.getKey(), this.toString(parameters)).startManual();
    }

    private String toString(List<Object> parameterSets) {
        if (null == parameterSets || parameterSets.isEmpty()) {
            return "";
        }
        return String.format("[%s]", Joiner.on((String)", ").useForNull("Null").join(parameterSets));
    }

    public void finishSuccess() {
        this.span.finish();
        if (null != this.activeSpan) {
            this.activeSpan.deactivate();
        }
    }

    public void finishFailure(Exception cause) {
        ShardingErrorSpan.setError(this.span, cause);
        this.span.finish();
        if (null != this.activeSpan) {
            this.activeSpan.deactivate();
        }
    }
}

