/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.orchestration.center.instance.wrapper;

import com.ctrip.framework.apollo.openapi.client.ApolloOpenApiClient;
import com.ctrip.framework.apollo.openapi.dto.NamespaceReleaseDTO;
import com.ctrip.framework.apollo.openapi.dto.OpenItemDTO;
import org.apache.shardingsphere.orchestration.center.config.CenterConfiguration;
import org.apache.shardingsphere.orchestration.center.instance.ApolloProperties;
import org.apache.shardingsphere.orchestration.center.instance.ApolloPropertyKey;

public final class ApolloOpenApiWrapper {
    private ApolloOpenApiClient client;
    private String namespace;
    private String appId;
    private String env;
    private String clusterName;
    private String administrator;

    public ApolloOpenApiWrapper(CenterConfiguration config, ApolloProperties properties) {
        this.namespace = config.getNamespace();
        this.appId = (String)properties.getValue(ApolloPropertyKey.APP_ID);
        this.env = (String)properties.getValue(ApolloPropertyKey.ENV);
        this.clusterName = (String)properties.getValue(ApolloPropertyKey.CLUSTER_NAME);
        this.administrator = (String)properties.getValue(ApolloPropertyKey.ADMINISTRATOR);
        String apolloToken = (String)properties.getValue(ApolloPropertyKey.TOKEN);
        String portalUrl = (String)properties.getValue(ApolloPropertyKey.PORTAL_URL);
        Integer connectTimeout = (Integer)properties.getValue(ApolloPropertyKey.CONNECT_TIMEOUT);
        Integer readTimeout = (Integer)properties.getValue(ApolloPropertyKey.READ_TIMEOUT);
        this.client = ApolloOpenApiClient.newBuilder().withPortalUrl(portalUrl).withConnectTimeout(connectTimeout.intValue()).withReadTimeout(readTimeout.intValue()).withToken(apolloToken).build();
    }

    public String getValue(String key) {
        OpenItemDTO itemDTO = this.client.getItem(this.appId, this.env, this.clusterName, this.namespace, key);
        if (itemDTO == null) {
            return null;
        }
        return itemDTO.getValue();
    }

    public void persist(String key, String value) {
        this.updateKey(key, value);
        this.publishNamespace();
    }

    private void updateKey(String key, String value) {
        OpenItemDTO openItem = new OpenItemDTO();
        openItem.setKey(key);
        openItem.setValue(value);
        openItem.setComment("ShardingSphere create or update config");
        openItem.setDataChangeCreatedBy(this.administrator);
        this.client.createOrUpdateItem(this.appId, this.env, this.clusterName, this.namespace, openItem);
    }

    private void publishNamespace() {
        NamespaceReleaseDTO release = new NamespaceReleaseDTO();
        release.setReleaseTitle("ShardingSphere namespace release");
        release.setReleaseComment("ShardingSphere namespace release");
        release.setReleasedBy(this.administrator);
        release.setEmergencyPublish(true);
        this.client.publishNamespace(this.appId, this.env, this.clusterName, this.namespace, release);
    }
}

