/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.orchestration.center.instance;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.config.ConfigService;
import com.alibaba.nacos.api.config.listener.Listener;
import com.alibaba.nacos.api.exception.NacosException;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Executor;
import lombok.Generated;
import org.apache.shardingsphere.orchestration.center.ConfigCenterRepository;
import org.apache.shardingsphere.orchestration.center.config.CenterConfiguration;
import org.apache.shardingsphere.orchestration.center.instance.NacosProperties;
import org.apache.shardingsphere.orchestration.center.instance.NacosPropertyKey;
import org.apache.shardingsphere.orchestration.center.listener.DataChangedEvent;
import org.apache.shardingsphere.orchestration.center.listener.DataChangedEventListener;
import org.apache.shardingsphere.orchestration.center.util.ConfigKeyUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NacosCenterRepository
implements ConfigCenterRepository {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NacosCenterRepository.class);
    private ConfigService configService;
    private NacosProperties nacosProperties;
    private Properties properties = new Properties();

    public void init(CenterConfiguration config) {
        try {
            this.nacosProperties = new NacosProperties(this.properties);
            Properties properties = new Properties();
            properties.put("serverAddr", config.getServerLists());
            properties.put("namespace", null == config.getNamespace() ? "" : config.getNamespace());
            this.configService = NacosFactory.createConfigService((Properties)properties);
        }
        catch (NacosException ex) {
            log.error("Init nacos config center exception for: {}", (Object)ex.toString());
        }
    }

    public String get(String key) {
        try {
            String dataId = ConfigKeyUtils.path2Key((String)key);
            String group = (String)this.nacosProperties.getValue(NacosPropertyKey.GROUP);
            long timeoutMs = (Long)this.nacosProperties.getValue(NacosPropertyKey.TIMEOUT);
            return this.configService.getConfig(dataId, group, timeoutMs);
        }
        catch (NacosException ex) {
            log.debug("Nacos get config value exception for: {}", (Object)ex.toString());
            return null;
        }
    }

    public List<String> getChildrenKeys(String key) {
        return null;
    }

    public void persist(String key, String value) {
        try {
            String dataId = ConfigKeyUtils.path2Key((String)key);
            String group = (String)this.nacosProperties.getValue(NacosPropertyKey.GROUP);
            this.configService.publishConfig(dataId, group, value);
        }
        catch (NacosException ex) {
            log.debug("Nacos persist config exception for: {}", (Object)ex.toString());
        }
    }

    public void watch(final String key, final DataChangedEventListener dataChangedEventListener) {
        try {
            String dataId = ConfigKeyUtils.path2Key((String)key);
            String group = (String)this.nacosProperties.getValue(NacosPropertyKey.GROUP);
            this.configService.addListener(dataId, group, new Listener(){

                public Executor getExecutor() {
                    return null;
                }

                public void receiveConfigInfo(String configInfo) {
                    dataChangedEventListener.onChange(new DataChangedEvent(key, configInfo, DataChangedEvent.ChangedType.UPDATED));
                }
            });
        }
        catch (NacosException ex) {
            log.debug("Nacos watch key exception for: {}", (Object)ex.toString());
        }
    }

    public void close() {
    }

    public String getType() {
        return "nacos";
    }

    @Generated
    public Properties getProperties() {
        return this.properties;
    }

    @Generated
    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

