/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.sane.mysql;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.sane.SaneQueryResultEngine;
import org.apache.shardingsphere.infra.executor.sql.execute.engine.driver.jdbc.sane.mysql.MySQLDefaultVariable;
import org.apache.shardingsphere.infra.executor.sql.execute.result.ExecuteResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.QueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultColumnMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.metadata.RawQueryResultMetaData;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.impl.raw.type.RawMemoryQueryResult;
import org.apache.shardingsphere.infra.executor.sql.execute.result.query.type.memory.row.MemoryQueryResultDataRow;
import org.apache.shardingsphere.infra.executor.sql.execute.result.update.UpdateResult;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.SQLStatement;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLSetStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.dal.MySQLShowOtherStatement;

public final class MySQLSaneQueryResultEngine
implements SaneQueryResultEngine {
    @Override
    public Optional<ExecuteResult> getSaneQueryResult(SQLStatement sqlStatement) {
        if (sqlStatement instanceof SelectStatement) {
            return this.createQueryResult((SelectStatement)sqlStatement);
        }
        if (sqlStatement instanceof MySQLShowOtherStatement) {
            return Optional.of(this.createQueryResult((MySQLShowOtherStatement)sqlStatement));
        }
        if (sqlStatement instanceof MySQLSetStatement) {
            return Optional.of(new UpdateResult(0, 0L));
        }
        return Optional.empty();
    }

    private Optional<ExecuteResult> createQueryResult(SelectStatement sqlStatement) {
        if (null != sqlStatement.getFrom()) {
            return Optional.empty();
        }
        ArrayList<RawQueryResultColumnMetaData> queryResultColumnMetaDataList = new ArrayList<RawQueryResultColumnMetaData>(sqlStatement.getProjections().getProjections().size());
        ArrayList<Object> data = new ArrayList<Object>(sqlStatement.getProjections().getProjections().size());
        for (ProjectionSegment each : sqlStatement.getProjections().getProjections()) {
            if (!(each instanceof ExpressionProjectionSegment)) continue;
            String text = ((ExpressionProjectionSegment)each).getText();
            String alias = ((ExpressionProjectionSegment)each).getAlias().orElse(((ExpressionProjectionSegment)each).getText());
            queryResultColumnMetaDataList.add(this.createRawQueryResultColumnMetaData(text, alias));
            data.add(MySQLDefaultVariable.containsVariable(alias) ? MySQLDefaultVariable.getVariable(alias) : "1");
        }
        return queryResultColumnMetaDataList.isEmpty() ? Optional.empty() : Optional.of(new RawMemoryQueryResult((QueryResultMetaData)new RawQueryResultMetaData(queryResultColumnMetaDataList), Collections.singletonList(new MemoryQueryResultDataRow(data))));
    }

    private QueryResult createQueryResult(MySQLShowOtherStatement sqlStatement) {
        RawQueryResultColumnMetaData queryResultColumnMetaData = this.createRawQueryResultColumnMetaData("", "");
        MemoryQueryResultDataRow resultDataRow = new MemoryQueryResultDataRow(Collections.singletonList("1"));
        return new RawMemoryQueryResult((QueryResultMetaData)new RawQueryResultMetaData(Collections.singletonList(queryResultColumnMetaData)), Collections.singletonList(resultDataRow));
    }

    private RawQueryResultColumnMetaData createRawQueryResultColumnMetaData(String name, String label) {
        return new RawQueryResultColumnMetaData("", name, label, 12, "VARCHAR", 255, 0);
    }

    public String getType() {
        return "MySQL";
    }
}

