/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sql.parser.sqlserver.visitor.statement.type;

import java.util.Optional;
import org.antlr.v4.runtime.tree.ParseTree;
import org.apache.shardingsphere.sql.parser.api.ASTNode;
import org.apache.shardingsphere.sql.parser.api.visitor.statement.type.DCLStatementVisitor;
import org.apache.shardingsphere.sql.parser.autogen.SQLServerStatementParser;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dcl.LoginSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.collection.CollectionValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;
import org.apache.shardingsphere.sql.parser.sql.common.value.literal.impl.StringLiteralValue;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.mysql.segment.UserSegment;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerAlterLoginStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerAlterRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerAlterUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerCreateLoginStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerCreateRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerCreateUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerDenyUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerDropLoginStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerDropRoleStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerDropUserStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerGrantStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerRevertStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerRevokeStatement;
import org.apache.shardingsphere.sql.parser.sql.dialect.statement.sqlserver.dcl.SQLServerSetUserStatement;
import org.apache.shardingsphere.sql.parser.sqlserver.visitor.statement.SQLServerStatementVisitor;

public final class SQLServerDCLStatementVisitor
extends SQLServerStatementVisitor
implements DCLStatementVisitor {
    @Override
    public ASTNode visitGrant(SQLServerStatementParser.GrantContext ctx) {
        SQLServerGrantStatement result = new SQLServerGrantStatement();
        if (null != ctx.grantClassPrivilegesClause()) {
            this.findTableSegment(ctx.grantClassPrivilegesClause().onClassClause(), ctx.grantClassPrivilegesClause().classPrivileges()).ifPresent(optional -> result.getTables().add(optional));
            if (null != ctx.grantClassPrivilegesClause().classPrivileges().columnNames()) {
                for (SQLServerStatementParser.ColumnNamesContext each : ctx.grantClassPrivilegesClause().classPrivileges().columnNames()) {
                    result.getColumns().addAll(((CollectionValue)this.visit((ParseTree)each)).getValue());
                }
            }
        }
        if (null != ctx.grantClassTypePrivilegesClause()) {
            this.findTableSegment(ctx.grantClassTypePrivilegesClause().onClassTypeClause()).ifPresent(optional -> result.getTables().add(optional));
        }
        return result;
    }

    @Override
    public ASTNode visitRevoke(SQLServerStatementParser.RevokeContext ctx) {
        SQLServerRevokeStatement result = new SQLServerRevokeStatement();
        if (null != ctx.revokeClassPrivilegesClause()) {
            this.findTableSegment(ctx.revokeClassPrivilegesClause().onClassClause(), ctx.revokeClassPrivilegesClause().classPrivileges()).ifPresent(optional -> result.getTables().add(optional));
            if (null != ctx.revokeClassPrivilegesClause().classPrivileges().columnNames()) {
                for (SQLServerStatementParser.ColumnNamesContext each : ctx.revokeClassPrivilegesClause().classPrivileges().columnNames()) {
                    result.getColumns().addAll(((CollectionValue)this.visit((ParseTree)each)).getValue());
                }
            }
        }
        if (null != ctx.revokeClassTypePrivilegesClause()) {
            this.findTableSegment(ctx.revokeClassTypePrivilegesClause().onClassTypeClause()).ifPresent(optional -> result.getTables().add(optional));
        }
        return result;
    }

    @Override
    public ASTNode visitSecurable(SQLServerStatementParser.SecurableContext ctx) {
        SimpleTableSegment result = new SimpleTableSegment(new TableNameSegment(ctx.name().getStart().getStartIndex(), ctx.name().getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.name())));
        SQLServerStatementParser.OwnerContext owner = ctx.owner();
        if (null != owner) {
            result.setOwner(new OwnerSegment(owner.getStart().getStartIndex(), owner.getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)owner.identifier())));
        }
        return result;
    }

    @Override
    public ASTNode visitCreateUser(SQLServerStatementParser.CreateUserContext ctx) {
        SQLServerCreateUserStatement result = new SQLServerCreateUserStatement();
        if (null != ctx.createUserLoginClause()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)ctx.createUserLoginClause().userName()));
        } else if (null != ctx.createUserWindowsPrincipalClause()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)ctx.createUserWindowsPrincipalClause()));
        } else if (null != ctx.createUserLoginWindowsPrincipalClause()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)ctx.createUserLoginWindowsPrincipalClause()));
        } else if (null != ctx.createUserWithoutLoginClause()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)ctx.createUserWithoutLoginClause().userName()));
        } else if (null != ctx.createUserFromExternalProviderClause()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)ctx.createUserFromExternalProviderClause().userName()));
        } else if (null != ctx.createUserWithDefaultSchema()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)ctx.createUserWithDefaultSchema().userName()));
        } else if (null != ctx.createUserWithAzureActiveDirectoryPrincipalClause()) {
            result.getUsers().add((UserSegment)this.visit((ParseTree)ctx.createUserWithAzureActiveDirectoryPrincipalClause().azureActiveDirectoryPrincipal().userName()));
        } else {
            result.getUsers().add((UserSegment)this.visit((ParseTree)ctx.userName()));
        }
        return result;
    }

    @Override
    public ASTNode visitUserName(SQLServerStatementParser.UserNameContext ctx) {
        UserSegment result = new UserSegment();
        String user = ((IdentifierValue)this.visit((ParseTree)ctx.ignoredNameIdentifier())).getValue();
        result.setUser(user);
        return result;
    }

    @Override
    public ASTNode visitIgnoredNameIdentifier(SQLServerStatementParser.IgnoredNameIdentifierContext ctx) {
        int identifierCount = ctx.identifier().size();
        return 1 == identifierCount ? (IdentifierValue)this.visit((ParseTree)ctx.identifier(0)) : new IdentifierValue(ctx.getText());
    }

    @Override
    public ASTNode visitCreateUserWindowsPrincipalClause(SQLServerStatementParser.CreateUserWindowsPrincipalClauseContext ctx) {
        if (null != ctx.windowsPrincipal()) {
            return (ASTNode)this.visit((ParseTree)ctx.windowsPrincipal().userName());
        }
        if (null != ctx.azureActiveDirectoryPrincipal()) {
            return (ASTNode)this.visit((ParseTree)ctx.azureActiveDirectoryPrincipal().userName());
        }
        return (ASTNode)this.visit((ParseTree)ctx.userName());
    }

    @Override
    public ASTNode visitCreateUserLoginWindowsPrincipalClause(SQLServerStatementParser.CreateUserLoginWindowsPrincipalClauseContext ctx) {
        return null == ctx.userName() ? (UserSegment)this.visit((ParseTree)ctx.windowsPrincipal(0)) : (UserSegment)this.visit((ParseTree)ctx.userName());
    }

    @Override
    public ASTNode visitAlterUser(SQLServerStatementParser.AlterUserContext ctx) {
        SQLServerAlterUserStatement result = new SQLServerAlterUserStatement();
        result.setUser((UserSegment)this.visit((ParseTree)ctx.userName()));
        return result;
    }

    @Override
    public ASTNode visitDeny(SQLServerStatementParser.DenyContext ctx) {
        SQLServerDenyUserStatement result = new SQLServerDenyUserStatement();
        if (null != ctx.denyClassPrivilegesClause()) {
            this.findTableSegment(ctx.denyClassPrivilegesClause().onClassClause(), ctx.denyClassPrivilegesClause().classPrivileges()).ifPresent(arg_0 -> ((SQLServerDenyUserStatement)result).setTable(arg_0));
            if (null != ctx.denyClassPrivilegesClause().classPrivileges().columnNames()) {
                for (SQLServerStatementParser.ColumnNamesContext each : ctx.denyClassPrivilegesClause().classPrivileges().columnNames()) {
                    result.getColumns().addAll(((CollectionValue)this.visit((ParseTree)each)).getValue());
                }
            }
        }
        if (null != ctx.denyClassTypePrivilegesClause()) {
            this.findTableSegment(ctx.denyClassTypePrivilegesClause().onClassTypeClause()).ifPresent(arg_0 -> ((SQLServerDenyUserStatement)result).setTable(arg_0));
        }
        return result;
    }

    private Optional<SimpleTableSegment> findTableSegment(SQLServerStatementParser.OnClassClauseContext onClassClauseCtx, SQLServerStatementParser.ClassPrivilegesContext classPrivilegesCtx) {
        if (null == onClassClauseCtx) {
            return Optional.empty();
        }
        if (null != onClassClauseCtx.classItem() && null != onClassClauseCtx.classItem().OBJECT() || null != classPrivilegesCtx.privilegeType().get(0).objectPermission() || null != classPrivilegesCtx.privilegeType().get(0).PRIVILEGES()) {
            return Optional.of((SimpleTableSegment)this.visit((ParseTree)onClassClauseCtx.securable()));
        }
        return Optional.empty();
    }

    private Optional<SimpleTableSegment> findTableSegment(SQLServerStatementParser.OnClassTypeClauseContext ctx) {
        return null != ctx && null != ctx.classType() && null != ctx.classType().OBJECT() ? Optional.of((SimpleTableSegment)this.visit((ParseTree)ctx.securable())) : Optional.empty();
    }

    @Override
    public ASTNode visitDropUser(SQLServerStatementParser.DropUserContext ctx) {
        SQLServerDropUserStatement result = new SQLServerDropUserStatement();
        result.getUsers().add(((UserSegment)this.visit((ParseTree)ctx.userName())).getUser());
        return result;
    }

    @Override
    public ASTNode visitCreateRole(SQLServerStatementParser.CreateRoleContext ctx) {
        return new SQLServerCreateRoleStatement();
    }

    @Override
    public ASTNode visitAlterRole(SQLServerStatementParser.AlterRoleContext ctx) {
        return new SQLServerAlterRoleStatement();
    }

    @Override
    public ASTNode visitDropRole(SQLServerStatementParser.DropRoleContext ctx) {
        return new SQLServerDropRoleStatement();
    }

    @Override
    public ASTNode visitCreateLogin(SQLServerStatementParser.CreateLoginContext ctx) {
        SQLServerCreateLoginStatement result = new SQLServerCreateLoginStatement();
        if (null != ctx.ignoredNameIdentifier()) {
            LoginSegment loginSegment = new LoginSegment(ctx.ignoredNameIdentifier().getStart().getStartIndex(), ctx.ignoredNameIdentifier().getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.ignoredNameIdentifier()));
            result.setLoginSegment(loginSegment);
        }
        return result;
    }

    @Override
    public ASTNode visitAlterLogin(SQLServerStatementParser.AlterLoginContext ctx) {
        SQLServerAlterLoginStatement result = new SQLServerAlterLoginStatement();
        if (null != ctx.ignoredNameIdentifier()) {
            LoginSegment loginSegment = new LoginSegment(ctx.ignoredNameIdentifier().getStart().getStartIndex(), ctx.ignoredNameIdentifier().getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.ignoredNameIdentifier()));
            result.setLoginSegment(loginSegment);
        }
        return result;
    }

    @Override
    public ASTNode visitDropLogin(SQLServerStatementParser.DropLoginContext ctx) {
        SQLServerDropLoginStatement result = new SQLServerDropLoginStatement();
        LoginSegment loginSegment = new LoginSegment(ctx.ignoredNameIdentifier().getStart().getStartIndex(), ctx.ignoredNameIdentifier().getStop().getStopIndex(), (IdentifierValue)this.visit((ParseTree)ctx.ignoredNameIdentifier()));
        result.setLoginSegment(loginSegment);
        return result;
    }

    @Override
    public ASTNode visitSetUser(SQLServerStatementParser.SetUserContext ctx) {
        SQLServerSetUserStatement result = new SQLServerSetUserStatement();
        if (null != ctx.stringLiterals()) {
            UserSegment userSegment = new UserSegment();
            userSegment.setUser(((StringLiteralValue)this.visit((ParseTree)ctx.stringLiterals())).getValue());
            userSegment.setStartIndex(ctx.stringLiterals().start.getStartIndex());
            userSegment.setStopIndex(ctx.stringLiterals().stop.getStopIndex());
            result.setUser(userSegment);
        }
        return result;
    }

    @Override
    public ASTNode visitRevert(SQLServerStatementParser.RevertContext ctx) {
        return new SQLServerRevertStatement();
    }
}

