/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.register.client.consul;

import com.ecwid.consul.v1.ConsulClient;
import com.ecwid.consul.v1.agent.model.NewService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.shenyu.common.enums.RpcTypeEnum;
import org.apache.shenyu.common.exception.ShenyuException;
import org.apache.shenyu.common.utils.ContextPathUtils;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.LogUtils;
import org.apache.shenyu.register.client.api.ShenyuClientRegisterRepository;
import org.apache.shenyu.register.common.config.ShenyuRegisterCenterConfig;
import org.apache.shenyu.register.common.dto.MetaDataRegisterDTO;
import org.apache.shenyu.register.common.dto.URIRegisterDTO;
import org.apache.shenyu.register.common.path.RegisterPathConstants;
import org.apache.shenyu.spi.Join;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Join
public class ConsulClientRegisterRepository
implements ShenyuClientRegisterRepository {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsulClientRegisterRepository.class);
    private static final char SEPARATOR = '-';
    private ConsulClient consulClient;
    private NewService service;

    public ConsulClientRegisterRepository() {
    }

    public ConsulClientRegisterRepository(ShenyuRegisterCenterConfig config) {
        this.init(config);
    }

    public void init(ShenyuRegisterCenterConfig config) {
        String tags;
        Properties properties = config.getProps();
        String serverList = config.getServerLists();
        if (StringUtils.isBlank((CharSequence)serverList)) {
            throw new ShenyuException("serverList can not be null.");
        }
        String[] addresses = this.splitAndCheckAddress(serverList);
        this.consulClient = new ConsulClient(addresses[0], Integer.parseInt(addresses[1]));
        this.service = new NewService();
        this.service.setMeta(new HashMap());
        String appName = properties.getProperty("name");
        this.service.setName(this.normalizeForDns(appName));
        String instanceId = properties.getProperty("instanceId");
        this.service.setId(this.normalizeForDns(instanceId));
        boolean preferAgentAddress = Boolean.parseBoolean(properties.getProperty("preferAgentAddress", "false"));
        if (!preferAgentAddress) {
            this.service.setAddress(properties.getProperty("hostName"));
        }
        if (StringUtils.isNotBlank((CharSequence)(tags = properties.getProperty("tags")))) {
            this.service.setTags(new ArrayList<String>(Arrays.asList(tags.split(","))));
        }
        this.service.setEnableTagOverride(Boolean.valueOf(properties.getProperty("enableTagOverride", "false")));
        String port = properties.getProperty("port");
        if (StringUtils.isNotBlank((CharSequence)port)) {
            this.service.setPort(Integer.valueOf(Integer.parseInt(port)));
        }
    }

    private String[] splitAndCheckAddress(String serverList) {
        String[] addresses = serverList.split(":");
        if (addresses.length != 2) {
            throw new ShenyuException("serverList formatter is not incorrect.");
        }
        return addresses;
    }

    private String normalizeForDns(String s) {
        if (s == null || !Character.isLetter(s.charAt(0)) || !Character.isLetterOrDigit(s.charAt(s.length() - 1))) {
            throw new IllegalArgumentException("Consul service ids must not be empty, must start with a letter, end with a letter or digit, and have as interior characters only letters, digits, and hyphen: " + s);
        }
        StringBuilder normalized = new StringBuilder();
        Character prev = null;
        for (char curr : s.toCharArray()) {
            Character toAppend = null;
            if (Character.isLetterOrDigit(curr)) {
                toAppend = Character.valueOf(curr);
            } else if (prev == null || prev.charValue() != '-') {
                toAppend = Character.valueOf('-');
            }
            if (toAppend == null) continue;
            normalized.append(toAppend);
            prev = toAppend;
        }
        return normalized.toString();
    }

    public void persistInterface(MetaDataRegisterDTO metadata) {
        this.registerMetadata(metadata);
        LogUtils.info((Logger)LOGGER, (String)"{} Consul client register success: {}", (Object[])new Object[]{metadata.getRpcType(), metadata});
    }

    public void persistURI(URIRegisterDTO registerDTO) {
        this.registerURI(registerDTO);
        LogUtils.info((Logger)LOGGER, (String)"{} Consul client register success: {}", (Object[])new Object[]{registerDTO.getRpcType(), registerDTO});
    }

    public void close() {
        this.consulClient.agentServiceDeregister(this.service.getId());
    }

    private void registerMetadata(MetaDataRegisterDTO metadata) {
        String rpcType = metadata.getRpcType();
        String contextPath = ContextPathUtils.buildRealNode((String)metadata.getContextPath(), (String)metadata.getAppName());
        String metadataNodeName = this.buildMetadataNodeName(metadata);
        String metaDataPath = RegisterPathConstants.buildMetaDataParentPath((String)rpcType, (String)contextPath);
        String realNode = RegisterPathConstants.buildRealNode((String)metaDataPath, (String)metadataNodeName);
        String metadataJson = GsonUtils.getInstance().toJson((Object)metadata);
        this.consulClient.setKVValue(realNode, metadataJson);
    }

    private void registerURI(URIRegisterDTO metadata) {
        this.service.getMeta().put("uri", GsonUtils.getInstance().toJson((Object)metadata));
        this.consulClient.agentServiceRegister(this.service);
    }

    private String buildMetadataNodeName(MetaDataRegisterDTO metadata) {
        String rpcType = metadata.getRpcType();
        String nodeName = Objects.equals(RpcTypeEnum.HTTP.getName(), rpcType) || Objects.equals(RpcTypeEnum.SPRING_CLOUD.getName(), rpcType) ? String.join((CharSequence)"-", metadata.getContextPath(), metadata.getRuleName().replace("/", "-")) : RegisterPathConstants.buildNodeName((String)metadata.getServiceName(), (String)metadata.getMethodName());
        return nodeName.startsWith("/") ? nodeName.substring(1) : nodeName;
    }
}

