/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.json.jcr;

import java.util.ArrayList;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFormatException;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.JSONObject;
import org.apache.sling.commons.json.jcr.JsonItemWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsonJcrNode
extends JSONObject {
    private Node node;
    private Set<String> propertyNamesToIgnore;

    public JsonJcrNode(Node node) throws JSONException, RepositoryException {
        this(node, (Set<String>)null);
    }

    public JsonJcrNode(Node node, Set<String> propertyNamesToIgnore) throws JSONException, RepositoryException {
        this.node = node;
        this.propertyNamesToIgnore = propertyNamesToIgnore;
        this.populate();
    }

    private void populate() throws JSONException, RepositoryException {
        PropertyIterator properties = this.node.getProperties();
        this.addNative("jcr:path", this.node.getPath());
        this.addNative("jcr:name", this.node.getName());
        while (properties.hasNext()) {
            Property prop = properties.nextProperty();
            String name = prop.getName();
            if (this.propertyNamesToIgnore != null && this.propertyNamesToIgnore.contains(name)) continue;
            this.addProperty(prop);
        }
    }

    private void addNative(String key, String value) throws JSONException, RepositoryException {
        if (this.propertyNamesToIgnore == null || !this.propertyNamesToIgnore.contains(key)) {
            this.put(key, value);
        }
    }

    protected void addProperty(Property p) throws ValueFormatException, RepositoryException, JSONException {
        if (p.getType() == 2) {
            String key = ":" + p.getName();
            if (!p.getDefinition().isMultiple()) {
                this.put(key, p.getLength());
            } else {
                long[] sizes = p.getLengths();
                ArrayList<Long> list = new ArrayList<Long>();
                for (long value : sizes) {
                    list.add(value);
                }
                this.put(key, list);
            }
        } else {
            String key = p.getName();
            if (!p.getDefinition().isMultiple()) {
                this.addValue(key, p.getValue());
            } else {
                for (Value v : p.getValues()) {
                    this.addValue(key, v);
                }
            }
        }
    }

    protected void addValue(String key, Value v) throws IllegalStateException, RepositoryException, JSONException {
        switch (v.getType()) {
            case 2: {
                this.accumulate(key, 0);
                break;
            }
            case 5: {
                this.accumulate(key, JsonItemWriter.format(v.getDate()));
                break;
            }
            case 6: {
                this.accumulate(key, v.getBoolean());
                break;
            }
            case 3: {
                this.accumulate(key, v.getLong());
                break;
            }
            case 4: {
                this.accumulate(key, v.getDouble());
                break;
            }
            default: {
                this.accumulate(key, v.getString());
            }
        }
    }
}

