/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.asn1;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle160.asn1.ASN1Encodable;
import org.bouncycastle160.asn1.ASN1OctetStringParser;
import org.bouncycastle160.asn1.ASN1OutputStream;
import org.bouncycastle160.asn1.ASN1Primitive;
import org.bouncycastle160.asn1.ASN1Sequence;
import org.bouncycastle160.asn1.ASN1TaggedObject;
import org.bouncycastle160.asn1.BEROctetString;
import org.bouncycastle160.asn1.DEROctetString;
import org.bouncycastle160.util.Arrays;
import org.bouncycastle160.util.Strings;
import org.bouncycastle160.util.encoders.Hex;

public abstract class ASN1OctetString
extends ASN1Primitive
implements ASN1OctetStringParser {
    byte[] string;

    public static ASN1OctetString getInstance(ASN1TaggedObject obj, boolean explicit) {
        ASN1Primitive o = obj.getObject();
        if (explicit || o instanceof ASN1OctetString) {
            return ASN1OctetString.getInstance(o);
        }
        return BEROctetString.fromSequence(ASN1Sequence.getInstance(o));
    }

    public static ASN1OctetString getInstance(Object obj) {
        ASN1Primitive primitive;
        if (obj == null || obj instanceof ASN1OctetString) {
            return (ASN1OctetString)obj;
        }
        if (obj instanceof byte[]) {
            try {
                return ASN1OctetString.getInstance(ASN1Primitive.fromByteArray((byte[])obj));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("failed to construct OCTET STRING from byte[]: " + e.getMessage());
            }
        }
        if (obj instanceof ASN1Encodable && (primitive = ((ASN1Encodable)obj).toASN1Primitive()) instanceof ASN1OctetString) {
            return (ASN1OctetString)primitive;
        }
        throw new IllegalArgumentException("illegal object in getInstance: " + obj.getClass().getName());
    }

    public ASN1OctetString(byte[] string) {
        if (string == null) {
            throw new NullPointerException("string cannot be null");
        }
        this.string = string;
    }

    @Override
    public InputStream getOctetStream() {
        return new ByteArrayInputStream(this.string);
    }

    public ASN1OctetStringParser parser() {
        return this;
    }

    public byte[] getOctets() {
        return this.string;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.getOctets());
    }

    @Override
    boolean asn1Equals(ASN1Primitive o) {
        if (!(o instanceof ASN1OctetString)) {
            return false;
        }
        ASN1OctetString other = (ASN1OctetString)o;
        return Arrays.areEqual(this.string, other.string);
    }

    @Override
    public ASN1Primitive getLoadedObject() {
        return this.toASN1Primitive();
    }

    @Override
    ASN1Primitive toDERObject() {
        return new DEROctetString(this.string);
    }

    @Override
    ASN1Primitive toDLObject() {
        return new DEROctetString(this.string);
    }

    @Override
    abstract void encode(ASN1OutputStream var1) throws IOException;

    public String toString() {
        return "#" + Strings.fromByteArray(Hex.encode(this.string));
    }
}

