/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.asn1;

import java.io.IOException;
import java.util.Date;
import org.bouncycastle160.asn1.ASN1GeneralizedTime;
import org.bouncycastle160.asn1.ASN1OutputStream;
import org.bouncycastle160.asn1.StreamUtil;
import org.bouncycastle160.util.Strings;

public class DERGeneralizedTime
extends ASN1GeneralizedTime {
    public DERGeneralizedTime(byte[] time) {
        super(time);
    }

    public DERGeneralizedTime(Date time) {
        super(time);
    }

    public DERGeneralizedTime(String time) {
        super(time);
    }

    private byte[] getDERTime() {
        if (this.time[this.time.length - 1] == 90) {
            if (!this.hasMinutes()) {
                byte[] derTime = new byte[this.time.length + 4];
                System.arraycopy(this.time, 0, derTime, 0, this.time.length - 1);
                System.arraycopy(Strings.toByteArray("0000Z"), 0, derTime, this.time.length - 1, 5);
                return derTime;
            }
            if (!this.hasSeconds()) {
                byte[] derTime = new byte[this.time.length + 2];
                System.arraycopy(this.time, 0, derTime, 0, this.time.length - 1);
                System.arraycopy(Strings.toByteArray("00Z"), 0, derTime, this.time.length - 1, 3);
                return derTime;
            }
            if (this.hasFractionalSeconds()) {
                int ind;
                for (ind = this.time.length - 2; ind > 0 && this.time[ind] == 48; --ind) {
                }
                if (this.time[ind] == 46) {
                    byte[] derTime = new byte[ind + 1];
                    System.arraycopy(this.time, 0, derTime, 0, ind);
                    derTime[ind] = 90;
                    return derTime;
                }
                byte[] derTime = new byte[ind + 2];
                System.arraycopy(this.time, 0, derTime, 0, ind + 1);
                derTime[ind + 1] = 90;
                return derTime;
            }
            return this.time;
        }
        return this.time;
    }

    @Override
    int encodedLength() {
        int length = this.getDERTime().length;
        return 1 + StreamUtil.calculateBodyLength(length) + length;
    }

    @Override
    void encode(ASN1OutputStream out) throws IOException {
        out.writeEncoded(24, this.getDERTime());
    }
}

