/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.asn1.est;

import org.bouncycastle160.asn1.ASN1Object;
import org.bouncycastle160.asn1.ASN1Primitive;
import org.bouncycastle160.asn1.ASN1Sequence;
import org.bouncycastle160.asn1.ASN1TaggedObject;
import org.bouncycastle160.asn1.DERSequence;
import org.bouncycastle160.asn1.est.AttrOrOID;
import org.bouncycastle160.asn1.est.Utils;

public class CsrAttrs
extends ASN1Object {
    private final AttrOrOID[] attrOrOIDs;

    public static CsrAttrs getInstance(Object obj) {
        if (obj instanceof CsrAttrs) {
            return (CsrAttrs)obj;
        }
        if (obj != null) {
            return new CsrAttrs(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static CsrAttrs getInstance(ASN1TaggedObject obj, boolean explicit) {
        return CsrAttrs.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    public CsrAttrs(AttrOrOID attrOrOID) {
        this.attrOrOIDs = new AttrOrOID[]{attrOrOID};
    }

    public CsrAttrs(AttrOrOID[] attrOrOIDs) {
        this.attrOrOIDs = Utils.clone(attrOrOIDs);
    }

    private CsrAttrs(ASN1Sequence seq) {
        this.attrOrOIDs = new AttrOrOID[seq.size()];
        for (int i = 0; i != seq.size(); ++i) {
            this.attrOrOIDs[i] = AttrOrOID.getInstance(seq.getObjectAt(i));
        }
    }

    public AttrOrOID[] getAttrOrOIDs() {
        return Utils.clone(this.attrOrOIDs);
    }

    public int size() {
        return this.attrOrOIDs.length;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.attrOrOIDs);
    }
}

