/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.asn1.test;

import org.bouncycastle160.asn1.cmc.BodyPartID;
import org.bouncycastle160.util.test.SimpleTest;

public class BodyPartIDTest
extends SimpleTest {
    @Override
    public void performTest() throws Exception {
        block9: {
            block8: {
                BodyPartID bpd = new BodyPartID(10L);
                byte[] b = bpd.getEncoded();
                BodyPartID resBpd = BodyPartID.getInstance(b);
                this.isEquals("Correct / Encode byte array", resBpd.getID(), bpd.getID());
                BodyPartID rootPartID = new BodyPartID(12L);
                bpd = BodyPartID.getInstance(rootPartID);
                b = bpd.getEncoded();
                resBpd = BodyPartID.getInstance(b);
                this.isEquals("Correct / Encode byte array", resBpd.getID(), rootPartID.getID());
                try {
                    new BodyPartID(0L);
                }
                catch (Throwable t) {
                    this.fail("Unexpected exception: " + t.getMessage(), t);
                }
                try {
                    new BodyPartID(-1L);
                    this.fail("Expecting IllegalArgumentException because of outside lower range");
                }
                catch (Throwable e) {
                    if (e instanceof IllegalArgumentException) break block8;
                    this.fail("Expecting only IllegalArgumentException, got:" + e.getMessage(), e);
                }
            }
            try {
                new BodyPartID(0xFFFFFFFFL);
            }
            catch (Throwable t) {
                this.fail("Unexpected exception: " + t.getMessage(), t);
            }
            try {
                new BodyPartID(0x100000000L);
                this.fail("Expecting IllegalArgumentException because of outside upper range");
            }
            catch (Throwable e) {
                if (e instanceof IllegalArgumentException) break block9;
                this.fail("Expecting only IllegalArgumentException, got:" + e.getMessage(), e);
            }
        }
    }

    @Override
    public String getName() {
        return "BodyPartIDTest";
    }

    public static void main(String[] args) throws Exception {
        BodyPartIDTest.runTest(new BodyPartIDTest());
    }
}

