/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.asn1.test;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle160.asn1.ASN1Integer;
import org.bouncycastle160.asn1.cmc.CMCFailInfo;
import org.bouncycastle160.util.test.SimpleTest;

public class CMCFailInfoTest
extends SimpleTest {
    private static Object[][] types = new Object[][]{{"badAlg", new Long(0L)}, {"badMessageCheck", new Long(1L)}, {"badRequest", new Long(2L)}, {"badTime", new Long(3L)}, {"badCertId", new Long(4L)}, {"unsupportedExt", new Long(5L)}, {"mustArchiveKeys", new Long(6L)}, {"badIdentity", new Long(7L)}, {"popRequired", new Long(8L)}, {"popFailed", new Long(9L)}, {"noKeyReuse", new Long(10L)}, {"internalCAError", new Long(11L)}, {"tryLater", new Long(12L)}, {"authDataFail", new Long(13L)}};
    private static Map typesMap = new HashMap();

    @Override
    public void performTest() throws Exception {
        Field rangeField = CMCFailInfo.class.getDeclaredField("range");
        rangeField.setAccessible(true);
        Map range = (Map)rangeField.get(null);
        this.isEquals("Range in CMCFailInfo does not match test data.", range.size(), types.length);
        for (Object j : range.keySet()) {
            if (typesMap.containsKey(new Long(((ASN1Integer)j).getValue().longValue()))) continue;
            this.fail("The 'range' map in CMCFailInfo contains a value not in the test ('typesMap') map, value was: " + j.toString());
        }
        for (Object j : typesMap.keySet()) {
            if (range.containsKey(new ASN1Integer((Long)j))) continue;
            this.fail("The 'typesMap' map in CMCFailInfoTest contains a value not in the CMCFailInfo ('range') map, value was: " + j.toString());
        }
        byte[] b = CMCFailInfo.authDataFail.getEncoded();
        CMCFailInfo r = CMCFailInfo.getInstance(b);
        this.isEquals(r, CMCFailInfo.authDataFail);
    }

    @Override
    public String getName() {
        return "CMCFailInfoTest";
    }

    public static void main(String[] args) {
        CMCFailInfoTest.runTest(new CMCFailInfoTest());
    }

    static {
        for (int t = 0; t < types.length; ++t) {
            typesMap.put(types[t][1], types[t][0]);
        }
    }
}

