/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.asn1.test;

import java.util.Date;
import org.bouncycastle160.asn1.DERGeneralizedTime;
import org.bouncycastle160.asn1.DEROctetString;
import org.bouncycastle160.asn1.cmc.BodyPartID;
import org.bouncycastle160.asn1.cmc.CMCFailInfo;
import org.bouncycastle160.asn1.cmc.CMCStatus;
import org.bouncycastle160.asn1.cmc.CMCStatusInfoV2;
import org.bouncycastle160.asn1.cmc.CMCStatusInfoV2Builder;
import org.bouncycastle160.asn1.cmc.ExtendedFailInfo;
import org.bouncycastle160.asn1.cmc.PendInfo;
import org.bouncycastle160.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle160.util.Strings;
import org.bouncycastle160.util.test.SimpleTest;

public class CMCStatusInfoV2Test
extends SimpleTest {
    public static void main(String[] args) {
        CMCStatusInfoV2Test.runTest(new CMCStatusInfoV2Test());
    }

    @Override
    public String getName() {
        return "CMCStatusInfoV2Test";
    }

    @Override
    public void performTest() throws Exception {
        CMCStatusInfoV2Builder bldr = new CMCStatusInfoV2Builder(CMCStatus.confirmRequired, new BodyPartID(10L));
        CMCStatusInfoV2 cmsInfo = bldr.build();
        this.isTrue("Has statusString", null == cmsInfo.getStatusString());
        this.isEquals("Has other info", false, cmsInfo.hasOtherInfo());
        byte[] b = cmsInfo.getEncoded();
        CMCStatusInfoV2 res = CMCStatusInfoV2.getInstance(b);
        this.isEquals("CMCStatus with no optional part", cmsInfo, res);
        this.isEquals("Has other info", false, res.hasOtherInfo());
        bldr = new CMCStatusInfoV2Builder(CMCStatus.confirmRequired, new BodyPartID(10L)).setStatusString("Cats");
        cmsInfo = bldr.build();
        this.isEquals("Has other info", false, cmsInfo.hasOtherInfo());
        b = cmsInfo.getEncoded();
        res = CMCStatusInfoV2.getInstance(b);
        this.isEquals("CMCStatus with no optional part", cmsInfo, res);
        this.isEquals("Has other info", false, res.hasOtherInfo());
        bldr = new CMCStatusInfoV2Builder(CMCStatus.confirmRequired, new BodyPartID(10L)).setStatusString("Cats").setOtherInfo(new PendInfo(Strings.toByteArray("fish"), new DERGeneralizedTime(new Date())));
        cmsInfo = bldr.build();
        this.isEquals("Must have other info", true, cmsInfo.hasOtherInfo());
        this.isEquals("Other is NOT fail info", false, cmsInfo.getOtherStatusInfo().isFailInfo());
        b = cmsInfo.getEncoded();
        res = CMCStatusInfoV2.getInstance(b);
        this.isEquals("With optional info: PendInfo", cmsInfo, res);
        this.isEquals("Must have other info", true, res.hasOtherInfo());
        this.isEquals("Other is NOT fail info", false, res.getOtherStatusInfo().isFailInfo());
        bldr = new CMCStatusInfoV2Builder(CMCStatus.confirmRequired, new BodyPartID(10L)).setStatusString("Cats").setOtherInfo(CMCFailInfo.authDataFail);
        cmsInfo = bldr.build();
        this.isEquals("Must have other info", true, cmsInfo.hasOtherInfo());
        this.isEquals("Other is fail info", true, cmsInfo.getOtherStatusInfo().isFailInfo());
        b = cmsInfo.getEncoded();
        res = CMCStatusInfoV2.getInstance(b);
        this.isEquals("With optional info: CMCFailInfo", cmsInfo, res);
        this.isEquals("Must have other info", true, res.hasOtherInfo());
        this.isEquals("Other is fail info", true, res.getOtherStatusInfo().isFailInfo());
        bldr = new CMCStatusInfoV2Builder(CMCStatus.confirmRequired, new BodyPartID(10L)).setStatusString("Cats").setOtherInfo(new ExtendedFailInfo(PKCSObjectIdentifiers.bagtypes, new DEROctetString("fish".getBytes())));
        cmsInfo = bldr.build();
        this.isEquals("Must have other info", true, cmsInfo.hasOtherInfo());
        this.isEquals("Other is extended fail info", true, cmsInfo.getOtherStatusInfo().isExtendedFailInfo());
        b = cmsInfo.getEncoded();
        res = CMCStatusInfoV2.getInstance(b);
        this.isEquals("With optional info: ExtendedFailInfo", cmsInfo, res);
        this.isEquals("Must have other info", true, res.hasOtherInfo());
        this.isEquals("Other is extended fail info", true, res.getOtherStatusInfo().isExtendedFailInfo());
    }
}

