/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import org.bouncycastle160.asn1.ASN1InputStream;
import org.bouncycastle160.asn1.ASN1OctetStringParser;
import org.bouncycastle160.asn1.ASN1OutputStream;
import org.bouncycastle160.asn1.ASN1SequenceParser;
import org.bouncycastle160.asn1.ASN1Set;
import org.bouncycastle160.asn1.ASN1SetParser;
import org.bouncycastle160.asn1.ASN1StreamParser;
import org.bouncycastle160.asn1.DERSet;
import org.bouncycastle160.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle160.asn1.cms.CompressedData;
import org.bouncycastle160.asn1.cms.ContentInfo;
import org.bouncycastle160.asn1.cms.ContentInfoParser;
import org.bouncycastle160.asn1.cms.EncryptedContentInfoParser;
import org.bouncycastle160.asn1.cms.EnvelopedData;
import org.bouncycastle160.asn1.cms.EnvelopedDataParser;
import org.bouncycastle160.asn1.cms.KEKRecipientInfo;
import org.bouncycastle160.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle160.asn1.cms.RecipientInfo;
import org.bouncycastle160.asn1.cms.SignedData;
import org.bouncycastle160.util.encoders.Base64;
import org.bouncycastle160.util.io.Streams;
import org.bouncycastle160.util.test.SimpleTestResult;
import org.bouncycastle160.util.test.Test;
import org.bouncycastle160.util.test.TestResult;

public class CMSTest
implements Test {
    byte[] compData = Base64.decode("MIAGCyqGSIb3DQEJEAEJoIAwgAIBADANBgsqhkiG9w0BCRADCDCABgkqhkiG9w0BBwGggCSABIICHnic7ZRdb9owFIbvK/k/5PqVYPFXGK12YYyboVFASSp1vQtZGiLRACZE49/XHoUW7S/0tXP8EfuxfU5ivWnasml72XFb3gb5druui7ytN803M570nii7C5r8tfwR281hy/p/KSM3+jzH5s3+pbQ90xSbP3VT3QbLusnt8WPIuN5vN/vaA2+DulnXTXkXvNTr8j8ouZmkCmGI/UW+ZS/C8zP0bz2dz0zwLt+1UEk2M8mlaxjRMByAhZTj0RGYg4TvogiRASROsZgjpVcJCb1KV6QzQeDJ1XkoQ5Jm+C5PbOHZZGRiv+ORAcshOGeCcdFJyfgFxdtCdEcmOrbinc/+BBMzRThEYpwl+jEBpciSGWQkI0TSlREmD/eOHb2DSGLuESm/iKUFt1y4XHBO2a5oq0IKJKWLS9kUZTA7vC5LSxYmgVL46SIWxIfWBQd6AdrnjLmH94UTvGxVibLqRCtIpp4g2qpdtqK1LiOeolpVK5wVQ5P7+QjZAlrh0cePYTx/gNZuB9Vhndtgujl9T/tgW9ogK+3rnmg3YWygnTuF5GDS+Q/jIVLnCcYZFc6Kk/+c80wKwZjwdZIqDYWRH68MuBQSXLgXYXj23CAaYOBNJMliTl0X7eV5DnoKIFSKYdj3cRpD/cK/JWTHJRe76MUXnfBW8m7Hd5zhQ4ri2NrVF/WL+kV1/3AGSlJ32bFPd2BsQD8uSzIx6lObkjdz95c0AAAAAAAAAAAAAAAA");
    byte[] envDataKeyTrns = Base64.decode("MIAGCSqGSIb3DQEHA6CAMIACAQAxgcQwgcECAQAwKjAlMRYwFAYDVQQKEw1Cb3VuY3kgQ2FzdGxlMQswCQYDVQQGEwJBVQIBCjANBgkqhkiG9w0BAQEFAASBgC5vdGrBitQSGwifLf3KwPILjaB4WEXgT/IIO1KDzrsbItCJsMA0Smq2y0zptxT0pSRL6JRgNMxLk1ySnrIrvGiEPLMR1zjxlT8yQ6VLX+kEoK43ztd1aaLw0oBfrcXcLN7BEpZ1TIdjlBfXIOx1S88WY1MiYqJJFc3LMwRUaTEDMIAGCSqGSIb3DQEHATAdBglghkgBZQMEARYEEAfxLMWeaBOTTZQwUq0Y5FuggAQgwOJhL04rjSZCBCSOv5i5XpFfGsOdYSHSqwntGpFqCx4AAAAAAAAAAAAA");
    byte[] envDataKEK = Base64.decode("MIAGCSqGSIb3DQEHA6CAMIACAQIxUqJQAgEEMAcEBQECAwQFMBAGCyqGSIb3DQEJEAMHAgE6BDC7G/HyUPilIrin2Yeajqmj795VoLWETRnZAAFcAiQdoQWyz+oCh6WY/HjHHi+0y+cwgAYJKoZIhvcNAQcBMBQGCCqGSIb3DQMHBAiY3eDBBbF6naCABBiNdzJb/v6+UZB3XXKipxFDUpz9GyjzB+gAAAAAAAAAAAAA");
    byte[] envDataNestedNDEF = Base64.decode("MIAGCSqGSIb3DQEHA6CAMIACAQAxge8wgewCAQAwgZUwgY8xKDAmBgNVBAoMH1RoZSBMZWdpb24gb2YgdGhlIEJvdW5jeSBDYXN0bGUxLzAtBgkqhkiG9w0BCQEWIGZlZWRiYWNrLWNyeXB0b0Bib3VuY3ljYXN0bGUub3JnMREwDwYDVQQIDAhWaWN0b3JpYTESMBAGA1UEBwwJTWVsYm91cm5lMQswCQYDVQQGEwJBVQIBATANBgkqhkiG9w0BAQEFAARABIXMd8xiTyWDKO/LQfvdGYTPW3I9oSQWwtm4OIaNVINpfY2lfwTvbmE6VXiLKeALC0dMBV8z7DEM9hE0HVmvLDCABgkqhkiG9w0BBwEwHQYJYIZIAWUDBAECBBB32ko6WrVxDTqwUYEpV6IUoIAEggKgS6RowrhNlmWWI13zxD/lryxkZ5oWXPUfNiUxYX/Pr5iscW3s8VKJKUpJ4W5SNA7JGL4l/5LmSnJ4Qu/xzxcoH4r4vmt75EDE9p2Ob2Xi1NuSFAZubJFcZlnp4e05UHKikmoaz0PbiAi277sLQlK2FcVsntTYVT00y8+IwuuQu0ATVqkXC+VhfjV/sK6vQZnw2rQKedZhLB7B4dUkmxCujb/UAq4lgSpLMXg2P6wMimTczXyQxRiZxPeI4ByCENjkafXbfcJft2eDgv1DEDdYM5WrW9Z75b4lmJiOJ/xxDniHCvum7KGXzpK1d1mqTlpzPC2xoz08/MO4lRf5Mb0bYdq6CjMaYqVwGsYryp/2ayX+d8H+JphEG+V9Eg8uPcDoibwhDI4KkoyGHstPw5bxcy7vVFt7LXUdNjJcK1wxaUKEXDGKt9Vj93FnBTLMX0Pc9HpueV5o1ipX34dn/P3HZB9XK8ScbrE38B1VnIgylStnhVFOCj9s7qSVqI2L+xYHJRHsxaMumIRnmRuOqdXDfIo28EZAnFtQ/b9BziMGVvAW5+A8h8s2oazhSmK223ftV7uv98ScgE8fCd3PwT1kKJM83ThTYyBzokvMfPYCCvsonMV+kTWXhWcwjYTS4ukrpR452ZdWl3aJqDnzobt5FK4T8OGciOj+1PxYFZyRmCuafm2Dx6o7Et2Tu/T5HYvhdY9jHyqtDl2PXH4CTnVigA1YOAArjPVmsZVwAM3Ml46uyXXhcsXwQ1X0Tv4D+PSa/id4UQ2cObOw8Cj1eW2GB8iJIZVqkZaUXBexqgWYOIoxjqODSeoZKiBsTK3c+oOUBqBDueY1i55swE2o6dDt95FluX6iyr/q4w2wLt3upY1JYL+TuvZxAKviuAczMS1bAAAAAAAAAAAAAA==");
    byte[] signedData = Base64.decode("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");

    private boolean isSameAs(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i != a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private TestResult compressionTest() {
        try {
            ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(this.compData));
            ContentInfo info = ContentInfo.getInstance(aIn.readObject());
            CompressedData data = CompressedData.getInstance(info.getContent());
            data = new CompressedData(data.getCompressionAlgorithmIdentifier(), data.getEncapContentInfo());
            info = new ContentInfo(CMSObjectIdentifiers.compressedData, data);
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(info);
            if (!this.isSameAs(bOut.toByteArray(), this.compData)) {
                return new SimpleTestResult(false, this.getName() + ": CMS compression failed to re-encode");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": CMS compression failed - " + e.toString(), e);
        }
    }

    private TestResult envelopedTest() {
        try {
            ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(this.envDataKeyTrns));
            ContentInfo info = ContentInfo.getInstance(aIn.readObject());
            EnvelopedData envData = EnvelopedData.getInstance(info.getContent());
            ASN1Set s = envData.getRecipientInfos();
            if (s.size() != 1) {
                return new SimpleTestResult(false, this.getName() + ": CMS KeyTrans enveloped, wrong number of recipients");
            }
            RecipientInfo recip = RecipientInfo.getInstance(s.getObjectAt(0));
            if (!(recip.getInfo() instanceof KeyTransRecipientInfo)) {
                return new SimpleTestResult(false, this.getName() + ": CMS KeyTrans enveloped, wrong recipient type");
            }
            KeyTransRecipientInfo inf = KeyTransRecipientInfo.getInstance(recip.getInfo());
            inf = new KeyTransRecipientInfo(inf.getRecipientIdentifier(), inf.getKeyEncryptionAlgorithm(), inf.getEncryptedKey());
            s = new DERSet(new RecipientInfo(inf));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            envData = new EnvelopedData(envData.getOriginatorInfo(), s, envData.getEncryptedContentInfo(), envData.getUnprotectedAttrs());
            info = new ContentInfo(CMSObjectIdentifiers.envelopedData, envData);
            aOut.writeObject(info);
            if (!this.isSameAs(bOut.toByteArray(), this.envDataKeyTrns)) {
                return new SimpleTestResult(false, this.getName() + ": CMS KeyTrans enveloped failed to re-encode");
            }
            aIn = new ASN1InputStream(new ByteArrayInputStream(this.envDataKEK));
            info = ContentInfo.getInstance(aIn.readObject());
            envData = EnvelopedData.getInstance(info.getContent());
            s = envData.getRecipientInfos();
            if (s.size() != 1) {
                return new SimpleTestResult(false, this.getName() + ": CMS KEK enveloped, wrong number of recipients");
            }
            recip = RecipientInfo.getInstance(s.getObjectAt(0));
            if (!(recip.getInfo() instanceof KEKRecipientInfo)) {
                return new SimpleTestResult(false, this.getName() + ": CMS KEK enveloped, wrong recipient type");
            }
            KEKRecipientInfo inf2 = KEKRecipientInfo.getInstance(recip.getInfo());
            inf2 = new KEKRecipientInfo(inf2.getKekid(), inf2.getKeyEncryptionAlgorithm(), inf2.getEncryptedKey());
            s = new DERSet(new RecipientInfo(inf2));
            bOut = new ByteArrayOutputStream();
            aOut = new ASN1OutputStream(bOut);
            envData = new EnvelopedData(envData.getOriginatorInfo(), s, envData.getEncryptedContentInfo(), envData.getUnprotectedAttrs());
            info = new ContentInfo(CMSObjectIdentifiers.envelopedData, envData);
            aOut.writeObject(info);
            if (!this.isSameAs(bOut.toByteArray(), this.envDataKEK)) {
                System.out.println(new String(Base64.encode(bOut.toByteArray())));
                return new SimpleTestResult(false, this.getName() + ": CMS KEK enveloped failed to re-encode");
            }
            ASN1StreamParser asn1In = new ASN1StreamParser(new ByteArrayInputStream(this.envDataNestedNDEF));
            ContentInfoParser ci = new ContentInfoParser((ASN1SequenceParser)asn1In.readObject());
            EnvelopedDataParser ed = new EnvelopedDataParser((ASN1SequenceParser)ci.getContent(16));
            ed.getVersion();
            ed.getOriginatorInfo();
            ed.getRecipientInfos().toASN1Primitive();
            EncryptedContentInfoParser eci = ed.getEncryptedContentInfo();
            eci.getContentType();
            eci.getContentEncryptionAlgorithm();
            InputStream dataIn = ((ASN1OctetStringParser)eci.getEncryptedContent(4)).getOctetStream();
            Streams.drain(dataIn);
            dataIn.close();
            ASN1SetParser upa = ed.getUnprotectedAttrs();
            if (upa != null) {
                upa.toASN1Primitive();
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": CMS enveloped failed - " + e.toString(), e);
        }
    }

    private TestResult signedTest() {
        try {
            ASN1InputStream aIn = new ASN1InputStream(new ByteArrayInputStream(this.signedData));
            ContentInfo info = ContentInfo.getInstance(aIn.readObject());
            SignedData sData = SignedData.getInstance(info.getContent());
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            sData = new SignedData(sData.getDigestAlgorithms(), sData.getEncapContentInfo(), sData.getCertificates(), sData.getCRLs(), sData.getSignerInfos());
            info = new ContentInfo(CMSObjectIdentifiers.signedData, sData);
            aOut.writeObject(info);
            if (!this.isSameAs(bOut.toByteArray(), this.signedData)) {
                return new SimpleTestResult(false, this.getName() + ": CMS signed failed to re-encode");
            }
            return new SimpleTestResult(true, this.getName() + ": Okay");
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": CMS signed failed - " + e.toString(), e);
        }
    }

    @Override
    public TestResult perform() {
        TestResult res = this.compressionTest();
        if (!res.isSuccessful()) {
            return res;
        }
        res = this.envelopedTest();
        if (!res.isSuccessful()) {
            return res;
        }
        return this.signedTest();
    }

    @Override
    public String getName() {
        return "CMS";
    }

    public static void main(String[] args) {
        CMSTest test = new CMSTest();
        TestResult result = test.perform();
        System.out.println(result);
    }
}

