/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.asn1.test;

import java.io.IOException;
import org.bouncycastle160.asn1.ASN1Encodable;
import org.bouncycastle160.asn1.ASN1InputStream;
import org.bouncycastle160.asn1.ASN1ObjectIdentifier;
import org.bouncycastle160.asn1.ASN1Sequence;
import org.bouncycastle160.asn1.esf.CommitmentTypeIdentifier;
import org.bouncycastle160.asn1.esf.CommitmentTypeQualifier;
import org.bouncycastle160.util.test.SimpleTest;

public class CommitmentTypeQualifierUnitTest
extends SimpleTest {
    @Override
    public String getName() {
        return "CommitmentTypeQualifier";
    }

    @Override
    public void performTest() throws Exception {
        CommitmentTypeQualifier ctq = new CommitmentTypeQualifier(CommitmentTypeIdentifier.proofOfOrigin);
        this.checkConstruction(ctq, CommitmentTypeIdentifier.proofOfOrigin, null);
        ASN1ObjectIdentifier info = new ASN1ObjectIdentifier("1.2");
        ctq = new CommitmentTypeQualifier(CommitmentTypeIdentifier.proofOfOrigin, info);
        this.checkConstruction(ctq, CommitmentTypeIdentifier.proofOfOrigin, info);
        ctq = CommitmentTypeQualifier.getInstance(null);
        if (ctq != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            CommitmentTypeQualifier.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(CommitmentTypeQualifier mv, ASN1ObjectIdentifier commitmenttTypeId, ASN1Encodable qualifier) throws IOException {
        this.checkStatement(mv, commitmenttTypeId, qualifier);
        mv = CommitmentTypeQualifier.getInstance(mv);
        this.checkStatement(mv, commitmenttTypeId, qualifier);
        ASN1InputStream aIn = new ASN1InputStream(mv.toASN1Primitive().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        mv = CommitmentTypeQualifier.getInstance(seq);
        this.checkStatement(mv, commitmenttTypeId, qualifier);
    }

    private void checkStatement(CommitmentTypeQualifier ctq, ASN1ObjectIdentifier commitmentTypeId, ASN1Encodable qualifier) {
        if (!ctq.getCommitmentTypeIdentifier().equals(commitmentTypeId)) {
            this.fail("commitmentTypeIds don't match.");
        }
        if (qualifier != null) {
            if (!ctq.getQualifier().equals(qualifier)) {
                this.fail("qualifiers don't match.");
            }
        } else if (ctq.getQualifier() != null) {
            this.fail("qualifier found when none expected.");
        }
    }

    public static void main(String[] args) {
        CommitmentTypeQualifierUnitTest.runTest(new CommitmentTypeQualifierUnitTest());
    }
}

