/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.asn1.test;

import org.bouncycastle160.asn1.DEROctetString;
import org.bouncycastle160.asn1.DERUTF8String;
import org.bouncycastle160.util.Arrays;
import org.bouncycastle160.util.Strings;
import org.bouncycastle160.util.test.SimpleTestResult;
import org.bouncycastle160.util.test.Test;
import org.bouncycastle160.util.test.TestResult;

public class DERUTF8StringTest
implements Test {
    private static final char[] glyph1_utf16 = new char[]{'\ud801', '\udc00'};
    private static final byte[] glyph1_utf8 = new byte[]{-16, -112, -112, -128};
    private static final char[] glyph2_utf16 = new char[]{'\u6771'};
    private static final byte[] glyph2_utf8 = new byte[]{-26, -99, -79};
    private static final char[] glyph3_utf16 = new char[]{'\u00df'};
    private static final byte[] glyph3_utf8 = new byte[]{-61, -97};
    private static final char[] glyph4_utf16 = new char[]{'A'};
    private static final byte[] glyph4_utf8 = new byte[]{65};
    private static final byte[][] glyphs_utf8 = new byte[][]{glyph1_utf8, glyph2_utf8, glyph3_utf8, glyph4_utf8};
    private static final char[][] glyphs_utf16 = new char[][]{glyph1_utf16, glyph2_utf16, glyph3_utf16, glyph4_utf16};

    @Override
    public TestResult perform() {
        try {
            for (int i = 0; i < glyphs_utf16.length; ++i) {
                String s = new String(glyphs_utf16[i]);
                byte[] b1 = new DERUTF8String(s).getEncoded();
                byte[] temp = new byte[b1.length - 2];
                System.arraycopy(b1, 2, temp, 0, b1.length - 2);
                byte[] b2 = new DERUTF8String(Strings.fromUTF8ByteArray(new DEROctetString(temp).getOctets())).getEncoded();
                if (!Arrays.areEqual(b1, b2)) {
                    return new SimpleTestResult(false, this.getName() + ": failed UTF-8 encoding and decoding");
                }
                if (Arrays.areEqual(temp, glyphs_utf8[i])) continue;
                return new SimpleTestResult(false, this.getName() + ": failed UTF-8 encoding and decoding");
            }
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": failed with Exception " + e.getMessage());
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    @Override
    public String getName() {
        return "DERUTF8String";
    }

    public static void main(String[] args) {
        DERUTF8StringTest test = new DERUTF8StringTest();
        TestResult result = test.perform();
        System.out.println(result);
    }
}

