/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.asn1.test;

import org.bouncycastle160.asn1.ASN1Integer;
import org.bouncycastle160.asn1.ASN1ObjectIdentifier;
import org.bouncycastle160.asn1.DERSequence;
import org.bouncycastle160.asn1.cmc.BodyPartID;
import org.bouncycastle160.asn1.cmc.CertificationRequest;
import org.bouncycastle160.asn1.cmc.EncryptedPOP;
import org.bouncycastle160.asn1.cmc.TaggedCertificationRequest;
import org.bouncycastle160.asn1.cmc.TaggedRequest;
import org.bouncycastle160.asn1.cms.ContentInfo;
import org.bouncycastle160.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle160.util.encoders.Base64;
import org.bouncycastle160.util.test.SimpleTest;

public class EncryptedPOPTest
extends SimpleTest {
    private byte[] req1 = Base64.decode("MIHoMIGTAgEAMC4xDjAMBgNVBAMTBVRlc3QyMQ8wDQYDVQQKEwZBbmFUb20xCzAJBgNVBAYTAlNFMFwwDQYJKoZIhvcNAQEBBQADSwAwSAJBALlEt31Tzt2MlcOljvacJgzQVhmlMoqAOgqJ9Pgd3GuxZ7/WcIlgW4QCB7WZT21O1YoghwBhPDMcNGrHei9kHQkCAwEAAaAAMA0GCSqGSIb3DQEBBQUAA0EANDEI4ecNtJ3uHwGGlitNFq9WxcoZ0djbQJ5hABMotav6gtqlrwKXY2evaIrsNwkJtNdwwH18aQDUKCjOuBL38Q==");

    @Override
    public String getName() {
        return "EncryptedPOPTest";
    }

    @Override
    public void performTest() throws Exception {
        TaggedRequest taggedRequest = new TaggedRequest(new TaggedCertificationRequest(new BodyPartID(10L), CertificationRequest.getInstance(this.req1)));
        ContentInfo cms = new ContentInfo(new ASN1ObjectIdentifier("1.2.3"), new ASN1Integer(12L));
        AlgorithmIdentifier thePopID = new AlgorithmIdentifier(new ASN1ObjectIdentifier("2.2.5.2"));
        AlgorithmIdentifier whitenessID = new AlgorithmIdentifier(new ASN1ObjectIdentifier("1.2.5.2.5"));
        byte[] whiteness = "Fish and Chips".getBytes();
        EncryptedPOP ep = new EncryptedPOP(taggedRequest, cms, thePopID, whitenessID, whiteness);
        byte[] b = ep.getEncoded();
        EncryptedPOP epResult = EncryptedPOP.getInstance(b);
        this.isEquals("TaggedRequest", epResult.getRequest(), taggedRequest);
        this.isEquals("ContentInfo (cms)", epResult.getCms(), cms);
        this.isEquals("Pop Algorithm ID", epResult.getThePOPAlgID(), thePopID);
        this.isEquals("Whiteness ID", epResult.getWitnessAlgID(), whitenessID);
        this.isTrue("Whiteness", this.areEqual(epResult.getWitness(), whiteness));
        try {
            EncryptedPOP.getInstance(new DERSequence(new ASN1Integer(1L)));
            this.fail("Sequence must be 5 items long.");
        }
        catch (Throwable t) {
            this.isEquals(t.getClass(), IllegalArgumentException.class);
        }
    }

    public static void main(String[] args) {
        EncryptedPOPTest.runTest(new EncryptedPOPTest());
    }
}

