/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Date;
import org.bouncycastle160.asn1.ASN1Boolean;
import org.bouncycastle160.asn1.ASN1Enumerated;
import org.bouncycastle160.asn1.ASN1InputStream;
import org.bouncycastle160.asn1.ASN1Integer;
import org.bouncycastle160.asn1.ASN1ObjectIdentifier;
import org.bouncycastle160.asn1.ASN1OutputStream;
import org.bouncycastle160.asn1.ASN1Primitive;
import org.bouncycastle160.asn1.BERConstructedOctetString;
import org.bouncycastle160.asn1.BERSequence;
import org.bouncycastle160.asn1.BERSet;
import org.bouncycastle160.asn1.BERTaggedObject;
import org.bouncycastle160.asn1.DERApplicationSpecific;
import org.bouncycastle160.asn1.DERBMPString;
import org.bouncycastle160.asn1.DERBitString;
import org.bouncycastle160.asn1.DERGeneralString;
import org.bouncycastle160.asn1.DERGeneralizedTime;
import org.bouncycastle160.asn1.DERGraphicString;
import org.bouncycastle160.asn1.DERIA5String;
import org.bouncycastle160.asn1.DERNull;
import org.bouncycastle160.asn1.DERNumericString;
import org.bouncycastle160.asn1.DEROctetString;
import org.bouncycastle160.asn1.DERPrintableString;
import org.bouncycastle160.asn1.DERSequence;
import org.bouncycastle160.asn1.DERSet;
import org.bouncycastle160.asn1.DERT61String;
import org.bouncycastle160.asn1.DERTaggedObject;
import org.bouncycastle160.asn1.DERUTCTime;
import org.bouncycastle160.asn1.DERUTF8String;
import org.bouncycastle160.asn1.DERUniversalString;
import org.bouncycastle160.asn1.DERVideotexString;
import org.bouncycastle160.asn1.DERVisibleString;
import org.bouncycastle160.util.Strings;
import org.bouncycastle160.util.encoders.Hex;
import org.bouncycastle160.util.test.SimpleTestResult;
import org.bouncycastle160.util.test.Test;
import org.bouncycastle160.util.test.TestResult;

public class EqualsAndHashCodeTest
implements Test {
    @Override
    public TestResult perform() {
        byte[] data = new byte[]{0, 1, 0, 1, 0, 0, 1};
        ASN1Primitive[] values = new ASN1Primitive[]{new BERConstructedOctetString(data), new BERSequence(new DERPrintableString("hello world")), new BERSet(new DERPrintableString("hello world")), new BERTaggedObject(0, new DERPrintableString("hello world")), new DERApplicationSpecific(0, data), new DERBitString(data), new DERBMPString("hello world"), new ASN1Boolean(true), new ASN1Boolean(false), new ASN1Enumerated(100), new DERGeneralizedTime("20070315173729Z"), new DERGeneralString("hello world"), new DERIA5String("hello"), new ASN1Integer(1000L), new DERNull(), new DERNumericString("123456"), new ASN1ObjectIdentifier("1.1.1.10000.1"), new DEROctetString(data), new DERPrintableString("hello world"), new DERSequence(new DERPrintableString("hello world")), new DERSet(new DERPrintableString("hello world")), new DERT61String("hello world"), new DERTaggedObject(0, new DERPrintableString("hello world")), new DERUniversalString(data), new DERUTCTime(new Date()), new DERUTF8String("hello world"), new DERVisibleString("hello world"), new DERGraphicString(Hex.decode("deadbeef")), new DERVideotexString(Strings.toByteArray("Hello World"))};
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream(bOut);
            for (int i = 0; i != values.length; ++i) {
                aOut.writeObject(values[i]);
            }
            ByteArrayInputStream bIn = new ByteArrayInputStream(bOut.toByteArray());
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            for (int i = 0; i != values.length; ++i) {
                ASN1Primitive o = aIn.readObject();
                if (!o.equals(values[i])) {
                    return new SimpleTestResult(false, this.getName() + ": Failed equality test for " + o.getClass());
                }
                if (o.hashCode() == values[i].hashCode()) continue;
                return new SimpleTestResult(false, this.getName() + ": Failed hashCode test for " + o.getClass());
            }
        }
        catch (Exception e) {
            return new SimpleTestResult(false, this.getName() + ": Failed - exception " + e.toString(), e);
        }
        return new SimpleTestResult(true, this.getName() + ": Okay");
    }

    @Override
    public String getName() {
        return "EqualsAndHashCode";
    }

    public static void main(String[] args) {
        EqualsAndHashCodeTest test = new EqualsAndHashCodeTest();
        TestResult result = test.perform();
        System.out.println(result);
    }
}

