/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.asn1.test;

import org.bouncycastle160.asn1.ASN1Integer;
import org.bouncycastle160.asn1.ASN1ObjectIdentifier;
import org.bouncycastle160.asn1.DERSequence;
import org.bouncycastle160.asn1.cmc.ExtendedFailInfo;
import org.bouncycastle160.util.test.SimpleTest;

public class ExtendedFailInfoTest
extends SimpleTest {
    public static void main(String[] args) {
        ExtendedFailInfoTest.runTest(new ExtendedFailInfoTest());
    }

    @Override
    public String getName() {
        return "ExtendedFailInfo";
    }

    @Override
    public void performTest() throws Exception {
        ExtendedFailInfo extendedFailInfo = new ExtendedFailInfo(new ASN1ObjectIdentifier("1.2.3.2"), new ASN1Integer(10L));
        byte[] b = extendedFailInfo.getEncoded();
        ExtendedFailInfo extendedFailInfoResult = ExtendedFailInfo.getInstance(b);
        this.isEquals("failInfoOID", extendedFailInfo.getFailInfoOID(), extendedFailInfoResult.getFailInfoOID());
        this.isEquals("failInfoValue", extendedFailInfo.getFailInfoValue(), extendedFailInfoResult.getFailInfoValue());
        try {
            ExtendedFailInfo.getInstance(new DERSequence(new ASN1Integer(10L)));
            this.fail("Sequence must be 2 elements.");
        }
        catch (Throwable t) {
            this.isEquals("Wrong exception type", t.getClass(), IllegalArgumentException.class);
        }
    }
}

