/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.asn1.test;

import org.bouncycastle160.asn1.ASN1InputStream;
import org.bouncycastle160.asn1.ASN1Sequence;
import org.bouncycastle160.asn1.x509.qualified.Iso4217CurrencyCode;
import org.bouncycastle160.asn1.x509.qualified.MonetaryValue;
import org.bouncycastle160.util.test.SimpleTest;

public class MonetaryValueUnitTest
extends SimpleTest {
    private static final int TEST_AMOUNT = 100;
    private static final int ZERO_EXPONENT = 0;
    private static final String CURRENCY_CODE = "AUD";

    @Override
    public String getName() {
        return "MonetaryValue";
    }

    @Override
    public void performTest() throws Exception {
        MonetaryValue mv = new MonetaryValue(new Iso4217CurrencyCode(CURRENCY_CODE), 100, 0);
        this.checkValues(mv, 100, 0);
        mv = MonetaryValue.getInstance(mv);
        this.checkValues(mv, 100, 0);
        ASN1InputStream aIn = new ASN1InputStream(mv.toASN1Primitive().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        mv = MonetaryValue.getInstance(seq);
        this.checkValues(mv, 100, 0);
        mv = MonetaryValue.getInstance(null);
        if (mv != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            MonetaryValue.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkValues(MonetaryValue mv, int amount, int exponent) {
        Iso4217CurrencyCode cc;
        if (mv.getAmount().intValue() != amount) {
            this.fail("amounts don't match.");
        }
        if (mv.getExponent().intValue() != exponent) {
            this.fail("exponents don't match.");
        }
        if (!(cc = mv.getCurrency()).getAlphabetic().equals(CURRENCY_CODE)) {
            this.fail("currency code wrong");
        }
    }

    public static void main(String[] args) {
        MonetaryValueUnitTest.runTest(new MonetaryValueUnitTest());
    }
}

