/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.asn1.test;

import java.io.IOException;
import org.bouncycastle160.asn1.ASN1InputStream;
import org.bouncycastle160.asn1.ASN1ObjectIdentifier;
import org.bouncycastle160.asn1.ASN1Sequence;
import org.bouncycastle160.asn1.isismtt.x509.NamingAuthority;
import org.bouncycastle160.asn1.test.ASN1UnitTest;
import org.bouncycastle160.asn1.x500.DirectoryString;

public class NamingAuthorityUnitTest
extends ASN1UnitTest {
    @Override
    public String getName() {
        return "NamingAuthority";
    }

    @Override
    public void performTest() throws Exception {
        ASN1ObjectIdentifier namingAuthorityID = new ASN1ObjectIdentifier("1.2.3");
        String namingAuthorityURL = "url";
        DirectoryString namingAuthorityText = new DirectoryString("text");
        NamingAuthority auth = new NamingAuthority(namingAuthorityID, namingAuthorityURL, namingAuthorityText);
        this.checkConstruction(auth, namingAuthorityID, namingAuthorityURL, namingAuthorityText);
        auth = new NamingAuthority(null, namingAuthorityURL, namingAuthorityText);
        this.checkConstruction(auth, null, namingAuthorityURL, namingAuthorityText);
        auth = new NamingAuthority(namingAuthorityID, null, namingAuthorityText);
        this.checkConstruction(auth, namingAuthorityID, null, namingAuthorityText);
        auth = new NamingAuthority(namingAuthorityID, namingAuthorityURL, null);
        this.checkConstruction(auth, namingAuthorityID, namingAuthorityURL, null);
        auth = NamingAuthority.getInstance(null);
        if (auth != null) {
            this.fail("null getInstance() failed.");
        }
        try {
            NamingAuthority.getInstance(new Object());
            this.fail("getInstance() failed to detect bad object.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void checkConstruction(NamingAuthority auth, ASN1ObjectIdentifier namingAuthorityID, String namingAuthorityURL, DirectoryString namingAuthorityText) throws IOException {
        this.checkValues(auth, namingAuthorityID, namingAuthorityURL, namingAuthorityText);
        auth = NamingAuthority.getInstance(auth);
        this.checkValues(auth, namingAuthorityID, namingAuthorityURL, namingAuthorityText);
        ASN1InputStream aIn = new ASN1InputStream(auth.toASN1Primitive().getEncoded());
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        auth = NamingAuthority.getInstance(seq);
        this.checkValues(auth, namingAuthorityID, namingAuthorityURL, namingAuthorityText);
    }

    private void checkValues(NamingAuthority auth, ASN1ObjectIdentifier namingAuthorityId, String namingAuthorityURL, DirectoryString namingAuthorityText) {
        this.checkOptionalField("namingAuthorityId", namingAuthorityId, auth.getNamingAuthorityId());
        this.checkOptionalField("namingAuthorityURL", namingAuthorityURL, auth.getNamingAuthorityUrl());
        this.checkOptionalField("namingAuthorityText", namingAuthorityText, auth.getNamingAuthorityText());
    }

    public static void main(String[] args) {
        NamingAuthorityUnitTest.runTest(new NamingAuthorityUnitTest());
    }
}

