/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.asn1.test;

import java.io.IOException;
import org.bouncycastle160.asn1.ASN1InputStream;
import org.bouncycastle160.asn1.DERBitString;
import org.bouncycastle160.asn1.cmp.PKIFailureInfo;
import org.bouncycastle160.asn1.test.BitStringConstantTester;
import org.bouncycastle160.util.encoders.Base64;
import org.bouncycastle160.util.test.SimpleTest;

public class PKIFailureInfoTest
extends SimpleTest {
    private static final byte[] CORRECT_FAILURE_INFO = Base64.decode("AwIANQ==");

    @Override
    public String getName() {
        return "PKIFailureInfo";
    }

    private void testEncoding() throws IOException {
        DERBitString bitString = (DERBitString)new ASN1InputStream(CORRECT_FAILURE_INFO).readObject();
        PKIFailureInfo correct = new PKIFailureInfo(bitString);
        PKIFailureInfo bug = new PKIFailureInfo(53);
        if (!this.areEqual(correct.getEncoded("DER"), bug.getEncoded("DER"))) {
            this.fail("encoding doesn't match");
        }
    }

    @Override
    public void performTest() throws IOException {
        BitStringConstantTester.testFlagValueCorrect(0, 128);
        BitStringConstantTester.testFlagValueCorrect(1, 64);
        BitStringConstantTester.testFlagValueCorrect(2, 32);
        BitStringConstantTester.testFlagValueCorrect(3, 16);
        BitStringConstantTester.testFlagValueCorrect(4, 8);
        BitStringConstantTester.testFlagValueCorrect(5, 4);
        BitStringConstantTester.testFlagValueCorrect(6, 2);
        BitStringConstantTester.testFlagValueCorrect(7, 1);
        BitStringConstantTester.testFlagValueCorrect(8, 32768);
        BitStringConstantTester.testFlagValueCorrect(9, 16384);
        BitStringConstantTester.testFlagValueCorrect(10, 8192);
        BitStringConstantTester.testFlagValueCorrect(11, 4096);
        BitStringConstantTester.testFlagValueCorrect(12, 2048);
        BitStringConstantTester.testFlagValueCorrect(13, 1024);
        BitStringConstantTester.testFlagValueCorrect(14, 512);
        BitStringConstantTester.testFlagValueCorrect(15, 256);
        BitStringConstantTester.testFlagValueCorrect(16, 0x800000);
        BitStringConstantTester.testFlagValueCorrect(17, 0x400000);
        BitStringConstantTester.testFlagValueCorrect(18, 0x200000);
        BitStringConstantTester.testFlagValueCorrect(19, 0x100000);
        BitStringConstantTester.testFlagValueCorrect(20, 524288);
        BitStringConstantTester.testFlagValueCorrect(21, 262144);
        BitStringConstantTester.testFlagValueCorrect(22, 131072);
        BitStringConstantTester.testFlagValueCorrect(23, 65536);
        BitStringConstantTester.testFlagValueCorrect(24, Integer.MIN_VALUE);
        BitStringConstantTester.testFlagValueCorrect(25, 0x40000000);
        BitStringConstantTester.testFlagValueCorrect(26, 0x20000000);
        this.testEncoding();
    }

    public static void main(String[] args) {
        PKIFailureInfoTest.runTest(new PKIFailureInfoTest());
    }
}

