/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.asn1.test;

import java.math.BigInteger;
import org.bouncycastle160.asn1.ASN1Integer;
import org.bouncycastle160.asn1.DERSequence;
import org.bouncycastle160.asn1.DERTaggedObject;
import org.bouncycastle160.asn1.x509.PolicyConstraints;
import org.bouncycastle160.util.Arrays;
import org.bouncycastle160.util.test.SimpleTest;

public class PolicyConstraintsTest
extends SimpleTest {
    @Override
    public String getName() {
        return "PolicyConstraints";
    }

    @Override
    public void performTest() throws Exception {
        PolicyConstraints constraints = new PolicyConstraints(BigInteger.valueOf(1L), BigInteger.valueOf(2L));
        PolicyConstraints c = PolicyConstraints.getInstance(constraints.getEncoded());
        this.isTrue("1 requireExplicitPolicyMapping", c.getRequireExplicitPolicyMapping().equals(BigInteger.valueOf(1L)));
        this.isTrue("2 inhibitPolicyMapping", c.getInhibitPolicyMapping().equals(BigInteger.valueOf(2L)));
        constraints = new PolicyConstraints(BigInteger.valueOf(3L), null);
        c = PolicyConstraints.getInstance(constraints.getEncoded());
        this.isTrue("3 requireExplicitPolicyMapping", c.getRequireExplicitPolicyMapping().equals(BigInteger.valueOf(3L)));
        this.isTrue("4 inhibitPolicyMapping", c.getInhibitPolicyMapping() == null);
        constraints = new PolicyConstraints(null, BigInteger.valueOf(4L));
        c = PolicyConstraints.getInstance(constraints.getEncoded());
        this.isTrue("5 inhibitPolicyMapping", c.getInhibitPolicyMapping().equals(BigInteger.valueOf(4L)));
        this.isTrue("6 requireExplicitPolicyMapping", c.getRequireExplicitPolicyMapping() == null);
        this.isTrue("encoding test", Arrays.areEqual(new PolicyConstraints(BigInteger.valueOf(1L), null).getEncoded(), new DERSequence(new DERTaggedObject(false, 0, new ASN1Integer(1L))).getEncoded()));
    }

    public static void main(String[] args) {
        PolicyConstraintsTest.runTest(new PolicyConstraintsTest());
    }
}

