/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.asn1.test;

import java.io.IOException;
import org.bouncycastle160.asn1.ASN1Primitive;
import org.bouncycastle160.asn1.ASN1String;
import org.bouncycastle160.asn1.DERBMPString;
import org.bouncycastle160.asn1.DERBitString;
import org.bouncycastle160.asn1.DERGeneralString;
import org.bouncycastle160.asn1.DERIA5String;
import org.bouncycastle160.asn1.DERNumericString;
import org.bouncycastle160.asn1.DERPrintableString;
import org.bouncycastle160.asn1.DERT61String;
import org.bouncycastle160.asn1.DERUTF8String;
import org.bouncycastle160.asn1.DERUniversalString;
import org.bouncycastle160.asn1.DERVisibleString;
import org.bouncycastle160.util.Strings;
import org.bouncycastle160.util.test.SimpleTest;

public class StringTest
extends SimpleTest {
    @Override
    public String getName() {
        return "String";
    }

    @Override
    public void performTest() throws IOException {
        int i;
        DERUniversalString us;
        DERBitString bs = new DERBitString(new byte[]{1, 35, 69, 103, -119, -85, -51, -17});
        if (!bs.getString().equals("#0309000123456789ABCDEF")) {
            this.fail("DERBitString.getString() result incorrect");
        }
        if (!bs.toString().equals("#0309000123456789ABCDEF")) {
            this.fail("DERBitString.toString() result incorrect");
        }
        if (!(bs = new DERBitString(new byte[]{-2, -36, -70, -104, 118, 84, 50, 16})).getString().equals("#030900FEDCBA9876543210")) {
            this.fail("DERBitString.getString() result incorrect");
        }
        if (!bs.toString().equals("#030900FEDCBA9876543210")) {
            this.fail("DERBitString.toString() result incorrect");
        }
        if (!(us = new DERUniversalString(new byte[]{1, 35, 69, 103, -119, -85, -51, -17})).getString().equals("#1C080123456789ABCDEF")) {
            this.fail("DERUniversalString.getString() result incorrect");
        }
        if (!us.toString().equals("#1C080123456789ABCDEF")) {
            this.fail("DERUniversalString.toString() result incorrect");
        }
        if (!(us = new DERUniversalString(new byte[]{-2, -36, -70, -104, 118, 84, 50, 16})).getString().equals("#1C08FEDCBA9876543210")) {
            this.fail("DERUniversalString.getString() result incorrect");
        }
        if (!us.toString().equals("#1C08FEDCBA9876543210")) {
            this.fail("DERUniversalString.toString() result incorrect");
        }
        byte[] t61Bytes = new byte[]{-1, -2, -3, -4, -5, -6, -7, -8};
        String t61String = new String(t61Bytes, "iso-8859-1");
        DERT61String t61 = new DERT61String(Strings.fromByteArray(t61Bytes));
        if (!t61.getString().equals(t61String)) {
            this.fail("DERT61String.getString() result incorrect");
        }
        if (!t61.toString().equals(t61String)) {
            this.fail("DERT61String.toString() result incorrect");
        }
        char[] shortChars = new char[]{'a', 'b', 'c', 'd', 'e'};
        char[] longChars = new char[1000];
        for (i = 0; i != longChars.length; ++i) {
            longChars[i] = 88;
        }
        this.checkString(new DERBMPString(new String(shortChars)), new DERBMPString(new String(longChars)));
        this.checkString(new DERUTF8String(new String(shortChars)), new DERUTF8String(new String(longChars)));
        this.checkString(new DERIA5String(new String(shortChars)), new DERIA5String(new String(longChars)));
        this.checkString(new DERPrintableString(new String(shortChars)), new DERPrintableString(new String(longChars)));
        this.checkString(new DERVisibleString(new String(shortChars)), new DERVisibleString(new String(longChars)));
        this.checkString(new DERGeneralString(new String(shortChars)), new DERGeneralString(new String(longChars)));
        this.checkString(new DERT61String(new String(shortChars)), new DERT61String(new String(longChars)));
        shortChars = new char[]{'1', '2', '3', '4', '5'};
        longChars = new char[1000];
        for (i = 0; i != longChars.length; ++i) {
            longChars[i] = 49;
        }
        this.checkString(new DERNumericString(new String(shortChars)), new DERNumericString(new String(longChars)));
        byte[] shortBytes = new byte[]{97, 98, 99, 100, 101};
        byte[] longBytes = new byte[1000];
        for (int i2 = 0; i2 != longChars.length; ++i2) {
            longBytes[i2] = 88;
        }
        this.checkString(new DERUniversalString(shortBytes), new DERUniversalString(longBytes));
    }

    private void checkString(ASN1String shortString, ASN1String longString) throws IOException {
        ASN1String short2 = (ASN1String)((Object)ASN1Primitive.fromByteArray(((ASN1Primitive)((Object)shortString)).getEncoded()));
        if (!shortString.toString().equals(short2.toString())) {
            this.fail(short2.getClass().getName() + " shortBytes result incorrect");
        }
        ASN1String long2 = (ASN1String)((Object)ASN1Primitive.fromByteArray(((ASN1Primitive)((Object)longString)).getEncoded()));
        if (!longString.toString().equals(long2.toString())) {
            this.fail(long2.getClass().getName() + " longBytes result incorrect");
        }
    }

    public static void main(String[] args) {
        StringTest.runTest(new StringTest());
    }
}

