/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.asn1.test;

import org.bouncycastle160.asn1.ASN1Encodable;
import org.bouncycastle160.asn1.ASN1Integer;
import org.bouncycastle160.asn1.DERIA5String;
import org.bouncycastle160.asn1.DERSequence;
import org.bouncycastle160.asn1.DERSet;
import org.bouncycastle160.asn1.cmc.BodyPartID;
import org.bouncycastle160.asn1.cmc.CMCObjectIdentifiers;
import org.bouncycastle160.asn1.cmc.TaggedAttribute;
import org.bouncycastle160.util.Arrays;
import org.bouncycastle160.util.test.SimpleTest;

public class TaggedAttributeTest
extends SimpleTest {
    @Override
    public String getName() {
        return "TaggedAttributeTest";
    }

    @Override
    public void performTest() throws Exception {
        DERSequence seq;
        TaggedAttribute ta = new TaggedAttribute(new BodyPartID(10L), CMCObjectIdentifiers.id_cct_PKIData, new DERSet(new DERIA5String("Cats")));
        byte[] d = ta.getEncoded();
        TaggedAttribute res1 = TaggedAttribute.getInstance(d);
        this.isEquals(ta.getBodyPartID(), res1.getBodyPartID());
        this.isEquals(ta.getAttrType(), res1.getAttrType());
        this.isEquals(ta.getAttrValues().getObjectAt(0), res1.getAttrValues().getObjectAt(0));
        this.isTrue(Arrays.areEqual(res1.getEncoded(), d));
        try {
            seq = new DERSequence(new ASN1Encodable[]{new BodyPartID(10L)});
            TaggedAttribute.getInstance(seq);
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("incorrect sequence size", e.getMessage());
        }
        try {
            seq = new DERSequence(new ASN1Encodable[]{ta.getBodyPartID(), ta.getAttrType(), ta.getAttrValues(), new ASN1Integer(0L)});
            TaggedAttribute.getInstance(seq);
            this.fail("no exception");
        }
        catch (IllegalArgumentException e) {
            this.isEquals("incorrect sequence size", e.getMessage());
        }
    }

    public static void main(String[] args) throws Exception {
        TaggedAttributeTest.runTest(new TaggedAttributeTest());
    }
}

