/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.asn1.test;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle160.asn1.ASN1Encodable;
import org.bouncycastle160.asn1.ASN1EncodableVector;
import org.bouncycastle160.asn1.ASN1GeneralizedTime;
import org.bouncycastle160.asn1.ASN1InputStream;
import org.bouncycastle160.asn1.ASN1ObjectIdentifier;
import org.bouncycastle160.asn1.ASN1OutputStream;
import org.bouncycastle160.asn1.ASN1Primitive;
import org.bouncycastle160.asn1.ASN1Sequence;
import org.bouncycastle160.asn1.ASN1Set;
import org.bouncycastle160.asn1.ASN1String;
import org.bouncycastle160.asn1.DERIA5String;
import org.bouncycastle160.asn1.DERPrintableString;
import org.bouncycastle160.asn1.DERSequence;
import org.bouncycastle160.asn1.DERSet;
import org.bouncycastle160.asn1.DERTaggedObject;
import org.bouncycastle160.asn1.DERUTF8String;
import org.bouncycastle160.asn1.x500.RDN;
import org.bouncycastle160.asn1.x500.X500Name;
import org.bouncycastle160.asn1.x500.X500NameBuilder;
import org.bouncycastle160.asn1.x500.style.BCStrictStyle;
import org.bouncycastle160.asn1.x500.style.BCStyle;
import org.bouncycastle160.asn1.x500.style.IETFUtils;
import org.bouncycastle160.asn1.x509.X509DefaultEntryConverter;
import org.bouncycastle160.util.encoders.Hex;
import org.bouncycastle160.util.test.SimpleTest;

public class X500NameTest
extends SimpleTest {
    String[] subjects = new String[]{"C=AU,ST=Victoria,L=South Melbourne,O=Connect 4 Pty Ltd,OU=Webserver Team,CN=www2.connect4.com.au,E=webmaster@connect4.com.au", "C=AU,ST=Victoria,L=South Melbourne,O=Connect 4 Pty Ltd,OU=Certificate Authority,CN=Connect 4 CA,E=webmaster@connect4.com.au", "C=AU,ST=QLD,CN=SSLeay/rsa test cert", "C=US,O=National Aeronautics and Space Administration,SERIALNUMBER=16+CN=Steve Schoch", "E=cooke@issl.atl.hp.com,C=US,OU=Hewlett Packard Company (ISSL),CN=Paul A. Cooke", "O=Sun Microsystems Inc,CN=store.sun.com", "unstructuredAddress=192.168.1.33,unstructuredName=pixfirewall.ciscopix.com,CN=pixfirewall.ciscopix.com", "CN=*.canal-plus.com,OU=Provided by TBS INTERNET http://www.tbs-certificats.com/,OU=\\ CANAL \\+,O=CANAL\\+DISTRIBUTION,L=issy les moulineaux,ST=Hauts de Seine,C=FR", "O=Bouncy Castle,CN=www.bouncycastle.org\\ ", "O=Bouncy Castle,CN=c:\\\\fred\\\\bob"};
    String[] hexSubjects = new String[]{"CN=\\20Test\\20X,O=\\20Test,C=GB", "CN=\\ Test X,O=\\ Test,C=GB", "CN=\\20Test\\20X\\20,O=\\20Test,C=GB", "CN=\\ Test X\\ ,O=\\ Test,C=GB"};

    @Override
    public String getName() {
        return "X500Name";
    }

    private static X500Name fromBytes(byte[] bytes) throws IOException {
        return X500Name.getInstance(new ASN1InputStream(new ByteArrayInputStream(bytes)).readObject());
    }

    private ASN1Encodable createEntryValue(ASN1ObjectIdentifier oid, String value) {
        X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
        builder.addRDN(oid, value);
        X500Name name = builder.build();
        ASN1Sequence seq = (ASN1Sequence)name.toASN1Primitive();
        ASN1Set set = ASN1Set.getInstance(seq.getObjectAt(0).toASN1Primitive());
        seq = (ASN1Sequence)set.getObjectAt(0);
        return seq.getObjectAt(1);
    }

    private ASN1Encodable createEntryValueFromString(ASN1ObjectIdentifier oid, String value) {
        X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
        builder.addRDN(oid, value);
        X500Name name = new X500Name(builder.build().toString());
        ASN1Sequence seq = (ASN1Sequence)name.toASN1Primitive();
        ASN1Set set = ASN1Set.getInstance(seq.getObjectAt(0).toASN1Primitive());
        seq = (ASN1Sequence)set.getObjectAt(0);
        return seq.getObjectAt(1);
    }

    private void testEncodingPrintableString(ASN1ObjectIdentifier oid, String value) {
        ASN1Encodable converted = this.createEntryValue(oid, value);
        if (!(converted instanceof DERPrintableString)) {
            this.fail("encoding for " + oid + " not printable string");
        }
    }

    private void testEncodingIA5String(ASN1ObjectIdentifier oid, String value) {
        ASN1Encodable converted = this.createEntryValue(oid, value);
        if (!(converted instanceof DERIA5String)) {
            this.fail("encoding for " + oid + " not IA5String");
        }
    }

    private void testEncodingUTF8String(ASN1ObjectIdentifier oid, String value) throws IOException {
        ASN1Encodable converted = this.createEntryValue(oid, value);
        if (!(converted instanceof DERUTF8String)) {
            this.fail("encoding for " + oid + " not IA5String");
        }
        if (!value.equals(DERUTF8String.getInstance(converted.toASN1Primitive().getEncoded()).getString())) {
            this.fail("decoding not correct");
        }
    }

    private void testEncodingGeneralizedTime(ASN1ObjectIdentifier oid, String value) {
        ASN1Encodable converted = this.createEntryValue(oid, value);
        if (!(converted instanceof ASN1GeneralizedTime)) {
            this.fail("encoding for " + oid + " not GeneralizedTime");
        }
        if (!((converted = this.createEntryValueFromString(oid, value)) instanceof ASN1GeneralizedTime)) {
            this.fail("encoding for " + oid + " not GeneralizedTime");
        }
    }

    @Override
    public void performTest() throws Exception {
        String[] aliases;
        RDN[] vls;
        X500Name n;
        X500Name name;
        DERTaggedObject tag;
        X500Name nested;
        ASN1ObjectIdentifier[] types;
        ASN1InputStream aIn;
        ASN1OutputStream aOut;
        ByteArrayOutputStream bOut;
        X500Name name2;
        int i;
        this.ietfUtilsTest();
        this.testEncodingPrintableString(BCStyle.C, "AU");
        this.testEncodingPrintableString(BCStyle.SERIALNUMBER, "123456");
        this.testEncodingPrintableString(BCStyle.DN_QUALIFIER, "123456");
        this.testEncodingIA5String(BCStyle.EmailAddress, "test@test.com");
        this.testEncodingIA5String(BCStyle.DC, "test");
        this.testEncodingGeneralizedTime(BCStyle.DATE_OF_BIRTH, "#180F32303032303132323132323232305A");
        this.testEncodingGeneralizedTime(BCStyle.DATE_OF_BIRTH, "20020122122220Z");
        this.testEncodingUTF8String(BCStyle.CN, "M\u00f6rsky");
        this.testEncodingUTF8String(BCStyle.ORGANIZATION_IDENTIFIER, "M\u00f6rsky");
        X500NameBuilder builder = new X500NameBuilder(BCStyle.INSTANCE);
        builder.addRDN(BCStyle.C, "AU");
        builder.addRDN(BCStyle.O, "The Legion of the Bouncy Castle");
        builder.addRDN(BCStyle.L, "Melbourne");
        builder.addRDN(BCStyle.ST, "Victoria");
        builder.addRDN(BCStyle.E, "feedback-crypto@bouncycastle.org");
        X500Name name1 = builder.build();
        if (!name1.equals(name1)) {
            this.fail("Failed same object test");
        }
        builder = new X500NameBuilder(BCStyle.INSTANCE);
        builder.addRDN(BCStyle.C, "AU");
        builder.addRDN(BCStyle.O, "The Legion of the Bouncy Castle");
        builder.addRDN(BCStyle.L, "Melbourne");
        builder.addRDN(BCStyle.ST, "Victoria");
        builder.addRDN(BCStyle.E, "feedback-crypto@bouncycastle.org");
        X500Name name22 = builder.build();
        if (!name1.equals(name22)) {
            this.fail("Failed same name test");
        }
        if (name1.hashCode() != name22.hashCode()) {
            this.fail("Failed same name test - in Order");
        }
        X500NameBuilder builder1 = new X500NameBuilder(BCStyle.INSTANCE);
        builder.addRDN(BCStyle.C, "AU");
        builder.addRDN(BCStyle.O, "The Legion of the Bouncy Castle");
        builder.addRDN(BCStyle.L, "Melbourne");
        builder.addRDN(BCStyle.ST, "Victoria");
        builder.addRDN(BCStyle.E, "feedback-crypto@bouncycastle.org");
        X500NameBuilder builder2 = new X500NameBuilder(BCStyle.INSTANCE);
        builder.addRDN(BCStyle.E, "feedback-crypto@bouncycastle.org");
        builder.addRDN(BCStyle.C, "AU");
        builder.addRDN(BCStyle.O, "The Legion of the Bouncy Castle");
        builder.addRDN(BCStyle.L, "Melbourne");
        builder.addRDN(BCStyle.ST, "Victoria");
        name1 = builder1.build();
        name22 = builder2.build();
        if (!name1.equals(name22)) {
            this.fail("Failed reverse name test");
        }
        if (name1.hashCode() != name22.hashCode()) {
            this.fail("Failed reverse name test hashCode");
        }
        for (i = 0; i != this.subjects.length; ++i) {
            name2 = new X500Name(this.subjects[i]);
            bOut = new ByteArrayOutputStream();
            aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(name2);
            aIn = new ASN1InputStream(new ByteArrayInputStream(bOut.toByteArray()));
            name2 = X500Name.getInstance(aIn.readObject());
            if (name2.toString().equals(this.subjects[i])) continue;
            this.fail("failed regeneration test " + i + " got: " + name2.toString() + " expected " + this.subjects[i]);
        }
        for (i = 0; i < this.hexSubjects.length; i += 2) {
            name2 = new X500Name(this.hexSubjects[i]);
            bOut = new ByteArrayOutputStream();
            aOut = new ASN1OutputStream(bOut);
            aOut.writeObject(name2);
            aIn = new ASN1InputStream(new ByteArrayInputStream(bOut.toByteArray()));
            name2 = X500Name.getInstance(aIn.readObject());
            if (name2.toString().equals(this.hexSubjects[i + 1])) continue;
            this.fail("failed hex regeneration test " + i + " got: " + name2.toString() + " expected " + this.subjects[i]);
        }
        X500Name unsorted = new X500Name("SERIALNUMBER=BBB + CN=AA");
        if (!X500NameTest.fromBytes(unsorted.getEncoded()).toString().equals("CN=AA+SERIALNUMBER=BBB")) {
            this.fail("failed sort test 1");
        }
        if (!X500NameTest.fromBytes((unsorted = new X500Name("CN=AA + SERIALNUMBER=BBB")).getEncoded()).toString().equals("CN=AA+SERIALNUMBER=BBB")) {
            this.fail("failed sort test 2");
        }
        if (!X500NameTest.fromBytes((unsorted = new X500Name("SERIALNUMBER=B + CN=AA")).getEncoded()).toString().equals("SERIALNUMBER=B+CN=AA")) {
            this.fail("failed sort test 3");
        }
        if (!X500NameTest.fromBytes((unsorted = new X500Name("CN=AA + SERIALNUMBER=B")).getEncoded()).toString().equals("SERIALNUMBER=B+CN=AA")) {
            this.fail("failed sort test 4");
        }
        this.equalityTest(new X500Name("CN=The     Legion"), new X500Name("CN=The Legion"));
        this.equalityTest(new X500Name("CN=   The Legion"), new X500Name("CN=The Legion"));
        this.equalityTest(new X500Name("CN=The Legion   "), new X500Name("CN=The Legion"));
        this.equalityTest(new X500Name("CN=  The     Legion "), new X500Name("CN=The Legion"));
        this.equalityTest(new X500Name("CN=  the     legion "), new X500Name("CN=The Legion"));
        this.equalityTest(new X500Name("CN=  the     legion+C=AU, O=Legion "), new X500Name("CN=The Legion+C=AU, O=Legion"));
        X500Name n1 = new X500Name("SERIALNUMBER=8,O=ABC,CN=ABC Class 3 CA,C=LT");
        X500Name n2 = new X500Name("2.5.4.5=8,O=ABC,CN=ABC Class 3 CA,C=LT");
        X500Name n3 = new X500Name("2.5.4.5=#130138,O=ABC,CN=ABC Class 3 CA,C=LT");
        this.equalityTest(n1, n2);
        this.equalityTest(n2, n3);
        this.equalityTest(n3, n1);
        n1 = new X500Name("2.5.4.5=#130138,CN=SSC Class 3 CA,O=UAB Skaitmeninio sertifikavimo centras,C=LT");
        n2 = new X500Name("SERIALNUMBER=#130138,CN=SSC Class 3 CA,O=UAB Skaitmeninio sertifikavimo centras,C=LT");
        n3 = X500Name.getInstance(ASN1Primitive.fromByteArray(Hex.decode("3063310b3009060355040613024c54312f302d060355040a132655414220536b6169746d656e696e696f20736572746966696b6176696d6f2063656e74726173311730150603550403130e53534320436c6173732033204341310a30080603550405130138")));
        this.equalityTest(n1, n2);
        this.equalityTest(n2, n3);
        this.equalityTest(n3, n1);
        n1 = new X500Name("SERIALNUMBER=8,O=XX,CN=ABC Class 3 CA,C=LT");
        n2 = new X500Name("2.5.4.5=8,O=,CN=ABC Class 3 CA,C=LT");
        n1 = new X500Name("SERIALNUMBER=8,O=,CN=ABC Class 3 CA,C=LT");
        n2 = new X500Name("2.5.4.5=8,O=,CN=ABC Class 3 CA,C=LT");
        this.equalityTest(n1, n2);
        this.equalityTest(X500Name.getInstance(BCStrictStyle.INSTANCE, n1), X500Name.getInstance(BCStrictStyle.INSTANCE, n2));
        n2 = new X500Name("C=LT,2.5.4.5=8,O=,CN=ABC Class 3 CA");
        this.equalityTest(n1, n2);
        if (X500Name.getInstance(BCStrictStyle.INSTANCE, n1).equals(X500Name.getInstance(BCStrictStyle.INSTANCE, n2))) {
            this.fail("strict comparison failed");
        }
        if ((name1 = new X500Name("CN=The Legion")).equals(new DERSequence())) {
            this.fail("inequality test with sequence");
        }
        if (name1.equals(new DERSequence(new DERSet()))) {
            this.fail("inequality test with sequence and set");
        }
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(new ASN1ObjectIdentifier("1.1"));
        v.add(new ASN1ObjectIdentifier("1.1"));
        if (name1.equals(new DERSequence(new DERSet(new DERSet(v))))) {
            this.fail("inequality test with sequence and bad set");
        }
        if (name1.equals(new DERSequence(new DERSet(new DERSet(v))))) {
            this.fail("inequality test with sequence and bad set");
        }
        if (name1.equals(new DERSequence(new DERSet(new DERSequence())))) {
            this.fail("inequality test with sequence and short sequence");
        }
        if (name1.equals(new DERSequence(new DERSet(new DERSequence())))) {
            this.fail("inequality test with sequence and short sequence");
        }
        v = new ASN1EncodableVector();
        v.add(new ASN1ObjectIdentifier("1.1"));
        v.add(new DERSequence());
        if (name1.equals(new DERSequence(new DERSet(new DERSequence(v))))) {
            this.fail("inequality test with sequence and bad sequence");
        }
        if (name1.equals(null)) {
            this.fail("inequality test with null");
        }
        if (!((types = (unsorted = new X500Name("CN=AA + CN=AA + CN=AA")).getAttributeTypes()).length == 3 && types[0].equals(BCStyle.CN) && types[1].equals(BCStyle.CN) && types[2].equals(BCStyle.CN))) {
            this.fail("types not matched correctly");
        }
        if (!((types = (nested = new X500Name("CN=AA + CN=AA, C=AU")).getAttributeTypes()).length == 3 && types[0].equals(BCStyle.CN) && types[1].equals(BCStyle.CN) && types[2].equals(BCStyle.C))) {
            this.fail("nested types not matched correctly");
        }
        if (!(tag = new DERTaggedObject(false, 1, new X500Name("CN=AA"))).isExplicit()) {
            this.fail("failed to explicitly tag CHOICE object");
        }
        if (!(name = X500Name.getInstance(tag, false)).equals(new X500Name("CN=AA"))) {
            this.fail("failed to recover tagged name");
        }
        DERUTF8String testString = new DERUTF8String("The Legion of the Bouncy Castle");
        byte[] encodedBytes = testString.getEncoded();
        byte[] hexEncodedBytes = Hex.encode(encodedBytes);
        String hexEncodedString = "#" + new String(hexEncodedBytes);
        DERUTF8String converted = (DERUTF8String)new X509DefaultEntryConverter().getConvertedValue(BCStyle.L, hexEncodedString);
        if (!converted.equals(testString)) {
            this.fail("failed X509DefaultEntryConverter test");
        }
        if (!(converted = (DERUTF8String)new X509DefaultEntryConverter().getConvertedValue(BCStyle.L, "\\" + hexEncodedString)).equals(new DERUTF8String(hexEncodedString))) {
            this.fail("failed X509DefaultEntryConverter test got " + converted + " expected: " + hexEncodedString);
        }
        if (!(n = new X500Name("CN=\\#nothex#string")).toString().equals("CN=\\#nothex#string")) {
            this.fail("# string not properly escaped.");
        }
        if ((vls = n.getRDNs(BCStyle.CN)).length != 1 || !this.getValue(vls[0]).equals("#nothex#string")) {
            this.fail("escaped # not reduced properly");
        }
        if ((types = n.getAttributeTypes()).length != 1 || !types[0].equals(BCStyle.CN)) {
            this.fail("type not matched correctly");
        }
        if ((vls = (n = new X500Name("CN=\"a+b\"")).getRDNs(BCStyle.CN)).length != 1 || !this.getValue(vls[0]).equals("a+b")) {
            this.fail("escaped + not reduced properly");
        }
        if ((vls = (n = new X500Name("CN=a\\+b")).getRDNs(BCStyle.CN)).length != 1 || !this.getValue(vls[0]).equals("a+b")) {
            this.fail("escaped + not reduced properly");
        }
        if (!n.toString().equals("CN=a\\+b")) {
            this.fail("+ in string not properly escaped.");
        }
        if ((vls = (n = new X500Name("CN=a\\=b")).getRDNs(BCStyle.CN)).length != 1 || !this.getValue(vls[0]).equals("a=b")) {
            this.fail("escaped = not reduced properly");
        }
        if (!n.toString().equals("CN=a\\=b")) {
            this.fail("= in string not properly escaped.");
        }
        if ((vls = (n = new X500Name("TELEPHONENUMBER=\"+61999999999\"")).getRDNs(BCStyle.TELEPHONE_NUMBER)).length != 1 || !this.getValue(vls[0]).equals("+61999999999")) {
            this.fail("telephonenumber escaped + not reduced properly");
        }
        if ((vls = (n = new X500Name("TELEPHONENUMBER=\\+61999999999")).getRDNs(BCStyle.TELEPHONE_NUMBER)).length != 1 || !this.getValue(vls[0]).equals("+61999999999")) {
            this.fail("telephonenumber escaped + not reduced properly");
        }
        if (!"E".equals(BCStyle.INSTANCE.oidToDisplayName(BCStyle.EmailAddress))) {
            this.fail("display name for E incorrect");
        }
        if ((aliases = BCStyle.INSTANCE.oidToAttrNames(BCStyle.EmailAddress)).length != 2) {
            this.fail("no aliases found");
        }
        if (!"e".equals(aliases[0]) && !"e".equals(aliases[1])) {
            this.fail("first alias name for E incorrect");
        }
        if (!"emailaddress".equals(aliases[0]) && !"emailaddress".equals(aliases[1])) {
            this.fail("second alias name for E incorrect");
        }
        if (BCStyle.INSTANCE.oidToDisplayName(new ASN1ObjectIdentifier("1.2.1")) != null) {
            this.fail("unknown oid matched!");
        }
        if (BCStyle.INSTANCE.oidToAttrNames(new ASN1ObjectIdentifier("1.2.1")).length != 0) {
            this.fail("unknown oid matched aliases!");
        }
        if (!new X500Name("CN=\"  CA1 -   CP.04.03\", OU=Testing, OU=Dod, O=U.S. Government, C=US").equals(new X500Name("CN=\"ca1 - CP.04.03  \", OU=Testing, OU=Dod, O=U.S. Government, C=US"))) {
            this.fail("padded equality test failed");
        }
    }

    private String getValue(RDN vl) {
        return ((ASN1String)((Object)vl.getFirst().getValue())).getString();
    }

    private void ietfUtilsTest() throws Exception {
        IETFUtils.valueToString(new DERUTF8String(" "));
    }

    private void equalityTest(X500Name name1, X500Name name2) {
        if (!name1.equals(name2)) {
            this.fail("equality test failed for " + name1 + " : " + name2);
        }
        if (name1.hashCode() != name2.hashCode()) {
            this.fail("hashCodeTest test failed for " + name1 + " : " + name2);
        }
    }

    public static void main(String[] args) {
        X500NameTest.runTest(new X500NameTest());
    }
}

