/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.crypto.agreement;

import java.math.BigInteger;
import org.bouncycastle160.crypto.CipherParameters;
import org.bouncycastle160.crypto.agreement.ECDHCBasicAgreement;
import org.bouncycastle160.crypto.params.ECDHUPrivateParameters;
import org.bouncycastle160.crypto.params.ECDHUPublicParameters;
import org.bouncycastle160.util.Arrays;
import org.bouncycastle160.util.BigIntegers;

public class ECDHCUnifiedAgreement {
    private ECDHUPrivateParameters privParams;

    public void init(CipherParameters key) {
        this.privParams = (ECDHUPrivateParameters)key;
    }

    public int getFieldSize() {
        return (this.privParams.getStaticPrivateKey().getParameters().getCurve().getFieldSize() + 7) / 8;
    }

    public byte[] calculateAgreement(CipherParameters pubKey) {
        ECDHUPublicParameters pubParams = (ECDHUPublicParameters)pubKey;
        ECDHCBasicAgreement sAgree = new ECDHCBasicAgreement();
        ECDHCBasicAgreement eAgree = new ECDHCBasicAgreement();
        sAgree.init(this.privParams.getStaticPrivateKey());
        BigInteger sComp = sAgree.calculateAgreement(pubParams.getStaticPublicKey());
        eAgree.init(this.privParams.getEphemeralPrivateKey());
        BigInteger eComp = eAgree.calculateAgreement(pubParams.getEphemeralPublicKey());
        return Arrays.concatenate(BigIntegers.asUnsignedByteArray(this.getFieldSize(), eComp), BigIntegers.asUnsignedByteArray(this.getFieldSize(), sComp));
    }
}

