/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.crypto.ec;

import org.bouncycastle160.crypto.CipherParameters;
import org.bouncycastle160.crypto.ec.ECDecryptor;
import org.bouncycastle160.crypto.ec.ECPair;
import org.bouncycastle160.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle160.math.ec.ECAlgorithms;
import org.bouncycastle160.math.ec.ECCurve;
import org.bouncycastle160.math.ec.ECPoint;

public class ECElGamalDecryptor
implements ECDecryptor {
    private ECPrivateKeyParameters key;

    @Override
    public void init(CipherParameters param) {
        if (!(param instanceof ECPrivateKeyParameters)) {
            throw new IllegalArgumentException("ECPrivateKeyParameters are required for decryption.");
        }
        this.key = (ECPrivateKeyParameters)param;
    }

    @Override
    public ECPoint decrypt(ECPair pair) {
        if (this.key == null) {
            throw new IllegalStateException("ECElGamalDecryptor not initialised");
        }
        ECCurve curve = this.key.getParameters().getCurve();
        ECPoint tmp = ECAlgorithms.cleanPoint(curve, pair.getX()).multiply(this.key.getD());
        return ECAlgorithms.cleanPoint(curve, pair.getY()).subtract(tmp).normalize();
    }
}

