/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.crypto.generators;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle160.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle160.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle160.crypto.CryptoServicesRegistrar;
import org.bouncycastle160.crypto.KeyGenerationParameters;
import org.bouncycastle160.crypto.params.ECDomainParameters;
import org.bouncycastle160.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle160.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle160.crypto.params.ECPublicKeyParameters;
import org.bouncycastle160.math.ec.ECConstants;
import org.bouncycastle160.math.ec.ECMultiplier;
import org.bouncycastle160.math.ec.ECPoint;
import org.bouncycastle160.math.ec.FixedPointCombMultiplier;
import org.bouncycastle160.math.ec.WNafUtil;

public class ECKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator,
ECConstants {
    ECDomainParameters params;
    SecureRandom random;

    @Override
    public void init(KeyGenerationParameters param) {
        ECKeyGenerationParameters ecP = (ECKeyGenerationParameters)param;
        this.random = ecP.getRandom();
        this.params = ecP.getDomainParameters();
        if (this.random == null) {
            this.random = CryptoServicesRegistrar.getSecureRandom();
        }
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        BigInteger d;
        BigInteger n = this.params.getN();
        int nBitLength = n.bitLength();
        int minWeight = nBitLength >>> 2;
        while ((d = new BigInteger(nBitLength, this.random)).compareTo(TWO) < 0 || d.compareTo(n) >= 0 || WNafUtil.getNafWeight(d) < minWeight) {
        }
        ECPoint Q = this.createBasePointMultiplier().multiply(this.params.getG(), d);
        return new AsymmetricCipherKeyPair(new ECPublicKeyParameters(Q, this.params), new ECPrivateKeyParameters(d, this.params));
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }
}

