/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.crypto.generators;

import java.math.BigInteger;
import org.bouncycastle160.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle160.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle160.crypto.KeyGenerationParameters;
import org.bouncycastle160.crypto.generators.DHKeyGeneratorHelper;
import org.bouncycastle160.crypto.params.DHParameters;
import org.bouncycastle160.crypto.params.ElGamalKeyGenerationParameters;
import org.bouncycastle160.crypto.params.ElGamalParameters;
import org.bouncycastle160.crypto.params.ElGamalPrivateKeyParameters;
import org.bouncycastle160.crypto.params.ElGamalPublicKeyParameters;

public class ElGamalKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private ElGamalKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (ElGamalKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        ElGamalParameters egp = this.param.getParameters();
        DHParameters dhp = new DHParameters(egp.getP(), egp.getG(), null, egp.getL());
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new ElGamalPublicKeyParameters(y, egp), new ElGamalPrivateKeyParameters(x, egp));
    }
}

