/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle160.crypto.paddings;

import java.security.SecureRandom;
import org.bouncycastle160.crypto.InvalidCipherTextException;
import org.bouncycastle160.crypto.paddings.BlockCipherPadding;

public class ZeroBytePadding
implements BlockCipherPadding {
    @Override
    public void init(SecureRandom random) throws IllegalArgumentException {
    }

    @Override
    public String getPaddingName() {
        return "ZeroByte";
    }

    @Override
    public int addPadding(byte[] in, int inOff) {
        int added = in.length - inOff;
        while (inOff < in.length) {
            in[inOff] = 0;
            ++inOff;
        }
        return added;
    }

    @Override
    public int padCount(byte[] in) throws InvalidCipherTextException {
        int count;
        for (count = in.length; count > 0 && in[count - 1] == 0; --count) {
        }
        return in.length - count;
    }
}

